/**
 * DO NOT EDIT THIS FILE.
 * See the following change record for more information,
 * https://www.drupal.org/node/2815083
 * @preserve
 **/

(function (Drupal, CKEDITOR) {
  CKEDITOR.plugins.add('insert_view_adv', {
    icons: 'insert_view_adv',
    requires: 'widget',
    beforeInit: function beforeInit(editor) {
      convertLegacyTags(editor);
      // Execute widget editing action on double click.
      editor.on('doubleclick', function (evt) {
        var element = editor.getSelection().getSelectedElement() || evt.data.element;
        if (isEditableInsertViewAdvWidget(editor, element)) {
          editor.execCommand('insert_view_adv');
        }
      });

      editor.addCommand('insert_view_adv', {
        allowedContent: {
          'drupal-view': {
            attributes: {
              '!data-view-id': true,
              '!data-display-id': true,
              'data-arguments': true
            },
            classes: {}
          }
        },

        requiredContent: new CKEDITOR.style({
          element: 'drupal-view',
          attributes: {
            'data-view-id': '',
            'data-display-id': '',
            'data-arguments': ''
          }
        }),
        modes: { wysiwyg: 1 },
        editorFocus: true,
        canUndo: true,
        exec: function exec(editor) {
          var saveCallback = function saveCallback(values) {
            editor.fire('saveSnapshot');
            var viewElement = editor.getSelection().getSelectedElement();
            if (viewElement) {
              viewElement.remove();
            }
            viewElement = editor.document.createElement('drupal-view');

            var attributes = values.attributes;
            Object.keys(attributes).forEach(function (key) {
              viewElement.setAttribute(key, attributes[key]);
            });
            editor.insertHtml(viewElement.getOuterHtml());
            editor.fire('saveSnapshot');
          };
          // If the selected element while we click the button is an instance
          // of the drupalview widget, extract it's values so they can be
          // sent to the server to prime the configuration form.
          var existingValues = {};
          if (editor.widgets.focused && editor.widgets.focused.name === 'drupalview') {
            existingValues = editor.widgets.focused.data.attributes;
            existingValues.inserted_view_adv = existingValues['data-view-id'] + '=' + existingValues['data-display-id'];
            if (typeof existingValues['data-arguments'] !== 'undefined') {
              existingValues.arguments = existingValues['data-arguments'].split('/');
            }
          }
          Drupal.ckeditor.openDialog(editor, editor.config.InsertViewDialog_url, existingValues, saveCallback, editor.config.InsertViewDialog_options);
        }
      });
      if (editor.ui.addButton) {
        editor.ui.addButton('insert_view_adv', {
          label: Drupal.t('Advanced Insert View'),
          command: 'insert_view_adv',
          icon: this.path + 'icons/insert_view_adv.png'
        });
      }

      var dtd = CKEDITOR.dtd;

      dtd['drupal-view'] = { '#': 1 };

      Object.keys(dtd).forEach(function (tagName) {
        if (dtd[tagName].div) {
          dtd[tagName]['drupal-view'] = 1;
        }
      });
      dtd.a['drupal-view'] = 1;
      editor.widgets.add('drupalview', {
        allowedContent: {
          'drupal-view': {
            attributes: {
              '!data-view-id': true,
              '!data-display-id': true,
              'data-arguments': true,
            },
            classes: {}
          }
        },

        requiredContent: new CKEDITOR.style({
          element: 'drupal-view',
          attributes: {
            'data-view-id': '',
            'data-display-id': '',
            'data-arguments': ''
          }
        }),

        getLabel: function getLabel() {
          if (this.data.label) {
            return this.data.label;
          }
          return Drupal.t('Embedded view');
        },
        upcast: function upcast(element, data) {
          var attributes = element.attributes;
          if (element.name !== 'drupal-view' || attributes['data-view-id'] === undefined || attributes['data-display-id'] === undefined) {
            return;
          }
          data.attributes = CKEDITOR.tools.copy(attributes);
          return element;
        },
        downcast: function downcast() {
          return new CKEDITOR.htmlParser.element('drupal-view', this.data.attributes);
        },
        data: function data(event) {
          var _this = this;
          editor.fire('lockSnapshot');

          this._loadPreview(function (widget) {
            editor.fire('unlockSnapshot');
          });

          if (this.oldData) {
            Object.keys(this.oldData.attributes).forEach(function (attrName) {
              _this.element.removeAttribute(attrName);
            });
          }

          this.element.setAttributes(this.data.attributes);

          this.oldData = CKEDITOR.tools.clone(this.data);
        },
        _loadPreview: function _loadPreview(callback) {
          var _this3 = this;
          jQuery.get({
            url: editor.config.InsertViewPreview_url,
            data: {
              view_args: this.data.attributes['data-arguments'],
              view_name: this.data.attributes['data-view-id'],
              view_display_id: this.data.attributes['data-display-id'],
              view_dom_id: this.data.attributes['data-dom-id'],
            },
            success: function success(previewHtml, textStatus, jqXhr) {
              _this3.element.setHtml(previewHtml);
              callback(_this3);
            },
            error: function error() {
              _this3.element.setHtml(Drupal.theme('insertViewAdvPreviewError'));
            }
          });
        }
      });
    }
  });

  /**
   * Checks if the given element is an editable drupalview widget.
   *
   * @param {CKEDITOR.editor} editor
   * @param {CKEDITOR.htmlParser.element} element
   */
  function isEditableInsertViewAdvWidget(editor, element) {
    var widget = editor.widgets.getByElement(element, true);
    return !!(widget && widget.name === 'drupalview');
  }

  /**
   * Convert legacy json to <drupal-view> tag.
   *
   * @param editor
   */
  function convertLegacyTags(editor) {
    // Upcast check must be sensitive to both HTML encoded and plain text.
    if (editor.getData().indexOf('inserted_view_adv') === -1) {
      return;
    }
    var content = editor.getData();
    var json = content.match(/{"inserted_view_adv":[^}]*}/gm);
    if (json && json.length > 0) {
      for (var i = 0; i < json.length; i++) {
        var dataItem = JSON.parse(json[i]);
        var rendered = Drupal.theme('advancedInsertView', dataItem);
        content = content.replace(json[i], rendered);
      }
      editor.setData(content);
    }
  }

  /**
   * Error message
   *
   * @returns {string}
   */
  Drupal.theme.insertViewAdvPreviewError = function () {
    return '<div>' + Drupal.t('An error occurred while trying to preview the view. Please save your work and reload this page.') + '</div>';
  };

  /**
   * Converting legacy json string to <drupal-view> tag.
   *
   * @param attributes
   * @returns {string}
   */
  Drupal.theme.advancedInsertView = function (attributes) {
    var viewElement = document.createElement('drupal-view');
    var view_attributes = attributes['inserted_view_adv'].split('=');
    delete(attributes['inserted_view_adv']);
    attributes['data-view-id'] = view_attributes[0];
    attributes['data-display-id'] = view_attributes[1];
    if (typeof attributes['arguments'] !== 'undefined' && !isEmpty(attributes['arguments'])) {
      attributes['data-arguments'] = attributes['arguments'].join('/');
    }
    delete(attributes['arguments']);
    Object.keys(attributes).forEach(function (key) {
      viewElement.setAttribute(key, attributes[key]);
    });
    return viewElement.outerHTML;
  }

  /**
   * Checks if the value is empty.
   *
   * @param val
   * @returns {boolean}
   */
  function isEmpty(val){
    return (val === undefined || val == null || val.length <= 0);
  }

})(Drupal, CKEDITOR);
