<?php
// phpcs:ignoreFile
/**
 * @file
 * A database agnostic dump for testing purposes.
 *
 * This file was generated by the Drupal 9.5.4-dev db-tools.php script.
 */

use Drupal\Core\Database\Database;

$connection = Database::getConnection();
// Ensure any tables with a serial column with a value of 0 are created as
// expected.
if ($connection->databaseType() === 'mysql') {
  $sql_mode = $connection->query("SELECT @@sql_mode;")->fetchField();
  $connection->query("SET sql_mode = '$sql_mode,NO_AUTO_VALUE_ON_ZERO'");
}

$connection->schema()->createTable('block_content', array(
  'fields' => array(
    'id' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'type' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '32',
    ),
    'uuid' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '128',
    ),
    'langcode' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '12',
    ),
  ),
  'primary key' => array(
    'id',
  ),
  'unique keys' => array(
    'block_content_field__uuid__value' => array(
      'uuid',
    ),
    'block_content__revision_id' => array(
      'revision_id',
    ),
  ),
  'indexes' => array(
    'block_content_field__type__target_id' => array(
      'type',
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->schema()->createTable('block_content__body', array(
  'fields' => array(
    'bundle' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'entity_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'langcode' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'body_value' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'big',
    ),
    'body_summary' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'body_format' => array(
      'type' => 'varchar_ascii',
      'not null' => FALSE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'entity_id',
    'deleted',
    'delta',
    'langcode',
  ),
  'indexes' => array(
    'bundle' => array(
      'bundle',
    ),
    'revision_id' => array(
      'revision_id',
    ),
    'body_format' => array(
      'body_format',
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->schema()->createTable('block_content_field_data', array(
  'fields' => array(
    'id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'type' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '32',
    ),
    'langcode' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '12',
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
    ),
    'info' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
    'changed' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'reusable' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'tiny',
    ),
    'default_langcode' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
    ),
    'revision_translation_affected' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'tiny',
    ),
  ),
  'primary key' => array(
    'id',
    'langcode',
  ),
  'indexes' => array(
    'block_content__id__default_langcode__langcode' => array(
      'id',
      'default_langcode',
      'langcode',
    ),
    'block_content__revision_id' => array(
      'revision_id',
    ),
    'block_content_field__type__target_id' => array(
      'type',
    ),
    'block_content__status_type' => array(
      'status',
      'type',
      'id',
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->schema()->createTable('block_content_field_revision', array(
  'fields' => array(
    'id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'langcode' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '12',
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
    ),
    'info' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
    'changed' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'default_langcode' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
    ),
    'revision_translation_affected' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'tiny',
    ),
  ),
  'primary key' => array(
    'revision_id',
    'langcode',
  ),
  'indexes' => array(
    'block_content__id__default_langcode__langcode' => array(
      'id',
      'default_langcode',
      'langcode',
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->schema()->createTable('block_content_revision', array(
  'fields' => array(
    'id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'langcode' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '12',
    ),
    'revision_user' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_created' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'revision_log' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'revision_default' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'tiny',
    ),
  ),
  'primary key' => array(
    'revision_id',
  ),
  'indexes' => array(
    'block_content__id' => array(
      'id',
    ),
    'block_content_field__revision_user__target_id' => array(
      'revision_user',
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->schema()->createTable('block_content_revision__body', array(
  'fields' => array(
    'bundle' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'entity_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'langcode' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'body_value' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'big',
    ),
    'body_summary' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'body_format' => array(
      'type' => 'varchar_ascii',
      'not null' => FALSE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'entity_id',
    'revision_id',
    'deleted',
    'delta',
    'langcode',
  ),
  'indexes' => array(
    'bundle' => array(
      'bundle',
    ),
    'revision_id' => array(
      'revision_id',
    ),
    'body_format' => array(
      'body_format',
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->schema()->createTable('cache_bootstrap', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
      'binary' => TRUE,
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'numeric',
      'not null' => TRUE,
      'precision' => '14',
      'scale' => '3',
      'default' => '0.000',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
    'tags' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'checksum' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
    'created' => array(
      'created',
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->schema()->createTable('cache_config', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
      'binary' => TRUE,
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'numeric',
      'not null' => TRUE,
      'precision' => '14',
      'scale' => '3',
      'default' => '0.000',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
    'tags' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'checksum' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
    'created' => array(
      'created',
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->schema()->createTable('cache_container', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
      'binary' => TRUE,
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'numeric',
      'not null' => TRUE,
      'precision' => '14',
      'scale' => '3',
      'default' => '0.000',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
    'tags' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'checksum' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
    'created' => array(
      'created',
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->schema()->createTable('cache_data', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
      'binary' => TRUE,
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'numeric',
      'not null' => TRUE,
      'precision' => '14',
      'scale' => '3',
      'default' => '0.000',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
    'tags' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'checksum' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
    'created' => array(
      'created',
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->schema()->createTable('cache_default', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
      'binary' => TRUE,
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'numeric',
      'not null' => TRUE,
      'precision' => '14',
      'scale' => '3',
      'default' => '0.000',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
    'tags' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'checksum' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
    'created' => array(
      'created',
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->schema()->createTable('cache_discovery', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
      'binary' => TRUE,
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'numeric',
      'not null' => TRUE,
      'precision' => '14',
      'scale' => '3',
      'default' => '0.000',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
    'tags' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'checksum' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
    'created' => array(
      'created',
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->schema()->createTable('cache_entity', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
      'binary' => TRUE,
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'numeric',
      'not null' => TRUE,
      'precision' => '14',
      'scale' => '3',
      'default' => '0.000',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
    'tags' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'checksum' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
    'created' => array(
      'created',
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->schema()->createTable('cache_menu', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
      'binary' => TRUE,
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'numeric',
      'not null' => TRUE,
      'precision' => '14',
      'scale' => '3',
      'default' => '0.000',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
    'tags' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'checksum' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
    'created' => array(
      'created',
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->schema()->createTable('cache_toolbar', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
      'binary' => TRUE,
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'numeric',
      'not null' => TRUE,
      'precision' => '14',
      'scale' => '3',
      'default' => '0.000',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
    'tags' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'checksum' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
    'created' => array(
      'created',
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->schema()->createTable('cachetags', array(
  'fields' => array(
    'tag' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'invalidations' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'tag',
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->schema()->createTable('comment', array(
  'fields' => array(
    'cid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'comment_type' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '32',
    ),
    'uuid' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '128',
    ),
    'langcode' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '12',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'unique keys' => array(
    'comment_field__uuid__value' => array(
      'uuid',
    ),
  ),
  'indexes' => array(
    'comment_field__comment_type__target_id' => array(
      'comment_type',
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->schema()->createTable('comment__comment_body', array(
  'fields' => array(
    'bundle' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'entity_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'langcode' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'comment_body_value' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'big',
    ),
    'comment_body_format' => array(
      'type' => 'varchar_ascii',
      'not null' => FALSE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'entity_id',
    'deleted',
    'delta',
    'langcode',
  ),
  'indexes' => array(
    'bundle' => array(
      'bundle',
    ),
    'revision_id' => array(
      'revision_id',
    ),
    'comment_body_format' => array(
      'comment_body_format',
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->schema()->createTable('comment_entity_statistics', array(
  'fields' => array(
    'entity_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'entity_type' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '32',
      'default' => 'node',
    ),
    'field_name' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'cid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'last_comment_timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'last_comment_name' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '60',
    ),
    'last_comment_uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'comment_count' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'entity_id',
    'entity_type',
    'field_name',
  ),
  'indexes' => array(
    'last_comment_timestamp' => array(
      'last_comment_timestamp',
    ),
    'comment_count' => array(
      'comment_count',
    ),
    'last_comment_uid' => array(
      'last_comment_uid',
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->insert('comment_entity_statistics')
->fields(array(
  'entity_id',
  'entity_type',
  'field_name',
  'cid',
  'last_comment_timestamp',
  'last_comment_name',
  'last_comment_uid',
  'comment_count',
))
->values(array(
  'entity_id' => '3',
  'entity_type' => 'node',
  'field_name' => 'comment',
  'cid' => '0',
  'last_comment_timestamp' => '1684944612',
  'last_comment_name' => NULL,
  'last_comment_uid' => '1',
  'comment_count' => '0',
))
->values(array(
  'entity_id' => '4',
  'entity_type' => 'node',
  'field_name' => 'comment',
  'cid' => '0',
  'last_comment_timestamp' => '1684944647',
  'last_comment_name' => NULL,
  'last_comment_uid' => '1',
  'comment_count' => '0',
))
->values(array(
  'entity_id' => '5',
  'entity_type' => 'node',
  'field_name' => 'comment',
  'cid' => '0',
  'last_comment_timestamp' => '1686744871',
  'last_comment_name' => NULL,
  'last_comment_uid' => '1',
  'comment_count' => '0',
))
->values(array(
  'entity_id' => '6',
  'entity_type' => 'node',
  'field_name' => 'comment',
  'cid' => '0',
  'last_comment_timestamp' => '1686744888',
  'last_comment_name' => NULL,
  'last_comment_uid' => '1',
  'comment_count' => '0',
))
->values(array(
  'entity_id' => '7',
  'entity_type' => 'node',
  'field_name' => 'comment',
  'cid' => '0',
  'last_comment_timestamp' => '1686744905',
  'last_comment_name' => NULL,
  'last_comment_uid' => '1',
  'comment_count' => '0',
))
->execute();
$connection->schema()->createTable('comment_field_data', array(
  'fields' => array(
    'cid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'comment_type' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '32',
    ),
    'langcode' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '12',
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
    ),
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'pid' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'entity_id' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'subject' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '64',
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '60',
    ),
    'mail' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '254',
    ),
    'homepage' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
    'hostname' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '128',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'changed' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'thread' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ),
    'entity_type' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '32',
    ),
    'field_name' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '32',
    ),
    'default_langcode' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
    ),
  ),
  'primary key' => array(
    'cid',
    'langcode',
  ),
  'indexes' => array(
    'comment__id__default_langcode__langcode' => array(
      'cid',
      'default_langcode',
      'langcode',
    ),
    'comment_field__comment_type__target_id' => array(
      'comment_type',
    ),
    'comment_field__uid__target_id' => array(
      'uid',
    ),
    'comment_field__created' => array(
      'created',
    ),
    'comment__status_comment_type' => array(
      'status',
      'comment_type',
      'cid',
    ),
    'comment__status_pid' => array(
      'pid',
      'status',
    ),
    'comment__num_new' => array(
      'entity_id',
      'entity_type',
      'comment_type',
      'status',
      'created',
      'cid',
      array(
        'thread',
        '191',
      ),
    ),
    'comment__entity_langcode' => array(
      'entity_id',
      'entity_type',
      'comment_type',
      'default_langcode',
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->schema()->createTable('config', array(
  'fields' => array(
    'collection' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'name' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
  ),
  'primary key' => array(
    'collection',
    'name',
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->insert('config')
->fields(array(
  'collection',
  'name',
  'data',
))
->values(array(
  'collection' => '',
  'name' => 'automated_cron.settings',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"fUksROt4FfkAU9BV4hV2XvhTBSS2nTNrZS4U7S-tKrs";}s:8:"interval";i:10800;}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.claro_breadcrumbs',
  'data' => 'a:13:{s:4:"uuid";s:36:"f7df1911-ad5b-4cb3-8153-59321df33c3e";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:5:"claro";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"NjcxOBrPOiK5-38t56DwFBDVY4yer7YSlbRWXFuHe7A";}s:2:"id";s:17:"claro_breadcrumbs";s:5:"theme";s:5:"claro";s:6:"region";s:10:"breadcrumb";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:23:"system_breadcrumb_block";s:8:"settings";a:4:{s:2:"id";s:23:"system_breadcrumb_block";s:5:"label";s:11:"Breadcrumbs";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.claro_content',
  'data' => 'a:13:{s:4:"uuid";s:36:"f2ffe7dc-4030-4952-980a-11f199e6b8b7";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:5:"claro";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"a0Yyx1GeyKarZ4T_yXQBR_ZFKnXiFLtxAb6gWLd8nr0";}s:2:"id";s:13:"claro_content";s:5:"theme";s:5:"claro";s:6:"region";s:7:"content";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:17:"system_main_block";s:8:"settings";a:4:{s:2:"id";s:17:"system_main_block";s:5:"label";s:17:"Main page content";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.claro_help',
  'data' => 'a:13:{s:4:"uuid";s:36:"cf8942d4-054b-4fcd-9182-39a5cc30128f";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:4:"help";}s:5:"theme";a:1:{i:0;s:5:"claro";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"jccFSSVqV0WCDb6NtML1VWAWTtDbZ-zn5YgTRMgMrIM";}s:2:"id";s:10:"claro_help";s:5:"theme";s:5:"claro";s:6:"region";s:4:"help";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:10:"help_block";s:8:"settings";a:4:{s:2:"id";s:10:"help_block";s:5:"label";s:4:"Help";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"help";}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.claro_local_actions',
  'data' => 'a:13:{s:4:"uuid";s:36:"459da073-0b49-4889-b68e-65e6c6d21aa8";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:5:"claro";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"CdXfDmRgAvms7EQovxxWPdYi0GitxeRbVtScYK16ZH0";}s:2:"id";s:19:"claro_local_actions";s:5:"theme";s:5:"claro";s:6:"region";s:7:"content";s:6:"weight";i:-10;s:8:"provider";N;s:6:"plugin";s:19:"local_actions_block";s:8:"settings";a:4:{s:2:"id";s:19:"local_actions_block";s:5:"label";s:21:"Primary admin actions";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"core";}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.claro_messages',
  'data' => 'a:13:{s:4:"uuid";s:36:"8662e482-f3f3-4eb8-b414-35ec43424eaf";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:5:"claro";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"-Ac3ISpIT0PQ-whzD7_dw0SdKi6dAbRFNWdSjOiVDqg";}s:2:"id";s:14:"claro_messages";s:5:"theme";s:5:"claro";s:6:"region";s:11:"highlighted";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:21:"system_messages_block";s:8:"settings";a:4:{s:2:"id";s:21:"system_messages_block";s:5:"label";s:15:"Status messages";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.claro_page_title',
  'data' => 'a:13:{s:4:"uuid";s:36:"d9a84d3b-290b-4cc6-842b-598d359a5606";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:5:"claro";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"fNwDdW063tk_ktzSWzZVeQS9wzvLooVO280BQ9WrsIs";}s:2:"id";s:16:"claro_page_title";s:5:"theme";s:5:"claro";s:6:"region";s:6:"header";s:6:"weight";i:-30;s:8:"provider";N;s:6:"plugin";s:16:"page_title_block";s:8:"settings";a:4:{s:2:"id";s:16:"page_title_block";s:5:"label";s:10:"Page title";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"core";}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.claro_primary_local_tasks',
  'data' => 'a:13:{s:4:"uuid";s:36:"c47e7602-16ce-4e01-b63c-c758f7f1f86c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:5:"claro";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ACjBZI5shAMiiUpsz-inLYVXDqNNXRnSzAWV3kV_8Hw";}s:2:"id";s:25:"claro_primary_local_tasks";s:5:"theme";s:5:"claro";s:6:"region";s:6:"header";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:17:"local_tasks_block";s:8:"settings";a:6:{s:2:"id";s:17:"local_tasks_block";s:5:"label";s:12:"Primary tabs";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"core";s:7:"primary";b:1;s:9:"secondary";b:0;}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.claro_secondary_local_tasks',
  'data' => 'a:13:{s:4:"uuid";s:36:"2e1bcbf0-8814-48e4-bbcf-0240ed25b562";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:5:"claro";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"2L0geP-ixCbCkEpW6BVF6H7vDUZN4ea07_Y9CociQm4";}s:2:"id";s:27:"claro_secondary_local_tasks";s:5:"theme";s:5:"claro";s:6:"region";s:11:"pre_content";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:17:"local_tasks_block";s:8:"settings";a:6:{s:2:"id";s:17:"local_tasks_block";s:5:"label";s:14:"Secondary tabs";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"core";s:7:"primary";b:0;s:9:"secondary";b:1;}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.olivero_account_menu',
  'data' => 'a:13:{s:4:"uuid";s:36:"4fbdbb90-d3f0-4816-8a3b-88de512cd8f8";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:3:{s:6:"config";a:1:{i:0;s:19:"system.menu.account";}s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"gmxYWWHmgbe0Pnv8y48ZLSLH5mEHejOjAP6RLxUfdzU";}s:2:"id";s:20:"olivero_account_menu";s:5:"theme";s:7:"olivero";s:6:"region";s:14:"secondary_menu";s:6:"weight";i:-4;s:8:"provider";N;s:6:"plugin";s:25:"system_menu_block:account";s:8:"settings";a:7:{s:2:"id";s:25:"system_menu_block:account";s:5:"label";s:17:"User account menu";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";s:5:"level";i:1;s:5:"depth";i:1;s:16:"expand_all_items";b:0;}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.olivero_breadcrumbs',
  'data' => 'a:13:{s:4:"uuid";s:36:"e5e26cf3-f53e-4872-9680-96de34915223";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"VhBzWb7lMRtIOg9G7VSw_0uopi-7zXeHq4vXqqV1HFE";}s:2:"id";s:19:"olivero_breadcrumbs";s:5:"theme";s:7:"olivero";s:6:"region";s:10:"breadcrumb";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:23:"system_breadcrumb_block";s:8:"settings";a:4:{s:2:"id";s:23:"system_breadcrumb_block";s:5:"label";s:11:"Breadcrumbs";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.olivero_content',
  'data' => 'a:13:{s:4:"uuid";s:36:"ef5f9f63-2e20-446c-a8b7-d8375dade67b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"erQSEZF2XUjNmgTl0uNRBzmg18ZGXwUcw2FhApoeuHk";}s:2:"id";s:15:"olivero_content";s:5:"theme";s:7:"olivero";s:6:"region";s:7:"content";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:17:"system_main_block";s:8:"settings";a:4:{s:2:"id";s:17:"system_main_block";s:5:"label";s:17:"Main page content";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.olivero_help',
  'data' => 'a:13:{s:4:"uuid";s:36:"c1dde7d9-e643-4c46-91ce-b8084172fe2a";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:4:"help";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"VfPFqqxfkomud5CO8DUijw85QIl9GIxh_nIxLOYESxg";}s:2:"id";s:12:"olivero_help";s:5:"theme";s:7:"olivero";s:6:"region";s:13:"content_above";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:10:"help_block";s:8:"settings";a:4:{s:2:"id";s:10:"help_block";s:5:"label";s:4:"Help";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"help";}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.olivero_main_menu',
  'data' => 'a:13:{s:4:"uuid";s:36:"aa232095-6eeb-43c2-a0d9-53fcad8111b3";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:3:{s:6:"config";a:1:{i:0;s:16:"system.menu.main";}s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"KWAiziL39uEzmOJEql_wbUP2RtqGceL3WM2CfxhMelE";}s:2:"id";s:17:"olivero_main_menu";s:5:"theme";s:7:"olivero";s:6:"region";s:12:"primary_menu";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:22:"system_menu_block:main";s:8:"settings";a:7:{s:2:"id";s:22:"system_menu_block:main";s:5:"label";s:15:"Main navigation";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";s:5:"level";i:1;s:5:"depth";i:2;s:16:"expand_all_items";b:1;}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.olivero_messages',
  'data' => 'a:13:{s:4:"uuid";s:36:"0442b9ac-98e8-4171-97c3-c123f193dfcd";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"BZ5tpW7H8X4PVGRm3MImTIHd2tN0eF7zOtp4SpRYUA0";}s:2:"id";s:16:"olivero_messages";s:5:"theme";s:7:"olivero";s:6:"region";s:11:"highlighted";s:6:"weight";i:-5;s:8:"provider";N;s:6:"plugin";s:21:"system_messages_block";s:8:"settings";a:4:{s:2:"id";s:21:"system_messages_block";s:5:"label";s:15:"Status messages";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.olivero_page_title',
  'data' => 'a:13:{s:4:"uuid";s:36:"65675939-734e-4b74-b21d-54f954204978";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"6aOgWsNTXjqrDm98TXSAjP6qd2nCijD1xw45MrnbK-Y";}s:2:"id";s:18:"olivero_page_title";s:5:"theme";s:7:"olivero";s:6:"region";s:13:"content_above";s:6:"weight";i:-5;s:8:"provider";N;s:6:"plugin";s:16:"page_title_block";s:8:"settings";a:4:{s:2:"id";s:16:"page_title_block";s:5:"label";s:10:"Page title";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"core";}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.olivero_powered',
  'data' => 'a:13:{s:4:"uuid";s:36:"59e9b4eb-a103-4b80-bb14-c2265781acef";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"eYL19CLDyinGTWYQfBD1DswWzglEotE_kHnHx3AxTXM";}s:2:"id";s:15:"olivero_powered";s:5:"theme";s:7:"olivero";s:6:"region";s:13:"footer_bottom";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:23:"system_powered_by_block";s:8:"settings";a:4:{s:2:"id";s:23:"system_powered_by_block";s:5:"label";s:17:"Powered by Drupal";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.olivero_primary_admin_actions',
  'data' => 'a:13:{s:4:"uuid";s:36:"ef91aa88-b6dd-45c1-bd82-26873c2cc4ca";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Q9_2whdOj1YIomfvsIfopROW4FT_X5pY0DjdOiOaQ5U";}s:2:"id";s:29:"olivero_primary_admin_actions";s:5:"theme";s:7:"olivero";s:6:"region";s:11:"highlighted";s:6:"weight";i:-5;s:8:"provider";N;s:6:"plugin";s:19:"local_actions_block";s:8:"settings";a:4:{s:2:"id";s:19:"local_actions_block";s:5:"label";s:21:"Primary admin actions";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"core";}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.olivero_primary_local_tasks',
  'data' => 'a:13:{s:4:"uuid";s:36:"e6de916d-3c06-47bc-b12d-ff646ff9bd44";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"nGE3EoPQQaQCuqTUtZgw0-KIzmrqdKDzdNQf2JyPUt4";}s:2:"id";s:27:"olivero_primary_local_tasks";s:5:"theme";s:7:"olivero";s:6:"region";s:11:"highlighted";s:6:"weight";i:-4;s:8:"provider";N;s:6:"plugin";s:17:"local_tasks_block";s:8:"settings";a:6:{s:2:"id";s:17:"local_tasks_block";s:5:"label";s:12:"Primary tabs";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"core";s:7:"primary";b:1;s:9:"secondary";b:0;}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.olivero_search_form_narrow',
  'data' => 'a:13:{s:4:"uuid";s:36:"946411ff-8719-4097-b45b-ad6f3e1ef3c4";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"search";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"yEBET0cqDbk8dkWzaJw-8CKft0961VBflsISoSR6Lj8";}s:2:"id";s:26:"olivero_search_form_narrow";s:5:"theme";s:7:"olivero";s:6:"region";s:12:"primary_menu";s:6:"weight";i:-4;s:8:"provider";N;s:6:"plugin";s:17:"search_form_block";s:8:"settings";a:5:{s:2:"id";s:17:"search_form_block";s:5:"label";s:20:"Search form (narrow)";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"search";s:7:"page_id";s:0:"";}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.olivero_search_form_wide',
  'data' => 'a:13:{s:4:"uuid";s:36:"23cb830b-910c-42ef-ada8-7989bf95cbbb";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"search";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"imMyHD6LYci0gtXq56qr9ZKGHzbEG9uFydrN5EhKtSU";}s:2:"id";s:24:"olivero_search_form_wide";s:5:"theme";s:7:"olivero";s:6:"region";s:14:"secondary_menu";s:6:"weight";i:-5;s:8:"provider";N;s:6:"plugin";s:17:"search_form_block";s:8:"settings";a:5:{s:2:"id";s:17:"search_form_block";s:5:"label";s:18:"Search form (wide)";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"search";s:7:"page_id";s:0:"";}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.olivero_secondary_local_tasks',
  'data' => 'a:13:{s:4:"uuid";s:36:"aede71f4-8663-4ae2-8eb9-e87548031e97";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ydSxdq7R66I8UMC460rOzlfzvlUL4VRbdwc6z9DWaUI";}s:2:"id";s:29:"olivero_secondary_local_tasks";s:5:"theme";s:7:"olivero";s:6:"region";s:11:"highlighted";s:6:"weight";i:-2;s:8:"provider";N;s:6:"plugin";s:17:"local_tasks_block";s:8:"settings";a:6:{s:2:"id";s:17:"local_tasks_block";s:5:"label";s:14:"Secondary tabs";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"core";s:7:"primary";b:0;s:9:"secondary";b:1;}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.olivero_site_branding',
  'data' => 'a:13:{s:4:"uuid";s:36:"52366cc5-86b4-4cd1-a3ff-f395d76faece";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"n_nlgjggHVfQt2H__zvLOKB2YtjPDbQ5tHijF9LE1aM";}s:2:"id";s:21:"olivero_site_branding";s:5:"theme";s:7:"olivero";s:6:"region";s:6:"header";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:21:"system_branding_block";s:8:"settings";a:7:{s:2:"id";s:21:"system_branding_block";s:5:"label";s:13:"Site branding";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";s:13:"use_site_logo";b:1;s:13:"use_site_name";b:1;s:15:"use_site_slogan";b:0;}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.olivero_syndicate',
  'data' => 'a:13:{s:4:"uuid";s:36:"1f2e6bce-f5f5-4215-b257-4ef0bc5bb580";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:4:"node";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"0gq3VPg-_UM69FCCWurLFIrrnIjC2HLKhwo9iQNtcUo";}s:2:"id";s:17:"olivero_syndicate";s:5:"theme";s:7:"olivero";s:6:"region";s:6:"social";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:20:"node_syndicate_block";s:8:"settings";a:5:{s:2:"id";s:20:"node_syndicate_block";s:5:"label";s:8:"RSS feed";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"node";s:11:"block_count";i:10;}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block_content.type.basic',
  'data' => 'a:9:{s:4:"uuid";s:36:"4881ab95-c558-467e-804a-2979c2fd93d4";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"zglzjmYxi0G0ag9MZ02y0LSJOdpWRwJxyP_OvFojFyo";}s:2:"id";s:5:"basic";s:5:"label";s:11:"Basic block";s:8:"revision";i:0;s:11:"description";s:42:"A basic block contains a title and a body.";}',
))
->values(array(
  'collection' => '',
  'name' => 'claro.settings',
  'data' => 'a:1:{s:20:"third_party_settings";a:1:{s:8:"shortcut";a:1:{s:11:"module_link";b:1;}}}',
))
->values(array(
  'collection' => '',
  'name' => 'comment.settings',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"YNUW2Ij5uE7a4oaXp3i_2lvaFdYM1zNKPPfnEjB0jEc";}s:16:"log_ip_addresses";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'comment.type.comment',
  'data' => 'a:9:{s:4:"uuid";s:36:"63ce59b3-6c19-4247-a9b5-237ccf113e5a";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"bqZsN31T2n0UjcbyCpOPi9D2iO0sAOHR7FnEs9qMvaA";}s:2:"id";s:7:"comment";s:5:"label";s:16:"Default comments";s:21:"target_entity_type_id";s:4:"node";s:11:"description";s:28:"Allows commenting on content";}',
))
->values(array(
  'collection' => '',
  'name' => 'contact.form.feedback',
  'data' => 'a:12:{s:4:"uuid";s:36:"d78951fc-6ea8-4dc7-a4bb-34b0407ebb52";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"vymHlgJy26BuI5GGj9-IXjwR3dRC5C0tij4BpWJnoqw";}s:2:"id";s:8:"feedback";s:5:"label";s:16:"Website feedback";s:10:"recipients";a:1:{i:0;s:17:"admin@example.com";}s:5:"reply";s:0:"";s:6:"weight";i:0;s:7:"message";s:27:"Your message has been sent.";s:8:"redirect";s:0:"";}',
))
->values(array(
  'collection' => '',
  'name' => 'contact.form.personal',
  'data' => 'a:12:{s:4:"uuid";s:36:"cb2134ab-de78-46fb-857b-7f10480bf6ca";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"jonvgt3CkUM2eMLTFwWfHileWWDC4YtXCuIlCahTk_I";}s:2:"id";s:8:"personal";s:5:"label";s:21:"Personal contact form";s:10:"recipients";a:0:{}s:5:"reply";s:0:"";s:6:"weight";i:0;s:7:"message";s:27:"Your message has been sent.";s:8:"redirect";s:0:"";}',
))
->values(array(
  'collection' => '',
  'name' => 'contact.settings',
  'data' => 'a:4:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"U69DBeuvXuNVOC15rVNaBjDPK2fWFbo9v4takdYSSO8";}s:12:"default_form";s:8:"feedback";s:5:"flood";a:2:{s:5:"limit";i:5;s:8:"interval";i:3600;}s:20:"user_default_enabled";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.base_field_override.block_content.basic.changed',
  'data' => 'a:16:{s:4:"uuid";s:36:"d8c74ce9-b071-4099-bd7a-de15b1140cef";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:1:{i:0;s:24:"block_content.type.basic";}}s:2:"id";s:27:"block_content.basic.changed";s:10:"field_name";s:7:"changed";s:11:"entity_type";s:13:"block_content";s:6:"bundle";s:5:"basic";s:5:"label";s:7:"Changed";s:11:"description";s:47:"The time that the custom block was last edited.";s:8:"required";b:0;s:12:"translatable";b:0;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:0:{}s:10:"field_type";s:7:"changed";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.base_field_override.block_content.basic.info',
  'data' => 'a:16:{s:4:"uuid";s:36:"2539df91-1061-4a8d-b552-a57fa80fac56";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:1:{i:0;s:24:"block_content.type.basic";}}s:2:"id";s:24:"block_content.basic.info";s:10:"field_name";s:4:"info";s:11:"entity_type";s:13:"block_content";s:6:"bundle";s:5:"basic";s:5:"label";s:17:"Block description";s:11:"description";s:34:"A brief description of your block.";s:8:"required";b:1;s:12:"translatable";b:0;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:0:{}s:10:"field_type";s:6:"string";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.base_field_override.block_content.basic.status',
  'data' => 'a:16:{s:4:"uuid";s:36:"a6c866b6-a1b6-4c67-bdd9-c8d35fa0493a";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:1:{i:0;s:24:"block_content.type.basic";}}s:2:"id";s:26:"block_content.basic.status";s:10:"field_name";s:6:"status";s:11:"entity_type";s:13:"block_content";s:6:"bundle";s:5:"basic";s:5:"label";s:9:"Published";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:0;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";i:1;}}s:22:"default_value_callback";s:0:"";s:8:"settings";a:2:{s:8:"on_label";s:2:"On";s:9:"off_label";s:3:"Off";}s:10:"field_type";s:7:"boolean";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.base_field_override.comment.comment.changed',
  'data' => 'a:16:{s:4:"uuid";s:36:"12eb697d-1274-4a5c-a64e-ea737eb5541d";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:1:{i:0;s:20:"comment.type.comment";}}s:2:"id";s:23:"comment.comment.changed";s:10:"field_name";s:7:"changed";s:11:"entity_type";s:7:"comment";s:6:"bundle";s:7:"comment";s:5:"label";s:7:"Changed";s:11:"description";s:42:"The time that the comment was last edited.";s:8:"required";b:0;s:12:"translatable";b:0;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:0:{}s:10:"field_type";s:7:"changed";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.base_field_override.comment.comment.created',
  'data' => 'a:16:{s:4:"uuid";s:36:"dd327fdf-c923-4aa4-8c1b-b56484674551";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:1:{i:0;s:20:"comment.type.comment";}}s:2:"id";s:23:"comment.comment.created";s:10:"field_name";s:7:"created";s:11:"entity_type";s:7:"comment";s:6:"bundle";s:7:"comment";s:5:"label";s:7:"Created";s:11:"description";s:38:"The time that the comment was created.";s:8:"required";b:0;s:12:"translatable";b:0;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:0:{}s:10:"field_type";s:7:"created";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.base_field_override.comment.comment.homepage',
  'data' => "a:16:{s:4:\"uuid\";s:36:\"4718d2d5-c9d3-4aa6-92d4-41a3d00884f1\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"config\";a:1:{i:0;s:20:\"comment.type.comment\";}}s:2:\"id\";s:24:\"comment.comment.homepage\";s:10:\"field_name\";s:8:\"homepage\";s:11:\"entity_type\";s:7:\"comment\";s:6:\"bundle\";s:7:\"comment\";s:5:\"label\";s:8:\"Homepage\";s:11:\"description\";s:39:\"The comment author's home page address.\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:3:\"uri\";}",
))
->values(array(
  'collection' => '',
  'name' => 'core.base_field_override.comment.comment.hostname',
  'data' => "a:16:{s:4:\"uuid\";s:36:\"b849f4a4-278d-44b8-9ede-ef7774c859b0\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"config\";a:1:{i:0;s:20:\"comment.type.comment\";}}s:2:\"id\";s:24:\"comment.comment.hostname\";s:10:\"field_name\";s:8:\"hostname\";s:11:\"entity_type\";s:7:\"comment\";s:6:\"bundle\";s:7:\"comment\";s:5:\"label\";s:8:\"Hostname\";s:11:\"description\";s:30:\"The comment author's hostname.\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:49:\"Drupal\\comment\\Entity\\Comment::getDefaultHostname\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:6:\"string\";}",
))
->values(array(
  'collection' => '',
  'name' => 'core.base_field_override.comment.comment.mail',
  'data' => "a:16:{s:4:\"uuid\";s:36:\"f09c4137-6413-42be-a7fc-32676f40c4e0\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"config\";a:1:{i:0;s:20:\"comment.type.comment\";}}s:2:\"id\";s:20:\"comment.comment.mail\";s:10:\"field_name\";s:4:\"mail\";s:11:\"entity_type\";s:7:\"comment\";s:6:\"bundle\";s:7:\"comment\";s:5:\"label\";s:5:\"Email\";s:11:\"description\";s:35:\"The comment author's email address.\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:5:\"email\";}",
))
->values(array(
  'collection' => '',
  'name' => 'core.base_field_override.comment.comment.name',
  'data' => "a:16:{s:4:\"uuid\";s:36:\"aa2fd0c3-eecd-49e8-b3b1-7047a0770315\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"config\";a:1:{i:0;s:20:\"comment.type.comment\";}}s:2:\"id\";s:20:\"comment.comment.name\";s:10:\"field_name\";s:4:\"name\";s:11:\"entity_type\";s:7:\"comment\";s:6:\"bundle\";s:7:\"comment\";s:5:\"label\";s:4:\"Name\";s:11:\"description\";s:26:\"The comment author's name.\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:1:{i:0;a:1:{s:5:\"value\";s:0:\"\";}}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:6:\"string\";}",
))
->values(array(
  'collection' => '',
  'name' => 'core.base_field_override.comment.comment.status',
  'data' => 'a:16:{s:4:"uuid";s:36:"2028df78-b9fb-4158-86cb-d7e00f5f0c41";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:1:{i:0;s:20:"comment.type.comment";}}s:2:"id";s:22:"comment.comment.status";s:10:"field_name";s:6:"status";s:11:"entity_type";s:7:"comment";s:6:"bundle";s:7:"comment";s:5:"label";s:9:"Published";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:0;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";i:1;}}s:22:"default_value_callback";s:47:"Drupal\comment\Entity\Comment::getDefaultStatus";s:8:"settings";a:2:{s:8:"on_label";s:2:"On";s:9:"off_label";s:3:"Off";}s:10:"field_type";s:7:"boolean";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.base_field_override.comment.comment.subject',
  'data' => 'a:16:{s:4:"uuid";s:36:"15356571-d6cb-4db8-972c-e2aa769757c3";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:1:{i:0;s:20:"comment.type.comment";}}s:2:"id";s:23:"comment.comment.subject";s:10:"field_name";s:7:"subject";s:11:"entity_type";s:7:"comment";s:6:"bundle";s:7:"comment";s:5:"label";s:7:"Subject";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:0;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:0:{}s:10:"field_type";s:6:"string";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.base_field_override.comment.comment.uid',
  'data' => 'a:16:{s:4:"uuid";s:36:"87e35c7e-8fea-4a75-b4a7-2eb0145ebb70";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:1:{i:0;s:20:"comment.type.comment";}}s:2:"id";s:19:"comment.comment.uid";s:10:"field_name";s:3:"uid";s:11:"entity_type";s:7:"comment";s:6:"bundle";s:7:"comment";s:5:"label";s:7:"User ID";s:11:"description";s:34:"The user ID of the comment author.";s:8:"required";b:0;s:12:"translatable";b:0;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:52:"Drupal\comment\Entity\Comment::getDefaultEntityOwner";s:8:"settings";a:2:{s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}s:10:"field_type";s:16:"entity_reference";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.base_field_override.menu_link_content.menu_link_content.changed',
  'data' => 'a:16:{s:4:"uuid";s:36:"86699fcf-33a9-42b9-a0d2-1ada5a10eb2e";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:17:"menu_link_content";}}s:2:"id";s:43:"menu_link_content.menu_link_content.changed";s:10:"field_name";s:7:"changed";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";s:17:"menu_link_content";s:5:"label";s:7:"Changed";s:11:"description";s:44:"The time that the menu link was last edited.";s:8:"required";b:0;s:12:"translatable";b:0;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:0:{}s:10:"field_type";s:7:"changed";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.base_field_override.menu_link_content.menu_link_content.description',
  'data' => 'a:16:{s:4:"uuid";s:36:"ec83dc02-9aee-4c3b-ad8d-af0a9521951e";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:17:"menu_link_content";}}s:2:"id";s:47:"menu_link_content.menu_link_content.description";s:10:"field_name";s:11:"description";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";s:17:"menu_link_content";s:5:"label";s:11:"Description";s:11:"description";s:39:"Shown when hovering over the menu link.";s:8:"required";b:0;s:12:"translatable";b:0;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:0:{}s:10:"field_type";s:6:"string";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.base_field_override.menu_link_content.menu_link_content.title',
  'data' => 'a:16:{s:4:"uuid";s:36:"7315ee29-7133-4144-9b9e-3e53f2740fb3";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:17:"menu_link_content";}}s:2:"id";s:41:"menu_link_content.menu_link_content.title";s:10:"field_name";s:5:"title";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";s:17:"menu_link_content";s:5:"label";s:15:"Menu link title";s:11:"description";s:46:"The text to be used for this link in the menu.";s:8:"required";b:1;s:12:"translatable";b:0;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:0:{}s:10:"field_type";s:6:"string";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.base_field_override.node.article.rh_action',
  'data' => 'a:16:{s:4:"uuid";s:36:"062f2320-ab99-4d4a-834c-501fe447ac5c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:1:{i:0;s:17:"node.type.article";}}s:2:"id";s:22:"node.article.rh_action";s:10:"field_name";s:9:"rh_action";s:11:"entity_type";s:4:"node";s:6:"bundle";s:7:"article";s:5:"label";s:18:"Rabbit Hole action";s:11:"description";s:52:"Specifies which action that Rabbit Hole should take.";s:8:"required";b:0;s:12:"translatable";b:0;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:0:{}s:10:"field_type";s:6:"string";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.base_field_override.node.article.rh_redirect',
  'data' => 'a:16:{s:4:"uuid";s:36:"7ded2e12-327a-4706-9239-4349e17a0c03";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:1:{i:0;s:17:"node.type.article";}}s:2:"id";s:24:"node.article.rh_redirect";s:10:"field_name";s:11:"rh_redirect";s:11:"entity_type";s:4:"node";s:6:"bundle";s:7:"article";s:5:"label";s:26:"Rabbit Hole redirect path.";s:11:"description";s:52:"The path to where the user should get redirected to.";s:8:"required";b:0;s:12:"translatable";b:0;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:0:{}s:10:"field_type";s:6:"string";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.base_field_override.node.article.rh_redirect_fallback_action',
  'data' => 'a:16:{s:4:"uuid";s:36:"a0c262b6-c92c-4626-9a6f-77e969a9cb4d";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:1:{i:0;s:17:"node.type.article";}}s:2:"id";s:40:"node.article.rh_redirect_fallback_action";s:10:"field_name";s:27:"rh_redirect_fallback_action";s:11:"entity_type";s:4:"node";s:6:"bundle";s:7:"article";s:5:"label";s:36:"Rabbit Hole redirect fallback action";s:11:"description";s:84:"Specifies the action that should be used when the redirect path is invalid or empty.";s:8:"required";b:0;s:12:"translatable";b:0;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:0:{}s:10:"field_type";s:6:"string";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.base_field_override.node.article.rh_redirect_response',
  'data' => 'a:16:{s:4:"uuid";s:36:"c678bbab-370a-4fe2-9077-2a6f8f8de945";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:1:{i:0;s:17:"node.type.article";}}s:2:"id";s:33:"node.article.rh_redirect_response";s:10:"field_name";s:20:"rh_redirect_response";s:11:"entity_type";s:4:"node";s:6:"bundle";s:7:"article";s:5:"label";s:34:"Rabbit Hole redirect response code";s:11:"description";s:77:"Specifies the HTTP response code that should be used when perform a redirect.";s:8:"required";b:0;s:12:"translatable";b:0;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:4:{s:3:"min";N;s:3:"max";N;s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}s:10:"field_type";s:7:"integer";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.base_field_override.node.page.promote',
  'data' => 'a:17:{s:4:"uuid";s:36:"a81001fa-33aa-4d00-b7ea-dbabbec715d1";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:1:{i:0;s:14:"node.type.page";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"fPUEnm4T5zfZRr3ttDUqq7yCDd2uW3clWD-pvos4tlQ";}s:2:"id";s:17:"node.page.promote";s:10:"field_name";s:7:"promote";s:11:"entity_type";s:4:"node";s:6:"bundle";s:4:"page";s:5:"label";s:22:"Promoted to front page";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";i:0;}}s:22:"default_value_callback";s:0:"";s:8:"settings";a:2:{s:8:"on_label";s:2:"On";s:9:"off_label";s:3:"Off";}s:10:"field_type";s:7:"boolean";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.base_field_override.shortcut.default.title',
  'data' => 'a:16:{s:4:"uuid";s:36:"010aa3ca-9514-42d9-a9d1-e334ebc4900b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:1:{i:0;s:20:"shortcut.set.default";}}s:2:"id";s:22:"shortcut.default.title";s:10:"field_name";s:5:"title";s:11:"entity_type";s:8:"shortcut";s:6:"bundle";s:7:"default";s:5:"label";s:4:"Name";s:11:"description";s:25:"The name of the shortcut.";s:8:"required";b:1;s:12:"translatable";b:0;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:0:{}s:10:"field_type";s:6:"string";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.base_field_override.taxonomy_term.tags.changed',
  'data' => 'a:16:{s:4:"uuid";s:36:"af42b204-bebc-4a6c-bd09-20d9cdd7b38c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:1:{i:0;s:24:"taxonomy.vocabulary.tags";}}s:2:"id";s:26:"taxonomy_term.tags.changed";s:10:"field_name";s:7:"changed";s:11:"entity_type";s:13:"taxonomy_term";s:6:"bundle";s:4:"tags";s:5:"label";s:7:"Changed";s:11:"description";s:39:"The time that the term was last edited.";s:8:"required";b:0;s:12:"translatable";b:0;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:0:{}s:10:"field_type";s:7:"changed";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.base_field_override.taxonomy_term.tags.description',
  'data' => 'a:16:{s:4:"uuid";s:36:"72ea2bd3-d8cf-4509-88d3-dcef55c3f1ee";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:24:"taxonomy.vocabulary.tags";}s:6:"module";a:1:{i:0;s:4:"text";}}s:2:"id";s:30:"taxonomy_term.tags.description";s:10:"field_name";s:11:"description";s:11:"entity_type";s:13:"taxonomy_term";s:6:"bundle";s:4:"tags";s:5:"label";s:11:"Description";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:0;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:0:{}s:10:"field_type";s:9:"text_long";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.base_field_override.taxonomy_term.tags.name',
  'data' => 'a:16:{s:4:"uuid";s:36:"93412faa-4d09-4f10-83b7-9d5cae40c467";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:1:{i:0;s:24:"taxonomy.vocabulary.tags";}}s:2:"id";s:23:"taxonomy_term.tags.name";s:10:"field_name";s:4:"name";s:11:"entity_type";s:13:"taxonomy_term";s:6:"bundle";s:4:"tags";s:5:"label";s:4:"Name";s:11:"description";s:0:"";s:8:"required";b:1;s:12:"translatable";b:0;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:0:{}s:10:"field_type";s:6:"string";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.base_field_override.taxonomy_term.tags.path',
  'data' => 'a:16:{s:4:"uuid";s:36:"cbc2f376-3b41-4057-a273-eadceae16414";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:24:"taxonomy.vocabulary.tags";}s:6:"module";a:1:{i:0;s:4:"path";}}s:2:"id";s:23:"taxonomy_term.tags.path";s:10:"field_name";s:4:"path";s:11:"entity_type";s:13:"taxonomy_term";s:6:"bundle";s:4:"tags";s:5:"label";s:9:"URL alias";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:0;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:0:{}s:10:"field_type";s:4:"path";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.base_field_override.taxonomy_term.tags.rh_action',
  'data' => 'a:16:{s:4:"uuid";s:36:"083af0da-1165-4d27-9f1d-02b03c35936b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:1:{i:0;s:24:"taxonomy.vocabulary.tags";}}s:2:"id";s:28:"taxonomy_term.tags.rh_action";s:10:"field_name";s:9:"rh_action";s:11:"entity_type";s:13:"taxonomy_term";s:6:"bundle";s:4:"tags";s:5:"label";s:18:"Rabbit Hole action";s:11:"description";s:52:"Specifies which action that Rabbit Hole should take.";s:8:"required";b:0;s:12:"translatable";b:0;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:0:{}s:10:"field_type";s:6:"string";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.base_field_override.taxonomy_term.tags.rh_redirect',
  'data' => 'a:16:{s:4:"uuid";s:36:"69078bef-d9da-4b06-bef5-62c83444a9f6";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:1:{i:0;s:24:"taxonomy.vocabulary.tags";}}s:2:"id";s:30:"taxonomy_term.tags.rh_redirect";s:10:"field_name";s:11:"rh_redirect";s:11:"entity_type";s:13:"taxonomy_term";s:6:"bundle";s:4:"tags";s:5:"label";s:26:"Rabbit Hole redirect path.";s:11:"description";s:52:"The path to where the user should get redirected to.";s:8:"required";b:0;s:12:"translatable";b:0;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:0:{}s:10:"field_type";s:6:"string";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.base_field_override.taxonomy_term.tags.rh_redirect_fallback_action',
  'data' => 'a:16:{s:4:"uuid";s:36:"22f65d4b-d9c5-4606-9856-3ee22df13795";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:1:{i:0;s:24:"taxonomy.vocabulary.tags";}}s:2:"id";s:46:"taxonomy_term.tags.rh_redirect_fallback_action";s:10:"field_name";s:27:"rh_redirect_fallback_action";s:11:"entity_type";s:13:"taxonomy_term";s:6:"bundle";s:4:"tags";s:5:"label";s:36:"Rabbit Hole redirect fallback action";s:11:"description";s:84:"Specifies the action that should be used when the redirect path is invalid or empty.";s:8:"required";b:0;s:12:"translatable";b:0;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:0:{}s:10:"field_type";s:6:"string";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.base_field_override.taxonomy_term.tags.rh_redirect_response',
  'data' => 'a:16:{s:4:"uuid";s:36:"9ae3fec0-f92a-4057-a6f7-bda872976a10";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:1:{i:0;s:24:"taxonomy.vocabulary.tags";}}s:2:"id";s:39:"taxonomy_term.tags.rh_redirect_response";s:10:"field_name";s:20:"rh_redirect_response";s:11:"entity_type";s:13:"taxonomy_term";s:6:"bundle";s:4:"tags";s:5:"label";s:34:"Rabbit Hole redirect response code";s:11:"description";s:77:"Specifies the HTTP response code that should be used when perform a redirect.";s:8:"required";b:0;s:12:"translatable";b:0;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:4:{s:3:"min";N;s:3:"max";N;s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}s:10:"field_type";s:7:"integer";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.base_field_override.taxonomy_term.tags.status',
  'data' => 'a:16:{s:4:"uuid";s:36:"31ff29dd-82a8-44f8-a637-2c83057ace31";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:1:{i:0;s:24:"taxonomy.vocabulary.tags";}}s:2:"id";s:25:"taxonomy_term.tags.status";s:10:"field_name";s:6:"status";s:11:"entity_type";s:13:"taxonomy_term";s:6:"bundle";s:4:"tags";s:5:"label";s:9:"Published";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:0;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";i:1;}}s:22:"default_value_callback";s:0:"";s:8:"settings";a:2:{s:8:"on_label";s:2:"On";s:9:"off_label";s:3:"Off";}s:10:"field_type";s:7:"boolean";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.base_field_override.user.user.changed',
  'data' => 'a:16:{s:4:"uuid";s:36:"dde9ebf7-2660-4908-84fe-19fea6b58d52";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:2:"id";s:17:"user.user.changed";s:10:"field_name";s:7:"changed";s:11:"entity_type";s:4:"user";s:6:"bundle";s:4:"user";s:5:"label";s:7:"Changed";s:11:"description";s:39:"The time that the user was last edited.";s:8:"required";b:0;s:12:"translatable";b:0;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:0:{}s:10:"field_type";s:7:"changed";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.base_field_override.user.user.rh_action',
  'data' => 'a:16:{s:4:"uuid";s:36:"8657e051-84d7-472b-b97e-50fb218bdec5";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:2:"id";s:19:"user.user.rh_action";s:10:"field_name";s:9:"rh_action";s:11:"entity_type";s:4:"user";s:6:"bundle";s:4:"user";s:5:"label";s:18:"Rabbit Hole action";s:11:"description";s:52:"Specifies which action that Rabbit Hole should take.";s:8:"required";b:0;s:12:"translatable";b:0;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:0:{}s:10:"field_type";s:6:"string";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.base_field_override.user.user.rh_redirect',
  'data' => 'a:16:{s:4:"uuid";s:36:"09d8c72d-3aeb-4386-80ef-30e765f255d2";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:2:"id";s:21:"user.user.rh_redirect";s:10:"field_name";s:11:"rh_redirect";s:11:"entity_type";s:4:"user";s:6:"bundle";s:4:"user";s:5:"label";s:26:"Rabbit Hole redirect path.";s:11:"description";s:52:"The path to where the user should get redirected to.";s:8:"required";b:0;s:12:"translatable";b:0;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:0:{}s:10:"field_type";s:6:"string";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.base_field_override.user.user.rh_redirect_fallback_action',
  'data' => 'a:16:{s:4:"uuid";s:36:"a0c01f27-9134-48d8-a21c-c3a9f676d4e1";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:2:"id";s:37:"user.user.rh_redirect_fallback_action";s:10:"field_name";s:27:"rh_redirect_fallback_action";s:11:"entity_type";s:4:"user";s:6:"bundle";s:4:"user";s:5:"label";s:36:"Rabbit Hole redirect fallback action";s:11:"description";s:84:"Specifies the action that should be used when the redirect path is invalid or empty.";s:8:"required";b:0;s:12:"translatable";b:0;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:0:{}s:10:"field_type";s:6:"string";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.base_field_override.user.user.rh_redirect_response',
  'data' => 'a:16:{s:4:"uuid";s:36:"6ecc200f-7bb8-4c18-82b4-631827cba805";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:2:"id";s:30:"user.user.rh_redirect_response";s:10:"field_name";s:20:"rh_redirect_response";s:11:"entity_type";s:4:"user";s:6:"bundle";s:4:"user";s:5:"label";s:34:"Rabbit Hole redirect response code";s:11:"description";s:77:"Specifies the HTTP response code that should be used when perform a redirect.";s:8:"required";b:0;s:12:"translatable";b:0;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:4:{s:3:"min";N;s:3:"max";N;s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}s:10:"field_type";s:7:"integer";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.date_format.fallback',
  'data' => 'a:9:{s:4:"uuid";s:36:"fc55a34d-977a-4c5e-9dab-c53f0ec8b807";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"7klS5IWXrwzVaPpYZFAs6wcx8U2FF1X73OfrtTsvuvE";}s:2:"id";s:8:"fallback";s:5:"label";s:20:"Fallback date format";s:6:"locked";b:1;s:7:"pattern";s:14:"D, m/d/Y - H:i";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.date_format.html_date',
  'data' => 'a:9:{s:4:"uuid";s:36:"a250c99c-7172-4b50-b307-511c40463c4d";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"EOQltUQPmgc6UQ2rcJ4Xi_leCEJj5ui0TR-12duS-Tk";}s:2:"id";s:9:"html_date";s:5:"label";s:9:"HTML Date";s:6:"locked";b:1;s:7:"pattern";s:5:"Y-m-d";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.date_format.html_datetime',
  'data' => 'a:9:{s:4:"uuid";s:36:"bf6c9d38-c690-404a-8d73-c8f0aad5470f";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"jxfClwZIRXIdcvMrE--WkcZxDGUVoOIE3Sm2NRZlFuE";}s:2:"id";s:13:"html_datetime";s:5:"label";s:13:"HTML Datetime";s:6:"locked";b:1;s:7:"pattern";s:13:"Y-m-d\TH:i:sO";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.date_format.html_month',
  'data' => 'a:9:{s:4:"uuid";s:36:"ea70c2ac-98e7-4c4a-a56a-ec5bf6ce3e53";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Z7KuCUwM_WdTNvLcoltuX3_8d-s-8FZkTN6KgNwF0eM";}s:2:"id";s:10:"html_month";s:5:"label";s:10:"HTML Month";s:6:"locked";b:1;s:7:"pattern";s:3:"Y-m";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.date_format.html_time',
  'data' => 'a:9:{s:4:"uuid";s:36:"5568ba70-4dae-4e97-8b83-2cb119bc6be2";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"M7yqicYkU36hRy5p9drAaGBBihhUD1OyujFrAaQ93ZE";}s:2:"id";s:9:"html_time";s:5:"label";s:9:"HTML Time";s:6:"locked";b:1;s:7:"pattern";s:5:"H:i:s";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.date_format.html_week',
  'data' => 'a:9:{s:4:"uuid";s:36:"a2e91c79-4092-4c47-94bb-b84041f2b3dc";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"wKD4WsoV_wFgv2vgI4mcAAFSIzrye17ykzdwrnApkfY";}s:2:"id";s:9:"html_week";s:5:"label";s:9:"HTML Week";s:6:"locked";b:1;s:7:"pattern";s:5:"Y-\WW";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.date_format.html_year',
  'data' => 'a:9:{s:4:"uuid";s:36:"0e95ba11-2ad1-4afe-8e2a-05b49c6ee6b9";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"OjekiQuX9RbVQ2_8jOHBL94RgYLePqX7wpfNGgcQzrk";}s:2:"id";s:9:"html_year";s:5:"label";s:9:"HTML Year";s:6:"locked";b:1;s:7:"pattern";s:1:"Y";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.date_format.html_yearless_date',
  'data' => 'a:9:{s:4:"uuid";s:36:"f1c6c204-fc6f-47ab-a5ec-73f2033bdeaf";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"5VpawMrKPEPCkoO4YpPa0TDFO2dgiIHfTziJtwlmUxc";}s:2:"id";s:18:"html_yearless_date";s:5:"label";s:18:"HTML Yearless date";s:6:"locked";b:1;s:7:"pattern";s:3:"m-d";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.date_format.long',
  'data' => 'a:9:{s:4:"uuid";s:36:"1d0b2c03-3a8a-43d2-96d7-85796d902a39";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"og8sWXhBuHbLMw3CoiBEZjgqSyhFBFmcbUW_wLcfNbo";}s:2:"id";s:4:"long";s:5:"label";s:17:"Default long date";s:6:"locked";b:0;s:7:"pattern";s:15:"l, F j, Y - H:i";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.date_format.medium',
  'data' => 'a:9:{s:4:"uuid";s:36:"5b386ae4-5082-4cde-9ec6-6a0a9c1fb723";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"nzL5d024NjXIX_8TlT6uFAu973lmfkmHklJC-2i9rAE";}s:2:"id";s:6:"medium";s:5:"label";s:19:"Default medium date";s:6:"locked";b:0;s:7:"pattern";s:14:"D, m/d/Y - H:i";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.date_format.olivero_medium',
  'data' => 'a:9:{s:4:"uuid";s:36:"2ffba333-ed3b-4e2e-81e7-66b3364aa6bb";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:8:"enforced";a:1:{s:5:"theme";a:1:{i:0;s:7:"olivero";}}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Mt6cmxUbDZ9XxD6p25WQ8tj3_JcX8ylfcddwZc8gcAE";}s:2:"id";s:14:"olivero_medium";s:5:"label";s:14:"Olivero Medium";s:6:"locked";b:0;s:7:"pattern";s:8:"j  F,  Y";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.date_format.short',
  'data' => 'a:9:{s:4:"uuid";s:36:"ee4078e7-1a7f-4492-a2be-63a96add03b9";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"AlzeyytA8InBgxIG9H2UDJYs3CG98Zj6yRsDKmlbZwA";}s:2:"id";s:5:"short";s:5:"label";s:18:"Default short date";s:6:"locked";b:0;s:7:"pattern";s:11:"m/d/Y - H:i";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_form_display.block_content.basic.default',
  'data' => 'a:11:{s:4:"uuid";s:36:"8d2b1728-4a57-4aa8-8653-8d5e9e9fac2d";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:24:"block_content.type.basic";i:1;s:36:"field.field.block_content.basic.body";}s:6:"module";a:1:{i:0;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"jAps3FCxvKecABS_tgExbhCZrBLQB3bNPWw18WjE3ss";}s:2:"id";s:27:"block_content.basic.default";s:16:"targetEntityType";s:13:"block_content";s:6:"bundle";s:5:"basic";s:4:"mode";s:7:"default";s:7:"content";a:3:{s:4:"body";a:5:{s:4:"type";s:26:"text_textarea_with_summary";s:6:"weight";i:-4;s:6:"region";s:7:"content";s:8:"settings";a:4:{s:4:"rows";i:9;s:12:"summary_rows";i:3;s:11:"placeholder";s:0:"";s:12:"show_summary";b:0;}s:20:"third_party_settings";a:0:{}}s:4:"info";a:5:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:-5;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:8:"langcode";a:5:{s:4:"type";s:15:"language_select";s:6:"weight";i:2;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:14:"include_locked";b:1;}s:20:"third_party_settings";a:0:{}}}s:6:"hidden";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_form_display.comment.comment.default',
  'data' => 'a:11:{s:4:"uuid";s:36:"158b3f10-2979-46bf-83e2-a687c389253c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:20:"comment.type.comment";i:1;s:40:"field.field.comment.comment.comment_body";}s:6:"module";a:1:{i:0;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"I0Pa0aQvT_jawlPo9oz4FE3h_ickc55dYKTPl6gILes";}s:2:"id";s:23:"comment.comment.default";s:16:"targetEntityType";s:7:"comment";s:6:"bundle";s:7:"comment";s:4:"mode";s:7:"default";s:7:"content";a:4:{s:6:"author";a:2:{s:6:"weight";i:-2;s:6:"region";s:7:"content";}s:12:"comment_body";a:5:{s:4:"type";s:13:"text_textarea";s:6:"weight";i:11;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"rows";i:5;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:8:"langcode";a:5:{s:4:"type";s:15:"language_select";s:6:"weight";i:2;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:14:"include_locked";b:1;}s:20:"third_party_settings";a:0:{}}s:7:"subject";a:5:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:10;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}}s:6:"hidden";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_form_display.node.article.default',
  'data' => 'a:11:{s:4:"uuid";s:36:"26f84e3c-dce5-445f-bc14-e13f3f3077e0";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:6:{i:0;s:29:"field.field.node.article.body";i:1;s:32:"field.field.node.article.comment";i:2;s:36:"field.field.node.article.field_image";i:3;s:35:"field.field.node.article.field_tags";i:4;s:21:"image.style.thumbnail";i:5;s:17:"node.type.article";}s:6:"module";a:4:{i:0;s:7:"comment";i:1;s:5:"image";i:2;s:4:"path";i:3;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ewbd6G2uX456-bgwseM2Q-KQG3RkASoyHmTh-XR3oLU";}s:2:"id";s:20:"node.article.default";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:7:"article";s:4:"mode";s:7:"default";s:7:"content";a:12:{s:4:"body";a:5:{s:4:"type";s:26:"text_textarea_with_summary";s:6:"weight";i:2;s:6:"region";s:7:"content";s:8:"settings";a:4:{s:4:"rows";i:9;s:12:"summary_rows";i:3;s:11:"placeholder";s:0:"";s:12:"show_summary";b:0;}s:20:"third_party_settings";a:0:{}}s:7:"comment";a:5:{s:4:"type";s:15:"comment_default";s:6:"weight";i:20;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:7:"created";a:5:{s:4:"type";s:18:"datetime_timestamp";s:6:"weight";i:10;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:11:"field_image";a:5:{s:4:"type";s:11:"image_image";s:6:"weight";i:1;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:18:"progress_indicator";s:8:"throbber";s:19:"preview_image_style";s:9:"thumbnail";}s:20:"third_party_settings";a:0:{}}s:10:"field_tags";a:5:{s:4:"type";s:34:"entity_reference_autocomplete_tags";s:6:"weight";i:3;s:6:"region";s:7:"content";s:8:"settings";a:4:{s:14:"match_operator";s:8:"CONTAINS";s:11:"match_limit";i:10;s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:8:"langcode";a:5:{s:4:"type";s:15:"language_select";s:6:"weight";i:2;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:14:"include_locked";b:1;}s:20:"third_party_settings";a:0:{}}s:4:"path";a:5:{s:4:"type";s:4:"path";s:6:"weight";i:30;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:7:"promote";a:5:{s:4:"type";s:16:"boolean_checkbox";s:6:"weight";i:15;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:20:"third_party_settings";a:0:{}}s:6:"status";a:5:{s:4:"type";s:16:"boolean_checkbox";s:6:"weight";i:120;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:20:"third_party_settings";a:0:{}}s:6:"sticky";a:5:{s:4:"type";s:16:"boolean_checkbox";s:6:"weight";i:16;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:20:"third_party_settings";a:0:{}}s:5:"title";a:5:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:0;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:3:"uid";a:5:{s:4:"type";s:29:"entity_reference_autocomplete";s:6:"weight";i:5;s:6:"region";s:7:"content";s:8:"settings";a:4:{s:14:"match_operator";s:8:"CONTAINS";s:11:"match_limit";i:10;s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}}s:6:"hidden";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_form_display.node.page.default',
  'data' => 'a:11:{s:4:"uuid";s:36:"5201f1f5-40b8-4a21-bdd8-a74ab02089bc";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:26:"field.field.node.page.body";i:1;s:14:"node.type.page";}s:6:"module";a:2:{i:0;s:4:"path";i:1;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"SfpLhPExzvR0MgFp0Wp7CrmgEnhcqQ-fXIWFhbf4ue0";}s:2:"id";s:17:"node.page.default";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:4:"page";s:4:"mode";s:7:"default";s:7:"content";a:9:{s:4:"body";a:5:{s:4:"type";s:26:"text_textarea_with_summary";s:6:"weight";i:31;s:6:"region";s:7:"content";s:8:"settings";a:4:{s:4:"rows";i:9;s:12:"summary_rows";i:3;s:11:"placeholder";s:0:"";s:12:"show_summary";b:0;}s:20:"third_party_settings";a:0:{}}s:7:"created";a:5:{s:4:"type";s:18:"datetime_timestamp";s:6:"weight";i:10;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:8:"langcode";a:5:{s:4:"type";s:15:"language_select";s:6:"weight";i:2;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:14:"include_locked";b:1;}s:20:"third_party_settings";a:0:{}}s:4:"path";a:5:{s:4:"type";s:4:"path";s:6:"weight";i:30;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:7:"promote";a:5:{s:4:"type";s:16:"boolean_checkbox";s:6:"weight";i:15;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:20:"third_party_settings";a:0:{}}s:6:"status";a:5:{s:4:"type";s:16:"boolean_checkbox";s:6:"weight";i:120;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:20:"third_party_settings";a:0:{}}s:6:"sticky";a:5:{s:4:"type";s:16:"boolean_checkbox";s:6:"weight";i:16;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:20:"third_party_settings";a:0:{}}s:5:"title";a:5:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:-5;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:3:"uid";a:5:{s:4:"type";s:29:"entity_reference_autocomplete";s:6:"weight";i:5;s:6:"region";s:7:"content";s:8:"settings";a:4:{s:14:"match_operator";s:8:"CONTAINS";s:11:"match_limit";i:10;s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}}s:6:"hidden";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_form_display.user.user.default',
  'data' => 'a:11:{s:4:"uuid";s:36:"496aaf84-ad4d-4013-9c17-a9cda437272b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:34:"field.field.user.user.user_picture";i:1;s:21:"image.style.thumbnail";}s:6:"module";a:2:{i:0;s:5:"image";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"FaQ9Ptcpxpg30AtiqRDtl_8zbJArHP1LPfug_s59TOA";}s:2:"id";s:17:"user.user.default";s:16:"targetEntityType";s:4:"user";s:6:"bundle";s:4:"user";s:4:"mode";s:7:"default";s:7:"content";a:5:{s:7:"account";a:2:{s:6:"weight";i:-10;s:6:"region";s:7:"content";}s:7:"contact";a:2:{s:6:"weight";i:5;s:6:"region";s:7:"content";}s:8:"language";a:2:{s:6:"weight";i:0;s:6:"region";s:7:"content";}s:8:"timezone";a:2:{s:6:"weight";i:6;s:6:"region";s:7:"content";}s:12:"user_picture";a:5:{s:4:"type";s:11:"image_image";s:6:"weight";i:-1;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:18:"progress_indicator";s:8:"throbber";s:19:"preview_image_style";s:9:"thumbnail";}s:20:"third_party_settings";a:0:{}}}s:6:"hidden";a:1:{s:8:"langcode";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_form_mode.user.register',
  'data' => 'a:9:{s:4:"uuid";s:36:"dc755c05-6c79-41b9-a243-27bad6080f38";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"flXhTcp55yLcyy7ZLOhPGKGZobZQJdkAFVWV3LseiuI";}s:2:"id";s:13:"user.register";s:5:"label";s:8:"Register";s:16:"targetEntityType";s:4:"user";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.block_content.basic.default',
  'data' => 'a:11:{s:4:"uuid";s:36:"32412924-bff8-41a6-bf40-dab1e7e643e3";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:24:"block_content.type.basic";i:1;s:36:"field.field.block_content.basic.body";}s:6:"module";a:1:{i:0;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"hBNNDTFwakREOTa6GGMqN899Iyrii0hInwSJtQ7Kj30";}s:2:"id";s:27:"block_content.basic.default";s:16:"targetEntityType";s:13:"block_content";s:6:"bundle";s:5:"basic";s:4:"mode";s:7:"default";s:7:"content";a:1:{s:4:"body";a:6:{s:4:"type";s:12:"text_default";s:5:"label";s:6:"hidden";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}}s:6:"hidden";a:1:{s:8:"langcode";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.comment.comment.default',
  'data' => 'a:11:{s:4:"uuid";s:36:"294f8feb-b408-4d00-995c-e1d58f72e00b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:20:"comment.type.comment";i:1;s:40:"field.field.comment.comment.comment_body";}s:6:"module";a:1:{i:0;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"aBQUGsQ46M4048fIlFuTXwl2zV0j2cJX89CTUobh9hA";}s:2:"id";s:23:"comment.comment.default";s:16:"targetEntityType";s:7:"comment";s:6:"bundle";s:7:"comment";s:4:"mode";s:7:"default";s:7:"content";a:2:{s:12:"comment_body";a:6:{s:4:"type";s:12:"text_default";s:5:"label";s:6:"hidden";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}s:5:"links";a:2:{s:6:"weight";i:100;s:6:"region";s:7:"content";}}s:6:"hidden";a:1:{s:8:"langcode";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.node.article.default',
  'data' => 'a:11:{s:4:"uuid";s:36:"69b0f199-ad2a-49cd-9dd7-89dd23c5b66c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:7:{i:0;s:48:"core.entity_view_display.comment.comment.default";i:1;s:29:"field.field.node.article.body";i:2;s:32:"field.field.node.article.comment";i:3;s:36:"field.field.node.article.field_image";i:4;s:35:"field.field.node.article.field_tags";i:5;s:16:"image.style.wide";i:6;s:17:"node.type.article";}s:6:"module";a:4:{i:0;s:7:"comment";i:1;s:5:"image";i:2;s:4:"text";i:3;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"7fb0j9HnIXfP9ndewzgPPzzeX_SV532wuYpkscrCMCk";}s:2:"id";s:20:"node.article.default";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:7:"article";s:4:"mode";s:7:"default";s:7:"content";a:5:{s:4:"body";a:6:{s:4:"type";s:12:"text_default";s:5:"label";s:6:"hidden";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}s:7:"comment";a:6:{s:4:"type";s:15:"comment_default";s:5:"label";s:5:"above";s:8:"settings";a:2:{s:9:"view_mode";s:7:"default";s:8:"pager_id";i:0;}s:20:"third_party_settings";a:0:{}s:6:"weight";i:110;s:6:"region";s:7:"content";}s:11:"field_image";a:6:{s:4:"type";s:5:"image";s:5:"label";s:6:"hidden";s:8:"settings";a:3:{s:10:"image_link";s:0:"";s:11:"image_style";s:4:"wide";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:-1;s:6:"region";s:7:"content";}s:10:"field_tags";a:6:{s:4:"type";s:22:"entity_reference_label";s:5:"label";s:5:"above";s:8:"settings";a:1:{s:4:"link";b:1;}s:20:"third_party_settings";a:0:{}s:6:"weight";i:10;s:6:"region";s:7:"content";}s:5:"links";a:4:{s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:6:"weight";i:100;s:6:"region";s:7:"content";}}s:6:"hidden";a:1:{s:8:"langcode";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.node.article.rss',
  'data' => 'a:11:{s:4:"uuid";s:36:"90156650-0cc9-4125-97fe-0479950a9551";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:6:{i:0;s:30:"core.entity_view_mode.node.rss";i:1;s:29:"field.field.node.article.body";i:2;s:32:"field.field.node.article.comment";i:3;s:36:"field.field.node.article.field_image";i:4;s:35:"field.field.node.article.field_tags";i:5;s:17:"node.type.article";}s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"2rIr6K5Q0UQ9khg0zE_CK-PtJH76UL-BDDZcZnZzwCc";}s:2:"id";s:16:"node.article.rss";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:7:"article";s:4:"mode";s:3:"rss";s:7:"content";a:1:{s:5:"links";a:2:{s:6:"weight";i:100;s:6:"region";s:7:"content";}}s:6:"hidden";a:5:{s:4:"body";b:1;s:7:"comment";b:1;s:11:"field_image";b:1;s:10:"field_tags";b:1;s:8:"langcode";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.node.article.teaser',
  'data' => 'a:11:{s:4:"uuid";s:36:"afa608b4-006c-42dd-9afa-43f3c16ef7cd";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:7:{i:0;s:33:"core.entity_view_mode.node.teaser";i:1;s:29:"field.field.node.article.body";i:2;s:32:"field.field.node.article.comment";i:3;s:36:"field.field.node.article.field_image";i:4;s:35:"field.field.node.article.field_tags";i:5;s:18:"image.style.medium";i:6;s:17:"node.type.article";}s:6:"module";a:3:{i:0;s:5:"image";i:1;s:4:"text";i:2;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"83jX5ChAGdMzOxiDA_B1NjgebVMuD8lNVDgClg_QVP8";}s:2:"id";s:19:"node.article.teaser";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:7:"article";s:4:"mode";s:6:"teaser";s:7:"content";a:4:{s:4:"body";a:6:{s:4:"type";s:23:"text_summary_or_trimmed";s:5:"label";s:6:"hidden";s:8:"settings";a:1:{s:11:"trim_length";i:600;}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}s:11:"field_image";a:6:{s:4:"type";s:5:"image";s:5:"label";s:6:"hidden";s:8:"settings";a:3:{s:10:"image_link";s:7:"content";s:11:"image_style";s:6:"medium";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:-1;s:6:"region";s:7:"content";}s:10:"field_tags";a:6:{s:4:"type";s:22:"entity_reference_label";s:5:"label";s:5:"above";s:8:"settings";a:1:{s:4:"link";b:1;}s:20:"third_party_settings";a:0:{}s:6:"weight";i:10;s:6:"region";s:7:"content";}s:5:"links";a:2:{s:6:"weight";i:100;s:6:"region";s:7:"content";}}s:6:"hidden";a:4:{s:7:"comment";b:1;s:11:"field_image";b:1;s:10:"field_tags";b:1;s:8:"langcode";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.node.page.default',
  'data' => 'a:11:{s:4:"uuid";s:36:"3df1c635-9a37-4ebd-b6ac-d6c576bf5c93";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:26:"field.field.node.page.body";i:1;s:14:"node.type.page";}s:6:"module";a:2:{i:0;s:4:"text";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"M_Y8L5tfmhx7DR143E05YyZSpvgil6VFvqcfBWykalg";}s:2:"id";s:17:"node.page.default";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:4:"page";s:4:"mode";s:7:"default";s:7:"content";a:2:{s:4:"body";a:6:{s:4:"type";s:12:"text_default";s:5:"label";s:6:"hidden";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:6:"weight";i:100;s:6:"region";s:7:"content";}s:5:"links";a:2:{s:6:"weight";i:101;s:6:"region";s:7:"content";}}s:6:"hidden";a:1:{s:8:"langcode";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.node.page.teaser',
  'data' => 'a:11:{s:4:"uuid";s:36:"7b67ecbf-72bd-4e61-b6a8-9f382e2c171c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:3:{i:0;s:33:"core.entity_view_mode.node.teaser";i:1;s:26:"field.field.node.page.body";i:2;s:14:"node.type.page";}s:6:"module";a:2:{i:0;s:4:"text";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"8BgdRtLbtQ0F__o0FHSH0Mx5fvXOra9tfT1GmNKbRYw";}s:2:"id";s:16:"node.page.teaser";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:4:"page";s:4:"mode";s:6:"teaser";s:7:"content";a:2:{s:4:"body";a:6:{s:4:"type";s:23:"text_summary_or_trimmed";s:5:"label";s:6:"hidden";s:8:"settings";a:1:{s:11:"trim_length";i:600;}s:20:"third_party_settings";a:0:{}s:6:"weight";i:100;s:6:"region";s:7:"content";}s:5:"links";a:2:{s:6:"weight";i:101;s:6:"region";s:7:"content";}}s:6:"hidden";a:1:{s:8:"langcode";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.user.user.compact',
  'data' => 'a:11:{s:4:"uuid";s:36:"7d171050-f25c-46c6-bebb-7677d4567e18";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:3:{i:0;s:34:"core.entity_view_mode.user.compact";i:1;s:34:"field.field.user.user.user_picture";i:2;s:21:"image.style.thumbnail";}s:6:"module";a:2:{i:0;s:5:"image";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"00zr_RBdTjPjBGITD3h4c1ESQZimjdVCcHGt1trLqIY";}s:2:"id";s:17:"user.user.compact";s:16:"targetEntityType";s:4:"user";s:6:"bundle";s:4:"user";s:4:"mode";s:7:"compact";s:7:"content";a:1:{s:12:"user_picture";a:6:{s:4:"type";s:5:"image";s:5:"label";s:6:"hidden";s:8:"settings";a:3:{s:10:"image_link";s:7:"content";s:11:"image_style";s:9:"thumbnail";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}}s:6:"hidden";a:2:{s:8:"langcode";b:1;s:10:"member_for";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.user.user.default',
  'data' => 'a:11:{s:4:"uuid";s:36:"7ca019af-f9a1-42bb-9a97-2b075fd770ea";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:34:"field.field.user.user.user_picture";i:1;s:21:"image.style.thumbnail";}s:6:"module";a:2:{i:0;s:5:"image";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"mZLyuWM9CQx2ZJVqFGSbzgFnHzudVbHBYmdU256A5Wk";}s:2:"id";s:17:"user.user.default";s:16:"targetEntityType";s:4:"user";s:6:"bundle";s:4:"user";s:4:"mode";s:7:"default";s:7:"content";a:2:{s:10:"member_for";a:2:{s:6:"weight";i:5;s:6:"region";s:7:"content";}s:12:"user_picture";a:6:{s:4:"type";s:5:"image";s:5:"label";s:6:"hidden";s:8:"settings";a:3:{s:10:"image_link";s:7:"content";s:11:"image_style";s:9:"thumbnail";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}}s:6:"hidden";a:1:{s:8:"langcode";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.block_content.full',
  'data' => 'a:9:{s:4:"uuid";s:36:"5c5c9306-d386-4ecc-ae0d-629535b0c29f";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:13:"block_content";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"4tedlMuvQjDOdvHdw86_e-2Rt78aR7TGFMfOK8Ejppg";}s:2:"id";s:18:"block_content.full";s:5:"label";s:4:"Full";s:16:"targetEntityType";s:13:"block_content";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.comment.full',
  'data' => 'a:9:{s:4:"uuid";s:36:"388d609f-5453-4e15-b2f5-83a72ae546d7";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:7:"comment";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"K7eNlfU7NEUajz01wItywZklr2oaPgL6s1_97fmDXLA";}s:2:"id";s:12:"comment.full";s:5:"label";s:12:"Full comment";s:16:"targetEntityType";s:7:"comment";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.node.full',
  'data' => 'a:9:{s:4:"uuid";s:36:"249d4400-885a-4003-be6e-9353dd5fc4c7";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ElrtInxGjZd7GaapJ5O9n-ugi2hG2IxFivtgn0tHOsk";}s:2:"id";s:9:"node.full";s:5:"label";s:12:"Full content";s:16:"targetEntityType";s:4:"node";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.node.rss',
  'data' => 'a:9:{s:4:"uuid";s:36:"86d20921-4629-4162-b3a5-419cfb9af234";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"vlYzr-rp2f9NMp-Qlr4sFjlqRq-90mco5-afLNGwCrU";}s:2:"id";s:8:"node.rss";s:5:"label";s:3:"RSS";s:16:"targetEntityType";s:4:"node";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.node.search_index',
  'data' => 'a:9:{s:4:"uuid";s:36:"4a18b620-3934-406b-b0a3-b181e5e7671a";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"fVFfJv_GzBRE-wpRHbfD5a3VjnhbEOXG6lvRd3uaccY";}s:2:"id";s:17:"node.search_index";s:5:"label";s:12:"Search index";s:16:"targetEntityType";s:4:"node";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.node.search_result',
  'data' => 'a:9:{s:4:"uuid";s:36:"1b99a673-7dd1-4f63-bac1-c08068a1dcea";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"6GCOQ-jP2RbdbHA5YWQ6bT8CfGbqrBYKOSC_XY4E3ZM";}s:2:"id";s:18:"node.search_result";s:5:"label";s:32:"Search result highlighting input";s:16:"targetEntityType";s:4:"node";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.node.teaser',
  'data' => 'a:9:{s:4:"uuid";s:36:"c641d165-0cb4-467c-8aa6-54ac4ffe62d7";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Mz9qWr1kUYK0mjRAGDsr5XS6PvtZ24en_7ndt-pyWe4";}s:2:"id";s:11:"node.teaser";s:5:"label";s:6:"Teaser";s:16:"targetEntityType";s:4:"node";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.taxonomy_term.full',
  'data' => 'a:9:{s:4:"uuid";s:36:"f35baadd-bd61-488f-9032-b91176c3235e";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:8:"taxonomy";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"-PPKjsNQPvoIDjOuUAvlLocYD976MNjb9Zpgyz5_BWE";}s:2:"id";s:18:"taxonomy_term.full";s:5:"label";s:18:"Taxonomy term page";s:16:"targetEntityType";s:13:"taxonomy_term";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.user.compact',
  'data' => 'a:9:{s:4:"uuid";s:36:"463b7949-5ecc-4fb2-b674-45dee5f906fb";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"71CSAr_LNPcgu6D6jI4INl1KATkahmeyUFBETAWya8g";}s:2:"id";s:12:"user.compact";s:5:"label";s:7:"Compact";s:16:"targetEntityType";s:4:"user";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.user.full',
  'data' => 'a:9:{s:4:"uuid";s:36:"089bb350-b28f-4432-a8e7-c057202d6250";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"mQIF_foYjmnVSr9MpcD4CTaJE_FpO1AyDd_DskztGhM";}s:2:"id";s:9:"user.full";s:5:"label";s:12:"User account";s:16:"targetEntityType";s:4:"user";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.extension',
  'data' => 'a:4:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"R4IF-ClDHXxblLcG0L7MgsLvfBIMAvi_skumNFQwkDc";}s:6:"module";a:47:{s:14:"automated_cron";i:0;s:8:"big_pipe";i:0;s:5:"block";i:0;s:13:"block_content";i:0;s:10:"breakpoint";i:0;s:9:"ckeditor5";i:0;s:7:"comment";i:0;s:6:"config";i:0;s:7:"contact";i:0;s:10:"contextual";i:0;s:8:"datetime";i:0;s:18:"dynamic_page_cache";i:0;s:6:"editor";i:0;s:5:"field";i:0;s:8:"field_ui";i:0;s:4:"file";i:0;s:6:"filter";i:0;s:4:"help";i:0;s:7:"history";i:0;s:5:"image";i:0;s:8:"language";i:0;s:4:"link";i:0;s:17:"menu_link_content";i:0;s:7:"menu_ui";i:0;s:5:"mysql";i:0;s:4:"node";i:0;s:7:"options";i:0;s:10:"page_cache";i:0;s:4:"path";i:0;s:10:"path_alias";i:0;s:11:"rabbit_hole";i:0;s:7:"rh_node";i:0;s:11:"rh_taxonomy";i:0;s:7:"rh_user";i:0;s:6:"search";i:0;s:8:"shortcut";i:0;s:6:"system";i:0;s:8:"taxonomy";i:0;s:4:"text";i:0;s:7:"toolbar";i:0;s:4:"tour";i:0;s:6:"update";i:0;s:4:"user";i:0;s:8:"views_ui";i:0;s:19:"content_translation";i:10;s:5:"views";i:10;s:8:"standard";i:1000;}s:5:"theme";a:2:{s:7:"olivero";i:0;s:5:"claro";i:0;}s:7:"profile";s:8:"standard";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.menu.static_menu_link_overrides',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"CXhei_vpaZk-3f_Mj2cH0YmpK-ZpKHoSzVA3yZrDq0g";}s:11:"definitions";a:1:{s:18:"contact__site_page";a:5:{s:9:"menu_name";s:6:"footer";s:6:"parent";s:0:"";s:6:"weight";i:0;s:8:"expanded";b:0;s:7:"enabled";b:1;}}}',
))
->values(array(
  'collection' => '',
  'name' => 'editor.editor.basic_html',
  'data' => 'a:9:{s:4:"uuid";s:36:"33fdf202-e530-4ad5-b69d-f1637f4f601b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:24:"filter.format.basic_html";}s:6:"module";a:1:{i:0;s:9:"ckeditor5";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"uXAqOeMiQVnzE5yk7-v1DsBagmkCI2h_q5WAf0bir-o";}s:6:"format";s:10:"basic_html";s:6:"editor";s:9:"ckeditor5";s:8:"settings";a:2:{s:7:"toolbar";a:1:{s:5:"items";a:15:{i:0;s:4:"bold";i:1;s:6:"italic";i:2;s:1:"|";i:3;s:4:"link";i:4;s:1:"|";i:5;s:12:"bulletedList";i:6;s:12:"numberedList";i:7;s:1:"|";i:8;s:10:"blockQuote";i:9;s:17:"drupalInsertImage";i:10;s:1:"|";i:11;s:7:"heading";i:12;s:4:"code";i:13;s:1:"|";i:14;s:13:"sourceEditing";}}s:7:"plugins";a:4:{s:17:"ckeditor5_heading";a:1:{s:16:"enabled_headings";a:5:{i:0;s:8:"heading2";i:1;s:8:"heading3";i:2;s:8:"heading4";i:3;s:8:"heading5";i:4;s:8:"heading6";}}s:23:"ckeditor5_sourceEditing";a:1:{s:12:"allowed_tags";a:13:{i:0;s:6:"<cite>";i:1;s:4:"<dl>";i:2;s:4:"<dt>";i:3;s:4:"<dd>";i:4;s:12:"<a hreflang>";i:5;s:17:"<blockquote cite>";i:6;s:9:"<ul type>";i:7;s:15:"<ol start type>";i:8;s:7:"<h2 id>";i:9;s:7:"<h3 id>";i:10;s:7:"<h4 id>";i:11;s:7:"<h5 id>";i:12;s:7:"<h6 id>";}}s:14:"ckeditor5_list";a:2:{s:8:"reversed";b:0;s:10:"startIndex";b:1;}s:21:"ckeditor5_imageResize";a:1:{s:12:"allow_resize";b:1;}}}s:12:"image_upload";a:5:{s:6:"status";b:1;s:6:"scheme";s:6:"public";s:9:"directory";s:13:"inline-images";s:8:"max_size";s:0:"";s:14:"max_dimensions";a:2:{s:5:"width";i:0;s:6:"height";i:0;}}}',
))
->values(array(
  'collection' => '',
  'name' => 'editor.editor.full_html',
  'data' => 'a:9:{s:4:"uuid";s:36:"9fcb2e7a-0370-490c-a98b-4c44279d3f17";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:23:"filter.format.full_html";}s:6:"module";a:1:{i:0;s:9:"ckeditor5";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"a0UeuvbLLshU7EeXK0lLcsZYdDuR4ByvaYRhrX_84mo";}s:6:"format";s:9:"full_html";s:6:"editor";s:9:"ckeditor5";s:8:"settings";a:2:{s:7:"toolbar";a:1:{s:5:"items";a:21:{i:0;s:4:"bold";i:1;s:6:"italic";i:2;s:13:"strikethrough";i:3;s:11:"superscript";i:4;s:9:"subscript";i:5;s:12:"removeFormat";i:6;s:1:"|";i:7;s:4:"link";i:8;s:1:"|";i:9;s:12:"bulletedList";i:10;s:12:"numberedList";i:11;s:1:"|";i:12;s:10:"blockQuote";i:13;s:17:"drupalInsertImage";i:14;s:11:"insertTable";i:15;s:14:"horizontalLine";i:16;s:1:"|";i:17;s:7:"heading";i:18;s:9:"codeBlock";i:19;s:1:"|";i:20;s:13:"sourceEditing";}}s:7:"plugins";a:4:{s:17:"ckeditor5_heading";a:1:{s:16:"enabled_headings";a:5:{i:0;s:8:"heading2";i:1;s:8:"heading3";i:2;s:8:"heading4";i:3;s:8:"heading5";i:4;s:8:"heading6";}}s:23:"ckeditor5_sourceEditing";a:1:{s:12:"allowed_tags";a:0:{}}s:14:"ckeditor5_list";a:2:{s:8:"reversed";b:1;s:10:"startIndex";b:1;}s:21:"ckeditor5_imageResize";a:1:{s:12:"allow_resize";b:1;}}}s:12:"image_upload";a:5:{s:6:"status";b:1;s:6:"scheme";s:6:"public";s:9:"directory";s:13:"inline-images";s:8:"max_size";s:0:"";s:14:"max_dimensions";a:2:{s:5:"width";i:0;s:6:"height";i:0;}}}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.block_content.basic.body',
  'data' => 'a:17:{s:4:"uuid";s:36:"74c9a038-e5bd-4c2f-bca4-bad616e68cc4";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:24:"block_content.type.basic";i:1;s:32:"field.storage.block_content.body";}s:6:"module";a:1:{i:0;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"foetbaMhlB6uLc2bn-PESvaPkbuDWj0MEjpQVwQiP-o";}s:2:"id";s:24:"block_content.basic.body";s:10:"field_name";s:4:"body";s:11:"entity_type";s:13:"block_content";s:6:"bundle";s:5:"basic";s:5:"label";s:4:"Body";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:0;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:2:{s:15:"display_summary";b:0;s:16:"required_summary";b:0;}s:10:"field_type";s:17:"text_with_summary";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.comment.comment.comment_body',
  'data' => 'a:17:{s:4:"uuid";s:36:"31a4fe58-da46-43bf-9a6e-5da5c546443b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:20:"comment.type.comment";i:1;s:34:"field.storage.comment.comment_body";}s:6:"module";a:1:{i:0;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"TmAKjNrJ7RR60YpqvJq_QqEewYe_S8Kd23n8VRCqiWs";}s:2:"id";s:28:"comment.comment.comment_body";s:10:"field_name";s:12:"comment_body";s:11:"entity_type";s:7:"comment";s:6:"bundle";s:7:"comment";s:5:"label";s:7:"Comment";s:11:"description";s:0:"";s:8:"required";b:1;s:12:"translatable";b:0;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:0:{}s:10:"field_type";s:9:"text_long";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.node.article.body',
  'data' => 'a:17:{s:4:"uuid";s:36:"21a0f353-84ac-403b-9f0b-6348ce0bbfd9";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:23:"field.storage.node.body";i:1;s:17:"node.type.article";}s:6:"module";a:1:{i:0;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"IjZnOLWk1Pjq3WRg2pLSA1ERh7Po7izCq_p6UztZr2c";}s:2:"id";s:17:"node.article.body";s:10:"field_name";s:4:"body";s:11:"entity_type";s:4:"node";s:6:"bundle";s:7:"article";s:5:"label";s:4:"Body";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:2:{s:15:"display_summary";b:1;s:16:"required_summary";b:0;}s:10:"field_type";s:17:"text_with_summary";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.node.article.comment',
  'data' => 'a:17:{s:4:"uuid";s:36:"d590a738-36b2-4e12-a222-2b905172c780";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:26:"field.storage.node.comment";i:1;s:17:"node.type.article";}s:6:"module";a:1:{i:0;s:7:"comment";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"UqXlkKC4v2-bDfWx4zcXQrD5YIi3d5byENEmWv-G_Uc";}s:2:"id";s:20:"node.article.comment";s:10:"field_name";s:7:"comment";s:11:"entity_type";s:4:"node";s:6:"bundle";s:7:"article";s:5:"label";s:8:"Comments";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:1;s:13:"default_value";a:1:{i:0;a:6:{s:6:"status";i:2;s:3:"cid";i:0;s:22:"last_comment_timestamp";i:0;s:17:"last_comment_name";N;s:16:"last_comment_uid";i:0;s:13:"comment_count";i:0;}}s:22:"default_value_callback";s:0:"";s:8:"settings";a:5:{s:12:"default_mode";i:1;s:8:"per_page";i:50;s:9:"anonymous";i:0;s:13:"form_location";b:1;s:7:"preview";i:1;}s:10:"field_type";s:7:"comment";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.node.article.field_image',
  'data' => 'a:18:{s:4:"uuid";s:36:"c55d79f2-3363-4976-ad22-e6cf221920d7";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:30:"field.storage.node.field_image";i:1;s:17:"node.type.article";}s:6:"module";a:2:{i:0;s:19:"content_translation";i:1;s:5:"image";}}s:20:"third_party_settings";a:1:{s:19:"content_translation";a:1:{s:16:"translation_sync";a:3:{s:3:"alt";s:3:"alt";s:5:"title";s:5:"title";s:4:"file";s:1:"0";}}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"PmVL51L3A9QGbPLoeLHw5epAPszeZRasCeC3imeeDRQ";}s:2:"id";s:24:"node.article.field_image";s:10:"field_name";s:11:"field_image";s:11:"entity_type";s:4:"node";s:6:"bundle";s:7:"article";s:5:"label";s:5:"Image";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:12:{s:7:"handler";s:12:"default:file";s:16:"handler_settings";a:0:{}s:14:"file_directory";s:31:"[date:custom:Y]-[date:custom:m]";s:15:"file_extensions";s:16:"png gif jpg jpeg";s:12:"max_filesize";s:0:"";s:14:"max_resolution";s:0:"";s:14:"min_resolution";s:0:"";s:9:"alt_field";b:1;s:18:"alt_field_required";b:1;s:11:"title_field";b:0;s:20:"title_field_required";b:0;s:13:"default_image";a:5:{s:4:"uuid";N;s:3:"alt";s:0:"";s:5:"title";s:0:"";s:5:"width";N;s:6:"height";N;}}s:10:"field_type";s:5:"image";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.node.article.field_tags',
  'data' => 'a:17:{s:4:"uuid";s:36:"9bd4733c-d1c9-4fee-9639-cc1cdb8fdcb5";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:3:{i:0;s:29:"field.storage.node.field_tags";i:1;s:17:"node.type.article";i:2;s:24:"taxonomy.vocabulary.tags";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"QdUgf_beeoaPiyKorFv0q1fcJpWH_uZTqe_xoVJacrw";}s:2:"id";s:23:"node.article.field_tags";s:10:"field_name";s:10:"field_tags";s:11:"entity_type";s:4:"node";s:6:"bundle";s:7:"article";s:5:"label";s:4:"Tags";s:11:"description";s:84:"Enter a comma-separated list. For example: Amsterdam, Mexico City, "Cleveland, Ohio"";s:8:"required";b:0;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:2:{s:7:"handler";s:21:"default:taxonomy_term";s:16:"handler_settings";a:3:{s:14:"target_bundles";a:1:{s:4:"tags";s:4:"tags";}s:4:"sort";a:1:{s:5:"field";s:5:"_none";}s:11:"auto_create";b:1;}}s:10:"field_type";s:16:"entity_reference";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.node.page.body',
  'data' => 'a:17:{s:4:"uuid";s:36:"804a65de-765e-44f6-acf7-20a8d53490ea";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:23:"field.storage.node.body";i:1;s:14:"node.type.page";}s:6:"module";a:1:{i:0;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"KgVkxLl_K3E3lvN6CEoWQIDT0V8J4Mv-fVYrAIc7-FE";}s:2:"id";s:14:"node.page.body";s:10:"field_name";s:4:"body";s:11:"entity_type";s:4:"node";s:6:"bundle";s:4:"page";s:5:"label";s:4:"Body";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:2:{s:15:"display_summary";b:1;s:16:"required_summary";b:0;}s:10:"field_type";s:17:"text_with_summary";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.user.user.user_picture',
  'data' => 'a:17:{s:4:"uuid";s:36:"797c8e1a-df33-4a40-b28b-5b924085355e";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:31:"field.storage.user.user_picture";}s:6:"module";a:2:{i:0;s:5:"image";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"twhm-ZOwSVkUjuLI_pQsaPo_pVLcqFfDmY-ojfqw0yk";}s:2:"id";s:22:"user.user.user_picture";s:10:"field_name";s:12:"user_picture";s:11:"entity_type";s:4:"user";s:6:"bundle";s:4:"user";s:5:"label";s:7:"Picture";s:11:"description";s:29:"Your virtual face or picture.";s:8:"required";b:0;s:12:"translatable";b:0;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:12:{s:7:"handler";s:12:"default:file";s:16:"handler_settings";a:0:{}s:14:"file_directory";s:40:"pictures/[date:custom:Y]-[date:custom:m]";s:15:"file_extensions";s:16:"png gif jpg jpeg";s:12:"max_filesize";s:0:"";s:14:"max_resolution";s:0:"";s:14:"min_resolution";s:0:"";s:9:"alt_field";b:0;s:18:"alt_field_required";b:0;s:11:"title_field";b:0;s:20:"title_field_required";b:0;s:13:"default_image";a:5:{s:4:"uuid";N;s:3:"alt";s:0:"";s:5:"title";s:0:"";s:5:"width";N;s:6:"height";N;}}s:10:"field_type";s:5:"image";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.settings',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"nJk0TAQBzlNo52ehiHI7bIEPLGi0BYqZvPdEn7Chfu0";}s:16:"purge_batch_size";i:50;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.block_content.body',
  'data' => 'a:17:{s:4:"uuid";s:36:"06af7efe-abc6-42ea-969f-6cfc97601d94";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:13:"block_content";i:1;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"eS0snV_L3dx9shtWRTzm5eblwOJ7qKWC9IE-4GMTDFc";}s:2:"id";s:18:"block_content.body";s:10:"field_name";s:4:"body";s:11:"entity_type";s:13:"block_content";s:4:"type";s:17:"text_with_summary";s:8:"settings";a:0:{}s:6:"module";s:4:"text";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:1;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.comment.comment_body',
  'data' => 'a:17:{s:4:"uuid";s:36:"c566e36b-0afb-40b2-9595-e249ba88a889";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:7:"comment";i:1;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"swYoCch_hY8QO5uwr4FURplfnUCUlpPB4idF8WGVCpw";}s:2:"id";s:20:"comment.comment_body";s:10:"field_name";s:12:"comment_body";s:11:"entity_type";s:7:"comment";s:4:"type";s:9:"text_long";s:8:"settings";a:0:{}s:6:"module";s:4:"text";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:1;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.node.body',
  'data' => 'a:17:{s:4:"uuid";s:36:"1eeb692d-16be-477f-8383-3f6355004254";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:4:"node";i:1;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"EBUo7qOWqaiZaQ_RC9sLY5IoDKphS34v77VIHSACmVY";}s:2:"id";s:9:"node.body";s:10:"field_name";s:4:"body";s:11:"entity_type";s:4:"node";s:4:"type";s:17:"text_with_summary";s:8:"settings";a:0:{}s:6:"module";s:4:"text";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:1;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.node.comment',
  'data' => 'a:17:{s:4:"uuid";s:36:"dbdd39c4-d17a-4c5f-be9e-9db9a64027de";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:7:"comment";i:1;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ktCna9xmWvYZIUfOCUyDQvedn5RtnS4CRmEIwNmvYjc";}s:2:"id";s:12:"node.comment";s:10:"field_name";s:7:"comment";s:11:"entity_type";s:4:"node";s:4:"type";s:7:"comment";s:8:"settings";a:1:{s:12:"comment_type";s:7:"comment";}s:6:"module";s:7:"comment";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.node.field_image',
  'data' => 'a:17:{s:4:"uuid";s:36:"3f70cbf2-e4e2-4352-ae29-e8696da9eeb2";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:3:{i:0;s:4:"file";i:1;s:5:"image";i:2;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"EymokncRIZ7SgQT2IdOQhQJicX4nNc0K89ik-LxmOHE";}s:2:"id";s:16:"node.field_image";s:10:"field_name";s:11:"field_image";s:11:"entity_type";s:4:"node";s:4:"type";s:5:"image";s:8:"settings";a:5:{s:11:"target_type";s:4:"file";s:13:"display_field";b:0;s:15:"display_default";b:0;s:10:"uri_scheme";s:6:"public";s:13:"default_image";a:5:{s:4:"uuid";N;s:3:"alt";s:0:"";s:5:"title";s:0:"";s:5:"width";N;s:6:"height";N;}}s:6:"module";s:5:"image";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.node.field_tags',
  'data' => 'a:17:{s:4:"uuid";s:36:"5ed462ff-240c-4675-aa57-4bb7dc3d064e";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:4:"node";i:1;s:8:"taxonomy";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"WpOE_bs8Bs_HY2ns7n2r__de-xno0-Bxkqep5-MsHAs";}s:2:"id";s:15:"node.field_tags";s:10:"field_name";s:10:"field_tags";s:11:"entity_type";s:4:"node";s:4:"type";s:16:"entity_reference";s:8:"settings";a:1:{s:11:"target_type";s:13:"taxonomy_term";}s:6:"module";s:4:"core";s:6:"locked";b:0;s:11:"cardinality";i:-1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.user.user_picture',
  'data' => 'a:17:{s:4:"uuid";s:36:"b3e256f3-94df-4903-8aa5-5a0cb456ed71";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:3:{i:0;s:4:"file";i:1;s:5:"image";i:2;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"0q8-mw8y-Ls5I578sIPQFLp4ljpH7WvVYpzY-I9O-8E";}s:2:"id";s:17:"user.user_picture";s:10:"field_name";s:12:"user_picture";s:11:"entity_type";s:4:"user";s:4:"type";s:5:"image";s:8:"settings";a:5:{s:11:"target_type";s:4:"file";s:13:"display_field";b:0;s:15:"display_default";b:0;s:10:"uri_scheme";s:6:"public";s:13:"default_image";a:5:{s:4:"uuid";N;s:3:"alt";s:0:"";s:5:"title";s:0:"";s:5:"width";N;s:6:"height";N;}}s:6:"module";s:5:"image";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field_ui.settings',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Q1nMi90W6YQxKzZAgJQw7Ag9U4JrsEUwkomF0lhvbIM";}s:12:"field_prefix";s:6:"field_";}',
))
->values(array(
  'collection' => '',
  'name' => 'file.settings',
  'data' => 'a:4:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"0aMkoXYnax5_tHI9C9zHs-K48KJ6K75PHtD9x-0nbgM";}s:11:"description";a:2:{s:4:"type";s:9:"textfield";s:6:"length";i:128;}s:4:"icon";a:1:{s:9:"directory";s:23:"core/modules/file/icons";}s:35:"make_unused_managed_files_temporary";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'filter.format.basic_html',
  'data' => 'a:9:{s:4:"uuid";s:36:"fff73a0c-209f-4629-85ea-a4a703c8df26";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:6:"editor";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"RjoJPQLCAE8u1Ys_yCKubpkYlRz_Oy12a5qCVeNIHJ8";}s:4:"name";s:10:"Basic HTML";s:6:"format";s:10:"basic_html";s:6:"weight";i:0;s:7:"filters";a:5:{s:11:"filter_html";a:5:{s:2:"id";s:11:"filter_html";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:-10;s:8:"settings";a:3:{s:12:"allowed_html";s:243:"<br> <p> <h2 id> <h3 id> <h4 id> <h5 id> <h6 id> <cite> <dl> <dt> <dd> <a hreflang href> <blockquote cite> <ul type> <ol start type> <strong> <em> <code> <li> <img src alt data-entity-uuid data-entity-type height width data-caption data-align>";s:16:"filter_html_help";b:0;s:20:"filter_html_nofollow";b:0;}}s:12:"filter_align";a:5:{s:2:"id";s:12:"filter_align";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:7;s:8:"settings";a:0:{}}s:14:"filter_caption";a:5:{s:2:"id";s:14:"filter_caption";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:8;s:8:"settings";a:0:{}}s:24:"filter_html_image_secure";a:5:{s:2:"id";s:24:"filter_html_image_secure";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:9;s:8:"settings";a:0:{}}s:21:"editor_file_reference";a:5:{s:2:"id";s:21:"editor_file_reference";s:8:"provider";s:6:"editor";s:6:"status";b:1;s:6:"weight";i:11;s:8:"settings";a:0:{}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'filter.format.full_html',
  'data' => 'a:9:{s:4:"uuid";s:36:"63b3a490-4b0b-420d-9fc5-c204a9553b34";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:6:"editor";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"WNeK5FbcY8pXgEpbD_KgRzlF1-5PL3BJXwqaBctPTqw";}s:4:"name";s:9:"Full HTML";s:6:"format";s:9:"full_html";s:6:"weight";i:2;s:7:"filters";a:4:{s:12:"filter_align";a:5:{s:2:"id";s:12:"filter_align";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:8;s:8:"settings";a:0:{}}s:14:"filter_caption";a:5:{s:2:"id";s:14:"filter_caption";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:9;s:8:"settings";a:0:{}}s:20:"filter_htmlcorrector";a:5:{s:2:"id";s:20:"filter_htmlcorrector";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:10;s:8:"settings";a:0:{}}s:21:"editor_file_reference";a:5:{s:2:"id";s:21:"editor_file_reference";s:8:"provider";s:6:"editor";s:6:"status";b:1;s:6:"weight";i:11;s:8:"settings";a:0:{}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'filter.format.plain_text',
  'data' => 'a:9:{s:4:"uuid";s:36:"5c2357c3-3152-45b7-8169-740bb25f2e88";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"NIKBt6kw_uPhNI0qtR2DnRf7mSOgAQdx7Q94SKMjXbQ";}s:4:"name";s:10:"Plain text";s:6:"format";s:10:"plain_text";s:6:"weight";i:10;s:7:"filters";a:3:{s:18:"filter_html_escape";a:5:{s:2:"id";s:18:"filter_html_escape";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:-10;s:8:"settings";a:0:{}}s:10:"filter_url";a:5:{s:2:"id";s:10:"filter_url";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:0;s:8:"settings";a:1:{s:17:"filter_url_length";i:72;}}s:12:"filter_autop";a:5:{s:2:"id";s:12:"filter_autop";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:0;s:8:"settings";a:0:{}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'filter.format.restricted_html',
  'data' => 'a:9:{s:4:"uuid";s:36:"34829048-b87f-4c08-b0ec-55e407a01afe";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"oz6NyPDAB4HB6N9hgH2LwNVtCd-sXbMG1fbn5KsRIDI";}s:4:"name";s:15:"Restricted HTML";s:6:"format";s:15:"restricted_html";s:6:"weight";i:1;s:7:"filters";a:3:{s:11:"filter_html";a:5:{s:2:"id";s:11:"filter_html";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:-10;s:8:"settings";a:3:{s:12:"allowed_html";s:149:"<a href hreflang> <em> <strong> <cite> <blockquote cite> <code> <ul type> <ol start type> <li> <dl> <dt> <dd> <h2 id> <h3 id> <h4 id> <h5 id> <h6 id>";s:16:"filter_html_help";b:1;s:20:"filter_html_nofollow";b:0;}}s:12:"filter_autop";a:5:{s:2:"id";s:12:"filter_autop";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:0;s:8:"settings";a:0:{}}s:10:"filter_url";a:5:{s:2:"id";s:10:"filter_url";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:0;s:8:"settings";a:1:{s:17:"filter_url_length";i:72;}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'filter.settings',
  'data' => 'a:3:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"FiPjM3WdB__ruFA7B6TLwni_UcZbmek5G4b2dxQItxA";}s:15:"fallback_format";s:10:"plain_text";s:27:"always_show_fallback_choice";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'image.settings',
  'data' => 'a:4:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"k-yDFHbqNfpe-Srg4sdCSqaosCl2D8uwyEY5esF8gEw";}s:13:"preview_image";s:29:"core/modules/image/sample.png";s:26:"allow_insecure_derivatives";b:0;s:20:"suppress_itok_output";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'image.style.large',
  'data' => 'a:8:{s:4:"uuid";s:36:"9bb053fd-992a-4ca3-bcf9-14f86a40e8e4";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"J2n0RpFzS0-bgSyxjs6rSdgxB1rb-bTAgqywNx_964M";}s:4:"name";s:5:"large";s:5:"label";s:16:"Large (480×480)";s:7:"effects";a:1:{s:36:"ddd73aa7-4bd6-4c85-b600-bdf2b1628d1d";a:4:{s:4:"uuid";s:36:"ddd73aa7-4bd6-4c85-b600-bdf2b1628d1d";s:2:"id";s:11:"image_scale";s:6:"weight";i:0;s:4:"data";a:3:{s:5:"width";i:480;s:6:"height";i:480;s:7:"upscale";b:0;}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'image.style.medium',
  'data' => 'a:8:{s:4:"uuid";s:36:"987a55c1-a2c5-4173-831f-d4c324bd6dfb";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Y9NmnZHQq20ASSyTNA6JnwtWrJJiSajOehGDtmUFdM0";}s:4:"name";s:6:"medium";s:5:"label";s:17:"Medium (220×220)";s:7:"effects";a:1:{s:36:"bddf0d06-42f9-4c75-a700-a33cafa25ea0";a:4:{s:4:"uuid";s:36:"bddf0d06-42f9-4c75-a700-a33cafa25ea0";s:2:"id";s:11:"image_scale";s:6:"weight";i:0;s:4:"data";a:3:{s:5:"width";i:220;s:6:"height";i:220;s:7:"upscale";b:0;}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'image.style.thumbnail',
  'data' => 'a:8:{s:4:"uuid";s:36:"29aed8da-4271-4aa4-98b5-c82f09e8fea9";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"cCiWdBHgLwj5omG35lsKc4LkW4MBdmcctkVop4ol5x0";}s:4:"name";s:9:"thumbnail";s:5:"label";s:20:"Thumbnail (100×100)";s:7:"effects";a:1:{s:36:"1cfec298-8620-4749-b100-ccb6c4500779";a:4:{s:4:"uuid";s:36:"1cfec298-8620-4749-b100-ccb6c4500779";s:2:"id";s:11:"image_scale";s:6:"weight";i:0;s:4:"data";a:3:{s:5:"width";i:100;s:6:"height";i:100;s:7:"upscale";b:0;}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'image.style.wide',
  'data' => 'a:8:{s:4:"uuid";s:36:"83e90fb2-fa03-456d-8678-4c574f3d7d8c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"LswCVLg8z4Zk1u6pV1Dpj1qUj5YY2CQ7_ojx7bJQ8qk";}s:4:"name";s:4:"wide";s:5:"label";s:11:"Wide (1090)";s:7:"effects";a:1:{s:36:"09959c15-59ce-4f6d-90df-e2d7cf32bce5";a:4:{s:4:"uuid";s:36:"09959c15-59ce-4f6d-90df-e2d7cf32bce5";s:2:"id";s:11:"image_scale";s:6:"weight";i:1;s:4:"data";a:3:{s:5:"width";i:1090;s:6:"height";N;s:7:"upscale";b:0;}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'language.content_settings.block_content.basic',
  'data' => 'a:10:{s:4:"uuid";s:36:"9b5beadd-ebad-4424-aab5-01bdaa67c616";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:24:"block_content.type.basic";}s:6:"module";a:1:{i:0;s:19:"content_translation";}}s:20:"third_party_settings";a:1:{s:19:"content_translation";a:2:{s:7:"enabled";b:0;s:15:"bundle_settings";a:1:{s:26:"untranslatable_fields_hide";s:1:"0";}}}s:2:"id";s:19:"block_content.basic";s:21:"target_entity_type_id";s:13:"block_content";s:13:"target_bundle";s:5:"basic";s:16:"default_langcode";s:12:"site_default";s:18:"language_alterable";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'language.content_settings.comment.comment',
  'data' => 'a:10:{s:4:"uuid";s:36:"66c2058e-2e91-46e1-89ce-08f853d746e5";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:20:"comment.type.comment";}s:6:"module";a:1:{i:0;s:19:"content_translation";}}s:20:"third_party_settings";a:1:{s:19:"content_translation";a:2:{s:7:"enabled";b:0;s:15:"bundle_settings";a:1:{s:26:"untranslatable_fields_hide";s:1:"0";}}}s:2:"id";s:15:"comment.comment";s:21:"target_entity_type_id";s:7:"comment";s:13:"target_bundle";s:7:"comment";s:16:"default_langcode";s:12:"site_default";s:18:"language_alterable";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'language.content_settings.contact_message.feedback',
  'data' => 'a:9:{s:4:"uuid";s:36:"e2f4b565-47ae-48da-819e-12f0e02e90d6";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:1:{i:0;s:21:"contact.form.feedback";}}s:2:"id";s:24:"contact_message.feedback";s:21:"target_entity_type_id";s:15:"contact_message";s:13:"target_bundle";s:8:"feedback";s:16:"default_langcode";s:12:"site_default";s:18:"language_alterable";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'language.content_settings.contact_message.personal',
  'data' => 'a:9:{s:4:"uuid";s:36:"e349e325-7650-4dfa-bf24-4201ea3eb6ea";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:1:{i:0;s:21:"contact.form.personal";}}s:2:"id";s:24:"contact_message.personal";s:21:"target_entity_type_id";s:15:"contact_message";s:13:"target_bundle";s:8:"personal";s:16:"default_langcode";s:12:"site_default";s:18:"language_alterable";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'language.content_settings.file.file',
  'data' => 'a:9:{s:4:"uuid";s:36:"e6937f28-57de-4a49-8d23-463da60f2248";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"file";}}s:2:"id";s:9:"file.file";s:21:"target_entity_type_id";s:4:"file";s:13:"target_bundle";s:4:"file";s:16:"default_langcode";s:12:"site_default";s:18:"language_alterable";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'language.content_settings.menu_link_content.menu_link_content',
  'data' => 'a:10:{s:4:"uuid";s:36:"85e9a9b1-d12c-4d1d-8307-5657936c52ac";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:19:"content_translation";i:1;s:17:"menu_link_content";}}s:20:"third_party_settings";a:1:{s:19:"content_translation";a:2:{s:7:"enabled";b:0;s:15:"bundle_settings";a:1:{s:26:"untranslatable_fields_hide";s:1:"0";}}}s:2:"id";s:35:"menu_link_content.menu_link_content";s:21:"target_entity_type_id";s:17:"menu_link_content";s:13:"target_bundle";s:17:"menu_link_content";s:16:"default_langcode";s:12:"site_default";s:18:"language_alterable";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'language.content_settings.node.article',
  'data' => 'a:10:{s:4:"uuid";s:36:"8320a8b1-c8d2-497e-bacc-4c3322e090b0";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:17:"node.type.article";}s:6:"module";a:1:{i:0;s:19:"content_translation";}}s:20:"third_party_settings";a:1:{s:19:"content_translation";a:2:{s:7:"enabled";b:1;s:15:"bundle_settings";a:1:{s:26:"untranslatable_fields_hide";s:1:"0";}}}s:2:"id";s:12:"node.article";s:21:"target_entity_type_id";s:4:"node";s:13:"target_bundle";s:7:"article";s:16:"default_langcode";s:12:"site_default";s:18:"language_alterable";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'language.content_settings.node.page',
  'data' => 'a:10:{s:4:"uuid";s:36:"c486b001-21d0-4a4f-9e02-c0cb8e6de8dd";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:14:"node.type.page";}s:6:"module";a:1:{i:0;s:19:"content_translation";}}s:20:"third_party_settings";a:1:{s:19:"content_translation";a:2:{s:7:"enabled";b:1;s:15:"bundle_settings";a:1:{s:26:"untranslatable_fields_hide";s:1:"0";}}}s:2:"id";s:9:"node.page";s:21:"target_entity_type_id";s:4:"node";s:13:"target_bundle";s:4:"page";s:16:"default_langcode";s:12:"site_default";s:18:"language_alterable";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'language.content_settings.path_alias.path_alias',
  'data' => 'a:10:{s:4:"uuid";s:36:"dda5117a-7413-4749-9d68-be2be8846cfc";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:10:"path_alias";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"dhjFABRzm52DkRXnYja5ZoHwjY0R3gEGic3KpDUXgRo";}s:2:"id";s:21:"path_alias.path_alias";s:21:"target_entity_type_id";s:10:"path_alias";s:13:"target_bundle";s:10:"path_alias";s:16:"default_langcode";s:3:"und";s:18:"language_alterable";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'language.content_settings.shortcut.default',
  'data' => 'a:10:{s:4:"uuid";s:36:"100c00dd-12d2-44d4-802c-80b0ff22d871";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:20:"shortcut.set.default";}s:6:"module";a:1:{i:0;s:19:"content_translation";}}s:20:"third_party_settings";a:1:{s:19:"content_translation";a:2:{s:7:"enabled";b:0;s:15:"bundle_settings";a:1:{s:26:"untranslatable_fields_hide";s:1:"0";}}}s:2:"id";s:16:"shortcut.default";s:21:"target_entity_type_id";s:8:"shortcut";s:13:"target_bundle";s:7:"default";s:16:"default_langcode";s:12:"site_default";s:18:"language_alterable";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'language.content_settings.taxonomy_term.tags',
  'data' => 'a:10:{s:4:"uuid";s:36:"ddd16efb-b283-47af-98ad-49815ed2379d";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:24:"taxonomy.vocabulary.tags";}s:6:"module";a:1:{i:0;s:19:"content_translation";}}s:20:"third_party_settings";a:1:{s:19:"content_translation";a:2:{s:7:"enabled";b:0;s:15:"bundle_settings";a:1:{s:26:"untranslatable_fields_hide";s:1:"0";}}}s:2:"id";s:18:"taxonomy_term.tags";s:21:"target_entity_type_id";s:13:"taxonomy_term";s:13:"target_bundle";s:4:"tags";s:16:"default_langcode";s:12:"site_default";s:18:"language_alterable";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'language.content_settings.user.user',
  'data' => 'a:10:{s:4:"uuid";s:36:"f500ad84-42db-4609-a575-0e15fec91da9";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:19:"content_translation";i:1;s:4:"user";}}s:20:"third_party_settings";a:1:{s:19:"content_translation";a:2:{s:7:"enabled";b:0;s:15:"bundle_settings";a:1:{s:26:"untranslatable_fields_hide";s:1:"0";}}}s:2:"id";s:9:"user.user";s:21:"target_entity_type_id";s:4:"user";s:13:"target_bundle";s:4:"user";s:16:"default_langcode";s:12:"site_default";s:18:"language_alterable";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'language.entity.en',
  'data' => 'a:10:{s:4:"uuid";s:36:"027b741e-6414-4fb3-878f-54867b56c321";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"lBXDpdDPXQtrfTJQhr6MjRJJEEyYSoRJ0acdvHLsWeA";}s:2:"id";s:2:"en";s:5:"label";s:7:"English";s:9:"direction";s:3:"ltr";s:6:"weight";i:0;s:6:"locked";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'language.entity.uk',
  'data' => 'a:9:{s:4:"uuid";s:36:"087697ad-1c26-468c-bf74-1bfa7588ae69";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:2:"id";s:2:"uk";s:5:"label";s:9:"Ukrainian";s:9:"direction";s:3:"ltr";s:6:"weight";i:1;s:6:"locked";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'language.entity.und',
  'data' => 'a:10:{s:4:"uuid";s:36:"35c58115-92fb-4667-90ff-a4b361a17697";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"eNX6lLCKDaY83nCMh20My---y03KbiFlv802DKCCpvg";}s:2:"id";s:3:"und";s:5:"label";s:13:"Not specified";s:9:"direction";s:3:"ltr";s:6:"weight";i:2;s:6:"locked";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'language.entity.zxx',
  'data' => 'a:10:{s:4:"uuid";s:36:"c49203ec-243e-4460-b997-a6d4582168c2";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"35CefWbnzaiytcg3acexxz_GTvuwIjYd_ZTcmmR-tXA";}s:2:"id";s:3:"zxx";s:5:"label";s:14:"Not applicable";s:9:"direction";s:3:"ltr";s:6:"weight";i:3;s:6:"locked";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'language.mappings',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"EMWe7Yu4Q5eD-NUfNuQAWGBvYUNZPIinztEtONSmsDc";}s:3:"map";a:10:{s:2:"no";s:2:"nb";s:2:"pt";s:5:"pt-pt";s:2:"zh";s:7:"zh-hans";s:5:"zh-tw";s:7:"zh-hant";s:5:"zh-hk";s:7:"zh-hant";s:5:"zh-mo";s:7:"zh-hant";s:6:"zh-cht";s:7:"zh-hant";s:5:"zh-cn";s:7:"zh-hans";s:5:"zh-sg";s:7:"zh-hans";s:6:"zh-chs";s:7:"zh-hans";}}',
))
->values(array(
  'collection' => '',
  'name' => 'language.negotiation',
  'data' => 'a:4:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"uEePITI9tV6WqzmsTb7MfPCi5yPWXSxAN1xeLcYFQbM";}s:7:"session";a:1:{s:9:"parameter";s:8:"language";}s:3:"url";a:3:{s:6:"source";s:11:"path_prefix";s:8:"prefixes";a:2:{s:2:"en";s:0:"";s:2:"uk";s:2:"uk";}s:7:"domains";a:2:{s:2:"en";s:0:"";s:2:"uk";s:0:"";}}s:17:"selected_langcode";s:12:"site_default";}',
))
->values(array(
  'collection' => '',
  'name' => 'language.types',
  'data' => 'a:4:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"dqouFqVseNJNvEjsoYKxbinFOITuCxYhi4y2OTNQP_8";}s:3:"all";a:3:{i:0;s:18:"language_interface";i:1;s:16:"language_content";i:2;s:12:"language_url";}s:12:"configurable";a:1:{i:0;s:18:"language_interface";}s:11:"negotiation";a:3:{s:16:"language_content";a:1:{s:7:"enabled";a:1:{s:18:"language-interface";i:0;}}s:12:"language_url";a:1:{s:7:"enabled";a:2:{s:12:"language-url";i:0;s:21:"language-url-fallback";i:1;}}s:18:"language_interface";a:1:{s:7:"enabled";a:1:{s:12:"language-url";i:0;}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'menu_ui.settings',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"SqMarzIjxC3F8dZo9FEOxfqDKD_sdW1tbcFTV1BA2zU";}s:24:"override_parent_selector";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'node.settings',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"W0cgFPhPJ3gAdqm06-az48BLf5MVcoZVS0HdByoofi0";}s:15:"use_admin_theme";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'node.type.article',
  'data' => 'a:13:{s:4:"uuid";s:36:"f2c03a43-67e9-494f-97b5-63b6375d27a5";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:7:"menu_ui";}}s:20:"third_party_settings";a:1:{s:7:"menu_ui";a:2:{s:15:"available_menus";a:1:{i:0;s:4:"main";}s:6:"parent";s:5:"main:";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"AeW1SEDgb1OTQACAWGhzvMknMYAJlcZu0jljfeU3oso";}s:4:"name";s:7:"Article";s:4:"type";s:7:"article";s:11:"description";s:89:"Use <em>articles</em> for time-sensitive content like news, press releases or blog posts.";s:4:"help";s:0:"";s:12:"new_revision";b:1;s:12:"preview_mode";i:1;s:17:"display_submitted";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'node.type.page',
  'data' => "a:13:{s:4:\"uuid\";s:36:\"b8eee83a-751f-44e1-b403-2198bb97ec25\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:7:\"menu_ui\";}}s:20:\"third_party_settings\";a:1:{s:7:\"menu_ui\";a:2:{s:15:\"available_menus\";a:1:{i:0;s:4:\"main\";}s:6:\"parent\";s:5:\"main:\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"KuyA4NHPXcmKAjRtwa0vQc2ZcyrUJy6IlS2TAyMNRbc\";}s:4:\"name\";s:10:\"Basic page\";s:4:\"type\";s:4:\"page\";s:11:\"description\";s:77:\"Use <em>basic pages</em> for your static content, such as an 'About us' page.\";s:4:\"help\";s:0:\"\";s:12:\"new_revision\";b:1;s:12:\"preview_mode\";i:1;s:17:\"display_submitted\";b:0;}",
))
->values(array(
  'collection' => '',
  'name' => 'olivero.settings',
  'data' => 'a:7:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Ylohp6sdrL1dU4v-KcXzXTP-U8BAMgh4NWJA9eGHtO4";}s:7:"favicon";a:1:{s:11:"use_default";b:1;}s:8:"features";a:4:{s:20:"comment_user_picture";b:1;s:25:"comment_user_verification";b:1;s:7:"favicon";b:1;s:17:"node_user_picture";b:0;}s:4:"logo";a:1:{s:11:"use_default";b:0;}s:20:"third_party_settings";a:1:{s:8:"shortcut";a:1:{s:11:"module_link";b:1;}}s:22:"mobile_menu_all_widths";i:0;s:22:"site_branding_bg_color";s:7:"default";}',
))
->values(array(
  'collection' => '',
  'name' => 'rabbit_hole.behavior_settings.default',
  'data' => 'a:13:{s:4:"uuid";s:36:"bf480a7d-f120-49bc-9ce2-8d3807fea0ec";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"hzh9CgsYCGxPEcbR3ieT1la6e43lMv-ivoN7oZJKkQQ";}s:2:"id";s:7:"default";s:14:"entity_type_id";N;s:9:"entity_id";N;s:6:"action";s:12:"display_page";s:14:"allow_override";i:1;s:8:"redirect";s:0:"";s:13:"redirect_code";i:0;s:24:"redirect_fallback_action";s:13:"access_denied";}',
))
->values(array(
  'collection' => '',
  'name' => 'rabbit_hole.behavior_settings.default_bundle',
  'data' => 'a:13:{s:4:"uuid";s:36:"ae7d012c-c572-4aad-b53b-fac4d7ef022e";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"qUkgsWZRCa_sLIn5JsMzB3xnx5ekIsVeGGZr7T0s9MY";}s:2:"id";s:14:"default_bundle";s:14:"entity_type_id";N;s:9:"entity_id";N;s:6:"action";s:12:"display_page";s:14:"allow_override";i:1;s:8:"redirect";s:0:"";s:13:"redirect_code";i:0;s:24:"redirect_fallback_action";s:13:"access_denied";}',
))
->values(array(
  'collection' => '',
  'name' => 'rabbit_hole.behavior_settings.node_type_article',
  'data' => 'a:12:{s:4:"uuid";s:36:"fa21bc8e-3113-4150-a5f7-3a6b665a3b6f";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:1:{i:0;s:17:"node.type.article";}}s:2:"id";s:17:"node_type_article";s:14:"entity_type_id";s:9:"node_type";s:9:"entity_id";s:7:"article";s:6:"action";s:13:"page_redirect";s:14:"allow_override";i:1;s:8:"redirect";s:9:"/articles";s:13:"redirect_code";i:301;s:24:"redirect_fallback_action";s:13:"access_denied";}',
))
->values(array(
  'collection' => '',
  'name' => 'rabbit_hole.behavior_settings.taxonomy_vocabulary_tags',
  'data' => 'a:12:{s:4:"uuid";s:36:"e72c30ab-9660-4f0e-8fc4-a7834a0dd04b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:1:{i:0;s:24:"taxonomy.vocabulary.tags";}}s:2:"id";s:24:"taxonomy_vocabulary_tags";s:14:"entity_type_id";s:19:"taxonomy_vocabulary";s:9:"entity_id";s:4:"tags";s:6:"action";s:20:"page_redirect_custom";s:14:"allow_override";i:1;s:8:"redirect";s:5:"/tags";s:13:"redirect_code";i:301;s:24:"redirect_fallback_action";s:13:"access_denied";}',
))
->values(array(
  'collection' => '',
  'name' => 'rabbit_hole.behavior_settings.user',
  'data' => 'a:12:{s:4:"uuid";s:36:"79eed3d9-4fdd-40b2-9b1d-e5440bd92433";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:2:"id";s:4:"user";s:14:"entity_type_id";s:4:"user";s:9:"entity_id";N;s:6:"action";s:14:"page_not_found";s:14:"allow_override";i:1;s:8:"redirect";s:0:"";s:13:"redirect_code";i:301;s:24:"redirect_fallback_action";s:13:"access_denied";}',
))
->values(array(
  'collection' => '',
  'name' => 'search.page.node_search',
  'data' => 'a:11:{s:4:"uuid";s:36:"58c9e4c2-eec7-4ee7-9986-738d9ed5c78c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"97tvtzGOa8_flb22CzSjgtm_YkiGMHvEBO-6q2K9V_U";}s:2:"id";s:11:"node_search";s:5:"label";s:7:"Content";s:4:"path";s:4:"node";s:6:"weight";i:-10;s:6:"plugin";s:11:"node_search";s:13:"configuration";a:1:{s:8:"rankings";a:0:{}}}',
))
->values(array(
  'collection' => '',
  'name' => 'search.page.user_search',
  'data' => 'a:11:{s:4:"uuid";s:36:"c37120e6-f9c1-41a1-8ffc-1d763107163c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"k3aUaZXGDuhkek2TZIee0PApOPTvYZLadziekdyHA5A";}s:2:"id";s:11:"user_search";s:5:"label";s:5:"Users";s:4:"path";s:4:"user";s:6:"weight";i:0;s:6:"plugin";s:11:"user_search";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'search.settings',
  'data' => 'a:5:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"hvVxL1G-ZCxaq32IZws0YsfuhvaDiQE_np-0g35KjUk";}s:12:"and_or_limit";i:7;s:12:"default_page";s:11:"node_search";s:5:"index";a:4:{s:10:"cron_limit";i:100;s:11:"overlap_cjk";b:1;s:17:"minimum_word_size";i:3;s:11:"tag_weights";a:12:{s:2:"h1";i:25;s:2:"h2";i:18;s:2:"h3";i:15;s:2:"h4";i:14;s:2:"h5";i:9;s:2:"h6";i:6;s:1:"u";i:3;s:1:"b";i:3;s:1:"i";i:3;s:6:"strong";i:3;s:2:"em";i:3;s:1:"a";i:10;}}s:7:"logging";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'shortcut.set.default',
  'data' => 'a:7:{s:4:"uuid";s:36:"1c370768-46b6-42cf-9b64-8ee8f643edc7";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"U5VlGjd_SfV0Qm_EfnaynOfc549cNscFAx48JfYoMRI";}s:2:"id";s:7:"default";s:5:"label";s:7:"Default";}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.comment_delete_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"5f656b10-b5fb-4298-b518-a32679087872";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:7:"comment";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"vpBH8OmL4sdesCdeZLsW8KOutB5gkbreWJbfjhfFKaQ";}s:2:"id";s:21:"comment_delete_action";s:5:"label";s:14:"Delete comment";s:4:"type";s:7:"comment";s:6:"plugin";s:28:"entity:delete_action:comment";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.comment_publish_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"6761de1f-3792-4aaa-8e91-4a4997bbdf88";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:7:"comment";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"C00dyL_W_5M0nFlgUB3lWUTUs96jn51Jw1MLHVEHZD0";}s:2:"id";s:22:"comment_publish_action";s:5:"label";s:15:"Publish comment";s:4:"type";s:7:"comment";s:6:"plugin";s:29:"entity:publish_action:comment";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.comment_save_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"df875fda-75ee-44f6-85f6-a67a1dca6fe1";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:7:"comment";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"lfyE_snmvfg_EQ3VDyhUtGAXgmqtEiqa46I3bTMg8DU";}s:2:"id";s:19:"comment_save_action";s:5:"label";s:12:"Save comment";s:4:"type";s:7:"comment";s:6:"plugin";s:26:"entity:save_action:comment";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.comment_unpublish_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"5db82785-8f19-422a-b63f-31fe1f0cec45";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:7:"comment";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"tWOIjSMobEWOFZddMkNqb9JySbOVwE1diC6NRqcfLTk";}s:2:"id";s:24:"comment_unpublish_action";s:5:"label";s:17:"Unpublish comment";s:4:"type";s:7:"comment";s:6:"plugin";s:31:"entity:unpublish_action:comment";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.node_delete_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"a4e858ff-a668-4282-8e77-98c262d56292";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"t43OqwzP3CTbcAagSsWKNy6KwMm_zShXo3c4-So6rQg";}s:2:"id";s:18:"node_delete_action";s:5:"label";s:14:"Delete content";s:4:"type";s:4:"node";s:6:"plugin";s:25:"entity:delete_action:node";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.node_make_sticky_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"409ce2ad-5e9b-4b95-b3d6-8477271e3c21";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"sOb26JSy3fGpWkvR0WYN6_hMqj_6d1rvbvrkzp1yya0";}s:2:"id";s:23:"node_make_sticky_action";s:5:"label";s:19:"Make content sticky";s:4:"type";s:4:"node";s:6:"plugin";s:23:"node_make_sticky_action";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.node_make_unsticky_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"26b08999-f474-47e0-8051-bce594577c5e";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"lDM9mvIGAu8Sw8rt-uCO4Sr7yX5VPrDPxYcawkbKd6k";}s:2:"id";s:25:"node_make_unsticky_action";s:5:"label";s:21:"Make content unsticky";s:4:"type";s:4:"node";s:6:"plugin";s:25:"node_make_unsticky_action";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.node_promote_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"302d5d05-7465-47e3-b15a-8c34cf9f6912";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"N0RDBTqiK4dKoN4p4oW2j0SGWycdHyALUe9M-Ofp89U";}s:2:"id";s:19:"node_promote_action";s:5:"label";s:29:"Promote content to front page";s:4:"type";s:4:"node";s:6:"plugin";s:19:"node_promote_action";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.node_publish_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"4daf6bec-d2dc-44bf-a2d3-2349f32f2a12";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"2B9uF8NL5gutNKSdPRAhhAsDWFZZG1PJOBmx0aBGd_0";}s:2:"id";s:19:"node_publish_action";s:5:"label";s:15:"Publish content";s:4:"type";s:4:"node";s:6:"plugin";s:26:"entity:publish_action:node";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.node_save_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"204a0f15-e96a-486f-96e6-444b0ca9fdc2";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"LhdsoZPL_pFas2fjaAWue4zvrQ_tEVofLYtcNec-JGM";}s:2:"id";s:16:"node_save_action";s:5:"label";s:12:"Save content";s:4:"type";s:4:"node";s:6:"plugin";s:23:"entity:save_action:node";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.node_unpromote_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"a1b4900f-6ea6-44c6-a820-46972c5a530d";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"JBptjnfuOMtsdKygklXxoOgeOCTMtQxlkymjnnj-cC0";}s:2:"id";s:21:"node_unpromote_action";s:5:"label";s:30:"Remove content from front page";s:4:"type";s:4:"node";s:6:"plugin";s:21:"node_unpromote_action";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.node_unpublish_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"82fddbbe-471a-479e-91b4-84a25e9bc0aa";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"C7X8h9FWlwkQ9y5mnU2JzgaZICAdc6HFbPVbhvjlAYE";}s:2:"id";s:21:"node_unpublish_action";s:5:"label";s:17:"Unpublish content";s:4:"type";s:4:"node";s:6:"plugin";s:28:"entity:unpublish_action:node";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.taxonomy_term_publish_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"c449d713-5b72-4d22-991d-69848db25bf5";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:8:"taxonomy";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"DoVt_VGgVLcDD4XmVbSFzr0K17SJy9imFiYusKkJBgY";}s:2:"id";s:28:"taxonomy_term_publish_action";s:5:"label";s:21:"Publish taxonomy term";s:4:"type";s:13:"taxonomy_term";s:6:"plugin";s:35:"entity:publish_action:taxonomy_term";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.taxonomy_term_unpublish_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"4de35454-ce45-4eaa-b979-bc7b46e84f4b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:8:"taxonomy";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"z2sNRM3ECa7FPCGnSNje_9SmZJQgwhD_6fG_L4Mr8zI";}s:2:"id";s:30:"taxonomy_term_unpublish_action";s:5:"label";s:23:"Unpublish taxonomy term";s:4:"type";s:13:"taxonomy_term";s:6:"plugin";s:37:"entity:unpublish_action:taxonomy_term";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.user_add_role_action.administrator',
  'data' => 'a:9:{s:4:"uuid";s:36:"8cec3297-a41f-43eb-bfc7-892900ed17ba";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:23:"user.role.administrator";}s:6:"module";a:1:{i:0;s:4:"user";}}s:2:"id";s:34:"user_add_role_action.administrator";s:5:"label";s:50:"Add the Administrator role to the selected user(s)";s:4:"type";s:4:"user";s:6:"plugin";s:20:"user_add_role_action";s:13:"configuration";a:1:{s:3:"rid";s:13:"administrator";}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.user_add_role_action.content_editor',
  'data' => 'a:9:{s:4:"uuid";s:36:"d6fb77a0-ccf6-4544-a641-293451d25a4b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:24:"user.role.content_editor";}s:6:"module";a:1:{i:0;s:4:"user";}}s:2:"id";s:35:"user_add_role_action.content_editor";s:5:"label";s:51:"Add the Content editor role to the selected user(s)";s:4:"type";s:4:"user";s:6:"plugin";s:20:"user_add_role_action";s:13:"configuration";a:1:{s:3:"rid";s:14:"content_editor";}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.user_block_user_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"28b16d16-efb1-4178-9c00-9a67b78fc013";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"DyypzTfThX10FFQw-399qPfEbLLyrhXgQrKPVsmAoJ4";}s:2:"id";s:22:"user_block_user_action";s:5:"label";s:26:"Block the selected user(s)";s:4:"type";s:4:"user";s:6:"plugin";s:22:"user_block_user_action";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.user_cancel_user_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"a485eae3-859c-4b73-8044-29ea53d94688";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"nvrL9bFilzBvm2bjO9rQnFDpBA7dBBUjShSSt6NS-DU";}s:2:"id";s:23:"user_cancel_user_action";s:5:"label";s:35:"Cancel the selected user account(s)";s:4:"type";s:4:"user";s:6:"plugin";s:23:"user_cancel_user_action";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.user_remove_role_action.administrator',
  'data' => 'a:9:{s:4:"uuid";s:36:"180a8529-8d78-44e4-a8ab-e5d3d1326611";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:23:"user.role.administrator";}s:6:"module";a:1:{i:0;s:4:"user";}}s:2:"id";s:37:"user_remove_role_action.administrator";s:5:"label";s:55:"Remove the Administrator role from the selected user(s)";s:4:"type";s:4:"user";s:6:"plugin";s:23:"user_remove_role_action";s:13:"configuration";a:1:{s:3:"rid";s:13:"administrator";}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.user_remove_role_action.content_editor',
  'data' => 'a:9:{s:4:"uuid";s:36:"b7e68852-84d3-4d45-80d7-d638ad2f3001";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:24:"user.role.content_editor";}s:6:"module";a:1:{i:0;s:4:"user";}}s:2:"id";s:38:"user_remove_role_action.content_editor";s:5:"label";s:56:"Remove the Content editor role from the selected user(s)";s:4:"type";s:4:"user";s:6:"plugin";s:23:"user_remove_role_action";s:13:"configuration";a:1:{s:3:"rid";s:14:"content_editor";}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.user_unblock_user_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"879c21c9-08f1-47c5-913f-b939ad49d2b1";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"SPsUXsR3Rc8d1y3gewzaAKWa1ncea_ywXX3f7LTn7k0";}s:2:"id";s:24:"user_unblock_user_action";s:5:"label";s:28:"Unblock the selected user(s)";s:4:"type";s:4:"user";s:6:"plugin";s:24:"user_unblock_user_action";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.advisories',
  'data' => 'a:3:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"x0FuQ_7Cg81mSDQwG028_Z0CjH3R9ib5IDlHeV2BbAo";}s:7:"enabled";b:1;s:14:"interval_hours";i:6;}',
))
->values(array(
  'collection' => '',
  'name' => 'system.cron',
  'data' => 'a:3:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"5Pw921y1EPfFN98wykliBBLArm51pC-SmrXeYCe7d0Y";}s:9:"threshold";a:2:{s:20:"requirements_warning";i:172800;s:18:"requirements_error";i:1209600;}s:7:"logging";i:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'system.date',
  'data' => 'a:4:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"t7clj3mzmOGrXX0HuCH5usf0vEqRtnMTBFVBIEmZ5pc";}s:9:"first_day";i:0;s:7:"country";a:1:{s:7:"default";s:0:"";}s:8:"timezone";a:2:{s:7:"default";s:3:"UTC";s:4:"user";a:3:{s:12:"configurable";b:1;s:7:"default";i:0;s:4:"warn";b:0;}}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.diff',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"1WanmaEhxW_vM8_5Ktsdntj8MaO9UBHXg0lN603PsWM";}s:7:"context";a:2:{s:13:"lines_leading";i:2;s:14:"lines_trailing";i:2;}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.file',
  'data' => 'a:4:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"mguGHCYb9Dw5EcpfjwoShGV1Vjkbz3QuPRCLfxiye-g";}s:22:"allow_insecure_uploads";b:0;s:14:"default_scheme";s:6:"public";s:21:"temporary_maximum_age";i:21600;}',
))
->values(array(
  'collection' => '',
  'name' => 'system.image',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"durWHaKeBaq4d9Wpi4RqwADj1OufDepcnJuhVLmKN24";}s:7:"toolkit";s:2:"gd";}',
))
->values(array(
  'collection' => '',
  'name' => 'system.image.gd',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"eNXaHfkJJUThHeF0nvkoXyPLRrKYGxgHRjORvT4F5rQ";}s:12:"jpeg_quality";i:75;}',
))
->values(array(
  'collection' => '',
  'name' => 'system.logging',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"u3-njszl92FaxjrCMiq0yDcjAfcdx72w1zT1O9dx6aA";}s:11:"error_level";s:4:"hide";}',
))
->values(array(
  'collection' => '',
  'name' => 'system.mail',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"rYgt7uhPafP2ngaN_ZUPFuyI4KdE0zU868zLNSlzKoE";}s:9:"interface";a:1:{s:7:"default";s:8:"php_mail";}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.maintenance',
  'data' => 'a:3:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"1SNdA25INsV5YjlgAJtfC-6AM8VcWe_00xneMLb2yFg";}s:8:"langcode";s:2:"en";s:7:"message";s:93:"@site is currently under maintenance. We should be back shortly. Thank you for your patience.";}',
))
->values(array(
  'collection' => '',
  'name' => 'system.menu.account',
  'data' => 'a:9:{s:4:"uuid";s:36:"32c478d3-6011-4c47-b28b-c9f5ac145eab";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"M_Bh81osDyUQ4wV0GgU_NdBNqkzM87sLxjaCdFj9mnw";}s:2:"id";s:7:"account";s:5:"label";s:17:"User account menu";s:11:"description";s:40:"Links related to the active user account";s:6:"locked";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'system.menu.admin',
  'data' => 'a:9:{s:4:"uuid";s:36:"eaa4d291-fb65-4128-84b0-40907672e5ed";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"sapEi2YDGoI9yQIT_WgIV2vUdQ6DScH0V3fAyTadAL0";}s:2:"id";s:5:"admin";s:5:"label";s:14:"Administration";s:11:"description";s:25:"Administrative task links";s:6:"locked";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'system.menu.footer',
  'data' => 'a:9:{s:4:"uuid";s:36:"96f8f789-3700-49b5-af38-4963dbab0e4e";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"7yrlW5z9zdg2eBucB2GPqXKSMQfH9lSRSO4DbWF7AFc";}s:2:"id";s:6:"footer";s:5:"label";s:6:"Footer";s:11:"description";s:22:"Site information links";s:6:"locked";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'system.menu.main',
  'data' => 'a:9:{s:4:"uuid";s:36:"9323e082-f9cf-45b6-aca9-172c0ee871bd";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Q2Ra3jfoIVk0f3SjxJX61byRQFVBAbpzYDQOiY-kno8";}s:2:"id";s:4:"main";s:5:"label";s:15:"Main navigation";s:11:"description";s:18:"Site section links";s:6:"locked";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'system.menu.tools',
  'data' => 'a:9:{s:4:"uuid";s:36:"e1cfe7a9-2e30-45cf-a2ab-07b152cdd3e7";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"BCM-vV1zzRaLHN18dqAR_CuGOj8AFJvTx7BKl_8Gcxc";}s:2:"id";s:5:"tools";s:5:"label";s:5:"Tools";s:11:"description";s:39:"User tool links, often added by modules";s:6:"locked";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'system.performance',
  'data' => 'a:6:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"b2cssrj-lOmATIbdehfCqfCFgVR0qCdxxWhwqa2KBVQ";}s:5:"cache";a:1:{s:4:"page";a:1:{s:7:"max_age";i:0;}}s:3:"css";a:2:{s:10:"preprocess";b:1;s:4:"gzip";b:1;}s:8:"fast_404";a:4:{s:7:"enabled";b:1;s:5:"paths";s:69:"/\.(?:txt|png|gif|jpe?g|css|js|ico|swf|flv|cgi|bat|pl|dll|exe|asp)$/i";s:13:"exclude_paths";s:27:"/\/(?:styles|imagecache)\//";s:4:"html";s:162:"<!DOCTYPE html><html><head><title>404 Not Found</title></head><body><h1>Not Found</h1><p>The requested URL "@path" was not found on this server.</p></body></html>";}s:2:"js";a:2:{s:10:"preprocess";b:1;s:4:"gzip";b:1;}s:20:"stale_file_threshold";i:2592000;}',
))
->values(array(
  'collection' => '',
  'name' => 'system.rss',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"MIpNzlG4gPunfS7vTCwUPum6QH3GUsEBMj-qS631Jw0";}s:5:"items";a:1:{s:9:"view_mode";s:3:"rss";}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.site',
  'data' => 'a:11:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"VDJxTZtQR21qB4lvOq8zszJZLvLKrSPQpdn2E3T71Ww";}s:8:"langcode";s:2:"en";s:4:"uuid";s:36:"c7a58122-ec76-4d96-979d-c7aeb49ec0ab";s:4:"name";s:18:"Drush Site-Install";s:4:"mail";s:17:"admin@example.com";s:6:"slogan";s:0:"";s:4:"page";a:3:{i:403;s:0:"";i:404;s:0:"";s:5:"front";s:5:"/node";}s:18:"admin_compact_mode";b:0;s:17:"weight_select_max";i:100;s:16:"default_langcode";s:2:"en";s:17:"mail_notification";s:0:"";}',
))
->values(array(
  'collection' => '',
  'name' => 'system.theme',
  'data' => 'a:3:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"eJ529VM1gSIA_vgTy2PdiDvJuG0xhSxfQjCyl5WKlv4";}s:5:"admin";s:5:"claro";s:7:"default";s:7:"olivero";}',
))
->values(array(
  'collection' => '',
  'name' => 'system.theme.global',
  'data' => 'a:4:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"9rAU4Pku7eMBQxauQqAgjzlcicFZ2As6zEa6zvTlCB8";}s:7:"favicon";a:4:{s:8:"mimetype";s:24:"image/vnd.microsoft.icon";s:4:"path";s:0:"";s:3:"url";s:0:"";s:11:"use_default";b:1;}s:8:"features";a:4:{s:20:"comment_user_picture";b:1;s:25:"comment_user_verification";b:1;s:7:"favicon";b:1;s:17:"node_user_picture";b:1;}s:4:"logo";a:3:{s:4:"path";s:0:"";s:3:"url";s:0:"";s:11:"use_default";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'taxonomy.settings',
  'data' => 'a:4:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"zKpaWT6cJc1tVQQaTqatGELaCqU_oyRym6zTl27Yias";}s:20:"maintain_index_table";b:1;s:17:"override_selector";b:0;s:20:"terms_per_page_admin";i:100;}',
))
->values(array(
  'collection' => '',
  'name' => 'taxonomy.vocabulary.tags',
  'data' => 'a:9:{s:4:"uuid";s:36:"7a3f07cc-15f1-465b-9849-e0c03bb59f78";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"yoNVreoTdTZTY7GuE8fI9Jmxqdz8vlo4ZJKixMNSosw";}s:4:"name";s:4:"Tags";s:3:"vid";s:4:"tags";s:11:"description";s:61:"Use tags to group articles on similar topics into categories.";s:6:"weight";i:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'text.settings',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Bkewb77RBOK3_aXMPsp8p87gbc03NvmC5gBLzPl7hVA";}s:22:"default_summary_length";i:600;}',
))
->values(array(
  'collection' => '',
  'name' => 'tour.tour.block-layout',
  'data' => 'a:10:{s:4:"uuid";s:36:"c6712d2f-69b8-4200-8401-059a7240a0b2";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:5:"block";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ructO0IOsghR3CIbNd-0QfLTDiUo8gIJ7mB_nxSil4o";}s:2:"id";s:12:"block-layout";s:5:"label";s:17:"Block Layout Page";s:6:"module";s:5:"block";s:6:"routes";a:1:{i:0;a:1:{s:10:"route_name";s:19:"block.admin_display";}}s:4:"tips";a:5:{s:12:"block-layout";a:5:{s:2:"id";s:12:"block-layout";s:6:"plugin";s:4:"text";s:5:"label";s:12:"Block Layout";s:6:"weight";i:1;s:4:"body";s:150:"Blocks are boxes of content rendered into an area, or region, of a web page that can be displayed in regions (such as footer or sidebar) on your page.";}s:11:"place-block";a:6:{s:2:"id";s:11:"place-block";s:6:"plugin";s:4:"text";s:5:"label";s:12:"Place Blocks";s:6:"weight";i:2;s:8:"selector";s:14:".button--small";s:4:"body";s:163:"Any custom or contributed block can be added to a particular region by clicking on a button Place block. A new block can also be created by clicking on Place Block";}s:12:"block-region";a:6:{s:2:"id";s:12:"block-region";s:6:"plugin";s:4:"text";s:5:"label";s:12:"Block Region";s:6:"weight";i:3;s:8:"selector";s:20:".block-region-select";s:4:"body";s:151:"Assign or change the region of a block by clicking here. A dropdown list with all the regions will appear. You can place one block in multiple regions.";}s:15:"configure-block";a:6:{s:2:"id";s:15:"configure-block";s:6:"plugin";s:4:"text";s:5:"label";s:15:"Configure Block";s:6:"weight";i:4;s:8:"selector";s:18:".dropbutton-widget";s:4:"body";s:173:"By Clicking on "Configure" you can go ahead and edit the contents of the block, deal with the visibility settings and even change the placement of where it is on your theme.";}s:20:"custom-block-library";a:5:{s:2:"id";s:20:"custom-block-library";s:6:"plugin";s:4:"text";s:5:"label";s:20:"Custom Block Library";s:6:"weight";i:5;s:4:"body";s:203:"The block management screen also has an another tab on the top which is used to add Custom blocks. The name of the tab is "Custom block library". This tab ultimately provides a link to add custom blocks.";}}}',
))
->values(array(
  'collection' => '',
  'name' => 'tour.tour.language',
  'data' => 'a:10:{s:4:"uuid";s:36:"1d328dfc-0956-4d37-8e5b-cb90e1d7a4d7";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:8:"language";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Okz8QMYRGvq95nqLGYjp8gLiy93DKoMEzEVZVwEeg4M";}s:2:"id";s:8:"language";s:5:"label";s:8:"Language";s:6:"module";s:8:"language";s:6:"routes";a:1:{i:0;a:1:{s:10:"route_name";s:39:"entity.configurable_language.collection";}}s:4:"tips";a:6:{s:17:"language-overview";a:5:{s:2:"id";s:17:"language-overview";s:6:"plugin";s:4:"text";s:5:"label";s:9:"Languages";s:6:"weight";i:1;s:4:"body";s:96:"<p>The "Languages" page allows you to add, edit, delete, and reorder languages for the site.</p>";}s:12:"language-add";a:6:{s:2:"id";s:12:"language-add";s:6:"plugin";s:4:"text";s:5:"label";s:16:"Adding languages";s:6:"weight";i:2;s:8:"selector";s:14:".button-action";s:4:"body";s:171:"<p>To add more languages to your site, click the "Add language" button.</p><p>Added languages will be displayed in the language list and can then be edited or deleted.</p>";}s:16:"language-reorder";a:6:{s:2:"id";s:16:"language-reorder";s:6:"plugin";s:4:"text";s:5:"label";s:20:"Reordering languages";s:6:"weight";i:3;s:8:"selector";s:10:".draggable";s:4:"body";s:402:"<p>To reorder the languages on your site, use the drag icons next to each language.</p><p>The order shown here is the display order for language lists on the site such as in the language switcher blocks provided by the Interface Translation and Content Translation modules.</p><p>When you are done with reordering the languages, click the "Save configuration" button for the changes to take effect.</p>";}s:16:"language-default";a:6:{s:2:"id";s:16:"language-default";s:6:"plugin";s:4:"text";s:5:"label";s:25:"Set a language as default";s:6:"weight";i:4;s:8:"selector";s:35:".js-form-item-site-default-language";s:4:"body";s:274:"<p>You can change the default language of the site by choosing one of your configured languages as default. The site will use the default language in situations where no choice is made but a language should be set, for example as the language of the displayed interface.</p>";}s:19:"language-operations";a:6:{s:2:"id";s:19:"language-operations";s:6:"plugin";s:4:"text";s:5:"label";s:19:"Modifying languages";s:6:"weight";i:5;s:8:"selector";s:19:".dropbutton-wrapper";s:4:"body";s:399:"<p>Operations are provided for editing and deleting your languages.</p><p>You can edit the name and the direction of the language.</p><p>Deleted languages can be added back at a later time. Deleting a language will remove all interface translations associated with it, and content in this language will be set to be language neutral. Note that you cannot delete the default language of the site.</p>";}s:17:"language-continue";a:5:{s:2:"id";s:17:"language-continue";s:6:"plugin";s:4:"text";s:5:"label";s:13:"Continuing on";s:6:"weight";i:6;s:4:"body";s:260:"<p>Now that you have an overview of the "Languages" page, you can continue by:<ul><li><a href="[site:url]admin/config/regional/language/add">Adding a language</a></li><li>Reordering languages</li><li>Editing a language</li><li>Deleting a language</li></ul></p>";}}}',
))
->values(array(
  'collection' => '',
  'name' => 'tour.tour.language-add',
  'data' => 'a:10:{s:4:"uuid";s:36:"a56e5264-50f9-4ce3-a434-bd45f8d9c944";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:8:"language";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"vcDd9H0uIlyOQGoVAJuD3ADMnQeRR_X3B-ojyb8Cbnc";}s:2:"id";s:12:"language-add";s:5:"label";s:16:"Adding languages";s:6:"module";s:8:"language";s:6:"routes";a:1:{i:0;a:1:{s:10:"route_name";s:12:"language.add";}}s:4:"tips";a:3:{s:21:"language-add-overview";a:5:{s:2:"id";s:21:"language-add-overview";s:6:"plugin";s:4:"text";s:5:"label";s:16:"Adding languages";s:6:"weight";i:1;s:4:"body";s:154:"<p>This page provides the ability to add common languages to your site.</p><p>If the desired language is not available, you can add a custom language.</p>";}s:19:"language-add-choose";a:6:{s:2:"id";s:19:"language-add-choose";s:6:"plugin";s:4:"text";s:5:"label";s:15:"Select language";s:6:"weight";i:2;s:8:"selector";s:25:"#edit-predefined-langcode";s:4:"body";s:312:"<p>Choose a language from the list, or choose "Custom language..." at the end of the list.</p><p>Click the "Add language" button when you are done choosing your language.</p><p>When adding a custom language, you will get an additional form where you can provide the name, code, and direction of the language.</p>";}s:21:"language-add-continue";a:5:{s:2:"id";s:21:"language-add-continue";s:6:"plugin";s:4:"text";s:5:"label";s:13:"Continuing on";s:6:"weight";i:3;s:4:"body";s:249:"<p>Now that you have an overview of the "Add languages" feature, you can continue by:<ul><li>Adding a language</li><li>Adding a custom language</li><li><a href="[site:url]admin/config/regional/language">Viewing configured languages</a></li></ul></p>";}}}',
))
->values(array(
  'collection' => '',
  'name' => 'tour.tour.language-edit',
  'data' => 'a:10:{s:4:"uuid";s:36:"d36fb242-2ca1-48a0-a99f-1a4f2a8e1e53";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:8:"language";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"gjYvYwMqulNsq7VmScWKOqEUxar9AX0TvG8vfCCguUQ";}s:2:"id";s:13:"language-edit";s:5:"label";s:17:"Editing languages";s:6:"module";s:8:"language";s:6:"routes";a:1:{i:0;a:1:{s:10:"route_name";s:38:"entity.configurable_language.edit_form";}}s:4:"tips";a:5:{s:22:"language-edit-overview";a:5:{s:2:"id";s:22:"language-edit-overview";s:6:"plugin";s:4:"text";s:5:"label";s:17:"Editing languages";s:6:"weight";i:1;s:4:"body";s:98:"<p>This page provides the ability to edit a language on your site, including custom languages.</p>";}s:22:"language-edit-langcode";a:6:{s:2:"id";s:22:"language-edit-langcode";s:6:"plugin";s:4:"text";s:5:"label";s:13:"Language code";s:6:"weight";i:2;s:8:"selector";s:19:"#edit-langcode-view";s:4:"body";s:122:"<p>You cannot change the code of a language on the site, since it is used by the system to keep track of the language.</p>";}s:19:"language-edit-label";a:6:{s:2:"id";s:19:"language-edit-label";s:6:"plugin";s:4:"text";s:5:"label";s:13:"Language name";s:6:"weight";i:3;s:8:"selector";s:11:"#edit-label";s:4:"body";s:289:"<p>The language name is used throughout the site for all users and is written in English. Names of built-in languages can be translated using the Interface Translation module, and names of both built-in and custom languages can be translated using the Configuration Translation module.</p>";}s:23:"language-edit-direction";a:6:{s:2:"id";s:23:"language-edit-direction";s:6:"plugin";s:4:"text";s:5:"label";s:18:"Language direction";s:6:"weight";i:4;s:8:"selector";s:37:"#edit-direction--wrapper--description";s:4:"body";s:196:"<p>Choose if the language is a "Left to right" or "Right to left" language.</p><p>Note that not all themes support "Right to left" layouts, so test your theme if you are using "Right to left".</p>";}s:22:"language-edit-continue";a:5:{s:2:"id";s:22:"language-edit-continue";s:6:"plugin";s:4:"text";s:5:"label";s:13:"Continuing on";s:6:"weight";i:5;s:4:"body";s:217:"<p>Now that you have an overview of the "Edit language" feature, you can continue by:<ul><li>Editing a language</li><li><a href="[site:url]admin/config/regional/language">Viewing configured languages</a></li></ul></p>";}}}',
))
->values(array(
  'collection' => '',
  'name' => 'tour.tour.views-ui',
  'data' => "a:10:{s:4:\"uuid\";s:36:\"b1baec29-9b50-4f44-8cf5-d97c1f63f4b9\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:8:\"views_ui\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"XIYL1KF7ND2XQRa5AxvEcp8vgCN2kUGiuBNhCgxrPME\";}s:2:\"id\";s:8:\"views-ui\";s:5:\"label\";s:14:\"View edit page\";s:6:\"module\";s:8:\"views_ui\";s:6:\"routes\";a:2:{i:0;a:1:{s:10:\"route_name\";s:21:\"entity.view.edit_form\";}i:1;a:1:{s:10:\"route_name\";s:29:\"entity.view.edit_display_form\";}}s:4:\"tips\";a:10:{s:10:\"views-main\";a:5:{s:2:\"id\";s:10:\"views-main\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:20:\"Manage view settings\";s:6:\"weight\";i:1;s:4:\"body\";s:31:\"View or edit the configuration.\";}s:17:\"views-ui-displays\";a:6:{s:2:\"id\";s:17:\"views-ui-displays\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:21:\"Displays in this view\";s:6:\"weight\";i:2;s:8:\"selector\";s:18:\"#views-display-top\";s:4:\"body\";s:169:\"A display is a way of outputting the results, e.g., as a page or a block. A view can contain multiple displays, which are listed here. The active display is highlighted.\";}s:19:\"views-ui-view-admin\";a:7:{s:2:\"id\";s:19:\"views-ui-view-admin\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:19:\"View administration\";s:6:\"weight\";i:3;s:8:\"position\";s:5:\"right\";s:8:\"selector\";s:28:\"#views-display-extra-actions\";s:4:\"body\";s:140:\"Perform administrative tasks, including adding a description and creating a clone. Click the drop-down button to view the available options.\";}s:15:\"views-ui-format\";a:6:{s:2:\"id\";s:15:\"views-ui-format\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:13:\"Output format\";s:6:\"weight\";i:4;s:8:\"selector\";s:35:\".views-ui-display-tab-bucket.format\";s:4:\"body\";s:325:\"Choose how to output results. E.g., choose <em>Content</em> to output each item completely, using your configured display settings. Or choose <em>Fields</em>, which allows you to output only specific fields for each result. Additional formats can be added by installing modules to <em>extend</em> Drupal's base functionality.\";}s:15:\"views-ui-fields\";a:6:{s:2:\"id\";s:15:\"views-ui-fields\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:6:\"Fields\";s:6:\"weight\";i:5;s:8:\"selector\";s:34:\".views-ui-display-tab-bucket.field\";s:4:\"body\";s:89:\"If this view uses fields, they are listed here. You can click on a field to configure it.\";}s:15:\"views-ui-filter\";a:6:{s:2:\"id\";s:15:\"views-ui-filter\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:16:\"Filter your view\";s:6:\"weight\";i:6;s:8:\"selector\";s:35:\".views-ui-display-tab-bucket.filter\";s:4:\"body\";s:173:\"Add filters to limit the results in the output. E.g., to only show content that is <em>published</em>, you would add a filter for <em>Published</em> and select <em>Yes</em>.\";}s:26:\"views-ui-filter-operations\";a:6:{s:2:\"id\";s:26:\"views-ui-filter-operations\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:14:\"Filter actions\";s:6:\"weight\";i:7;s:8:\"selector\";s:54:\".views-ui-display-tab-bucket.filter .dropbutton-widget\";s:4:\"body\";s:33:\"Add, rearrange or remove filters.\";}s:14:\"views-ui-sorts\";a:6:{s:2:\"id\";s:14:\"views-ui-sorts\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:13:\"Sort Criteria\";s:6:\"weight\";i:8;s:8:\"selector\";s:33:\".views-ui-display-tab-bucket.sort\";s:4:\"body\";s:96:\"Control the order in which the results are output. Click on an active sort rule to configure it.\";}s:25:\"views-ui-sorts-operations\";a:6:{s:2:\"id\";s:25:\"views-ui-sorts-operations\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:12:\"Sort actions\";s:6:\"weight\";i:9;s:8:\"selector\";s:52:\".views-ui-display-tab-bucket.sort .dropbutton-widget\";s:4:\"body\";s:39:\"Add, rearrange or remove sorting rules.\";}s:16:\"views-ui-preview\";a:7:{s:2:\"id\";s:16:\"views-ui-preview\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:7:\"Preview\";s:6:\"weight\";i:10;s:8:\"position\";s:5:\"right\";s:8:\"selector\";s:15:\"#preview-submit\";s:4:\"body\";s:34:\"Show a preview of the view output.\";}}}",
))
->values(array(
  'collection' => '',
  'name' => 'update.settings',
  'data' => 'a:4:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"2QzULf0zovJQx3J06Y9rufzzfi-CY2CTTlEfJJh2Qyw";}s:5:"check";a:2:{s:19:"disabled_extensions";b:0;s:13:"interval_days";i:1;}s:5:"fetch";a:3:{s:3:"url";s:0:"";s:12:"max_attempts";i:2;s:7:"timeout";i:30;}s:12:"notification";a:2:{s:6:"emails";a:1:{i:0;s:17:"admin@example.com";}s:9:"threshold";s:3:"all";}}',
))
->values(array(
  'collection' => '',
  'name' => 'user.flood',
  'data' => 'a:6:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"UYfMzeP1S8jKm9PSvxf7nQNe8DsNS-3bc2WSNNXBQWs";}s:8:"uid_only";b:0;s:8:"ip_limit";i:50;s:9:"ip_window";i:3600;s:10:"user_limit";i:5;s:11:"user_window";i:21600;}',
))
->values(array(
  'collection' => '',
  'name' => 'user.mail',
  'data' => "a:11:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"6CZIzFifRq3qbdq3n3nDpEOO4hWIQtKOAQNPvGNGKeM\";}s:8:\"langcode\";s:2:\"en\";s:14:\"cancel_confirm\";a:2:{s:7:\"subject\";s:67:\"Account cancellation request for [user:display-name] at [site:name]\";s:4:\"body\";s:388:\"[user:display-name]\r\n\r\nA request to cancel your account has been made at [site:name].\r\n\r\nYou may now cancel your account on [site:url-brief] by clicking this link or copying and pasting it into your browser:\r\n\r\n[user:cancel-url]\r\n\r\nNOTE: The cancellation of your account is not reversible.\r\n\r\nThis link expires in one day and nothing will happen if it is not used.\r\n\r\n--  [site:name] team\";}s:14:\"password_reset\";a:2:{s:7:\"subject\";s:68:\"Replacement login information for [user:display-name] at [site:name]\";s:4:\"body\";s:417:\"[user:display-name],\r\n\r\nA request to reset the password for your account has been made at [site:name].\r\n\r\nYou may now log in by clicking this link or copying and pasting it into your browser:\r\n\r\n[user:one-time-login-url]\r\n\r\nThis link can only be used once to log in and will lead you to a page where you can set your password. It expires after one day and nothing will happen if it's not used.\r\n\r\n--  [site:name] team\";}s:22:\"register_admin_created\";a:2:{s:7:\"subject\";s:58:\"An administrator created an account for you at [site:name]\";s:4:\"body\";s:486:\"[user:display-name],\r\n\r\nA site administrator at [site:name] has created an account for you. You may now log in by clicking this link or copying and pasting it into your browser:\r\n\r\n[user:one-time-login-url]\r\n\r\nThis link can only be used once to log in and will lead you to a page where you can set your password.\r\n\r\nAfter setting your password, you will be able to log in at [site:login-url] in the future using:\r\n\r\nusername: [user:name]\r\npassword: Your password\r\n\r\n--  [site:name] team\";}s:29:\"register_no_approval_required\";a:2:{s:7:\"subject\";s:54:\"Account details for [user:display-name] at [site:name]\";s:4:\"body\";s:460:\"[user:display-name],\r\n\r\nThank you for registering at [site:name]. You may now log in by clicking this link or copying and pasting it into your browser:\r\n\r\n[user:one-time-login-url]\r\n\r\nThis link can only be used once to log in and will lead you to a page where you can set your password.\r\n\r\nAfter setting your password, you will be able to log in at [site:login-url] in the future using:\r\n\r\nusername: [user:name]\r\npassword: Your password\r\n\r\n--  [site:name] team\";}s:25:\"register_pending_approval\";a:2:{s:7:\"subject\";s:79:\"Account details for [user:display-name] at [site:name] (pending admin approval)\";s:4:\"body\";s:292:\"[user:display-name],\r\n\r\nThank you for registering at [site:name]. Your application for an account is currently pending approval. Once it has been approved, you will receive another email containing information about how to log in, set your password, and other details.\r\n\r\n--  [site:name] team\";}s:31:\"register_pending_approval_admin\";a:2:{s:7:\"subject\";s:79:\"Account details for [user:display-name] at [site:name] (pending admin approval)\";s:4:\"body\";s:66:\"[user:display-name] has applied for an account.\r\n\r\n[user:edit-url]\";}s:16:\"status_activated\";a:2:{s:7:\"subject\";s:65:\"Account details for [user:display-name] at [site:name] (approved)\";s:4:\"body\";s:477:\"[user:display-name],\r\n\r\nYour account at [site:name] has been activated.\r\n\r\nYou may now log in by clicking this link or copying and pasting it into your browser:\r\n\r\n[user:one-time-login-url]\r\n\r\nThis link can only be used once to log in and will lead you to a page where you can set your password.\r\n\r\nAfter setting your password, you will be able to log in at [site:login-url] in the future using:\r\n\r\nusername: [user:account-name]\r\npassword: Your password\r\n\r\n--  [site:name] team\";}s:14:\"status_blocked\";a:2:{s:7:\"subject\";s:64:\"Account details for [user:display-name] at [site:name] (blocked)\";s:4:\"body\";s:93:\"[user:display-name],\r\n\r\nYour account on [site:name] has been blocked.\r\n\r\n--  [site:name] team\";}s:15:\"status_canceled\";a:2:{s:7:\"subject\";s:65:\"Account details for [user:display-name] at [site:name] (canceled)\";s:4:\"body\";s:94:\"[user:display-name],\r\n\r\nYour account on [site:name] has been canceled.\r\n\r\n--  [site:name] team\";}}",
))
->values(array(
  'collection' => '',
  'name' => 'user.role.administrator',
  'data' => 'a:10:{s:4:"uuid";s:36:"91230e95-9e22-408b-8aad-f10efcaf81a5";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"OeKGIkmZA_c-t6QLH81WNQx8gDCc1MRmxaTuQgxBByU";}s:2:"id";s:13:"administrator";s:5:"label";s:13:"Administrator";s:6:"weight";i:3;s:8:"is_admin";b:1;s:11:"permissions";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'user.role.anonymous',
  'data' => 'a:10:{s:4:"uuid";s:36:"62ef622d-8099-4c0e-9332-4aa7bce947bd";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:29:"filter.format.restricted_html";}s:6:"module";a:5:{i:0;s:7:"comment";i:1;s:7:"contact";i:2;s:6:"filter";i:3;s:6:"search";i:4;s:6:"system";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"6WavjUYXIegP9AAg2zXGx54MWIVoomC3SZhNiqe-Dyk";}s:2:"id";s:9:"anonymous";s:5:"label";s:14:"Anonymous user";s:6:"weight";i:0;s:8:"is_admin";b:0;s:11:"permissions";a:5:{i:0;s:15:"access comments";i:1;s:14:"access content";i:2;s:29:"access site-wide contact form";i:3;s:14:"search content";i:4;s:31:"use text format restricted_html";}}',
))
->values(array(
  'collection' => '',
  'name' => 'user.role.authenticated',
  'data' => 'a:10:{s:4:"uuid";s:36:"69a5c5d9-5fad-4bf9-b424-5e572c8e7124";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:24:"filter.format.basic_html";}s:6:"module";a:6:{i:0;s:7:"comment";i:1;s:7:"contact";i:2;s:6:"filter";i:3;s:6:"search";i:4;s:8:"shortcut";i:5;s:6:"system";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"I44QAB4es39lNzMQWiJLq2dfjX7VRSOzT_5KzAcUq_M";}s:2:"id";s:13:"authenticated";s:5:"label";s:18:"Authenticated user";s:6:"weight";i:1;s:8:"is_admin";b:0;s:11:"permissions";a:8:{i:0;s:15:"access comments";i:1;s:14:"access content";i:2;s:16:"access shortcuts";i:3;s:29:"access site-wide contact form";i:4;s:13:"post comments";i:5;s:14:"search content";i:6;s:21:"skip comment approval";i:7;s:26:"use text format basic_html";}}',
))
->values(array(
  'collection' => '',
  'name' => 'user.role.content_editor',
  'data' => 'a:10:{s:4:"uuid";s:36:"97313136-8527-45df-b2b9-89f0a91fa696";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:3:{i:0;s:17:"node.type.article";i:1;s:14:"node.type.page";i:2;s:24:"taxonomy.vocabulary.tags";}s:6:"module";a:9:{i:0;s:7:"comment";i:1;s:10:"contextual";i:2;s:4:"file";i:3;s:4:"node";i:4;s:4:"path";i:5;s:6:"system";i:6;s:8:"taxonomy";i:7;s:7:"toolbar";i:8;s:4:"tour";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Wur9kcEOwY1Jal81NssKnz3RhVJxAvBwyWQBGcA_1Go";}s:2:"id";s:14:"content_editor";s:5:"label";s:14:"Content editor";s:6:"weight";i:2;s:8:"is_admin";b:0;s:11:"permissions";a:23:{i:0;s:27:"access administration pages";i:1;s:23:"access content overview";i:2;s:23:"access contextual links";i:3;s:21:"access files overview";i:4;s:14:"access toolbar";i:5;s:11:"access tour";i:6;s:22:"administer url aliases";i:7;s:22:"create article content";i:8;s:19:"create page content";i:9;s:20:"create terms in tags";i:10;s:18:"create url aliases";i:11;s:24:"delete article revisions";i:12;s:26:"delete own article content";i:13;s:23:"delete own page content";i:14;s:21:"delete page revisions";i:15;s:24:"edit own article content";i:16;s:17:"edit own comments";i:17;s:21:"edit own page content";i:18;s:18:"edit terms in tags";i:19;s:20:"revert all revisions";i:20;s:18:"view all revisions";i:21;s:28:"view own unpublished content";i:22;s:29:"view the administration theme";}}',
))
->values(array(
  'collection' => '',
  'name' => 'user.settings',
  'data' => 'a:9:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"-htDFWUv1S4OlJMzta2nhFl4QbhJvu0D9xsJ-clxo-M";}s:8:"langcode";s:2:"en";s:9:"anonymous";s:9:"Anonymous";s:11:"verify_mail";b:1;s:6:"notify";a:8:{s:14:"cancel_confirm";b:1;s:14:"password_reset";b:1;s:16:"status_activated";b:1;s:14:"status_blocked";b:0;s:15:"status_canceled";b:0;s:22:"register_admin_created";b:1;s:29:"register_no_approval_required";b:1;s:25:"register_pending_approval";b:1;}s:8:"register";s:23:"visitors_admin_approval";s:13:"cancel_method";s:17:"user_cancel_block";s:22:"password_reset_timeout";i:86400;s:17:"password_strength";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'views.settings',
  'data' => 'a:6:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"uZHsLrDp1ThO0RvupHKcPzLOyVvWexm58JTTHNDo7yc";}s:17:"display_extenders";a:0:{}s:10:"skip_cache";b:0;s:13:"sql_signature";b:0;s:2:"ui";a:3:{s:4:"show";a:7:{s:18:"additional_queries";b:0;s:15:"advanced_column";b:0;s:15:"default_display";b:0;s:22:"performance_statistics";b:0;s:19:"preview_information";b:1;s:9:"sql_query";a:2:{s:7:"enabled";b:0;s:5:"where";s:5:"above";}s:13:"display_embed";b:0;}s:19:"always_live_preview";b:1;s:24:"exposed_filter_any_label";s:7:"old_any";}s:22:"field_rewrite_elements";a:29:{s:3:"div";s:3:"DIV";s:4:"span";s:4:"SPAN";s:2:"h1";s:2:"H1";s:2:"h2";s:2:"H2";s:2:"h3";s:2:"H3";s:2:"h4";s:2:"H4";s:2:"h5";s:2:"H5";s:2:"h6";s:2:"H6";s:1:"p";s:1:"P";s:6:"header";s:6:"HEADER";s:6:"footer";s:6:"FOOTER";s:7:"article";s:7:"ARTICLE";s:7:"section";s:7:"SECTION";s:5:"aside";s:5:"ASIDE";s:7:"details";s:7:"DETAILS";s:10:"blockquote";s:10:"BLOCKQUOTE";s:6:"figure";s:6:"FIGURE";s:7:"address";s:7:"ADDRESS";s:4:"code";s:4:"CODE";s:3:"pre";s:3:"PRE";s:3:"var";s:3:"VAR";s:4:"samp";s:4:"SAMP";s:3:"kbd";s:3:"KBD";s:6:"strong";s:6:"STRONG";s:2:"em";s:2:"EM";s:3:"del";s:3:"DEL";s:3:"ins";s:3:"INS";s:1:"q";s:1:"Q";s:1:"s";s:1:"S";}}',
))
->values(array(
  'collection' => '',
  'name' => 'views.view.archive',
  'data' => 'a:13:{s:4:"uuid";s:36:"19e738c3-448d-4d69-b9d0-a284b56894eb";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:33:"core.entity_view_mode.node.teaser";}s:6:"module";a:2:{i:0;s:4:"node";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ko9GznzNBXHkuz09OCaBQ1YOSJYYjTY0TBpNV3WKnog";}s:2:"id";s:7:"archive";s:5:"label";s:7:"Archive";s:6:"module";s:4:"node";s:11:"description";s:22:"All content, by month.";s:3:"tag";s:7:"default";s:10:"base_table";s:15:"node_field_data";s:10:"base_field";s:3:"nid";s:7:"display";a:3:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:17:{s:5:"title";s:15:"Monthly archive";s:6:"fields";a:0:{}s:5:"pager";a:2:{s:4:"type";s:4:"mini";s:7:"options";a:6:{s:6:"offset";i:0;s:14:"items_per_page";i:10;s:11:"total_pages";i:0;s:2:"id";i:0;s:4:"tags";a:2:{s:4:"next";s:6:"››";s:8:"previous";s:6:"‹‹";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:5:"Apply";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:14:"access content";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"empty";a:0:{}s:5:"sorts";a:1:{s:7:"created";a:13:{s:2:"id";s:7:"created";s:5:"table";s:15:"node_field_data";s:5:"field";s:7:"created";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:7:"created";s:9:"plugin_id";s:4:"date";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:7:"created";}s:7:"exposed";b:0;s:11:"granularity";s:6:"second";}}s:9:"arguments";a:1:{s:18:"created_year_month";a:13:{s:2:"id";s:18:"created_year_month";s:5:"table";s:15:"node_field_data";s:5:"field";s:18:"created_year_month";s:11:"entity_type";s:4:"node";s:9:"plugin_id";s:15:"date_year_month";s:14:"default_action";s:7:"summary";s:9:"exception";a:1:{s:12:"title_enable";b:1;}s:12:"title_enable";b:1;s:5:"title";s:34:"{{ arguments.created_year_month }}";s:21:"default_argument_type";s:5:"fixed";s:15:"summary_options";a:2:{s:8:"override";b:1;s:14:"items_per_page";i:30;}s:7:"summary";a:2:{s:10:"sort_order";s:4:"desc";s:6:"format";s:15:"default_summary";}s:18:"specify_validation";b:1;}}s:7:"filters";a:2:{s:6:"status";a:9:{s:2:"id";s:6:"status";s:5:"table";s:15:"node_field_data";s:5:"field";s:6:"status";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:5:"value";s:1:"1";s:5:"group";i:0;s:6:"expose";a:3:{s:8:"operator";s:1:"0";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}}s:8:"langcode";a:16:{s:2:"id";s:8:"langcode";s:5:"table";s:15:"node_field_data";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:8:"langcode";s:9:"plugin_id";s:8:"language";s:8:"operator";s:2:"in";s:5:"value";a:1:{s:31:"***LANGUAGE_language_content***";s:31:"***LANGUAGE_language_content***";}s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:13:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:5:"style";a:2:{s:4:"type";s:7:"default";s:7:"options";a:4:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:11:"uses_fields";b:0;}}s:3:"row";a:2:{s:4:"type";s:11:"entity:node";s:7:"options";a:1:{s:9:"view_mode";s:6:"teaser";}}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:0:{}s:6:"header";a:0:{}s:6:"footer";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:28:"languages:language_interface";i:1;s:3:"url";i:2;s:14:"url.query_args";i:3;s:21:"user.node_grants:view";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:7:"block_1";a:6:{s:2:"id";s:7:"block_1";s:13:"display_title";s:5:"Block";s:14:"display_plugin";s:5:"block";s:8:"position";i:1;s:15:"display_options";a:4:{s:9:"arguments";a:1:{s:18:"created_year_month";a:13:{s:2:"id";s:18:"created_year_month";s:5:"table";s:15:"node_field_data";s:5:"field";s:18:"created_year_month";s:11:"entity_type";s:4:"node";s:9:"plugin_id";s:15:"date_year_month";s:14:"default_action";s:7:"summary";s:9:"exception";a:1:{s:12:"title_enable";b:1;}s:12:"title_enable";b:1;s:5:"title";s:34:"{{ arguments.created_year_month }}";s:21:"default_argument_type";s:5:"fixed";s:15:"summary_options";a:1:{s:14:"items_per_page";i:30;}s:7:"summary";a:1:{s:6:"format";s:15:"default_summary";}s:18:"specify_validation";b:1;}}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:0:{}}s:8:"defaults";a:1:{s:9:"arguments";b:0;}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:28:"languages:language_interface";i:1;s:3:"url";i:2;s:14:"url.query_args";i:3;s:21:"user.node_grants:view";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"page_1";a:6:{s:2:"id";s:6:"page_1";s:13:"display_title";s:4:"Page";s:14:"display_plugin";s:4:"page";s:8:"position";i:2;s:15:"display_options";a:3:{s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:0:{}}s:17:"display_extenders";a:0:{}s:4:"path";s:7:"archive";}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:28:"languages:language_interface";i:1;s:3:"url";i:2;s:14:"url.query_args";i:3;s:21:"user.node_grants:view";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'views.view.block_content',
  'data' => 'a:13:{s:4:"uuid";s:36:"a6ef2058-ad9b-49be-a320-42409905c55e";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:13:"block_content";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"jvd5Pu6jy-lra4oMr-mR7zuY6CVDv9CaNeoj0Y70gV4";}s:2:"id";s:13:"block_content";s:5:"label";s:20:"Custom block library";s:6:"module";s:5:"views";s:11:"description";s:30:"Find and manage custom blocks.";s:3:"tag";s:7:"default";s:10:"base_table";s:24:"block_content_field_data";s:10:"base_field";s:2:"id";s:7:"display";a:2:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:17:{s:5:"title";s:20:"Custom block library";s:6:"fields";a:4:{s:4:"info";a:37:{s:2:"id";s:4:"info";s:5:"table";s:24:"block_content_field_data";s:5:"field";s:4:"info";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";N;s:12:"entity_field";s:4:"info";s:9:"plugin_id";s:5:"field";s:5:"label";s:17:"Block description";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:6:"string";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:4:"type";a:37:{s:2:"id";s:4:"type";s:5:"table";s:24:"block_content_field_data";s:5:"field";s:4:"type";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:13:"block_content";s:12:"entity_field";s:4:"type";s:9:"plugin_id";s:5:"field";s:5:"label";s:10:"Block type";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:9:"target_id";s:4:"type";s:22:"entity_reference_label";s:8:"settings";a:1:{s:4:"link";b:0;}s:12:"group_column";s:9:"target_id";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:7:"changed";a:26:{s:2:"id";s:7:"changed";s:5:"table";s:24:"block_content_field_data";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:13:"block_content";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:5:"field";s:5:"label";s:7:"Updated";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:9:"timestamp";s:8:"settings";a:3:{s:11:"date_format";s:5:"short";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";}}s:10:"operations";a:24:{s:2:"id";s:10:"operations";s:5:"table";s:13:"block_content";s:5:"field";s:10:"operations";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:13:"block_content";s:9:"plugin_id";s:17:"entity_operations";s:5:"label";s:10:"Operations";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:11:"destination";b:1;}}s:5:"pager";a:2:{s:4:"type";s:4:"mini";s:7:"options";a:6:{s:6:"offset";i:0;s:14:"items_per_page";i:50;s:11:"total_pages";N;s:2:"id";i:0;s:4:"tags";a:2:{s:4:"next";s:8:"Next ›";s:8:"previous";s:12:"‹ Previous";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:5:"Apply";s:12:"reset_button";b:1;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:17:"administer blocks";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"empty";a:2:{s:16:"area_text_custom";a:10:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:11:"text_custom";s:5:"empty";b:1;s:7:"content";s:37:"There are no custom blocks available.";s:8:"tokenize";b:0;}s:27:"block_content_listing_empty";a:10:{s:2:"id";s:27:"block_content_listing_empty";s:5:"table";s:13:"block_content";s:5:"field";s:27:"block_content_listing_empty";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:13:"block_content";s:9:"plugin_id";s:27:"block_content_listing_empty";s:5:"label";s:0:"";s:5:"empty";b:1;}}s:5:"sorts";a:0:{}s:9:"arguments";a:0:{}s:7:"filters";a:3:{s:4:"info";a:16:{s:2:"id";s:4:"info";s:5:"table";s:24:"block_content_field_data";s:5:"field";s:4:"info";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:13:"block_content";s:12:"entity_field";s:4:"info";s:9:"plugin_id";s:6:"string";s:8:"operator";s:8:"contains";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:7:"info_op";s:5:"label";s:17:"Block description";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:7:"info_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:4:"info";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:4:"type";a:16:{s:2:"id";s:4:"type";s:5:"table";s:24:"block_content_field_data";s:5:"field";s:4:"type";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:13:"block_content";s:12:"entity_field";s:4:"type";s:9:"plugin_id";s:6:"bundle";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:7:"type_op";s:5:"label";s:10:"Block type";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:7:"type_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:4:"type";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:8:"reusable";a:16:{s:2:"id";s:8:"reusable";s:5:"table";s:24:"block_content_field_data";s:5:"field";s:8:"reusable";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:13:"block_content";s:12:"entity_field";s:8:"reusable";s:9:"plugin_id";s:7:"boolean";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:12:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:7:"columns";a:4:{s:4:"info";s:4:"info";s:4:"type";s:4:"type";s:7:"changed";s:7:"changed";s:10:"operations";s:10:"operations";}s:7:"default";s:7:"changed";s:4:"info";a:4:{s:4:"info";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:4:"type";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:7:"changed";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:10:"operations";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}}s:8:"override";b:1;s:6:"sticky";b:0;s:7:"summary";s:0:"";s:11:"empty_table";b:1;s:7:"caption";s:0:"";s:11:"description";s:0:"";}}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:0:{}s:6:"header";a:0:{}s:6:"footer";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"page_1";a:6:{s:2:"id";s:6:"page_1";s:13:"display_title";s:4:"Page";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:3:{s:17:"display_extenders";a:0:{}s:4:"path";s:35:"admin/structure/block/block-content";s:4:"menu";a:7:{s:4:"type";s:3:"tab";s:5:"title";s:20:"Custom block library";s:11:"description";s:0:"";s:6:"weight";i:0;s:9:"menu_name";s:5:"admin";s:6:"parent";s:19:"block.admin_display";s:7:"context";s:1:"0";}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'views.view.comment',
  'data' => 'a:13:{s:4:"uuid";s:36:"9e2d20b7-d5e7-4d44-9806-4ef509ffdb82";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:7:"comment";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"CgXkKY33fd-yaHz89du2hSw6MJOoIeNUJ-VHE5BiSdQ";}s:2:"id";s:7:"comment";s:5:"label";s:8:"Comments";s:6:"module";s:7:"comment";s:11:"description";s:25:"Find and manage comments.";s:3:"tag";s:7:"default";s:10:"base_table";s:18:"comment_field_data";s:10:"base_field";s:3:"cid";s:7:"display";a:3:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:26:{s:5:"title";s:8:"Comments";s:6:"fields";a:8:{s:17:"comment_bulk_form";a:26:{s:2:"id";s:17:"comment_bulk_form";s:5:"table";s:7:"comment";s:5:"field";s:17:"comment_bulk_form";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:9:"plugin_id";s:17:"comment_bulk_form";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:12:"action_title";s:6:"Action";s:15:"include_exclude";s:7:"include";s:16:"selected_actions";a:2:{i:0;s:21:"comment_delete_action";i:1;s:24:"comment_unpublish_action";}}s:7:"subject";a:37:{s:2:"id";s:7:"subject";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"subject";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"subject";s:9:"plugin_id";s:5:"field";s:5:"label";s:7:"Subject";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:17:"comment_permalink";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:3:"uid";a:37:{s:2:"id";s:3:"uid";s:5:"table";s:18:"comment_field_data";s:5:"field";s:3:"uid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:3:"uid";s:9:"plugin_id";s:5:"field";s:5:"label";s:0:"";s:7:"exclude";b:1;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:9:"target_id";s:4:"type";s:22:"entity_reference_label";s:8:"settings";a:1:{s:4:"link";b:1;}s:12:"group_column";s:9:"target_id";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:4:"name";a:37:{s:2:"id";s:4:"name";s:5:"table";s:18:"comment_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:5:"field";s:5:"label";s:6:"Author";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:9:"{{ uid }}";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:16:"comment_username";s:8:"settings";a:0:{}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:9:"entity_id";a:37:{s:2:"id";s:9:"entity_id";s:5:"table";s:18:"comment_field_data";s:5:"field";s:9:"entity_id";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:9:"entity_id";s:9:"plugin_id";s:16:"commented_entity";s:5:"label";s:9:"Posted in";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:9:"target_id";s:4:"type";s:22:"entity_reference_label";s:8:"settings";a:1:{s:4:"link";b:1;}s:12:"group_column";s:9:"target_id";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:7:"changed";a:37:{s:2:"id";s:7:"changed";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:5:"field";s:5:"label";s:7:"Updated";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:9:"timestamp";s:8:"settings";a:3:{s:11:"date_format";s:5:"short";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:10:"operations";a:24:{s:2:"id";s:10:"operations";s:5:"table";s:7:"comment";s:5:"field";s:10:"operations";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:9:"plugin_id";s:17:"entity_operations";s:5:"label";s:10:"Operations";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:11:"destination";b:1;}s:6:"name_1";a:37:{s:2:"id";s:6:"name_1";s:5:"table";s:16:"users_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:3:"uid";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:5:"field";s:5:"label";s:0:"";s:7:"exclude";b:1;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:9:"user_name";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}}s:5:"pager";a:2:{s:4:"type";s:4:"full";s:7:"options";a:7:{s:6:"offset";i:0;s:14:"items_per_page";i:50;s:11:"total_pages";N;s:2:"id";i:0;s:4:"tags";a:4:{s:4:"next";s:8:"next ›";s:8:"previous";s:12:"‹ previous";s:5:"first";s:8:"« first";s:4:"last";s:7:"last »";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}s:8:"quantity";i:9;}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:6:"Filter";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:19:"administer comments";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"empty";a:1:{s:16:"area_text_custom";a:10:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:11:"text_custom";s:5:"empty";b:1;s:7:"content";s:22:"No comments available.";s:8:"tokenize";b:0;}}s:5:"sorts";a:1:{s:7:"changed";a:13:{s:2:"id";s:7:"changed";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:4:"date";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:7:"changed";}s:7:"exposed";b:0;s:11:"granularity";s:6:"second";}}s:9:"arguments";a:0:{}s:7:"filters";a:4:{s:6:"status";a:16:{s:2:"id";s:6:"status";s:5:"table";s:18:"comment_field_data";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:7:"subject";a:16:{s:2:"id";s:7:"subject";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"subject";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"subject";s:9:"plugin_id";s:6:"string";s:8:"operator";s:8:"contains";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:10:"subject_op";s:5:"label";s:7:"Subject";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:10:"subject_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:7:"subject";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:7:"combine";a:15:{s:2:"id";s:7:"combine";s:5:"table";s:5:"views";s:5:"field";s:7:"combine";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:7:"combine";s:8:"operator";s:8:"contains";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:10:"combine_op";s:5:"label";s:11:"Author name";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:10:"combine_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:11:"author_name";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:6:"fields";a:2:{s:4:"name";s:4:"name";s:6:"name_1";s:6:"name_1";}}s:8:"langcode";a:16:{s:2:"id";s:8:"langcode";s:5:"table";s:18:"comment_field_data";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:8:"langcode";s:9:"plugin_id";s:8:"language";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:11:"langcode_op";s:5:"label";s:8:"Language";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:11:"langcode_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:8:"langcode";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:13:"filter_groups";a:2:{s:8:"operator";s:3:"AND";s:6:"groups";a:1:{i:1;s:3:"AND";}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:12:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:7:"columns";a:6:{s:17:"comment_bulk_form";s:17:"comment_bulk_form";s:7:"subject";s:7:"subject";s:3:"uid";s:3:"uid";s:9:"entity_id";s:9:"entity_id";s:7:"changed";s:7:"changed";s:10:"operations";s:10:"operations";}s:7:"default";s:7:"changed";s:4:"info";a:6:{s:17:"comment_bulk_form";a:4:{s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:7:"subject";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:3:"uid";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:9:"entity_id";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:7:"changed";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:10:"operations";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}}s:8:"override";b:1;s:6:"sticky";b:1;s:7:"summary";s:0:"";s:11:"empty_table";b:1;s:7:"caption";s:0:"";s:11:"description";s:0:"";}}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:1:{s:3:"uid";a:10:{s:2:"id";s:3:"uid";s:5:"table";s:18:"comment_field_data";s:5:"field";s:3:"uid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:6:"author";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:3:"uid";s:9:"plugin_id";s:8:"standard";s:8:"required";b:0;}}s:9:"css_class";s:0:"";s:8:"use_ajax";b:0;s:8:"group_by";b:0;s:16:"show_admin_links";b:1;s:8:"use_more";b:0;s:15:"use_more_always";b:1;s:13:"use_more_text";s:4:"more";s:6:"header";a:0:{}s:6:"footer";a:0:{}s:23:"hide_attachment_summary";b:0;s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:4:{s:7:"max-age";i:0;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}s:9:"cacheable";b:0;}}s:14:"page_published";a:6:{s:2:"id";s:14:"page_published";s:13:"display_title";s:18:"Published comments";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:6:{s:19:"display_description";s:30:"The approved comments listing.";s:15:"display_comment";s:0:"";s:13:"exposed_block";b:0;s:17:"display_extenders";a:0:{}s:4:"path";s:21:"admin/content/comment";s:4:"menu";a:7:{s:4:"type";s:3:"tab";s:5:"title";s:8:"Comments";s:11:"description";s:18:"Comments published";s:6:"weight";i:0;s:9:"menu_name";s:5:"admin";s:6:"parent";s:0:"";s:7:"context";s:1:"0";}}s:14:"cache_metadata";a:4:{s:7:"max-age";i:0;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}s:9:"cacheable";b:0;}}s:15:"page_unapproved";a:6:{s:2:"id";s:15:"page_unapproved";s:13:"display_title";s:19:"Unapproved comments";s:14:"display_plugin";s:4:"page";s:8:"position";i:2;s:15:"display_options";a:8:{s:6:"fields";a:8:{s:17:"comment_bulk_form";a:26:{s:2:"id";s:17:"comment_bulk_form";s:5:"table";s:7:"comment";s:5:"field";s:17:"comment_bulk_form";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:9:"plugin_id";s:17:"comment_bulk_form";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:12:"action_title";s:6:"Action";s:15:"include_exclude";s:7:"include";s:16:"selected_actions";a:2:{i:0;s:21:"comment_delete_action";i:1;s:22:"comment_publish_action";}}s:7:"subject";a:37:{s:2:"id";s:7:"subject";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"subject";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"subject";s:9:"plugin_id";s:5:"field";s:5:"label";s:7:"Subject";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:17:"comment_permalink";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:3:"uid";a:37:{s:2:"id";s:3:"uid";s:5:"table";s:18:"comment_field_data";s:5:"field";s:3:"uid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:3:"uid";s:9:"plugin_id";s:5:"field";s:5:"label";s:0:"";s:7:"exclude";b:1;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:9:"target_id";s:4:"type";s:22:"entity_reference_label";s:8:"settings";a:1:{s:4:"link";b:1;}s:12:"group_column";s:9:"target_id";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:4:"name";a:37:{s:2:"id";s:4:"name";s:5:"table";s:18:"comment_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:5:"field";s:5:"label";s:6:"Author";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:9:"{{ uid }}";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:16:"comment_username";s:8:"settings";a:0:{}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:9:"entity_id";a:37:{s:2:"id";s:9:"entity_id";s:5:"table";s:18:"comment_field_data";s:5:"field";s:9:"entity_id";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:9:"entity_id";s:9:"plugin_id";s:16:"commented_entity";s:5:"label";s:9:"Posted in";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:9:"target_id";s:4:"type";s:22:"entity_reference_label";s:8:"settings";a:1:{s:4:"link";b:1;}s:12:"group_column";s:9:"target_id";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:7:"changed";a:37:{s:2:"id";s:7:"changed";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:5:"field";s:5:"label";s:7:"Updated";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:9:"timestamp";s:8:"settings";a:3:{s:11:"date_format";s:5:"short";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:10:"operations";a:24:{s:2:"id";s:10:"operations";s:5:"table";s:7:"comment";s:5:"field";s:10:"operations";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:9:"plugin_id";s:17:"entity_operations";s:5:"label";s:10:"Operations";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:11:"destination";b:1;}s:6:"name_1";a:37:{s:2:"id";s:6:"name_1";s:5:"table";s:16:"users_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:3:"uid";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:5:"field";s:5:"label";s:0:"";s:7:"exclude";b:1;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:9:"user_name";s:8:"settings";a:1:{s:14:"link_to_entity";b:0;}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}}s:7:"filters";a:4:{s:6:"status";a:16:{s:2:"id";s:6:"status";s:5:"table";s:18:"comment_field_data";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:8:"operator";s:1:"=";s:5:"value";s:1:"0";s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:7:"subject";a:16:{s:2:"id";s:7:"subject";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"subject";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"subject";s:9:"plugin_id";s:6:"string";s:8:"operator";s:8:"contains";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:10:"subject_op";s:5:"label";s:7:"Subject";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:10:"subject_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:7:"subject";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:7:"combine";a:15:{s:2:"id";s:7:"combine";s:5:"table";s:5:"views";s:5:"field";s:7:"combine";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:7:"combine";s:8:"operator";s:8:"contains";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:10:"combine_op";s:5:"label";s:11:"Author Name";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:10:"combine_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:11:"author_name";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:6:"fields";a:2:{s:4:"name";s:4:"name";s:6:"name_1";s:6:"name_1";}}s:8:"langcode";a:16:{s:2:"id";s:8:"langcode";s:5:"table";s:18:"comment_field_data";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:8:"langcode";s:9:"plugin_id";s:8:"language";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:11:"langcode_op";s:5:"label";s:8:"Language";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:11:"langcode_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:8:"langcode";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:13:"filter_groups";a:2:{s:8:"operator";s:3:"AND";s:6:"groups";a:1:{i:1;s:3:"AND";}}s:8:"defaults";a:3:{s:6:"fields";b:0;s:7:"filters";b:0;s:13:"filter_groups";b:0;}s:19:"display_description";s:32:"The unapproved comments listing.";s:17:"display_extenders";a:0:{}s:4:"path";s:30:"admin/content/comment/approval";s:4:"menu";a:7:{s:4:"type";s:3:"tab";s:5:"title";s:19:"Unapproved comments";s:11:"description";s:19:"Comments unapproved";s:6:"weight";i:1;s:9:"menu_name";s:5:"admin";s:6:"parent";s:0:"";s:7:"context";s:1:"0";}}s:14:"cache_metadata";a:4:{s:7:"max-age";i:0;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}s:9:"cacheable";b:0;}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'views.view.comments_recent',
  'data' => 'a:13:{s:4:"uuid";s:36:"fde5a3d5-3205-4baf-a22b-38b8b2d1ff07";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:3:{i:0;s:7:"comment";i:1;s:4:"node";i:2;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"S_NN2ubd_NovTfgzbHVlZMmIJJQS-3h9h3inzbaFUMY";}s:2:"id";s:15:"comments_recent";s:5:"label";s:15:"Recent comments";s:6:"module";s:5:"views";s:11:"description";s:16:"Recent comments.";s:3:"tag";s:7:"default";s:10:"base_table";s:18:"comment_field_data";s:10:"base_field";s:3:"cid";s:7:"display";a:2:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:14:{s:5:"title";s:15:"Recent comments";s:6:"fields";a:2:{s:7:"subject";a:26:{s:2:"id";s:7:"subject";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"subject";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"subject";s:9:"plugin_id";s:5:"field";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:0;s:8:"ellipsis";b:0;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:6:"string";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}}s:7:"changed";a:26:{s:2:"id";s:7:"changed";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:5:"field";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:13:"timestamp_ago";s:8:"settings";a:3:{s:13:"future_format";s:15:"@interval hence";s:11:"past_format";s:13:"@interval ago";s:11:"granularity";i:2;}}}s:5:"pager";a:2:{s:4:"type";s:4:"some";s:7:"options";a:2:{s:6:"offset";i:0;s:14:"items_per_page";i:10;}}s:12:"exposed_form";a:1:{s:4:"type";s:5:"basic";}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:15:"access comments";}}s:5:"cache";a:1:{s:4:"type";s:3:"tag";}s:5:"empty";a:1:{s:16:"area_text_custom";a:11:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:11:"text_custom";s:5:"label";s:0:"";s:5:"empty";b:1;s:7:"content";s:22:"No comments available.";s:8:"tokenize";b:0;}}s:5:"sorts";a:2:{s:7:"created";a:12:{s:2:"id";s:7:"created";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"created";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"created";s:9:"plugin_id";s:4:"date";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:7:"created";}s:7:"exposed";b:0;}s:3:"cid";a:12:{s:2:"id";s:3:"cid";s:5:"table";s:18:"comment_field_data";s:5:"field";s:3:"cid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:3:"cid";s:9:"plugin_id";s:5:"field";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:3:"cid";}s:7:"exposed";b:0;}}s:7:"filters";a:2:{s:6:"status";a:9:{s:2:"id";s:6:"status";s:5:"table";s:18:"comment_field_data";s:5:"field";s:6:"status";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:5:"value";s:1:"1";s:5:"group";i:1;s:6:"expose";a:3:{s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}}s:11:"status_node";a:10:{s:2:"id";s:11:"status_node";s:5:"table";s:15:"node_field_data";s:5:"field";s:6:"status";s:12:"relationship";s:4:"node";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:5:"value";s:1:"1";s:5:"group";i:1;s:6:"expose";a:3:{s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}}}s:5:"style";a:2:{s:4:"type";s:9:"html_list";s:7:"options";a:6:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:4:"type";s:2:"ul";s:13:"wrapper_class";s:9:"item-list";s:5:"class";s:0:"";}}s:3:"row";a:2:{s:4:"type";s:6:"fields";s:7:"options";a:2:{s:22:"default_field_elements";b:1;s:10:"hide_empty";b:0;}}s:5:"query";a:1:{s:4:"type";s:11:"views_query";}s:13:"relationships";a:1:{s:4:"node";a:5:{s:2:"id";s:4:"node";s:5:"table";s:18:"comment_field_data";s:5:"field";s:4:"node";s:9:"plugin_id";s:8:"standard";s:8:"required";b:1;}}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:3:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:7:"block_1";a:6:{s:2:"id";s:7:"block_1";s:13:"display_title";s:5:"Block";s:14:"display_plugin";s:5:"block";s:8:"position";i:1;s:15:"display_options";a:4:{s:17:"display_extenders";a:0:{}s:17:"block_description";s:15:"Recent comments";s:14:"block_category";s:13:"Lists (Views)";s:5:"allow";a:1:{s:14:"items_per_page";b:1;}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:3:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'views.view.content',
  'data' => 'a:13:{s:4:"uuid";s:36:"854b9cc0-5812-4641-9264-2a5477b753e0";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:4:"node";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"vBKWYGGDoAX-tFd1JErB8tZLSxx3lJ0foouVsgpcbB4";}s:2:"id";s:7:"content";s:5:"label";s:7:"Content";s:6:"module";s:4:"node";s:11:"description";s:24:"Find and manage content.";s:3:"tag";s:7:"default";s:10:"base_table";s:15:"node_field_data";s:10:"base_field";s:3:"nid";s:7:"display";a:2:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:17:{s:5:"title";s:7:"Content";s:6:"fields";a:7:{s:14:"node_bulk_form";a:14:{s:2:"id";s:14:"node_bulk_form";s:5:"table";s:4:"node";s:5:"field";s:14:"node_bulk_form";s:11:"entity_type";s:4:"node";s:9:"plugin_id";s:14:"node_bulk_form";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:1:{s:10:"alter_text";b:0;}s:13:"element_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;}s:5:"title";a:17:{s:2:"id";s:5:"title";s:5:"table";s:15:"node_field_data";s:5:"field";s:5:"title";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:5:"title";s:9:"plugin_id";s:5:"field";s:5:"label";s:5:"Title";s:7:"exclude";b:0;s:5:"alter";a:1:{s:10:"alter_text";b:0;}s:13:"element_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:6:"string";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}}s:4:"type";a:37:{s:2:"id";s:4:"type";s:5:"table";s:15:"node_field_data";s:5:"field";s:4:"type";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:4:"type";s:9:"plugin_id";s:5:"field";s:5:"label";s:12:"Content type";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:9:"target_id";s:4:"type";s:22:"entity_reference_label";s:8:"settings";a:1:{s:4:"link";b:0;}s:12:"group_column";s:9:"target_id";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:4:"name";a:17:{s:2:"id";s:4:"name";s:5:"table";s:16:"users_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:3:"uid";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:5:"field";s:5:"label";s:6:"Author";s:7:"exclude";b:0;s:5:"alter";a:1:{s:10:"alter_text";b:0;}s:13:"element_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:9:"user_name";}s:6:"status";a:17:{s:2:"id";s:6:"status";s:5:"table";s:15:"node_field_data";s:5:"field";s:6:"status";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:5:"field";s:5:"label";s:6:"Status";s:7:"exclude";b:0;s:5:"alter";a:1:{s:10:"alter_text";b:0;}s:13:"element_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:7:"boolean";s:8:"settings";a:3:{s:6:"format";s:6:"custom";s:19:"format_custom_false";s:11:"Unpublished";s:18:"format_custom_true";s:9:"Published";}}s:7:"changed";a:17:{s:2:"id";s:7:"changed";s:5:"table";s:15:"node_field_data";s:5:"field";s:7:"changed";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:5:"field";s:5:"label";s:7:"Updated";s:7:"exclude";b:0;s:5:"alter";a:1:{s:10:"alter_text";b:0;}s:13:"element_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:9:"timestamp";s:8:"settings";a:3:{s:11:"date_format";s:5:"short";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";}}s:10:"operations";a:23:{s:2:"id";s:10:"operations";s:5:"table";s:4:"node";s:5:"field";s:10:"operations";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:17:"entity_operations";s:5:"label";s:10:"Operations";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:11:"destination";b:1;}}s:5:"pager";a:2:{s:4:"type";s:4:"full";s:7:"options";a:2:{s:14:"items_per_page";i:50;s:4:"tags";a:4:{s:4:"next";s:8:"Next ›";s:8:"previous";s:12:"‹ Previous";s:5:"first";s:8:"« First";s:4:"last";s:7:"Last »";}}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:6:"Filter";s:12:"reset_button";b:1;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:23:"access content overview";}}s:5:"cache";a:1:{s:4:"type";s:3:"tag";}s:5:"empty";a:1:{s:16:"area_text_custom";a:6:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:9:"plugin_id";s:11:"text_custom";s:5:"empty";b:1;s:7:"content";s:21:"No content available.";}}s:5:"sorts";a:0:{}s:9:"arguments";a:0:{}s:7:"filters";a:5:{s:5:"title";a:16:{s:2:"id";s:5:"title";s:5:"table";s:15:"node_field_data";s:5:"field";s:5:"title";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:5:"title";s:9:"plugin_id";s:6:"string";s:8:"operator";s:8:"contains";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:8:"title_op";s:5:"label";s:5:"Title";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:8:"title_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:5:"title";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:4:"type";a:16:{s:2:"id";s:4:"type";s:5:"table";s:15:"node_field_data";s:5:"field";s:4:"type";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:4:"type";s:9:"plugin_id";s:6:"bundle";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:7:"type_op";s:5:"label";s:12:"Content type";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:7:"type_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:4:"type";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:6:"status";a:16:{s:2:"id";s:6:"status";s:5:"table";s:15:"node_field_data";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:6:"Status";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:9:"status_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:6:"status";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:1;s:10:"group_info";a:10:{s:5:"label";s:16:"Published status";s:11:"description";s:0:"";s:10:"identifier";s:6:"status";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:2:{i:1;a:3:{s:5:"title";s:9:"Published";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";}i:2;a:3:{s:5:"title";s:11:"Unpublished";s:8:"operator";s:1:"=";s:5:"value";s:1:"0";}}}}s:8:"langcode";a:16:{s:2:"id";s:8:"langcode";s:5:"table";s:15:"node_field_data";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:8:"langcode";s:9:"plugin_id";s:8:"language";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:11:"langcode_op";s:5:"label";s:8:"Language";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:11:"langcode_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:8:"langcode";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:12:"status_extra";a:9:{s:2:"id";s:12:"status_extra";s:5:"table";s:15:"node_field_data";s:5:"field";s:12:"status_extra";s:11:"entity_type";s:4:"node";s:9:"plugin_id";s:11:"node_status";s:8:"operator";s:1:"=";s:5:"value";b:0;s:5:"group";i:1;s:6:"expose";a:2:{s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}}}s:13:"filter_groups";a:2:{s:8:"operator";s:3:"AND";s:6:"groups";a:1:{i:1;s:3:"AND";}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:12:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:7:"columns";a:10:{s:14:"node_bulk_form";s:14:"node_bulk_form";s:5:"title";s:5:"title";s:4:"type";s:4:"type";s:4:"name";s:4:"name";s:6:"status";s:6:"status";s:7:"changed";s:7:"changed";s:9:"edit_node";s:9:"edit_node";s:11:"delete_node";s:11:"delete_node";s:10:"dropbutton";s:10:"dropbutton";s:9:"timestamp";s:5:"title";}s:7:"default";s:7:"changed";s:4:"info";a:10:{s:14:"node_bulk_form";a:4:{s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:5:"title";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:4:"type";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:4:"name";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:6:"status";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:7:"changed";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:9:"edit_node";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:11:"delete_node";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:10:"dropbutton";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:9:"timestamp";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}}s:8:"override";b:1;s:6:"sticky";b:1;s:7:"summary";s:0:"";s:11:"empty_table";b:1;s:7:"caption";s:0:"";s:11:"description";s:0:"";}}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:5:"query";a:1:{s:4:"type";s:11:"views_query";}s:13:"relationships";a:1:{s:3:"uid";a:6:{s:2:"id";s:3:"uid";s:5:"table";s:15:"node_field_data";s:5:"field";s:3:"uid";s:11:"admin_label";s:6:"author";s:9:"plugin_id";s:8:"standard";s:8:"required";b:1;}}s:16:"show_admin_links";b:0;s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:0;s:8:"contexts";a:7:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:4:"user";i:5;s:21:"user.node_grants:view";i:6;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"page_1";a:6:{s:2:"id";s:6:"page_1";s:13:"display_title";s:4:"Page";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:4:{s:17:"display_extenders";a:0:{}s:4:"path";s:18:"admin/content/node";s:4:"menu";a:6:{s:4:"type";s:11:"default tab";s:5:"title";s:7:"Content";s:11:"description";s:0:"";s:6:"weight";i:-10;s:9:"menu_name";s:5:"admin";s:7:"context";s:0:"";}s:11:"tab_options";a:5:{s:4:"type";s:6:"normal";s:5:"title";s:7:"Content";s:11:"description";s:23:"Find and manage content";s:6:"weight";i:-10;s:9:"menu_name";s:5:"admin";}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:0;s:8:"contexts";a:7:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:4:"user";i:5;s:21:"user.node_grants:view";i:6;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'views.view.content_recent',
  'data' => 'a:13:{s:4:"uuid";s:36:"967b6c2c-aaab-4f4e-ae95-7888fcf58266";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:4:"node";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"YqZN5rc7XDQcFcInc8wkzuaHJmC5YvirhTmDcrarT6M";}s:2:"id";s:14:"content_recent";s:5:"label";s:14:"Recent content";s:6:"module";s:4:"node";s:11:"description";s:15:"Recent content.";s:3:"tag";s:7:"default";s:10:"base_table";s:15:"node_field_data";s:10:"base_field";s:3:"nid";s:7:"display";a:2:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:22:{s:5:"title";s:14:"Recent content";s:6:"fields";a:2:{s:5:"title";a:26:{s:2:"id";s:5:"title";s:5:"table";s:15:"node_field_data";s:5:"field";s:5:"title";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:5:"title";s:9:"plugin_id";s:5:"field";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:8:{s:10:"alter_text";b:0;s:9:"make_link";b:0;s:8:"absolute";b:0;s:13:"word_boundary";b:0;s:8:"ellipsis";b:0;s:10:"strip_tags";b:0;s:4:"trim";b:0;s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:6:"string";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}}s:7:"changed";a:37:{s:2:"id";s:7:"changed";s:5:"table";s:15:"node_field_data";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:5:"field";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:13:"timestamp_ago";s:8:"settings";a:0:{}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}}s:5:"pager";a:2:{s:4:"type";s:4:"some";s:7:"options";a:2:{s:6:"offset";i:0;s:14:"items_per_page";i:10;}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:5:"Apply";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:14:"access content";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"empty";a:1:{s:16:"area_text_custom";a:10:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:11:"text_custom";s:5:"empty";b:1;s:7:"content";s:21:"No content available.";s:8:"tokenize";b:0;}}s:5:"sorts";a:1:{s:7:"changed";a:13:{s:2:"id";s:7:"changed";s:5:"table";s:15:"node_field_data";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:4:"date";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:7:"changed";}s:7:"exposed";b:0;s:11:"granularity";s:6:"second";}}s:9:"arguments";a:0:{}s:7:"filters";a:2:{s:12:"status_extra";a:15:{s:2:"id";s:12:"status_extra";s:5:"table";s:15:"node_field_data";s:5:"field";s:12:"status_extra";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:9:"plugin_id";s:11:"node_status";s:8:"operator";s:1:"=";s:5:"value";b:0;s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:8:"langcode";a:16:{s:2:"id";s:8:"langcode";s:5:"table";s:15:"node_field_data";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:8:"langcode";s:9:"plugin_id";s:8:"language";s:8:"operator";s:2:"in";s:5:"value";a:1:{s:31:"***LANGUAGE_language_content***";s:31:"***LANGUAGE_language_content***";}s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:13:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:5:"style";a:2:{s:4:"type";s:9:"html_list";s:7:"options";a:6:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:4:"type";s:2:"ul";s:13:"wrapper_class";s:9:"item-list";s:5:"class";s:0:"";}}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:1:{s:3:"uid";a:10:{s:2:"id";s:3:"uid";s:5:"table";s:15:"node_field_data";s:5:"field";s:3:"uid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:6:"author";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:3:"uid";s:9:"plugin_id";s:8:"standard";s:8:"required";b:1;}}s:8:"use_more";b:0;s:15:"use_more_always";b:0;s:13:"use_more_text";s:4:"More";s:12:"link_display";s:1:"0";s:8:"link_url";s:0:"";s:6:"header";a:0:{}s:6:"footer";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:4:"user";i:3;s:21:"user.node_grants:view";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:7:"block_1";a:6:{s:2:"id";s:7:"block_1";s:13:"display_title";s:5:"Block";s:14:"display_plugin";s:5:"block";s:8:"position";i:1;s:15:"display_options";a:1:{s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:4:"user";i:3;s:21:"user.node_grants:view";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'views.view.files',
  'data' => 'a:13:{s:4:"uuid";s:36:"4f8d7912-8acb-4ef7-9c76-ff228942601e";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:4:"file";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"DaGeEDJMcbbQtgV96AuPeZ-0irMc_Oa6Zzh2U3Kmul8";}s:2:"id";s:5:"files";s:5:"label";s:5:"Files";s:6:"module";s:4:"file";s:11:"description";s:22:"Find and manage files.";s:3:"tag";s:7:"default";s:10:"base_table";s:12:"file_managed";s:10:"base_field";s:3:"fid";s:7:"display";a:3:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:19:{s:5:"title";s:5:"Files";s:6:"fields";a:8:{s:3:"fid";a:24:{s:2:"id";s:3:"fid";s:5:"table";s:12:"file_managed";s:5:"field";s:3:"fid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:3:"fid";s:9:"plugin_id";s:5:"field";s:5:"label";s:3:"Fid";s:7:"exclude";b:1;s:5:"alter";a:8:{s:10:"alter_text";b:0;s:9:"make_link";b:0;s:8:"absolute";b:0;s:13:"word_boundary";b:0;s:8:"ellipsis";b:0;s:10:"strip_tags";b:0;s:4:"trim";b:0;s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;}s:8:"filename";a:36:{s:2:"id";s:8:"filename";s:5:"table";s:12:"file_managed";s:5:"field";s:8:"filename";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:8:"filename";s:9:"plugin_id";s:5:"field";s:5:"label";s:4:"Name";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:0;s:8:"ellipsis";b:0;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:9:"file_link";s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:8:"filemime";a:25:{s:2:"id";s:8:"filemime";s:5:"table";s:12:"file_managed";s:5:"field";s:8:"filemime";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:8:"filemime";s:9:"plugin_id";s:5:"field";s:5:"label";s:9:"MIME type";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:13:"file_filemime";}s:8:"filesize";a:25:{s:2:"id";s:8:"filesize";s:5:"table";s:12:"file_managed";s:5:"field";s:8:"filesize";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:8:"filesize";s:9:"plugin_id";s:5:"field";s:5:"label";s:4:"Size";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:9:"file_size";}s:6:"status";a:26:{s:2:"id";s:6:"status";s:5:"table";s:12:"file_managed";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:5:"field";s:5:"label";s:6:"Status";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:7:"boolean";s:8:"settings";a:3:{s:6:"format";s:6:"custom";s:19:"format_custom_false";s:9:"Temporary";s:18:"format_custom_true";s:9:"Permanent";}}s:7:"created";a:26:{s:2:"id";s:7:"created";s:5:"table";s:12:"file_managed";s:5:"field";s:7:"created";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:7:"created";s:9:"plugin_id";s:5:"field";s:5:"label";s:11:"Upload date";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:9:"timestamp";s:8:"settings";a:3:{s:11:"date_format";s:6:"medium";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";}}s:7:"changed";a:26:{s:2:"id";s:7:"changed";s:5:"table";s:12:"file_managed";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:5:"field";s:5:"label";s:12:"Changed date";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:9:"timestamp";s:8:"settings";a:3:{s:11:"date_format";s:6:"medium";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";}}s:5:"count";a:30:{s:2:"id";s:5:"count";s:5:"table";s:10:"file_usage";s:5:"field";s:5:"count";s:12:"relationship";s:3:"fid";s:10:"group_type";s:3:"sum";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:7:"numeric";s:5:"label";s:7:"Used in";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:1;s:4:"path";s:35:"admin/content/files/usage/{{ fid }}";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:13:"set_precision";b:0;s:9:"precision";i:0;s:7:"decimal";s:1:".";s:9:"separator";s:1:",";s:13:"format_plural";b:1;s:20:"format_plural_string";s:21:"1 place@count places";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:5:"pager";a:2:{s:4:"type";s:4:"mini";s:7:"options";a:6:{s:6:"offset";i:0;s:14:"items_per_page";i:50;s:11:"total_pages";i:0;s:2:"id";i:0;s:4:"tags";a:2:{s:4:"next";s:8:"Next ›";s:8:"previous";s:12:"‹ Previous";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:6:"Filter";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:21:"access files overview";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"empty";a:1:{s:16:"area_text_custom";a:6:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:9:"plugin_id";s:11:"text_custom";s:5:"empty";b:1;s:7:"content";s:19:"No files available.";}}s:5:"sorts";a:0:{}s:9:"arguments";a:0:{}s:7:"filters";a:3:{s:8:"filename";a:16:{s:2:"id";s:8:"filename";s:5:"table";s:12:"file_managed";s:5:"field";s:8:"filename";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:8:"filename";s:9:"plugin_id";s:6:"string";s:8:"operator";s:4:"word";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:11:"filemime_op";s:5:"label";s:8:"Filename";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:11:"filename_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:8:"filename";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:8:"filemime";a:16:{s:2:"id";s:8:"filemime";s:5:"table";s:12:"file_managed";s:5:"field";s:8:"filemime";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:8:"filemime";s:9:"plugin_id";s:6:"string";s:8:"operator";s:4:"word";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:11:"filemime_op";s:5:"label";s:9:"MIME type";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:11:"filemime_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:8:"filemime";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:6:"status";a:16:{s:2:"id";s:6:"status";s:5:"table";s:12:"file_managed";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:11:"file_status";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:9:"status_op";s:5:"label";s:6:"Status";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:9:"status_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:6:"status";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:12:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:7:"columns";a:8:{s:3:"fid";s:3:"fid";s:8:"filename";s:8:"filename";s:8:"filemime";s:8:"filemime";s:8:"filesize";s:8:"filesize";s:6:"status";s:6:"status";s:7:"created";s:7:"created";s:7:"changed";s:7:"changed";s:5:"count";s:5:"count";}s:7:"default";s:7:"changed";s:4:"info";a:8:{s:3:"fid";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:8:"filename";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:8:"filemime";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:15:"priority-medium";}s:8:"filesize";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:6:"status";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:7:"created";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:7:"changed";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:5:"count";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:15:"priority-medium";}}s:8:"override";b:1;s:6:"sticky";b:0;s:7:"summary";s:0:"";s:11:"empty_table";b:1;s:7:"caption";s:0:"";s:11:"description";s:0:"";}}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:1:{s:3:"fid";a:7:{s:2:"id";s:3:"fid";s:5:"table";s:12:"file_managed";s:5:"field";s:3:"fid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:10:"File usage";s:8:"required";b:1;}}s:8:"group_by";b:1;s:16:"show_admin_links";b:1;s:6:"header";a:0:{}s:6:"footer";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"page_1";a:6:{s:2:"id";s:6:"page_1";s:13:"display_title";s:14:"Files overview";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:6:{s:8:"defaults";a:2:{s:5:"pager";b:1;s:13:"relationships";b:0;}s:13:"relationships";a:1:{s:3:"fid";a:7:{s:2:"id";s:3:"fid";s:5:"table";s:12:"file_managed";s:5:"field";s:3:"fid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:10:"File usage";s:8:"required";b:0;}}s:19:"display_description";s:0:"";s:17:"display_extenders";a:0:{}s:4:"path";s:19:"admin/content/files";s:4:"menu";a:6:{s:4:"type";s:3:"tab";s:5:"title";s:5:"Files";s:11:"description";s:0:"";s:6:"weight";i:0;s:9:"menu_name";s:5:"admin";s:7:"context";s:0:"";}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"page_2";a:6:{s:2:"id";s:6:"page_2";s:13:"display_title";s:10:"File usage";s:14:"display_plugin";s:4:"page";s:8:"position";i:2;s:15:"display_options";a:15:{s:5:"title";s:10:"File usage";s:6:"fields";a:4:{s:12:"entity_label";a:23:{s:2:"id";s:12:"entity_label";s:5:"table";s:10:"file_usage";s:5:"field";s:12:"entity_label";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:12:"entity_label";s:5:"label";s:6:"Entity";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:14:"link_to_entity";b:1;}s:4:"type";a:22:{s:2:"id";s:4:"type";s:5:"table";s:10:"file_usage";s:5:"field";s:4:"type";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:8:"standard";s:5:"label";s:11:"Entity type";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;}s:6:"module";a:22:{s:2:"id";s:6:"module";s:5:"table";s:10:"file_usage";s:5:"field";s:6:"module";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:8:"standard";s:5:"label";s:18:"Registering module";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;}s:5:"count";a:30:{s:2:"id";s:5:"count";s:5:"table";s:10:"file_usage";s:5:"field";s:5:"count";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:7:"numeric";s:5:"label";s:9:"Use count";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:13:"set_precision";b:0;s:9:"precision";i:0;s:7:"decimal";s:1:".";s:9:"separator";s:1:",";s:13:"format_plural";b:0;s:20:"format_plural_string";s:8:"1@count";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:5:"pager";a:2:{s:4:"type";s:4:"mini";s:7:"options";a:6:{s:6:"offset";i:0;s:14:"items_per_page";i:10;s:11:"total_pages";i:0;s:2:"id";i:0;s:4:"tags";a:2:{s:4:"next";s:8:"Next ›";s:8:"previous";s:12:"‹ Previous";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}}}s:5:"empty";a:0:{}s:9:"arguments";a:1:{s:3:"fid";a:23:{s:2:"id";s:3:"fid";s:5:"table";s:12:"file_managed";s:5:"field";s:3:"fid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:3:"fid";s:9:"plugin_id";s:8:"file_fid";s:14:"default_action";s:9:"not found";s:9:"exception";a:3:{s:5:"value";s:3:"all";s:12:"title_enable";b:0;s:5:"title";s:3:"All";}s:12:"title_enable";b:1;s:5:"title";s:46:"File usage information for {{ arguments.fid }}";s:21:"default_argument_type";s:5:"fixed";s:24:"default_argument_options";a:1:{s:8:"argument";s:0:"";}s:25:"default_argument_skip_url";b:0;s:15:"summary_options";a:4:{s:9:"base_path";s:0:"";s:5:"count";b:1;s:8:"override";b:0;s:14:"items_per_page";i:25;}s:7:"summary";a:3:{s:10:"sort_order";s:3:"asc";s:17:"number_of_records";i:0;s:6:"format";s:15:"default_summary";}s:18:"specify_validation";b:0;s:8:"validate";a:2:{s:4:"type";s:4:"none";s:4:"fail";s:9:"not found";}s:16:"validate_options";a:0:{}s:12:"break_phrase";b:0;s:3:"not";b:0;}}s:7:"filters";a:0:{}s:13:"filter_groups";a:2:{s:8:"operator";s:3:"AND";s:6:"groups";a:0:{}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:12:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:7:"columns";a:4:{s:12:"entity_label";s:12:"entity_label";s:4:"type";s:4:"type";s:6:"module";s:6:"module";s:5:"count";s:5:"count";}s:7:"default";s:12:"entity_label";s:4:"info";a:4:{s:12:"entity_label";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:4:"type";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:15:"priority-medium";}s:6:"module";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:5:"count";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}}s:8:"override";b:1;s:6:"sticky";b:0;s:7:"summary";s:0:"";s:11:"empty_table";b:1;s:7:"caption";s:0:"";s:11:"description";s:0:"";}}s:3:"row";a:2:{s:4:"type";s:6:"fields";s:7:"options";a:0:{}}s:8:"defaults";a:11:{s:5:"empty";b:0;s:5:"title";b:0;s:5:"pager";b:0;s:8:"group_by";b:0;s:5:"style";b:0;s:3:"row";b:0;s:13:"relationships";b:0;s:6:"fields";b:0;s:9:"arguments";b:0;s:7:"filters";b:0;s:13:"filter_groups";b:0;}s:13:"relationships";a:1:{s:3:"fid";a:7:{s:2:"id";s:3:"fid";s:5:"table";s:12:"file_managed";s:5:"field";s:3:"fid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:10:"File usage";s:8:"required";b:1;}}s:8:"group_by";b:0;s:19:"display_description";s:0:"";s:17:"display_extenders";a:0:{}s:4:"path";s:27:"admin/content/files/usage/%";}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:4:{i:0;s:28:"languages:language_interface";i:1;s:3:"url";i:2;s:14:"url.query_args";i:3;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'views.view.frontpage',
  'data' => 'a:13:{s:4:"uuid";s:36:"639eb23e-4b75-4bec-9e05-aef9eb033c81";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:30:"core.entity_view_mode.node.rss";i:1;s:33:"core.entity_view_mode.node.teaser";}s:6:"module";a:2:{i:0;s:4:"node";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"6eeliKIydPjqyv5V__QqTfahvJMWkHjOVUUuUIdB1ik";}s:2:"id";s:9:"frontpage";s:5:"label";s:9:"Frontpage";s:6:"module";s:4:"node";s:11:"description";s:39:"All content promoted to the front page.";s:3:"tag";s:7:"default";s:10:"base_table";s:15:"node_field_data";s:10:"base_field";s:3:"nid";s:7:"display";a:3:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:17:{s:5:"title";s:0:"";s:6:"fields";a:0:{}s:5:"pager";a:2:{s:4:"type";s:4:"full";s:7:"options";a:7:{s:6:"offset";i:0;s:14:"items_per_page";i:10;s:11:"total_pages";i:0;s:2:"id";i:0;s:4:"tags";a:4:{s:4:"next";s:8:"Next ›";s:8:"previous";s:12:"‹ Previous";s:5:"first";s:8:"« First";s:4:"last";s:7:"Last »";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}s:8:"quantity";i:9;}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:5:"Apply";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:14:"access content";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"empty";a:3:{s:16:"area_text_custom";a:11:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:11:"text_custom";s:5:"label";s:0:"";s:5:"empty";b:1;s:7:"content";s:181:"No front page content has been created yet.<br/>Follow the <a target="_blank" href="https://www.drupal.org/docs/user_guide/en/index.html">User Guide</a> to start building your site.";s:8:"tokenize";b:0;}s:18:"node_listing_empty";a:10:{s:2:"id";s:18:"node_listing_empty";s:5:"table";s:4:"node";s:5:"field";s:18:"node_listing_empty";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:9:"plugin_id";s:18:"node_listing_empty";s:5:"label";s:0:"";s:5:"empty";b:1;}s:5:"title";a:10:{s:2:"id";s:5:"title";s:5:"table";s:5:"views";s:5:"field";s:5:"title";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:5:"title";s:5:"label";s:0:"";s:5:"empty";b:1;s:5:"title";s:8:"Welcome!";}}s:5:"sorts";a:2:{s:6:"sticky";a:12:{s:2:"id";s:6:"sticky";s:5:"table";s:15:"node_field_data";s:5:"field";s:6:"sticky";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:6:"sticky";s:9:"plugin_id";s:7:"boolean";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:6:"sticky";}s:7:"exposed";b:0;}s:7:"created";a:13:{s:2:"id";s:7:"created";s:5:"table";s:15:"node_field_data";s:5:"field";s:7:"created";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:7:"created";s:9:"plugin_id";s:4:"date";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:7:"created";}s:7:"exposed";b:0;s:11:"granularity";s:6:"second";}}s:9:"arguments";a:0:{}s:7:"filters";a:3:{s:7:"promote";a:16:{s:2:"id";s:7:"promote";s:5:"table";s:15:"node_field_data";s:5:"field";s:7:"promote";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:7:"promote";s:9:"plugin_id";s:7:"boolean";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:6:"status";a:9:{s:2:"id";s:6:"status";s:5:"table";s:15:"node_field_data";s:5:"field";s:6:"status";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:5:"value";s:1:"1";s:5:"group";i:1;s:6:"expose";a:3:{s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}}s:8:"langcode";a:16:{s:2:"id";s:8:"langcode";s:5:"table";s:15:"node_field_data";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:8:"langcode";s:9:"plugin_id";s:8:"language";s:8:"operator";s:2:"in";s:5:"value";a:1:{s:31:"***LANGUAGE_language_content***";s:31:"***LANGUAGE_language_content***";}s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:13:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:5:"style";a:2:{s:4:"type";s:7:"default";s:7:"options";a:4:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:11:"uses_fields";b:0;}}s:3:"row";a:2:{s:4:"type";s:11:"entity:node";s:7:"options";a:1:{s:9:"view_mode";s:6:"teaser";}}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:0:{}s:6:"header";a:0:{}s:6:"footer";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:4:{i:0;s:28:"languages:language_interface";i:1;s:14:"url.query_args";i:2;s:21:"user.node_grants:view";i:3;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"feed_1";a:6:{s:2:"id";s:6:"feed_1";s:13:"display_title";s:4:"Feed";s:14:"display_plugin";s:4:"feed";s:8:"position";i:2;s:15:"display_options";a:7:{s:5:"pager";a:2:{s:4:"type";s:4:"some";s:7:"options";a:2:{s:6:"offset";i:0;s:14:"items_per_page";i:10;}}s:5:"style";a:2:{s:4:"type";s:3:"rss";s:7:"options";a:3:{s:8:"grouping";a:0:{}s:11:"uses_fields";b:0;s:11:"description";s:0:"";}}s:3:"row";a:2:{s:4:"type";s:8:"node_rss";s:7:"options";a:2:{s:12:"relationship";s:4:"none";s:9:"view_mode";s:3:"rss";}}s:17:"display_extenders";a:0:{}s:4:"path";s:7:"rss.xml";s:14:"sitename_title";b:1;s:8:"displays";a:2:{s:6:"page_1";s:6:"page_1";s:7:"default";s:0:"";}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:3:{i:0;s:28:"languages:language_interface";i:1;s:21:"user.node_grants:view";i:2;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"page_1";a:6:{s:2:"id";s:6:"page_1";s:13:"display_title";s:4:"Page";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:2:{s:17:"display_extenders";a:0:{}s:4:"path";s:4:"node";}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:4:{i:0;s:28:"languages:language_interface";i:1;s:14:"url.query_args";i:2;s:21:"user.node_grants:view";i:3;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'views.view.glossary',
  'data' => 'a:13:{s:4:"uuid";s:36:"8a79aa2c-15b9-4124-9735-542afd321165";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:16:"system.menu.main";}s:6:"module";a:2:{i:0;s:4:"node";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"sz_FoMz5aClG4jFy4UDlkenXQtgTUXohEDjWVBuHaro";}s:2:"id";s:8:"glossary";s:5:"label";s:8:"Glossary";s:6:"module";s:4:"node";s:11:"description";s:23:"All content, by letter.";s:3:"tag";s:7:"default";s:10:"base_table";s:15:"node_field_data";s:10:"base_field";s:3:"nid";s:7:"display";a:3:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:17:{s:6:"fields";a:3:{s:5:"title";a:24:{s:2:"id";s:5:"title";s:5:"table";s:15:"node_field_data";s:5:"field";s:5:"title";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:5:"title";s:9:"plugin_id";s:5:"field";s:5:"label";s:5:"Title";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;}s:4:"name";a:25:{s:2:"id";s:4:"name";s:5:"table";s:16:"users_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:3:"uid";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:5:"field";s:5:"label";s:6:"Author";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:9:"user_name";}s:7:"changed";a:26:{s:2:"id";s:7:"changed";s:5:"table";s:15:"node_field_data";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:5:"field";s:5:"label";s:11:"Last update";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:9:"timestamp";s:8:"settings";a:3:{s:11:"date_format";s:4:"long";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";}}}s:5:"pager";a:2:{s:4:"type";s:4:"mini";s:7:"options";a:6:{s:6:"offset";i:0;s:14:"items_per_page";i:36;s:11:"total_pages";i:0;s:2:"id";i:0;s:4:"tags";a:2:{s:4:"next";s:6:"››";s:8:"previous";s:6:"‹‹";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:5:"Apply";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:14:"access content";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"empty";a:0:{}s:5:"sorts";a:0:{}s:9:"arguments";a:1:{s:5:"title";a:27:{s:2:"id";s:5:"title";s:5:"table";s:15:"node_field_data";s:5:"field";s:5:"title";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:5:"title";s:9:"plugin_id";s:6:"string";s:14:"default_action";s:7:"default";s:9:"exception";a:1:{s:12:"title_enable";b:1;}s:12:"title_enable";b:0;s:5:"title";s:0:"";s:21:"default_argument_type";s:5:"fixed";s:24:"default_argument_options";a:1:{s:8:"argument";s:1:"a";}s:25:"default_argument_skip_url";b:0;s:15:"summary_options";a:0:{}s:7:"summary";a:1:{s:6:"format";s:15:"default_summary";}s:18:"specify_validation";b:1;s:8:"validate";a:2:{s:4:"type";s:4:"none";s:4:"fail";s:9:"not found";}s:16:"validate_options";a:0:{}s:8:"glossary";b:1;s:5:"limit";i:1;s:4:"case";s:5:"upper";s:9:"path_case";s:5:"lower";s:14:"transform_dash";b:0;s:12:"break_phrase";b:0;}}s:7:"filters";a:2:{s:6:"status";a:9:{s:2:"id";s:6:"status";s:5:"table";s:15:"node_field_data";s:5:"field";s:6:"status";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:5:"value";s:1:"1";s:5:"group";i:1;s:6:"expose";a:3:{s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}}s:8:"langcode";a:16:{s:2:"id";s:8:"langcode";s:5:"table";s:15:"node_field_data";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:8:"langcode";s:9:"plugin_id";s:8:"language";s:8:"operator";s:2:"in";s:5:"value";a:1:{s:31:"***LANGUAGE_language_content***";s:31:"***LANGUAGE_language_content***";}s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:13:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:12:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:11:"uses_fields";b:0;s:7:"columns";a:3:{s:5:"title";s:5:"title";s:4:"name";s:4:"name";s:7:"changed";s:7:"changed";}s:7:"default";s:5:"title";s:4:"info";a:3:{s:5:"title";a:2:{s:8:"sortable";b:1;s:9:"separator";s:0:"";}s:4:"name";a:2:{s:8:"sortable";b:1;s:9:"separator";s:0:"";}s:7:"changed";a:2:{s:8:"sortable";b:1;s:9:"separator";s:0:"";}}s:8:"override";b:1;s:6:"sticky";b:0;s:7:"summary";s:0:"";s:5:"order";s:3:"asc";s:11:"empty_table";b:0;}}s:3:"row";a:2:{s:4:"type";s:6:"fields";s:7:"options";a:4:{s:22:"default_field_elements";b:1;s:6:"inline";a:0:{}s:9:"separator";s:0:"";s:10:"hide_empty";b:0;}}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:1:{s:3:"uid";a:8:{s:2:"id";s:3:"uid";s:5:"table";s:15:"node_field_data";s:5:"field";s:3:"uid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:6:"author";s:9:"plugin_id";s:8:"standard";s:8:"required";b:0;}}s:8:"use_ajax";b:1;s:6:"header";a:0:{}s:6:"footer";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:6:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:21:"user.node_grants:view";i:5;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:12:"attachment_1";a:6:{s:2:"id";s:12:"attachment_1";s:13:"display_title";s:10:"Attachment";s:14:"display_plugin";s:10:"attachment";s:8:"position";i:2;s:15:"display_options";a:7:{s:5:"pager";a:2:{s:4:"type";s:4:"none";s:7:"options";a:2:{s:6:"offset";i:0;s:14:"items_per_page";i:0;}}s:9:"arguments";a:1:{s:5:"title";a:27:{s:2:"id";s:5:"title";s:5:"table";s:15:"node_field_data";s:5:"field";s:5:"title";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:5:"title";s:9:"plugin_id";s:6:"string";s:14:"default_action";s:7:"summary";s:9:"exception";a:1:{s:12:"title_enable";b:1;}s:12:"title_enable";b:0;s:5:"title";s:0:"";s:21:"default_argument_type";s:5:"fixed";s:24:"default_argument_options";a:1:{s:8:"argument";s:1:"a";}s:25:"default_argument_skip_url";b:0;s:15:"summary_options";a:3:{s:14:"items_per_page";i:25;s:6:"inline";b:1;s:9:"separator";s:3:" | ";}s:7:"summary";a:1:{s:6:"format";s:19:"unformatted_summary";}s:18:"specify_validation";b:1;s:8:"validate";a:2:{s:4:"type";s:4:"none";s:4:"fail";s:9:"not found";}s:16:"validate_options";a:0:{}s:8:"glossary";b:1;s:5:"limit";i:1;s:4:"case";s:5:"upper";s:9:"path_case";s:5:"lower";s:14:"transform_dash";b:0;s:12:"break_phrase";b:0;}}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:0:{}}s:8:"defaults";a:1:{s:9:"arguments";b:0;}s:17:"display_extenders";a:0:{}s:8:"displays";a:2:{s:7:"default";s:7:"default";s:6:"page_1";s:6:"page_1";}s:17:"inherit_arguments";b:0;}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:6:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:21:"user.node_grants:view";i:5;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"page_1";a:6:{s:2:"id";s:6:"page_1";s:13:"display_title";s:4:"Page";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:4:{s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:0:{}}s:17:"display_extenders";a:0:{}s:4:"path";s:8:"glossary";s:4:"menu";a:5:{s:4:"type";s:6:"normal";s:5:"title";s:8:"Glossary";s:6:"weight";i:0;s:9:"menu_name";s:4:"main";s:6:"parent";s:0:"";}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:6:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:21:"user.node_grants:view";i:5;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'views.view.taxonomy_term',
  'data' => 'a:13:{s:4:"uuid";s:36:"fa1285d7-e7c3-40be-a421-05f2bf849419";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:33:"core.entity_view_mode.node.teaser";}s:6:"module";a:3:{i:0;s:4:"node";i:1;s:8:"taxonomy";i:2;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"YKgw0f77GEmCu6_6Om9Mbig0mON9JdfVuMxTtd0WQaI";}s:2:"id";s:13:"taxonomy_term";s:5:"label";s:13:"Taxonomy term";s:6:"module";s:8:"taxonomy";s:11:"description";s:45:"Content belonging to a certain taxonomy term.";s:3:"tag";s:7:"default";s:10:"base_table";s:15:"node_field_data";s:10:"base_field";s:3:"nid";s:7:"display";a:3:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:18:{s:6:"fields";a:0:{}s:5:"pager";a:2:{s:4:"type";s:4:"mini";s:7:"options";a:6:{s:6:"offset";i:0;s:14:"items_per_page";i:10;s:11:"total_pages";i:0;s:2:"id";i:0;s:4:"tags";a:2:{s:4:"next";s:6:"››";s:8:"previous";s:6:"‹‹";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:5:"Apply";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:14:"access content";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"empty";a:0:{}s:5:"sorts";a:2:{s:6:"sticky";a:10:{s:2:"id";s:6:"sticky";s:5:"table";s:14:"taxonomy_index";s:5:"field";s:6:"sticky";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:8:"standard";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:6:"sticky";}s:7:"exposed";b:0;}s:7:"created";a:11:{s:2:"id";s:7:"created";s:5:"table";s:14:"taxonomy_index";s:5:"field";s:7:"created";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:4:"date";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:7:"created";}s:7:"exposed";b:0;s:11:"granularity";s:6:"second";}}s:9:"arguments";a:1:{s:3:"tid";a:23:{s:2:"id";s:3:"tid";s:5:"table";s:14:"taxonomy_index";s:5:"field";s:3:"tid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:18:"taxonomy_index_tid";s:14:"default_action";s:9:"not found";s:9:"exception";a:3:{s:5:"value";s:0:"";s:12:"title_enable";b:0;s:5:"title";s:3:"All";}s:12:"title_enable";b:1;s:5:"title";s:19:"{{ arguments.tid }}";s:21:"default_argument_type";s:5:"fixed";s:24:"default_argument_options";a:1:{s:8:"argument";s:0:"";}s:25:"default_argument_skip_url";b:0;s:15:"summary_options";a:4:{s:9:"base_path";s:0:"";s:5:"count";b:1;s:8:"override";b:0;s:14:"items_per_page";i:25;}s:7:"summary";a:3:{s:10:"sort_order";s:3:"asc";s:17:"number_of_records";i:0;s:6:"format";s:15:"default_summary";}s:18:"specify_validation";b:1;s:8:"validate";a:2:{s:4:"type";s:20:"entity:taxonomy_term";s:4:"fail";s:9:"not found";}s:16:"validate_options";a:4:{s:7:"bundles";a:0:{}s:6:"access";b:1;s:9:"operation";s:4:"view";s:8:"multiple";i:0;}s:12:"break_phrase";b:0;s:9:"add_table";b:0;s:13:"require_value";b:0;s:17:"reduce_duplicates";b:0;}}s:7:"filters";a:2:{s:8:"langcode";a:16:{s:2:"id";s:8:"langcode";s:5:"table";s:15:"node_field_data";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:8:"langcode";s:9:"plugin_id";s:8:"language";s:8:"operator";s:2:"in";s:5:"value";a:1:{s:31:"***LANGUAGE_language_content***";s:31:"***LANGUAGE_language_content***";}s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:13:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:6:"status";a:14:{s:2:"id";s:6:"status";s:5:"table";s:14:"taxonomy_index";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:7:"boolean";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:5:"style";a:2:{s:4:"type";s:7:"default";s:7:"options";a:4:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:11:"uses_fields";b:0;}}s:3:"row";a:2:{s:4:"type";s:11:"entity:node";s:7:"options";a:1:{s:9:"view_mode";s:6:"teaser";}}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:0:{}s:12:"link_display";s:6:"page_1";s:8:"link_url";s:0:"";s:6:"header";a:1:{s:20:"entity_taxonomy_term";a:12:{s:2:"id";s:20:"entity_taxonomy_term";s:5:"table";s:5:"views";s:5:"field";s:20:"entity_taxonomy_term";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:6:"entity";s:5:"empty";b:1;s:6:"target";s:23:"{{ raw_arguments.tid }}";s:9:"view_mode";s:4:"full";s:8:"tokenize";b:1;s:13:"bypass_access";b:0;}}s:6:"footer";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:28:"languages:language_interface";i:1;s:3:"url";i:2;s:14:"url.query_args";i:3;s:21:"user.node_grants:view";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"feed_1";a:6:{s:2:"id";s:6:"feed_1";s:13:"display_title";s:4:"Feed";s:14:"display_plugin";s:4:"feed";s:8:"position";i:2;s:15:"display_options";a:7:{s:5:"pager";a:2:{s:4:"type";s:4:"some";s:7:"options";a:2:{s:6:"offset";i:0;s:14:"items_per_page";i:10;}}s:5:"style";a:2:{s:4:"type";s:3:"rss";s:7:"options";a:3:{s:8:"grouping";a:0:{}s:11:"uses_fields";b:0;s:11:"description";s:0:"";}}s:3:"row";a:2:{s:4:"type";s:8:"node_rss";s:7:"options";a:2:{s:12:"relationship";s:4:"none";s:9:"view_mode";s:7:"default";}}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:0:{}}s:17:"display_extenders";a:0:{}s:4:"path";s:20:"taxonomy/term/%/feed";s:8:"displays";a:2:{s:6:"page_1";s:6:"page_1";s:7:"default";s:1:"0";}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:4:{i:0;s:28:"languages:language_interface";i:1;s:3:"url";i:2;s:21:"user.node_grants:view";i:3;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"page_1";a:6:{s:2:"id";s:6:"page_1";s:13:"display_title";s:4:"Page";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:3:{s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:0:{}}s:17:"display_extenders";a:0:{}s:4:"path";s:15:"taxonomy/term/%";}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:28:"languages:language_interface";i:1;s:3:"url";i:2;s:14:"url.query_args";i:3;s:21:"user.node_grants:view";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'views.view.user_admin_people',
  'data' => 'a:13:{s:4:"uuid";s:36:"10ec64fe-cf91-4c4a-941b-2ba3e21c3338";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"njaZigMvB4ap21Fg_tQcJhWgYJCGNi49Z5rRL_N6RI0";}s:2:"id";s:17:"user_admin_people";s:5:"label";s:6:"People";s:6:"module";s:4:"user";s:11:"description";s:50:"Find and manage people interacting with your site.";s:3:"tag";s:7:"default";s:10:"base_table";s:16:"users_field_data";s:10:"base_field";s:3:"uid";s:7:"display";a:2:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:25:{s:5:"title";s:6:"People";s:6:"fields";a:8:{s:14:"user_bulk_form";a:23:{s:2:"id";s:14:"user_bulk_form";s:5:"table";s:5:"users";s:5:"field";s:14:"user_bulk_form";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:9:"plugin_id";s:14:"user_bulk_form";s:5:"label";s:11:"Bulk update";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;}s:4:"name";a:25:{s:2:"id";s:4:"name";s:5:"table";s:16:"users_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:5:"field";s:5:"label";s:8:"Username";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:9:"user_name";}s:6:"status";a:26:{s:2:"id";s:6:"status";s:5:"table";s:16:"users_field_data";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:5:"field";s:5:"label";s:6:"Status";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:7:"boolean";s:8:"settings";a:3:{s:6:"format";s:6:"custom";s:19:"format_custom_false";s:7:"Blocked";s:18:"format_custom_true";s:6:"Active";}}s:15:"roles_target_id";a:24:{s:2:"id";s:15:"roles_target_id";s:5:"table";s:11:"user__roles";s:5:"field";s:15:"roles_target_id";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:10:"user_roles";s:5:"label";s:5:"Roles";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:2:"ul";s:9:"separator";s:2:", ";}s:7:"created";a:26:{s:2:"id";s:7:"created";s:5:"table";s:16:"users_field_data";s:5:"field";s:7:"created";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:7:"created";s:9:"plugin_id";s:5:"field";s:5:"label";s:10:"Member for";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:13:"timestamp_ago";s:8:"settings";a:3:{s:13:"future_format";s:9:"@interval";s:11:"past_format";s:9:"@interval";s:11:"granularity";i:2;}}s:6:"access";a:26:{s:2:"id";s:6:"access";s:5:"table";s:16:"users_field_data";s:5:"field";s:6:"access";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:6:"access";s:9:"plugin_id";s:5:"field";s:5:"label";s:11:"Last access";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:13:"timestamp_ago";s:8:"settings";a:3:{s:13:"future_format";s:15:"@interval hence";s:11:"past_format";s:13:"@interval ago";s:11:"granularity";i:2;}}s:10:"operations";a:24:{s:2:"id";s:10:"operations";s:5:"table";s:5:"users";s:5:"field";s:10:"operations";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:9:"plugin_id";s:17:"entity_operations";s:5:"label";s:10:"Operations";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:11:"destination";b:1;}s:4:"mail";a:37:{s:2:"id";s:4:"mail";s:5:"table";s:16:"users_field_data";s:5:"field";s:4:"mail";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:4:"mail";s:9:"plugin_id";s:5:"field";s:5:"label";s:0:"";s:7:"exclude";b:1;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:12:"basic_string";s:8:"settings";a:0:{}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}}s:5:"pager";a:2:{s:4:"type";s:4:"full";s:7:"options";a:7:{s:6:"offset";i:0;s:14:"items_per_page";i:50;s:11:"total_pages";i:0;s:2:"id";i:0;s:4:"tags";a:4:{s:4:"next";s:8:"Next ›";s:8:"previous";s:12:"‹ Previous";s:5:"first";s:8:"« First";s:4:"last";s:7:"Last »";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}s:8:"quantity";i:9;}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:6:"Filter";s:12:"reset_button";b:1;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:16:"administer users";}}s:5:"cache";a:1:{s:4:"type";s:3:"tag";}s:5:"empty";a:1:{s:16:"area_text_custom";a:10:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:11:"text_custom";s:5:"empty";b:1;s:7:"content";s:20:"No people available.";s:8:"tokenize";b:0;}}s:5:"sorts";a:1:{s:7:"created";a:13:{s:2:"id";s:7:"created";s:5:"table";s:16:"users_field_data";s:5:"field";s:7:"created";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:7:"created";s:9:"plugin_id";s:4:"date";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:7:"created";}s:7:"exposed";b:0;s:11:"granularity";s:6:"second";}}s:7:"filters";a:6:{s:7:"combine";a:15:{s:2:"id";s:7:"combine";s:5:"table";s:5:"views";s:5:"field";s:7:"combine";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:7:"combine";s:8:"operator";s:8:"contains";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:10:"combine_op";s:5:"label";s:22:"Name or email contains";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:10:"combine_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:4:"user";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:6:"fields";a:2:{s:4:"name";s:4:"name";s:4:"mail";s:4:"mail";}}s:6:"status";a:16:{s:2:"id";s:6:"status";s:5:"table";s:16:"users_field_data";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:9:"status_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:6:"status";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}}s:10:"is_grouped";b:1;s:10:"group_info";a:10:{s:5:"label";s:6:"Status";s:11:"description";s:0:"";s:10:"identifier";s:6:"status";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:2:{i:1;a:3:{s:5:"title";s:6:"Active";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";}i:2;a:3:{s:5:"title";s:7:"Blocked";s:8:"operator";s:1:"=";s:5:"value";s:1:"0";}}}}s:15:"roles_target_id";a:15:{s:2:"id";s:15:"roles_target_id";s:5:"table";s:11:"user__roles";s:5:"field";s:15:"roles_target_id";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:10:"user_roles";s:8:"operator";s:2:"or";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:18:"roles_target_id_op";s:5:"label";s:4:"Role";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:18:"roles_target_id_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:4:"role";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:17:"reduce_duplicates";b:0;}s:10:"permission";a:15:{s:2:"id";s:10:"permission";s:5:"table";s:11:"user__roles";s:5:"field";s:10:"permission";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:16:"user_permissions";s:8:"operator";s:2:"or";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:13:"permission_op";s:5:"label";s:10:"Permission";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:13:"permission_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:10:"permission";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:17:"reduce_duplicates";b:0;}s:16:"default_langcode";a:16:{s:2:"id";s:16:"default_langcode";s:5:"table";s:16:"users_field_data";s:5:"field";s:16:"default_langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:16:"default_langcode";s:9:"plugin_id";s:7:"boolean";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:7:"uid_raw";a:15:{s:2:"id";s:7:"uid_raw";s:5:"table";s:16:"users_field_data";s:5:"field";s:7:"uid_raw";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:9:"plugin_id";s:7:"numeric";s:8:"operator";s:2:"!=";s:5:"value";a:3:{s:3:"min";s:0:"";s:3:"max";s:0:"";s:5:"value";s:1:"0";}s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:1:"0";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:13:"filter_groups";a:2:{s:8:"operator";s:3:"AND";s:6:"groups";a:1:{i:1;s:3:"AND";}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:10:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:7:"columns";a:8:{s:14:"user_bulk_form";s:14:"user_bulk_form";s:4:"name";s:4:"name";s:6:"status";s:6:"status";s:3:"rid";s:3:"rid";s:7:"created";s:7:"created";s:6:"access";s:6:"access";s:9:"edit_node";s:9:"edit_node";s:10:"dropbutton";s:10:"dropbutton";}s:7:"default";s:7:"created";s:4:"info";a:8:{s:14:"user_bulk_form";a:4:{s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:4:"name";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:6:"status";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:3:"rid";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:7:"created";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:6:"access";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:9:"edit_node";a:4:{s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:10:"dropbutton";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}}s:8:"override";b:1;s:6:"sticky";b:0;s:7:"summary";s:0:"";s:11:"empty_table";b:1;}}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:9:"css_class";s:0:"";s:8:"use_ajax";b:0;s:8:"group_by";b:0;s:16:"show_admin_links";b:1;s:8:"use_more";b:0;s:15:"use_more_always";b:0;s:13:"use_more_text";s:4:"more";s:12:"link_display";s:6:"page_1";s:8:"link_url";s:0:"";s:15:"display_comment";s:0:"";s:23:"hide_attachment_summary";b:0;s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:0;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"page_1";a:6:{s:2:"id";s:6:"page_1";s:13:"display_title";s:4:"Page";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:6:{s:8:"defaults";a:1:{s:16:"show_admin_links";b:0;}s:16:"show_admin_links";b:0;s:17:"display_extenders";a:0:{}s:4:"path";s:17:"admin/people/list";s:4:"menu";a:6:{s:4:"type";s:11:"default tab";s:5:"title";s:4:"List";s:11:"description";s:50:"Find and manage people interacting with your site.";s:6:"weight";i:-10;s:9:"menu_name";s:5:"admin";s:7:"context";s:0:"";}s:11:"tab_options";a:5:{s:4:"type";s:6:"normal";s:5:"title";s:6:"People";s:11:"description";s:45:"Manage user accounts, roles, and permissions.";s:6:"weight";i:0;s:9:"menu_name";s:5:"admin";}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:0;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'views.view.who_s_new',
  'data' => "a:13:{s:4:\"uuid\";s:36:\"3626aaf5-6c82-4e1b-8f19-752e2cdac89f\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"zji0_13MyVGK7Bn1lUMDeZyyOIZedWvqpYUeM_SioPI\";}s:2:\"id\";s:9:\"who_s_new\";s:5:\"label\";s:9:\"Who's new\";s:6:\"module\";s:4:\"user\";s:11:\"description\";s:53:\"Shows a list of the newest user accounts on the site.\";s:3:\"tag\";s:7:\"default\";s:10:\"base_table\";s:16:\"users_field_data\";s:10:\"base_field\";s:3:\"uid\";s:7:\"display\";a:2:{s:7:\"default\";a:6:{s:2:\"id\";s:7:\"default\";s:13:\"display_title\";s:7:\"Default\";s:14:\"display_plugin\";s:7:\"default\";s:8:\"position\";i:0;s:15:\"display_options\";a:17:{s:5:\"title\";s:9:\"Who's new\";s:6:\"fields\";a:1:{s:4:\"name\";a:25:{s:2:\"id\";s:4:\"name\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:4:\"name\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:4:\"name\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:8:{s:10:\"alter_text\";b:0;s:9:\"make_link\";b:0;s:8:\"absolute\";b:0;s:13:\"word_boundary\";b:0;s:8:\"ellipsis\";b:0;s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"type\";s:9:\"user_name\";}}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"some\";s:7:\"options\";a:2:{s:6:\"offset\";i:0;s:14:\"items_per_page\";i:5;}}s:12:\"exposed_form\";a:2:{s:4:\"type\";s:5:\"basic\";s:7:\"options\";a:7:{s:13:\"submit_button\";s:5:\"Apply\";s:12:\"reset_button\";b:0;s:18:\"reset_button_label\";s:5:\"Reset\";s:19:\"exposed_sorts_label\";s:7:\"Sort by\";s:17:\"expose_sort_order\";b:1;s:14:\"sort_asc_label\";s:3:\"Asc\";s:15:\"sort_desc_label\";s:4:\"Desc\";}}s:6:\"access\";a:2:{s:4:\"type\";s:4:\"perm\";s:7:\"options\";a:1:{s:4:\"perm\";s:14:\"access content\";}}s:5:\"cache\";a:2:{s:4:\"type\";s:3:\"tag\";s:7:\"options\";a:0:{}}s:5:\"empty\";a:0:{}s:5:\"sorts\";a:1:{s:7:\"created\";a:13:{s:2:\"id\";s:7:\"created\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:7:\"created\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:7:\"created\";s:9:\"plugin_id\";s:4:\"date\";s:5:\"order\";s:4:\"DESC\";s:6:\"expose\";a:2:{s:5:\"label\";s:0:\"\";s:16:\"field_identifier\";s:7:\"created\";}s:7:\"exposed\";b:0;s:11:\"granularity\";s:6:\"second\";}}s:9:\"arguments\";a:0:{}s:7:\"filters\";a:2:{s:6:\"status\";a:9:{s:2:\"id\";s:6:\"status\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:6:\"status\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:6:\"status\";s:9:\"plugin_id\";s:7:\"boolean\";s:5:\"value\";s:1:\"1\";s:5:\"group\";i:1;s:6:\"expose\";a:3:{s:8:\"operator\";s:1:\"0\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}}}s:6:\"access\";a:16:{s:2:\"id\";s:6:\"access\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:6:\"access\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:6:\"access\";s:9:\"plugin_id\";s:4:\"date\";s:8:\"operator\";s:1:\">\";s:5:\"value\";a:4:{s:3:\"min\";s:0:\"\";s:3:\"max\";s:0:\"\";s:5:\"value\";s:10:\"1970-01-01\";s:4:\"type\";s:4:\"date\";}s:5:\"group\";i:1;s:7:\"exposed\";b:0;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:1:\"0\";s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:0:\"\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:0:\"\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:1:{s:13:\"authenticated\";s:13:\"authenticated\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}}s:5:\"style\";a:1:{s:4:\"type\";s:9:\"html_list\";}s:3:\"row\";a:1:{s:4:\"type\";s:6:\"fields\";}s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:5:{s:13:\"query_comment\";s:0:\"\";s:19:\"disable_sql_rewrite\";b:0;s:8:\"distinct\";b:0;s:7:\"replica\";b:0;s:10:\"query_tags\";a:0:{}}}s:13:\"relationships\";a:0:{}s:6:\"header\";a:0:{}s:6:\"footer\";a:0:{}s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:3:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}s:7:\"block_1\";a:6:{s:2:\"id\";s:7:\"block_1\";s:13:\"display_title\";s:9:\"Who's new\";s:14:\"display_plugin\";s:5:\"block\";s:8:\"position\";i:1;s:15:\"display_options\";a:4:{s:19:\"display_description\";s:19:\"A list of new users\";s:17:\"display_extenders\";a:0:{}s:17:\"block_description\";s:9:\"Who's new\";s:14:\"block_category\";s:4:\"User\";}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:3:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}}}",
))
->values(array(
  'collection' => '',
  'name' => 'views.view.who_s_online',
  'data' => "a:13:{s:4:\"uuid\";s:36:\"be956f46-fbc7-42d5-9482-711b3ab643c2\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"suDsVMgawXoQt4rfmdfpr05EVX3z3KyfDDTYgeSM898\";}s:2:\"id\";s:12:\"who_s_online\";s:5:\"label\";s:18:\"Who's online block\";s:6:\"module\";s:4:\"user\";s:11:\"description\";s:93:\"Shows the user names of the most recently active users, and the total number of active users.\";s:3:\"tag\";s:7:\"default\";s:10:\"base_table\";s:16:\"users_field_data\";s:10:\"base_field\";s:3:\"uid\";s:7:\"display\";a:2:{s:7:\"default\";a:6:{s:2:\"id\";s:7:\"default\";s:13:\"display_title\";s:7:\"Default\";s:14:\"display_plugin\";s:7:\"default\";s:8:\"position\";i:0;s:15:\"display_options\";a:17:{s:5:\"title\";s:12:\"Who's online\";s:6:\"fields\";a:1:{s:4:\"name\";a:25:{s:2:\"id\";s:4:\"name\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:4:\"name\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:4:\"name\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:8:{s:10:\"alter_text\";b:0;s:9:\"make_link\";b:0;s:8:\"absolute\";b:0;s:13:\"word_boundary\";b:0;s:8:\"ellipsis\";b:0;s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"type\";s:9:\"user_name\";}}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"some\";s:7:\"options\";a:2:{s:6:\"offset\";i:0;s:14:\"items_per_page\";i:10;}}s:12:\"exposed_form\";a:2:{s:4:\"type\";s:5:\"basic\";s:7:\"options\";a:7:{s:13:\"submit_button\";s:5:\"Apply\";s:12:\"reset_button\";b:0;s:18:\"reset_button_label\";s:5:\"Reset\";s:19:\"exposed_sorts_label\";s:7:\"Sort by\";s:17:\"expose_sort_order\";b:1;s:14:\"sort_asc_label\";s:3:\"Asc\";s:15:\"sort_desc_label\";s:4:\"Desc\";}}s:6:\"access\";a:2:{s:4:\"type\";s:4:\"perm\";s:7:\"options\";a:1:{s:4:\"perm\";s:20:\"access user profiles\";}}s:5:\"cache\";a:2:{s:4:\"type\";s:3:\"tag\";s:7:\"options\";a:0:{}}s:5:\"empty\";a:1:{s:16:\"area_text_custom\";a:10:{s:2:\"id\";s:16:\"area_text_custom\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:16:\"area_text_custom\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:11:\"text_custom\";s:5:\"empty\";b:1;s:7:\"content\";s:35:\"There are currently 0 users online.\";s:8:\"tokenize\";b:0;}}s:5:\"sorts\";a:1:{s:6:\"access\";a:13:{s:2:\"id\";s:6:\"access\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:6:\"access\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:6:\"access\";s:9:\"plugin_id\";s:4:\"date\";s:5:\"order\";s:4:\"DESC\";s:6:\"expose\";a:2:{s:5:\"label\";s:0:\"\";s:16:\"field_identifier\";s:6:\"access\";}s:7:\"exposed\";b:0;s:11:\"granularity\";s:6:\"second\";}}s:9:\"arguments\";a:0:{}s:7:\"filters\";a:2:{s:6:\"status\";a:9:{s:2:\"id\";s:6:\"status\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:6:\"status\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:6:\"status\";s:9:\"plugin_id\";s:7:\"boolean\";s:5:\"value\";s:1:\"1\";s:5:\"group\";i:1;s:6:\"expose\";a:3:{s:8:\"operator\";s:1:\"0\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}}}s:6:\"access\";a:16:{s:2:\"id\";s:6:\"access\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:6:\"access\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:6:\"access\";s:9:\"plugin_id\";s:4:\"date\";s:8:\"operator\";s:2:\">=\";s:5:\"value\";a:4:{s:3:\"min\";s:0:\"\";s:3:\"max\";s:0:\"\";s:5:\"value\";s:11:\"-15 minutes\";s:4:\"type\";s:6:\"offset\";}s:5:\"group\";i:1;s:7:\"exposed\";b:0;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:9:\"access_op\";s:5:\"label\";s:11:\"Last access\";s:11:\"description\";s:77:\"A user is considered online for this long after they have last viewed a page.\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:9:\"access_op\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:6:\"access\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}}s:5:\"style\";a:2:{s:4:\"type\";s:9:\"html_list\";s:7:\"options\";a:6:{s:8:\"grouping\";a:0:{}s:9:\"row_class\";s:0:\"\";s:17:\"default_row_class\";b:1;s:4:\"type\";s:2:\"ul\";s:13:\"wrapper_class\";s:9:\"item-list\";s:5:\"class\";s:0:\"\";}}s:3:\"row\";a:1:{s:4:\"type\";s:6:\"fields\";}s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:5:{s:13:\"query_comment\";s:0:\"\";s:19:\"disable_sql_rewrite\";b:0;s:8:\"distinct\";b:0;s:7:\"replica\";b:0;s:10:\"query_tags\";a:0:{}}}s:13:\"relationships\";a:0:{}s:6:\"header\";a:1:{s:6:\"result\";a:9:{s:2:\"id\";s:6:\"result\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:6:\"result\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:6:\"result\";s:5:\"empty\";b:0;s:7:\"content\";s:40:\"There are currently @total users online.\";}}s:6:\"footer\";a:0:{}s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:3:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}s:18:\"who_s_online_block\";a:6:{s:2:\"id\";s:18:\"who_s_online_block\";s:13:\"display_title\";s:12:\"Who's online\";s:14:\"display_plugin\";s:5:\"block\";s:8:\"position\";i:1;s:15:\"display_options\";a:3:{s:19:\"display_description\";s:45:\"A list of users that are currently logged in.\";s:17:\"display_extenders\";a:0:{}s:17:\"block_description\";s:12:\"Who's online\";}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:3:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}}}",
))
->execute();
$connection->schema()->createTable('config_export', array(
  'fields' => array(
    'collection' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'name' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
  ),
  'primary key' => array(
    'collection',
    'name',
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->insert('config_export')
->fields(array(
  'collection',
  'name',
  'data',
))
->values(array(
  'collection' => '',
  'name' => 'automated_cron.settings',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"fUksROt4FfkAU9BV4hV2XvhTBSS2nTNrZS4U7S-tKrs";}s:8:"interval";i:10800;}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.claro_breadcrumbs',
  'data' => 'a:13:{s:4:"uuid";s:36:"f7df1911-ad5b-4cb3-8153-59321df33c3e";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:5:"claro";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"NjcxOBrPOiK5-38t56DwFBDVY4yer7YSlbRWXFuHe7A";}s:2:"id";s:17:"claro_breadcrumbs";s:5:"theme";s:5:"claro";s:6:"region";s:10:"breadcrumb";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:23:"system_breadcrumb_block";s:8:"settings";a:4:{s:2:"id";s:23:"system_breadcrumb_block";s:5:"label";s:11:"Breadcrumbs";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.claro_content',
  'data' => 'a:13:{s:4:"uuid";s:36:"f2ffe7dc-4030-4952-980a-11f199e6b8b7";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:5:"claro";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"a0Yyx1GeyKarZ4T_yXQBR_ZFKnXiFLtxAb6gWLd8nr0";}s:2:"id";s:13:"claro_content";s:5:"theme";s:5:"claro";s:6:"region";s:7:"content";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:17:"system_main_block";s:8:"settings";a:4:{s:2:"id";s:17:"system_main_block";s:5:"label";s:17:"Main page content";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.claro_help',
  'data' => 'a:13:{s:4:"uuid";s:36:"cf8942d4-054b-4fcd-9182-39a5cc30128f";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:4:"help";}s:5:"theme";a:1:{i:0;s:5:"claro";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"jccFSSVqV0WCDb6NtML1VWAWTtDbZ-zn5YgTRMgMrIM";}s:2:"id";s:10:"claro_help";s:5:"theme";s:5:"claro";s:6:"region";s:4:"help";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:10:"help_block";s:8:"settings";a:4:{s:2:"id";s:10:"help_block";s:5:"label";s:4:"Help";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"help";}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.claro_local_actions',
  'data' => 'a:13:{s:4:"uuid";s:36:"459da073-0b49-4889-b68e-65e6c6d21aa8";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:5:"claro";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"CdXfDmRgAvms7EQovxxWPdYi0GitxeRbVtScYK16ZH0";}s:2:"id";s:19:"claro_local_actions";s:5:"theme";s:5:"claro";s:6:"region";s:7:"content";s:6:"weight";i:-10;s:8:"provider";N;s:6:"plugin";s:19:"local_actions_block";s:8:"settings";a:4:{s:2:"id";s:19:"local_actions_block";s:5:"label";s:21:"Primary admin actions";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"core";}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.claro_messages',
  'data' => 'a:13:{s:4:"uuid";s:36:"8662e482-f3f3-4eb8-b414-35ec43424eaf";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:5:"claro";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"-Ac3ISpIT0PQ-whzD7_dw0SdKi6dAbRFNWdSjOiVDqg";}s:2:"id";s:14:"claro_messages";s:5:"theme";s:5:"claro";s:6:"region";s:11:"highlighted";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:21:"system_messages_block";s:8:"settings";a:4:{s:2:"id";s:21:"system_messages_block";s:5:"label";s:15:"Status messages";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.claro_page_title',
  'data' => 'a:13:{s:4:"uuid";s:36:"d9a84d3b-290b-4cc6-842b-598d359a5606";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:5:"claro";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"fNwDdW063tk_ktzSWzZVeQS9wzvLooVO280BQ9WrsIs";}s:2:"id";s:16:"claro_page_title";s:5:"theme";s:5:"claro";s:6:"region";s:6:"header";s:6:"weight";i:-30;s:8:"provider";N;s:6:"plugin";s:16:"page_title_block";s:8:"settings";a:4:{s:2:"id";s:16:"page_title_block";s:5:"label";s:10:"Page title";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"core";}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.claro_primary_local_tasks',
  'data' => 'a:13:{s:4:"uuid";s:36:"c47e7602-16ce-4e01-b63c-c758f7f1f86c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:5:"claro";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ACjBZI5shAMiiUpsz-inLYVXDqNNXRnSzAWV3kV_8Hw";}s:2:"id";s:25:"claro_primary_local_tasks";s:5:"theme";s:5:"claro";s:6:"region";s:6:"header";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:17:"local_tasks_block";s:8:"settings";a:6:{s:2:"id";s:17:"local_tasks_block";s:5:"label";s:12:"Primary tabs";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"core";s:7:"primary";b:1;s:9:"secondary";b:0;}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.claro_secondary_local_tasks',
  'data' => 'a:13:{s:4:"uuid";s:36:"2e1bcbf0-8814-48e4-bbcf-0240ed25b562";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:5:"claro";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"2L0geP-ixCbCkEpW6BVF6H7vDUZN4ea07_Y9CociQm4";}s:2:"id";s:27:"claro_secondary_local_tasks";s:5:"theme";s:5:"claro";s:6:"region";s:11:"pre_content";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:17:"local_tasks_block";s:8:"settings";a:6:{s:2:"id";s:17:"local_tasks_block";s:5:"label";s:14:"Secondary tabs";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"core";s:7:"primary";b:0;s:9:"secondary";b:1;}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.olivero_account_menu',
  'data' => 'a:13:{s:4:"uuid";s:36:"4fbdbb90-d3f0-4816-8a3b-88de512cd8f8";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:3:{s:6:"config";a:1:{i:0;s:19:"system.menu.account";}s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"gmxYWWHmgbe0Pnv8y48ZLSLH5mEHejOjAP6RLxUfdzU";}s:2:"id";s:20:"olivero_account_menu";s:5:"theme";s:7:"olivero";s:6:"region";s:14:"secondary_menu";s:6:"weight";i:-4;s:8:"provider";N;s:6:"plugin";s:25:"system_menu_block:account";s:8:"settings";a:7:{s:2:"id";s:25:"system_menu_block:account";s:5:"label";s:17:"User account menu";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";s:5:"level";i:1;s:5:"depth";i:1;s:16:"expand_all_items";b:0;}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.olivero_breadcrumbs',
  'data' => 'a:13:{s:4:"uuid";s:36:"e5e26cf3-f53e-4872-9680-96de34915223";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"VhBzWb7lMRtIOg9G7VSw_0uopi-7zXeHq4vXqqV1HFE";}s:2:"id";s:19:"olivero_breadcrumbs";s:5:"theme";s:7:"olivero";s:6:"region";s:10:"breadcrumb";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:23:"system_breadcrumb_block";s:8:"settings";a:4:{s:2:"id";s:23:"system_breadcrumb_block";s:5:"label";s:11:"Breadcrumbs";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.olivero_content',
  'data' => 'a:13:{s:4:"uuid";s:36:"ef5f9f63-2e20-446c-a8b7-d8375dade67b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"erQSEZF2XUjNmgTl0uNRBzmg18ZGXwUcw2FhApoeuHk";}s:2:"id";s:15:"olivero_content";s:5:"theme";s:7:"olivero";s:6:"region";s:7:"content";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:17:"system_main_block";s:8:"settings";a:4:{s:2:"id";s:17:"system_main_block";s:5:"label";s:17:"Main page content";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.olivero_help',
  'data' => 'a:13:{s:4:"uuid";s:36:"c1dde7d9-e643-4c46-91ce-b8084172fe2a";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:4:"help";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"VfPFqqxfkomud5CO8DUijw85QIl9GIxh_nIxLOYESxg";}s:2:"id";s:12:"olivero_help";s:5:"theme";s:7:"olivero";s:6:"region";s:13:"content_above";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:10:"help_block";s:8:"settings";a:4:{s:2:"id";s:10:"help_block";s:5:"label";s:4:"Help";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"help";}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.olivero_main_menu',
  'data' => 'a:13:{s:4:"uuid";s:36:"aa232095-6eeb-43c2-a0d9-53fcad8111b3";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:3:{s:6:"config";a:1:{i:0;s:16:"system.menu.main";}s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"KWAiziL39uEzmOJEql_wbUP2RtqGceL3WM2CfxhMelE";}s:2:"id";s:17:"olivero_main_menu";s:5:"theme";s:7:"olivero";s:6:"region";s:12:"primary_menu";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:22:"system_menu_block:main";s:8:"settings";a:7:{s:2:"id";s:22:"system_menu_block:main";s:5:"label";s:15:"Main navigation";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";s:5:"level";i:1;s:5:"depth";i:2;s:16:"expand_all_items";b:1;}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.olivero_messages',
  'data' => 'a:13:{s:4:"uuid";s:36:"0442b9ac-98e8-4171-97c3-c123f193dfcd";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"BZ5tpW7H8X4PVGRm3MImTIHd2tN0eF7zOtp4SpRYUA0";}s:2:"id";s:16:"olivero_messages";s:5:"theme";s:7:"olivero";s:6:"region";s:11:"highlighted";s:6:"weight";i:-5;s:8:"provider";N;s:6:"plugin";s:21:"system_messages_block";s:8:"settings";a:4:{s:2:"id";s:21:"system_messages_block";s:5:"label";s:15:"Status messages";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.olivero_page_title',
  'data' => 'a:13:{s:4:"uuid";s:36:"65675939-734e-4b74-b21d-54f954204978";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"6aOgWsNTXjqrDm98TXSAjP6qd2nCijD1xw45MrnbK-Y";}s:2:"id";s:18:"olivero_page_title";s:5:"theme";s:7:"olivero";s:6:"region";s:13:"content_above";s:6:"weight";i:-5;s:8:"provider";N;s:6:"plugin";s:16:"page_title_block";s:8:"settings";a:4:{s:2:"id";s:16:"page_title_block";s:5:"label";s:10:"Page title";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"core";}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.olivero_powered',
  'data' => 'a:13:{s:4:"uuid";s:36:"59e9b4eb-a103-4b80-bb14-c2265781acef";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"eYL19CLDyinGTWYQfBD1DswWzglEotE_kHnHx3AxTXM";}s:2:"id";s:15:"olivero_powered";s:5:"theme";s:7:"olivero";s:6:"region";s:13:"footer_bottom";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:23:"system_powered_by_block";s:8:"settings";a:4:{s:2:"id";s:23:"system_powered_by_block";s:5:"label";s:17:"Powered by Drupal";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.olivero_primary_admin_actions',
  'data' => 'a:13:{s:4:"uuid";s:36:"ef91aa88-b6dd-45c1-bd82-26873c2cc4ca";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Q9_2whdOj1YIomfvsIfopROW4FT_X5pY0DjdOiOaQ5U";}s:2:"id";s:29:"olivero_primary_admin_actions";s:5:"theme";s:7:"olivero";s:6:"region";s:11:"highlighted";s:6:"weight";i:-5;s:8:"provider";N;s:6:"plugin";s:19:"local_actions_block";s:8:"settings";a:4:{s:2:"id";s:19:"local_actions_block";s:5:"label";s:21:"Primary admin actions";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"core";}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.olivero_primary_local_tasks',
  'data' => 'a:13:{s:4:"uuid";s:36:"e6de916d-3c06-47bc-b12d-ff646ff9bd44";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"nGE3EoPQQaQCuqTUtZgw0-KIzmrqdKDzdNQf2JyPUt4";}s:2:"id";s:27:"olivero_primary_local_tasks";s:5:"theme";s:7:"olivero";s:6:"region";s:11:"highlighted";s:6:"weight";i:-4;s:8:"provider";N;s:6:"plugin";s:17:"local_tasks_block";s:8:"settings";a:6:{s:2:"id";s:17:"local_tasks_block";s:5:"label";s:12:"Primary tabs";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"core";s:7:"primary";b:1;s:9:"secondary";b:0;}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.olivero_search_form_narrow',
  'data' => 'a:13:{s:4:"uuid";s:36:"946411ff-8719-4097-b45b-ad6f3e1ef3c4";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"search";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"yEBET0cqDbk8dkWzaJw-8CKft0961VBflsISoSR6Lj8";}s:2:"id";s:26:"olivero_search_form_narrow";s:5:"theme";s:7:"olivero";s:6:"region";s:12:"primary_menu";s:6:"weight";i:-4;s:8:"provider";N;s:6:"plugin";s:17:"search_form_block";s:8:"settings";a:5:{s:2:"id";s:17:"search_form_block";s:5:"label";s:20:"Search form (narrow)";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"search";s:7:"page_id";s:0:"";}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.olivero_search_form_wide',
  'data' => 'a:13:{s:4:"uuid";s:36:"23cb830b-910c-42ef-ada8-7989bf95cbbb";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"search";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"imMyHD6LYci0gtXq56qr9ZKGHzbEG9uFydrN5EhKtSU";}s:2:"id";s:24:"olivero_search_form_wide";s:5:"theme";s:7:"olivero";s:6:"region";s:14:"secondary_menu";s:6:"weight";i:-5;s:8:"provider";N;s:6:"plugin";s:17:"search_form_block";s:8:"settings";a:5:{s:2:"id";s:17:"search_form_block";s:5:"label";s:18:"Search form (wide)";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"search";s:7:"page_id";s:0:"";}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.olivero_secondary_local_tasks',
  'data' => 'a:13:{s:4:"uuid";s:36:"aede71f4-8663-4ae2-8eb9-e87548031e97";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ydSxdq7R66I8UMC460rOzlfzvlUL4VRbdwc6z9DWaUI";}s:2:"id";s:29:"olivero_secondary_local_tasks";s:5:"theme";s:7:"olivero";s:6:"region";s:11:"highlighted";s:6:"weight";i:-2;s:8:"provider";N;s:6:"plugin";s:17:"local_tasks_block";s:8:"settings";a:6:{s:2:"id";s:17:"local_tasks_block";s:5:"label";s:14:"Secondary tabs";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"core";s:7:"primary";b:0;s:9:"secondary";b:1;}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.olivero_site_branding',
  'data' => 'a:13:{s:4:"uuid";s:36:"52366cc5-86b4-4cd1-a3ff-f395d76faece";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"n_nlgjggHVfQt2H__zvLOKB2YtjPDbQ5tHijF9LE1aM";}s:2:"id";s:21:"olivero_site_branding";s:5:"theme";s:7:"olivero";s:6:"region";s:6:"header";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:21:"system_branding_block";s:8:"settings";a:7:{s:2:"id";s:21:"system_branding_block";s:5:"label";s:13:"Site branding";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";s:13:"use_site_logo";b:1;s:13:"use_site_name";b:1;s:15:"use_site_slogan";b:0;}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.olivero_syndicate',
  'data' => 'a:13:{s:4:"uuid";s:36:"1f2e6bce-f5f5-4215-b257-4ef0bc5bb580";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:4:"node";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"0gq3VPg-_UM69FCCWurLFIrrnIjC2HLKhwo9iQNtcUo";}s:2:"id";s:17:"olivero_syndicate";s:5:"theme";s:7:"olivero";s:6:"region";s:6:"social";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:20:"node_syndicate_block";s:8:"settings";a:5:{s:2:"id";s:20:"node_syndicate_block";s:5:"label";s:8:"RSS feed";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"node";s:11:"block_count";i:10;}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block_content.type.basic',
  'data' => 'a:9:{s:4:"uuid";s:36:"4881ab95-c558-467e-804a-2979c2fd93d4";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"zglzjmYxi0G0ag9MZ02y0LSJOdpWRwJxyP_OvFojFyo";}s:2:"id";s:5:"basic";s:5:"label";s:11:"Basic block";s:8:"revision";i:0;s:11:"description";s:42:"A basic block contains a title and a body.";}',
))
->values(array(
  'collection' => '',
  'name' => 'claro.settings',
  'data' => 'a:1:{s:20:"third_party_settings";a:1:{s:8:"shortcut";a:1:{s:11:"module_link";b:1;}}}',
))
->values(array(
  'collection' => '',
  'name' => 'comment.settings',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"YNUW2Ij5uE7a4oaXp3i_2lvaFdYM1zNKPPfnEjB0jEc";}s:16:"log_ip_addresses";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'comment.type.comment',
  'data' => 'a:9:{s:4:"uuid";s:36:"63ce59b3-6c19-4247-a9b5-237ccf113e5a";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"bqZsN31T2n0UjcbyCpOPi9D2iO0sAOHR7FnEs9qMvaA";}s:2:"id";s:7:"comment";s:5:"label";s:16:"Default comments";s:21:"target_entity_type_id";s:4:"node";s:11:"description";s:28:"Allows commenting on content";}',
))
->values(array(
  'collection' => '',
  'name' => 'contact.form.feedback',
  'data' => 'a:12:{s:4:"uuid";s:36:"d78951fc-6ea8-4dc7-a4bb-34b0407ebb52";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"vymHlgJy26BuI5GGj9-IXjwR3dRC5C0tij4BpWJnoqw";}s:2:"id";s:8:"feedback";s:5:"label";s:16:"Website feedback";s:10:"recipients";a:1:{i:0;s:17:"admin@example.com";}s:5:"reply";s:0:"";s:6:"weight";i:0;s:7:"message";s:27:"Your message has been sent.";s:8:"redirect";s:0:"";}',
))
->values(array(
  'collection' => '',
  'name' => 'contact.form.personal',
  'data' => 'a:12:{s:4:"uuid";s:36:"cb2134ab-de78-46fb-857b-7f10480bf6ca";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"jonvgt3CkUM2eMLTFwWfHileWWDC4YtXCuIlCahTk_I";}s:2:"id";s:8:"personal";s:5:"label";s:21:"Personal contact form";s:10:"recipients";a:0:{}s:5:"reply";s:0:"";s:6:"weight";i:0;s:7:"message";s:27:"Your message has been sent.";s:8:"redirect";s:0:"";}',
))
->values(array(
  'collection' => '',
  'name' => 'contact.settings',
  'data' => 'a:4:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"U69DBeuvXuNVOC15rVNaBjDPK2fWFbo9v4takdYSSO8";}s:12:"default_form";s:8:"feedback";s:5:"flood";a:2:{s:5:"limit";i:5;s:8:"interval";i:3600;}s:20:"user_default_enabled";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.base_field_override.node.page.promote',
  'data' => 'a:17:{s:4:"uuid";s:36:"a81001fa-33aa-4d00-b7ea-dbabbec715d1";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:1:{i:0;s:14:"node.type.page";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"fPUEnm4T5zfZRr3ttDUqq7yCDd2uW3clWD-pvos4tlQ";}s:2:"id";s:17:"node.page.promote";s:10:"field_name";s:7:"promote";s:11:"entity_type";s:4:"node";s:6:"bundle";s:4:"page";s:5:"label";s:22:"Promoted to front page";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:0;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";i:0;}}s:22:"default_value_callback";s:0:"";s:8:"settings";a:2:{s:8:"on_label";s:2:"On";s:9:"off_label";s:3:"Off";}s:10:"field_type";s:7:"boolean";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.date_format.fallback',
  'data' => 'a:9:{s:4:"uuid";s:36:"fc55a34d-977a-4c5e-9dab-c53f0ec8b807";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"7klS5IWXrwzVaPpYZFAs6wcx8U2FF1X73OfrtTsvuvE";}s:2:"id";s:8:"fallback";s:5:"label";s:20:"Fallback date format";s:6:"locked";b:1;s:7:"pattern";s:14:"D, m/d/Y - H:i";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.date_format.html_date',
  'data' => 'a:9:{s:4:"uuid";s:36:"a250c99c-7172-4b50-b307-511c40463c4d";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"EOQltUQPmgc6UQ2rcJ4Xi_leCEJj5ui0TR-12duS-Tk";}s:2:"id";s:9:"html_date";s:5:"label";s:9:"HTML Date";s:6:"locked";b:1;s:7:"pattern";s:5:"Y-m-d";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.date_format.html_datetime',
  'data' => 'a:9:{s:4:"uuid";s:36:"bf6c9d38-c690-404a-8d73-c8f0aad5470f";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"jxfClwZIRXIdcvMrE--WkcZxDGUVoOIE3Sm2NRZlFuE";}s:2:"id";s:13:"html_datetime";s:5:"label";s:13:"HTML Datetime";s:6:"locked";b:1;s:7:"pattern";s:13:"Y-m-d\TH:i:sO";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.date_format.html_month',
  'data' => 'a:9:{s:4:"uuid";s:36:"ea70c2ac-98e7-4c4a-a56a-ec5bf6ce3e53";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Z7KuCUwM_WdTNvLcoltuX3_8d-s-8FZkTN6KgNwF0eM";}s:2:"id";s:10:"html_month";s:5:"label";s:10:"HTML Month";s:6:"locked";b:1;s:7:"pattern";s:3:"Y-m";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.date_format.html_time',
  'data' => 'a:9:{s:4:"uuid";s:36:"5568ba70-4dae-4e97-8b83-2cb119bc6be2";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"M7yqicYkU36hRy5p9drAaGBBihhUD1OyujFrAaQ93ZE";}s:2:"id";s:9:"html_time";s:5:"label";s:9:"HTML Time";s:6:"locked";b:1;s:7:"pattern";s:5:"H:i:s";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.date_format.html_week',
  'data' => 'a:9:{s:4:"uuid";s:36:"a2e91c79-4092-4c47-94bb-b84041f2b3dc";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"wKD4WsoV_wFgv2vgI4mcAAFSIzrye17ykzdwrnApkfY";}s:2:"id";s:9:"html_week";s:5:"label";s:9:"HTML Week";s:6:"locked";b:1;s:7:"pattern";s:5:"Y-\WW";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.date_format.html_year',
  'data' => 'a:9:{s:4:"uuid";s:36:"0e95ba11-2ad1-4afe-8e2a-05b49c6ee6b9";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"OjekiQuX9RbVQ2_8jOHBL94RgYLePqX7wpfNGgcQzrk";}s:2:"id";s:9:"html_year";s:5:"label";s:9:"HTML Year";s:6:"locked";b:1;s:7:"pattern";s:1:"Y";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.date_format.html_yearless_date',
  'data' => 'a:9:{s:4:"uuid";s:36:"f1c6c204-fc6f-47ab-a5ec-73f2033bdeaf";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"5VpawMrKPEPCkoO4YpPa0TDFO2dgiIHfTziJtwlmUxc";}s:2:"id";s:18:"html_yearless_date";s:5:"label";s:18:"HTML Yearless date";s:6:"locked";b:1;s:7:"pattern";s:3:"m-d";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.date_format.long',
  'data' => 'a:9:{s:4:"uuid";s:36:"1d0b2c03-3a8a-43d2-96d7-85796d902a39";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"og8sWXhBuHbLMw3CoiBEZjgqSyhFBFmcbUW_wLcfNbo";}s:2:"id";s:4:"long";s:5:"label";s:17:"Default long date";s:6:"locked";b:0;s:7:"pattern";s:15:"l, F j, Y - H:i";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.date_format.medium',
  'data' => 'a:9:{s:4:"uuid";s:36:"5b386ae4-5082-4cde-9ec6-6a0a9c1fb723";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"nzL5d024NjXIX_8TlT6uFAu973lmfkmHklJC-2i9rAE";}s:2:"id";s:6:"medium";s:5:"label";s:19:"Default medium date";s:6:"locked";b:0;s:7:"pattern";s:14:"D, m/d/Y - H:i";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.date_format.olivero_medium',
  'data' => 'a:9:{s:4:"uuid";s:36:"2ffba333-ed3b-4e2e-81e7-66b3364aa6bb";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:8:"enforced";a:1:{s:5:"theme";a:1:{i:0;s:7:"olivero";}}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Mt6cmxUbDZ9XxD6p25WQ8tj3_JcX8ylfcddwZc8gcAE";}s:2:"id";s:14:"olivero_medium";s:5:"label";s:14:"Olivero Medium";s:6:"locked";b:0;s:7:"pattern";s:8:"j  F,  Y";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.date_format.short',
  'data' => 'a:9:{s:4:"uuid";s:36:"ee4078e7-1a7f-4492-a2be-63a96add03b9";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"AlzeyytA8InBgxIG9H2UDJYs3CG98Zj6yRsDKmlbZwA";}s:2:"id";s:5:"short";s:5:"label";s:18:"Default short date";s:6:"locked";b:0;s:7:"pattern";s:11:"m/d/Y - H:i";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_form_display.block_content.basic.default',
  'data' => 'a:11:{s:4:"uuid";s:36:"8d2b1728-4a57-4aa8-8653-8d5e9e9fac2d";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:24:"block_content.type.basic";i:1;s:36:"field.field.block_content.basic.body";}s:6:"module";a:1:{i:0;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"jAps3FCxvKecABS_tgExbhCZrBLQB3bNPWw18WjE3ss";}s:2:"id";s:27:"block_content.basic.default";s:16:"targetEntityType";s:13:"block_content";s:6:"bundle";s:5:"basic";s:4:"mode";s:7:"default";s:7:"content";a:2:{s:4:"body";a:5:{s:4:"type";s:26:"text_textarea_with_summary";s:6:"weight";i:-4;s:6:"region";s:7:"content";s:8:"settings";a:4:{s:4:"rows";i:9;s:12:"summary_rows";i:3;s:11:"placeholder";s:0:"";s:12:"show_summary";b:0;}s:20:"third_party_settings";a:0:{}}s:4:"info";a:5:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:-5;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}}s:6:"hidden";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_form_display.comment.comment.default',
  'data' => 'a:11:{s:4:"uuid";s:36:"158b3f10-2979-46bf-83e2-a687c389253c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:20:"comment.type.comment";i:1;s:40:"field.field.comment.comment.comment_body";}s:6:"module";a:1:{i:0;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"I0Pa0aQvT_jawlPo9oz4FE3h_ickc55dYKTPl6gILes";}s:2:"id";s:23:"comment.comment.default";s:16:"targetEntityType";s:7:"comment";s:6:"bundle";s:7:"comment";s:4:"mode";s:7:"default";s:7:"content";a:3:{s:6:"author";a:2:{s:6:"weight";i:-2;s:6:"region";s:7:"content";}s:12:"comment_body";a:5:{s:4:"type";s:13:"text_textarea";s:6:"weight";i:11;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"rows";i:5;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:7:"subject";a:5:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:10;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}}s:6:"hidden";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_form_display.node.article.default',
  'data' => 'a:11:{s:4:"uuid";s:36:"26f84e3c-dce5-445f-bc14-e13f3f3077e0";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:6:{i:0;s:29:"field.field.node.article.body";i:1;s:32:"field.field.node.article.comment";i:2;s:36:"field.field.node.article.field_image";i:3;s:35:"field.field.node.article.field_tags";i:4;s:21:"image.style.thumbnail";i:5;s:17:"node.type.article";}s:6:"module";a:4:{i:0;s:7:"comment";i:1;s:5:"image";i:2;s:4:"path";i:3;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ewbd6G2uX456-bgwseM2Q-KQG3RkASoyHmTh-XR3oLU";}s:2:"id";s:20:"node.article.default";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:7:"article";s:4:"mode";s:7:"default";s:7:"content";a:11:{s:4:"body";a:5:{s:4:"type";s:26:"text_textarea_with_summary";s:6:"weight";i:2;s:6:"region";s:7:"content";s:8:"settings";a:4:{s:4:"rows";i:9;s:12:"summary_rows";i:3;s:11:"placeholder";s:0:"";s:12:"show_summary";b:0;}s:20:"third_party_settings";a:0:{}}s:7:"comment";a:5:{s:4:"type";s:15:"comment_default";s:6:"weight";i:20;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:7:"created";a:5:{s:4:"type";s:18:"datetime_timestamp";s:6:"weight";i:10;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:11:"field_image";a:5:{s:4:"type";s:11:"image_image";s:6:"weight";i:1;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:18:"progress_indicator";s:8:"throbber";s:19:"preview_image_style";s:9:"thumbnail";}s:20:"third_party_settings";a:0:{}}s:10:"field_tags";a:5:{s:4:"type";s:34:"entity_reference_autocomplete_tags";s:6:"weight";i:3;s:6:"region";s:7:"content";s:8:"settings";a:4:{s:14:"match_operator";s:8:"CONTAINS";s:11:"match_limit";i:10;s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:4:"path";a:5:{s:4:"type";s:4:"path";s:6:"weight";i:30;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:7:"promote";a:5:{s:4:"type";s:16:"boolean_checkbox";s:6:"weight";i:15;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:20:"third_party_settings";a:0:{}}s:6:"status";a:5:{s:4:"type";s:16:"boolean_checkbox";s:6:"weight";i:120;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:20:"third_party_settings";a:0:{}}s:6:"sticky";a:5:{s:4:"type";s:16:"boolean_checkbox";s:6:"weight";i:16;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:20:"third_party_settings";a:0:{}}s:5:"title";a:5:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:0;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:3:"uid";a:5:{s:4:"type";s:29:"entity_reference_autocomplete";s:6:"weight";i:5;s:6:"region";s:7:"content";s:8:"settings";a:4:{s:14:"match_operator";s:8:"CONTAINS";s:11:"match_limit";i:10;s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}}s:6:"hidden";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_form_display.node.page.default',
  'data' => 'a:11:{s:4:"uuid";s:36:"5201f1f5-40b8-4a21-bdd8-a74ab02089bc";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:26:"field.field.node.page.body";i:1;s:14:"node.type.page";}s:6:"module";a:2:{i:0;s:4:"path";i:1;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"SfpLhPExzvR0MgFp0Wp7CrmgEnhcqQ-fXIWFhbf4ue0";}s:2:"id";s:17:"node.page.default";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:4:"page";s:4:"mode";s:7:"default";s:7:"content";a:8:{s:4:"body";a:5:{s:4:"type";s:26:"text_textarea_with_summary";s:6:"weight";i:31;s:6:"region";s:7:"content";s:8:"settings";a:4:{s:4:"rows";i:9;s:12:"summary_rows";i:3;s:11:"placeholder";s:0:"";s:12:"show_summary";b:0;}s:20:"third_party_settings";a:0:{}}s:7:"created";a:5:{s:4:"type";s:18:"datetime_timestamp";s:6:"weight";i:10;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:4:"path";a:5:{s:4:"type";s:4:"path";s:6:"weight";i:30;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:7:"promote";a:5:{s:4:"type";s:16:"boolean_checkbox";s:6:"weight";i:15;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:20:"third_party_settings";a:0:{}}s:6:"status";a:5:{s:4:"type";s:16:"boolean_checkbox";s:6:"weight";i:120;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:20:"third_party_settings";a:0:{}}s:6:"sticky";a:5:{s:4:"type";s:16:"boolean_checkbox";s:6:"weight";i:16;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:20:"third_party_settings";a:0:{}}s:5:"title";a:5:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:-5;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:3:"uid";a:5:{s:4:"type";s:29:"entity_reference_autocomplete";s:6:"weight";i:5;s:6:"region";s:7:"content";s:8:"settings";a:4:{s:14:"match_operator";s:8:"CONTAINS";s:11:"match_limit";i:10;s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}}s:6:"hidden";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_form_display.user.user.default',
  'data' => 'a:11:{s:4:"uuid";s:36:"496aaf84-ad4d-4013-9c17-a9cda437272b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:34:"field.field.user.user.user_picture";i:1;s:21:"image.style.thumbnail";}s:6:"module";a:2:{i:0;s:5:"image";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"FaQ9Ptcpxpg30AtiqRDtl_8zbJArHP1LPfug_s59TOA";}s:2:"id";s:17:"user.user.default";s:16:"targetEntityType";s:4:"user";s:6:"bundle";s:4:"user";s:4:"mode";s:7:"default";s:7:"content";a:5:{s:7:"account";a:2:{s:6:"weight";i:-10;s:6:"region";s:7:"content";}s:7:"contact";a:2:{s:6:"weight";i:5;s:6:"region";s:7:"content";}s:8:"language";a:2:{s:6:"weight";i:0;s:6:"region";s:7:"content";}s:8:"timezone";a:2:{s:6:"weight";i:6;s:6:"region";s:7:"content";}s:12:"user_picture";a:5:{s:4:"type";s:11:"image_image";s:6:"weight";i:-1;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:18:"progress_indicator";s:8:"throbber";s:19:"preview_image_style";s:9:"thumbnail";}s:20:"third_party_settings";a:0:{}}}s:6:"hidden";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_form_mode.user.register',
  'data' => 'a:9:{s:4:"uuid";s:36:"dc755c05-6c79-41b9-a243-27bad6080f38";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"flXhTcp55yLcyy7ZLOhPGKGZobZQJdkAFVWV3LseiuI";}s:2:"id";s:13:"user.register";s:5:"label";s:8:"Register";s:16:"targetEntityType";s:4:"user";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.block_content.basic.default',
  'data' => 'a:11:{s:4:"uuid";s:36:"32412924-bff8-41a6-bf40-dab1e7e643e3";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:24:"block_content.type.basic";i:1;s:36:"field.field.block_content.basic.body";}s:6:"module";a:1:{i:0;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"hBNNDTFwakREOTa6GGMqN899Iyrii0hInwSJtQ7Kj30";}s:2:"id";s:27:"block_content.basic.default";s:16:"targetEntityType";s:13:"block_content";s:6:"bundle";s:5:"basic";s:4:"mode";s:7:"default";s:7:"content";a:1:{s:4:"body";a:6:{s:4:"type";s:12:"text_default";s:5:"label";s:6:"hidden";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}}s:6:"hidden";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.comment.comment.default',
  'data' => 'a:11:{s:4:"uuid";s:36:"294f8feb-b408-4d00-995c-e1d58f72e00b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:20:"comment.type.comment";i:1;s:40:"field.field.comment.comment.comment_body";}s:6:"module";a:1:{i:0;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"aBQUGsQ46M4048fIlFuTXwl2zV0j2cJX89CTUobh9hA";}s:2:"id";s:23:"comment.comment.default";s:16:"targetEntityType";s:7:"comment";s:6:"bundle";s:7:"comment";s:4:"mode";s:7:"default";s:7:"content";a:2:{s:12:"comment_body";a:6:{s:4:"type";s:12:"text_default";s:5:"label";s:6:"hidden";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}s:5:"links";a:2:{s:6:"weight";i:100;s:6:"region";s:7:"content";}}s:6:"hidden";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.node.article.default',
  'data' => 'a:11:{s:4:"uuid";s:36:"69b0f199-ad2a-49cd-9dd7-89dd23c5b66c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:7:{i:0;s:48:"core.entity_view_display.comment.comment.default";i:1;s:29:"field.field.node.article.body";i:2;s:32:"field.field.node.article.comment";i:3;s:36:"field.field.node.article.field_image";i:4;s:35:"field.field.node.article.field_tags";i:5;s:16:"image.style.wide";i:6;s:17:"node.type.article";}s:6:"module";a:4:{i:0;s:7:"comment";i:1;s:5:"image";i:2;s:4:"text";i:3;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"7fb0j9HnIXfP9ndewzgPPzzeX_SV532wuYpkscrCMCk";}s:2:"id";s:20:"node.article.default";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:7:"article";s:4:"mode";s:7:"default";s:7:"content";a:5:{s:4:"body";a:6:{s:4:"type";s:12:"text_default";s:5:"label";s:6:"hidden";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}s:7:"comment";a:6:{s:4:"type";s:15:"comment_default";s:5:"label";s:5:"above";s:8:"settings";a:2:{s:9:"view_mode";s:7:"default";s:8:"pager_id";i:0;}s:20:"third_party_settings";a:0:{}s:6:"weight";i:110;s:6:"region";s:7:"content";}s:11:"field_image";a:6:{s:4:"type";s:5:"image";s:5:"label";s:6:"hidden";s:8:"settings";a:3:{s:11:"image_style";s:4:"wide";s:10:"image_link";s:0:"";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:-1;s:6:"region";s:7:"content";}s:10:"field_tags";a:6:{s:4:"type";s:22:"entity_reference_label";s:5:"label";s:5:"above";s:8:"settings";a:1:{s:4:"link";b:1;}s:20:"third_party_settings";a:0:{}s:6:"weight";i:10;s:6:"region";s:7:"content";}s:5:"links";a:4:{s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:6:"weight";i:100;s:6:"region";s:7:"content";}}s:6:"hidden";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.node.article.rss',
  'data' => 'a:11:{s:4:"uuid";s:36:"90156650-0cc9-4125-97fe-0479950a9551";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:6:{i:0;s:30:"core.entity_view_mode.node.rss";i:1;s:29:"field.field.node.article.body";i:2;s:32:"field.field.node.article.comment";i:3;s:36:"field.field.node.article.field_image";i:4;s:35:"field.field.node.article.field_tags";i:5;s:17:"node.type.article";}s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"2rIr6K5Q0UQ9khg0zE_CK-PtJH76UL-BDDZcZnZzwCc";}s:2:"id";s:16:"node.article.rss";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:7:"article";s:4:"mode";s:3:"rss";s:7:"content";a:1:{s:5:"links";a:2:{s:6:"weight";i:100;s:6:"region";s:7:"content";}}s:6:"hidden";a:4:{s:4:"body";b:1;s:7:"comment";b:1;s:11:"field_image";b:1;s:10:"field_tags";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.node.article.teaser',
  'data' => 'a:11:{s:4:"uuid";s:36:"afa608b4-006c-42dd-9afa-43f3c16ef7cd";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:7:{i:0;s:33:"core.entity_view_mode.node.teaser";i:1;s:29:"field.field.node.article.body";i:2;s:32:"field.field.node.article.comment";i:3;s:36:"field.field.node.article.field_image";i:4;s:35:"field.field.node.article.field_tags";i:5;s:18:"image.style.medium";i:6;s:17:"node.type.article";}s:6:"module";a:3:{i:0;s:5:"image";i:1;s:4:"text";i:2;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"83jX5ChAGdMzOxiDA_B1NjgebVMuD8lNVDgClg_QVP8";}s:2:"id";s:19:"node.article.teaser";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:7:"article";s:4:"mode";s:6:"teaser";s:7:"content";a:4:{s:4:"body";a:6:{s:4:"type";s:23:"text_summary_or_trimmed";s:5:"label";s:6:"hidden";s:8:"settings";a:1:{s:11:"trim_length";i:600;}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}s:11:"field_image";a:6:{s:4:"type";s:5:"image";s:5:"label";s:6:"hidden";s:8:"settings";a:3:{s:11:"image_style";s:6:"medium";s:10:"image_link";s:7:"content";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:-1;s:6:"region";s:7:"content";}s:10:"field_tags";a:6:{s:4:"type";s:22:"entity_reference_label";s:5:"label";s:5:"above";s:8:"settings";a:1:{s:4:"link";b:1;}s:20:"third_party_settings";a:0:{}s:6:"weight";i:10;s:6:"region";s:7:"content";}s:5:"links";a:2:{s:6:"weight";i:100;s:6:"region";s:7:"content";}}s:6:"hidden";a:3:{s:7:"comment";b:1;s:11:"field_image";b:1;s:10:"field_tags";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.node.page.default',
  'data' => 'a:11:{s:4:"uuid";s:36:"3df1c635-9a37-4ebd-b6ac-d6c576bf5c93";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:26:"field.field.node.page.body";i:1;s:14:"node.type.page";}s:6:"module";a:2:{i:0;s:4:"text";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"M_Y8L5tfmhx7DR143E05YyZSpvgil6VFvqcfBWykalg";}s:2:"id";s:17:"node.page.default";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:4:"page";s:4:"mode";s:7:"default";s:7:"content";a:2:{s:4:"body";a:6:{s:4:"type";s:12:"text_default";s:5:"label";s:6:"hidden";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:6:"weight";i:100;s:6:"region";s:7:"content";}s:5:"links";a:2:{s:6:"weight";i:101;s:6:"region";s:7:"content";}}s:6:"hidden";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.node.page.teaser',
  'data' => 'a:11:{s:4:"uuid";s:36:"7b67ecbf-72bd-4e61-b6a8-9f382e2c171c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:3:{i:0;s:33:"core.entity_view_mode.node.teaser";i:1;s:26:"field.field.node.page.body";i:2;s:14:"node.type.page";}s:6:"module";a:2:{i:0;s:4:"text";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"8BgdRtLbtQ0F__o0FHSH0Mx5fvXOra9tfT1GmNKbRYw";}s:2:"id";s:16:"node.page.teaser";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:4:"page";s:4:"mode";s:6:"teaser";s:7:"content";a:2:{s:4:"body";a:6:{s:4:"type";s:23:"text_summary_or_trimmed";s:5:"label";s:6:"hidden";s:8:"settings";a:1:{s:11:"trim_length";i:600;}s:20:"third_party_settings";a:0:{}s:6:"weight";i:100;s:6:"region";s:7:"content";}s:5:"links";a:2:{s:6:"weight";i:101;s:6:"region";s:7:"content";}}s:6:"hidden";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.user.user.compact',
  'data' => 'a:11:{s:4:"uuid";s:36:"7d171050-f25c-46c6-bebb-7677d4567e18";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:3:{i:0;s:34:"core.entity_view_mode.user.compact";i:1;s:34:"field.field.user.user.user_picture";i:2;s:21:"image.style.thumbnail";}s:6:"module";a:2:{i:0;s:5:"image";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"00zr_RBdTjPjBGITD3h4c1ESQZimjdVCcHGt1trLqIY";}s:2:"id";s:17:"user.user.compact";s:16:"targetEntityType";s:4:"user";s:6:"bundle";s:4:"user";s:4:"mode";s:7:"compact";s:7:"content";a:1:{s:12:"user_picture";a:6:{s:4:"type";s:5:"image";s:5:"label";s:6:"hidden";s:8:"settings";a:3:{s:11:"image_style";s:9:"thumbnail";s:10:"image_link";s:7:"content";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}}s:6:"hidden";a:1:{s:10:"member_for";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.user.user.default',
  'data' => 'a:11:{s:4:"uuid";s:36:"7ca019af-f9a1-42bb-9a97-2b075fd770ea";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:34:"field.field.user.user.user_picture";i:1;s:21:"image.style.thumbnail";}s:6:"module";a:2:{i:0;s:5:"image";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"mZLyuWM9CQx2ZJVqFGSbzgFnHzudVbHBYmdU256A5Wk";}s:2:"id";s:17:"user.user.default";s:16:"targetEntityType";s:4:"user";s:6:"bundle";s:4:"user";s:4:"mode";s:7:"default";s:7:"content";a:2:{s:10:"member_for";a:2:{s:6:"weight";i:5;s:6:"region";s:7:"content";}s:12:"user_picture";a:6:{s:4:"type";s:5:"image";s:5:"label";s:6:"hidden";s:8:"settings";a:3:{s:11:"image_style";s:9:"thumbnail";s:10:"image_link";s:7:"content";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}}s:6:"hidden";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.block_content.full',
  'data' => 'a:9:{s:4:"uuid";s:36:"5c5c9306-d386-4ecc-ae0d-629535b0c29f";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:13:"block_content";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"4tedlMuvQjDOdvHdw86_e-2Rt78aR7TGFMfOK8Ejppg";}s:2:"id";s:18:"block_content.full";s:5:"label";s:4:"Full";s:16:"targetEntityType";s:13:"block_content";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.comment.full',
  'data' => 'a:9:{s:4:"uuid";s:36:"388d609f-5453-4e15-b2f5-83a72ae546d7";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:7:"comment";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"K7eNlfU7NEUajz01wItywZklr2oaPgL6s1_97fmDXLA";}s:2:"id";s:12:"comment.full";s:5:"label";s:12:"Full comment";s:16:"targetEntityType";s:7:"comment";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.node.full',
  'data' => 'a:9:{s:4:"uuid";s:36:"249d4400-885a-4003-be6e-9353dd5fc4c7";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ElrtInxGjZd7GaapJ5O9n-ugi2hG2IxFivtgn0tHOsk";}s:2:"id";s:9:"node.full";s:5:"label";s:12:"Full content";s:16:"targetEntityType";s:4:"node";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.node.rss',
  'data' => 'a:9:{s:4:"uuid";s:36:"86d20921-4629-4162-b3a5-419cfb9af234";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"vlYzr-rp2f9NMp-Qlr4sFjlqRq-90mco5-afLNGwCrU";}s:2:"id";s:8:"node.rss";s:5:"label";s:3:"RSS";s:16:"targetEntityType";s:4:"node";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.node.search_index',
  'data' => 'a:9:{s:4:"uuid";s:36:"4a18b620-3934-406b-b0a3-b181e5e7671a";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"fVFfJv_GzBRE-wpRHbfD5a3VjnhbEOXG6lvRd3uaccY";}s:2:"id";s:17:"node.search_index";s:5:"label";s:12:"Search index";s:16:"targetEntityType";s:4:"node";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.node.search_result',
  'data' => 'a:9:{s:4:"uuid";s:36:"1b99a673-7dd1-4f63-bac1-c08068a1dcea";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"6GCOQ-jP2RbdbHA5YWQ6bT8CfGbqrBYKOSC_XY4E3ZM";}s:2:"id";s:18:"node.search_result";s:5:"label";s:32:"Search result highlighting input";s:16:"targetEntityType";s:4:"node";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.node.teaser',
  'data' => 'a:9:{s:4:"uuid";s:36:"c641d165-0cb4-467c-8aa6-54ac4ffe62d7";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Mz9qWr1kUYK0mjRAGDsr5XS6PvtZ24en_7ndt-pyWe4";}s:2:"id";s:11:"node.teaser";s:5:"label";s:6:"Teaser";s:16:"targetEntityType";s:4:"node";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.taxonomy_term.full',
  'data' => 'a:9:{s:4:"uuid";s:36:"f35baadd-bd61-488f-9032-b91176c3235e";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:8:"taxonomy";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"-PPKjsNQPvoIDjOuUAvlLocYD976MNjb9Zpgyz5_BWE";}s:2:"id";s:18:"taxonomy_term.full";s:5:"label";s:18:"Taxonomy term page";s:16:"targetEntityType";s:13:"taxonomy_term";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.user.compact',
  'data' => 'a:9:{s:4:"uuid";s:36:"463b7949-5ecc-4fb2-b674-45dee5f906fb";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"71CSAr_LNPcgu6D6jI4INl1KATkahmeyUFBETAWya8g";}s:2:"id";s:12:"user.compact";s:5:"label";s:7:"Compact";s:16:"targetEntityType";s:4:"user";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.user.full',
  'data' => 'a:9:{s:4:"uuid";s:36:"089bb350-b28f-4432-a8e7-c057202d6250";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"mQIF_foYjmnVSr9MpcD4CTaJE_FpO1AyDd_DskztGhM";}s:2:"id";s:9:"user.full";s:5:"label";s:12:"User account";s:16:"targetEntityType";s:4:"user";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.extension',
  'data' => 'a:4:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"R4IF-ClDHXxblLcG0L7MgsLvfBIMAvi_skumNFQwkDc";}s:6:"module";a:45:{s:14:"automated_cron";i:0;s:8:"big_pipe";i:0;s:5:"block";i:0;s:13:"block_content";i:0;s:10:"breakpoint";i:0;s:9:"ckeditor5";i:0;s:7:"comment";i:0;s:6:"config";i:0;s:7:"contact";i:0;s:10:"contextual";i:0;s:8:"datetime";i:0;s:18:"dynamic_page_cache";i:0;s:6:"editor";i:0;s:5:"field";i:0;s:8:"field_ui";i:0;s:4:"file";i:0;s:6:"filter";i:0;s:4:"help";i:0;s:7:"history";i:0;s:5:"image";i:0;s:4:"link";i:0;s:17:"menu_link_content";i:0;s:7:"menu_ui";i:0;s:5:"mysql";i:0;s:4:"node";i:0;s:7:"options";i:0;s:10:"page_cache";i:0;s:4:"path";i:0;s:10:"path_alias";i:0;s:11:"rabbit_hole";i:0;s:7:"rh_node";i:0;s:11:"rh_taxonomy";i:0;s:7:"rh_user";i:0;s:6:"search";i:0;s:8:"shortcut";i:0;s:6:"system";i:0;s:8:"taxonomy";i:0;s:4:"text";i:0;s:7:"toolbar";i:0;s:4:"tour";i:0;s:6:"update";i:0;s:4:"user";i:0;s:8:"views_ui";i:0;s:5:"views";i:10;s:8:"standard";i:1000;}s:5:"theme";a:2:{s:7:"olivero";i:0;s:5:"claro";i:0;}s:7:"profile";s:8:"standard";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.menu.static_menu_link_overrides',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"CXhei_vpaZk-3f_Mj2cH0YmpK-ZpKHoSzVA3yZrDq0g";}s:11:"definitions";a:1:{s:18:"contact__site_page";a:5:{s:9:"menu_name";s:6:"footer";s:6:"parent";s:0:"";s:6:"weight";i:0;s:8:"expanded";b:0;s:7:"enabled";b:1;}}}',
))
->values(array(
  'collection' => '',
  'name' => 'editor.editor.basic_html',
  'data' => 'a:9:{s:4:"uuid";s:36:"33fdf202-e530-4ad5-b69d-f1637f4f601b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:24:"filter.format.basic_html";}s:6:"module";a:1:{i:0;s:9:"ckeditor5";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"uXAqOeMiQVnzE5yk7-v1DsBagmkCI2h_q5WAf0bir-o";}s:6:"format";s:10:"basic_html";s:6:"editor";s:9:"ckeditor5";s:8:"settings";a:2:{s:7:"toolbar";a:1:{s:5:"items";a:15:{i:0;s:4:"bold";i:1;s:6:"italic";i:2;s:1:"|";i:3;s:4:"link";i:4;s:1:"|";i:5;s:12:"bulletedList";i:6;s:12:"numberedList";i:7;s:1:"|";i:8;s:10:"blockQuote";i:9;s:17:"drupalInsertImage";i:10;s:1:"|";i:11;s:7:"heading";i:12;s:4:"code";i:13;s:1:"|";i:14;s:13:"sourceEditing";}}s:7:"plugins";a:4:{s:17:"ckeditor5_heading";a:1:{s:16:"enabled_headings";a:5:{i:0;s:8:"heading2";i:1;s:8:"heading3";i:2;s:8:"heading4";i:3;s:8:"heading5";i:4;s:8:"heading6";}}s:23:"ckeditor5_sourceEditing";a:1:{s:12:"allowed_tags";a:13:{i:0;s:6:"<cite>";i:1;s:4:"<dl>";i:2;s:4:"<dt>";i:3;s:4:"<dd>";i:4;s:12:"<a hreflang>";i:5;s:17:"<blockquote cite>";i:6;s:9:"<ul type>";i:7;s:15:"<ol start type>";i:8;s:7:"<h2 id>";i:9;s:7:"<h3 id>";i:10;s:7:"<h4 id>";i:11;s:7:"<h5 id>";i:12;s:7:"<h6 id>";}}s:14:"ckeditor5_list";a:2:{s:8:"reversed";b:0;s:10:"startIndex";b:1;}s:21:"ckeditor5_imageResize";a:1:{s:12:"allow_resize";b:1;}}}s:12:"image_upload";a:5:{s:6:"status";b:1;s:6:"scheme";s:6:"public";s:9:"directory";s:13:"inline-images";s:8:"max_size";s:0:"";s:14:"max_dimensions";a:2:{s:5:"width";i:0;s:6:"height";i:0;}}}',
))
->values(array(
  'collection' => '',
  'name' => 'editor.editor.full_html',
  'data' => 'a:9:{s:4:"uuid";s:36:"9fcb2e7a-0370-490c-a98b-4c44279d3f17";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:23:"filter.format.full_html";}s:6:"module";a:1:{i:0;s:9:"ckeditor5";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"a0UeuvbLLshU7EeXK0lLcsZYdDuR4ByvaYRhrX_84mo";}s:6:"format";s:9:"full_html";s:6:"editor";s:9:"ckeditor5";s:8:"settings";a:2:{s:7:"toolbar";a:1:{s:5:"items";a:21:{i:0;s:4:"bold";i:1;s:6:"italic";i:2;s:13:"strikethrough";i:3;s:11:"superscript";i:4;s:9:"subscript";i:5;s:12:"removeFormat";i:6;s:1:"|";i:7;s:4:"link";i:8;s:1:"|";i:9;s:12:"bulletedList";i:10;s:12:"numberedList";i:11;s:1:"|";i:12;s:10:"blockQuote";i:13;s:17:"drupalInsertImage";i:14;s:11:"insertTable";i:15;s:14:"horizontalLine";i:16;s:1:"|";i:17;s:7:"heading";i:18;s:9:"codeBlock";i:19;s:1:"|";i:20;s:13:"sourceEditing";}}s:7:"plugins";a:4:{s:17:"ckeditor5_heading";a:1:{s:16:"enabled_headings";a:5:{i:0;s:8:"heading2";i:1;s:8:"heading3";i:2;s:8:"heading4";i:3;s:8:"heading5";i:4;s:8:"heading6";}}s:23:"ckeditor5_sourceEditing";a:1:{s:12:"allowed_tags";a:0:{}}s:14:"ckeditor5_list";a:2:{s:8:"reversed";b:1;s:10:"startIndex";b:1;}s:21:"ckeditor5_imageResize";a:1:{s:12:"allow_resize";b:1;}}}s:12:"image_upload";a:5:{s:6:"status";b:1;s:6:"scheme";s:6:"public";s:9:"directory";s:13:"inline-images";s:8:"max_size";s:0:"";s:14:"max_dimensions";a:2:{s:5:"width";i:0;s:6:"height";i:0;}}}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.block_content.basic.body',
  'data' => 'a:17:{s:4:"uuid";s:36:"74c9a038-e5bd-4c2f-bca4-bad616e68cc4";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:24:"block_content.type.basic";i:1;s:32:"field.storage.block_content.body";}s:6:"module";a:1:{i:0;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"foetbaMhlB6uLc2bn-PESvaPkbuDWj0MEjpQVwQiP-o";}s:2:"id";s:24:"block_content.basic.body";s:10:"field_name";s:4:"body";s:11:"entity_type";s:13:"block_content";s:6:"bundle";s:5:"basic";s:5:"label";s:4:"Body";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:2:{s:15:"display_summary";b:0;s:16:"required_summary";b:0;}s:10:"field_type";s:17:"text_with_summary";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.comment.comment.comment_body',
  'data' => 'a:17:{s:4:"uuid";s:36:"31a4fe58-da46-43bf-9a6e-5da5c546443b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:20:"comment.type.comment";i:1;s:34:"field.storage.comment.comment_body";}s:6:"module";a:1:{i:0;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"TmAKjNrJ7RR60YpqvJq_QqEewYe_S8Kd23n8VRCqiWs";}s:2:"id";s:28:"comment.comment.comment_body";s:10:"field_name";s:12:"comment_body";s:11:"entity_type";s:7:"comment";s:6:"bundle";s:7:"comment";s:5:"label";s:7:"Comment";s:11:"description";s:0:"";s:8:"required";b:1;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:0:{}s:10:"field_type";s:9:"text_long";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.node.article.body',
  'data' => 'a:17:{s:4:"uuid";s:36:"21a0f353-84ac-403b-9f0b-6348ce0bbfd9";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:23:"field.storage.node.body";i:1;s:17:"node.type.article";}s:6:"module";a:1:{i:0;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"IjZnOLWk1Pjq3WRg2pLSA1ERh7Po7izCq_p6UztZr2c";}s:2:"id";s:17:"node.article.body";s:10:"field_name";s:4:"body";s:11:"entity_type";s:4:"node";s:6:"bundle";s:7:"article";s:5:"label";s:4:"Body";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:2:{s:15:"display_summary";b:1;s:16:"required_summary";b:0;}s:10:"field_type";s:17:"text_with_summary";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.node.article.comment',
  'data' => 'a:17:{s:4:"uuid";s:36:"d590a738-36b2-4e12-a222-2b905172c780";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:26:"field.storage.node.comment";i:1;s:17:"node.type.article";}s:6:"module";a:1:{i:0;s:7:"comment";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"UqXlkKC4v2-bDfWx4zcXQrD5YIi3d5byENEmWv-G_Uc";}s:2:"id";s:20:"node.article.comment";s:10:"field_name";s:7:"comment";s:11:"entity_type";s:4:"node";s:6:"bundle";s:7:"article";s:5:"label";s:8:"Comments";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:1;s:13:"default_value";a:1:{i:0;a:6:{s:6:"status";i:2;s:3:"cid";i:0;s:22:"last_comment_timestamp";i:0;s:17:"last_comment_name";N;s:16:"last_comment_uid";i:0;s:13:"comment_count";i:0;}}s:22:"default_value_callback";s:0:"";s:8:"settings";a:5:{s:12:"default_mode";i:1;s:8:"per_page";i:50;s:9:"anonymous";i:0;s:13:"form_location";b:1;s:7:"preview";i:1;}s:10:"field_type";s:7:"comment";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.node.article.field_image',
  'data' => 'a:17:{s:4:"uuid";s:36:"c55d79f2-3363-4976-ad22-e6cf221920d7";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:30:"field.storage.node.field_image";i:1;s:17:"node.type.article";}s:6:"module";a:1:{i:0;s:5:"image";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"PmVL51L3A9QGbPLoeLHw5epAPszeZRasCeC3imeeDRQ";}s:2:"id";s:24:"node.article.field_image";s:10:"field_name";s:11:"field_image";s:11:"entity_type";s:4:"node";s:6:"bundle";s:7:"article";s:5:"label";s:5:"Image";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:12:{s:7:"handler";s:12:"default:file";s:16:"handler_settings";a:0:{}s:14:"file_directory";s:31:"[date:custom:Y]-[date:custom:m]";s:15:"file_extensions";s:16:"png gif jpg jpeg";s:12:"max_filesize";s:0:"";s:14:"max_resolution";s:0:"";s:14:"min_resolution";s:0:"";s:9:"alt_field";b:1;s:18:"alt_field_required";b:1;s:11:"title_field";b:0;s:20:"title_field_required";b:0;s:13:"default_image";a:5:{s:4:"uuid";N;s:3:"alt";s:0:"";s:5:"title";s:0:"";s:5:"width";N;s:6:"height";N;}}s:10:"field_type";s:5:"image";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.node.article.field_tags',
  'data' => 'a:17:{s:4:"uuid";s:36:"9bd4733c-d1c9-4fee-9639-cc1cdb8fdcb5";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:3:{i:0;s:29:"field.storage.node.field_tags";i:1;s:17:"node.type.article";i:2;s:24:"taxonomy.vocabulary.tags";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"QdUgf_beeoaPiyKorFv0q1fcJpWH_uZTqe_xoVJacrw";}s:2:"id";s:23:"node.article.field_tags";s:10:"field_name";s:10:"field_tags";s:11:"entity_type";s:4:"node";s:6:"bundle";s:7:"article";s:5:"label";s:4:"Tags";s:11:"description";s:84:"Enter a comma-separated list. For example: Amsterdam, Mexico City, "Cleveland, Ohio"";s:8:"required";b:0;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:2:{s:7:"handler";s:21:"default:taxonomy_term";s:16:"handler_settings";a:3:{s:14:"target_bundles";a:1:{s:4:"tags";s:4:"tags";}s:4:"sort";a:1:{s:5:"field";s:5:"_none";}s:11:"auto_create";b:1;}}s:10:"field_type";s:16:"entity_reference";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.node.page.body',
  'data' => 'a:17:{s:4:"uuid";s:36:"804a65de-765e-44f6-acf7-20a8d53490ea";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:23:"field.storage.node.body";i:1;s:14:"node.type.page";}s:6:"module";a:1:{i:0;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"KgVkxLl_K3E3lvN6CEoWQIDT0V8J4Mv-fVYrAIc7-FE";}s:2:"id";s:14:"node.page.body";s:10:"field_name";s:4:"body";s:11:"entity_type";s:4:"node";s:6:"bundle";s:4:"page";s:5:"label";s:4:"Body";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:2:{s:15:"display_summary";b:1;s:16:"required_summary";b:0;}s:10:"field_type";s:17:"text_with_summary";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.user.user.user_picture',
  'data' => 'a:17:{s:4:"uuid";s:36:"797c8e1a-df33-4a40-b28b-5b924085355e";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:31:"field.storage.user.user_picture";}s:6:"module";a:2:{i:0;s:5:"image";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"twhm-ZOwSVkUjuLI_pQsaPo_pVLcqFfDmY-ojfqw0yk";}s:2:"id";s:22:"user.user.user_picture";s:10:"field_name";s:12:"user_picture";s:11:"entity_type";s:4:"user";s:6:"bundle";s:4:"user";s:5:"label";s:7:"Picture";s:11:"description";s:29:"Your virtual face or picture.";s:8:"required";b:0;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:12:{s:7:"handler";s:12:"default:file";s:16:"handler_settings";a:0:{}s:14:"file_directory";s:40:"pictures/[date:custom:Y]-[date:custom:m]";s:15:"file_extensions";s:16:"png gif jpg jpeg";s:12:"max_filesize";s:0:"";s:14:"max_resolution";s:0:"";s:14:"min_resolution";s:0:"";s:9:"alt_field";b:0;s:18:"alt_field_required";b:0;s:11:"title_field";b:0;s:20:"title_field_required";b:0;s:13:"default_image";a:5:{s:4:"uuid";N;s:3:"alt";s:0:"";s:5:"title";s:0:"";s:5:"width";N;s:6:"height";N;}}s:10:"field_type";s:5:"image";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.settings',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"nJk0TAQBzlNo52ehiHI7bIEPLGi0BYqZvPdEn7Chfu0";}s:16:"purge_batch_size";i:50;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.block_content.body',
  'data' => 'a:17:{s:4:"uuid";s:36:"06af7efe-abc6-42ea-969f-6cfc97601d94";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:13:"block_content";i:1;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"eS0snV_L3dx9shtWRTzm5eblwOJ7qKWC9IE-4GMTDFc";}s:2:"id";s:18:"block_content.body";s:10:"field_name";s:4:"body";s:11:"entity_type";s:13:"block_content";s:4:"type";s:17:"text_with_summary";s:8:"settings";a:0:{}s:6:"module";s:4:"text";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:1;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.comment.comment_body',
  'data' => 'a:17:{s:4:"uuid";s:36:"c566e36b-0afb-40b2-9595-e249ba88a889";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:7:"comment";i:1;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"swYoCch_hY8QO5uwr4FURplfnUCUlpPB4idF8WGVCpw";}s:2:"id";s:20:"comment.comment_body";s:10:"field_name";s:12:"comment_body";s:11:"entity_type";s:7:"comment";s:4:"type";s:9:"text_long";s:8:"settings";a:0:{}s:6:"module";s:4:"text";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:1;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.node.body',
  'data' => 'a:17:{s:4:"uuid";s:36:"1eeb692d-16be-477f-8383-3f6355004254";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:4:"node";i:1;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"EBUo7qOWqaiZaQ_RC9sLY5IoDKphS34v77VIHSACmVY";}s:2:"id";s:9:"node.body";s:10:"field_name";s:4:"body";s:11:"entity_type";s:4:"node";s:4:"type";s:17:"text_with_summary";s:8:"settings";a:0:{}s:6:"module";s:4:"text";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:1;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.node.comment',
  'data' => 'a:17:{s:4:"uuid";s:36:"dbdd39c4-d17a-4c5f-be9e-9db9a64027de";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:7:"comment";i:1;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ktCna9xmWvYZIUfOCUyDQvedn5RtnS4CRmEIwNmvYjc";}s:2:"id";s:12:"node.comment";s:10:"field_name";s:7:"comment";s:11:"entity_type";s:4:"node";s:4:"type";s:7:"comment";s:8:"settings";a:1:{s:12:"comment_type";s:7:"comment";}s:6:"module";s:7:"comment";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.node.field_image',
  'data' => 'a:17:{s:4:"uuid";s:36:"3f70cbf2-e4e2-4352-ae29-e8696da9eeb2";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:3:{i:0;s:4:"file";i:1;s:5:"image";i:2;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"EymokncRIZ7SgQT2IdOQhQJicX4nNc0K89ik-LxmOHE";}s:2:"id";s:16:"node.field_image";s:10:"field_name";s:11:"field_image";s:11:"entity_type";s:4:"node";s:4:"type";s:5:"image";s:8:"settings";a:5:{s:11:"target_type";s:4:"file";s:13:"display_field";b:0;s:15:"display_default";b:0;s:10:"uri_scheme";s:6:"public";s:13:"default_image";a:5:{s:4:"uuid";N;s:3:"alt";s:0:"";s:5:"title";s:0:"";s:5:"width";N;s:6:"height";N;}}s:6:"module";s:5:"image";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.node.field_tags',
  'data' => 'a:17:{s:4:"uuid";s:36:"5ed462ff-240c-4675-aa57-4bb7dc3d064e";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:4:"node";i:1;s:8:"taxonomy";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"WpOE_bs8Bs_HY2ns7n2r__de-xno0-Bxkqep5-MsHAs";}s:2:"id";s:15:"node.field_tags";s:10:"field_name";s:10:"field_tags";s:11:"entity_type";s:4:"node";s:4:"type";s:16:"entity_reference";s:8:"settings";a:1:{s:11:"target_type";s:13:"taxonomy_term";}s:6:"module";s:4:"core";s:6:"locked";b:0;s:11:"cardinality";i:-1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.user.user_picture',
  'data' => 'a:17:{s:4:"uuid";s:36:"b3e256f3-94df-4903-8aa5-5a0cb456ed71";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:3:{i:0;s:4:"file";i:1;s:5:"image";i:2;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"0q8-mw8y-Ls5I578sIPQFLp4ljpH7WvVYpzY-I9O-8E";}s:2:"id";s:17:"user.user_picture";s:10:"field_name";s:12:"user_picture";s:11:"entity_type";s:4:"user";s:4:"type";s:5:"image";s:8:"settings";a:5:{s:11:"target_type";s:4:"file";s:13:"display_field";b:0;s:15:"display_default";b:0;s:10:"uri_scheme";s:6:"public";s:13:"default_image";a:5:{s:4:"uuid";N;s:3:"alt";s:0:"";s:5:"title";s:0:"";s:5:"width";N;s:6:"height";N;}}s:6:"module";s:5:"image";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field_ui.settings',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Q1nMi90W6YQxKzZAgJQw7Ag9U4JrsEUwkomF0lhvbIM";}s:12:"field_prefix";s:6:"field_";}',
))
->values(array(
  'collection' => '',
  'name' => 'file.settings',
  'data' => 'a:4:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"0aMkoXYnax5_tHI9C9zHs-K48KJ6K75PHtD9x-0nbgM";}s:11:"description";a:2:{s:4:"type";s:9:"textfield";s:6:"length";i:128;}s:4:"icon";a:1:{s:9:"directory";s:23:"core/modules/file/icons";}s:35:"make_unused_managed_files_temporary";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'filter.format.basic_html',
  'data' => 'a:9:{s:4:"uuid";s:36:"fff73a0c-209f-4629-85ea-a4a703c8df26";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:6:"editor";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"RjoJPQLCAE8u1Ys_yCKubpkYlRz_Oy12a5qCVeNIHJ8";}s:4:"name";s:10:"Basic HTML";s:6:"format";s:10:"basic_html";s:6:"weight";i:0;s:7:"filters";a:5:{s:11:"filter_html";a:5:{s:2:"id";s:11:"filter_html";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:-10;s:8:"settings";a:3:{s:12:"allowed_html";s:243:"<br> <p> <h2 id> <h3 id> <h4 id> <h5 id> <h6 id> <cite> <dl> <dt> <dd> <a hreflang href> <blockquote cite> <ul type> <ol start type> <strong> <em> <code> <li> <img src alt data-entity-uuid data-entity-type height width data-caption data-align>";s:16:"filter_html_help";b:0;s:20:"filter_html_nofollow";b:0;}}s:12:"filter_align";a:5:{s:2:"id";s:12:"filter_align";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:7;s:8:"settings";a:0:{}}s:14:"filter_caption";a:5:{s:2:"id";s:14:"filter_caption";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:8;s:8:"settings";a:0:{}}s:24:"filter_html_image_secure";a:5:{s:2:"id";s:24:"filter_html_image_secure";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:9;s:8:"settings";a:0:{}}s:21:"editor_file_reference";a:5:{s:2:"id";s:21:"editor_file_reference";s:8:"provider";s:6:"editor";s:6:"status";b:1;s:6:"weight";i:11;s:8:"settings";a:0:{}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'filter.format.full_html',
  'data' => 'a:9:{s:4:"uuid";s:36:"63b3a490-4b0b-420d-9fc5-c204a9553b34";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:6:"editor";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"WNeK5FbcY8pXgEpbD_KgRzlF1-5PL3BJXwqaBctPTqw";}s:4:"name";s:9:"Full HTML";s:6:"format";s:9:"full_html";s:6:"weight";i:2;s:7:"filters";a:4:{s:12:"filter_align";a:5:{s:2:"id";s:12:"filter_align";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:8;s:8:"settings";a:0:{}}s:14:"filter_caption";a:5:{s:2:"id";s:14:"filter_caption";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:9;s:8:"settings";a:0:{}}s:20:"filter_htmlcorrector";a:5:{s:2:"id";s:20:"filter_htmlcorrector";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:10;s:8:"settings";a:0:{}}s:21:"editor_file_reference";a:5:{s:2:"id";s:21:"editor_file_reference";s:8:"provider";s:6:"editor";s:6:"status";b:1;s:6:"weight";i:11;s:8:"settings";a:0:{}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'filter.format.plain_text',
  'data' => 'a:9:{s:4:"uuid";s:36:"5c2357c3-3152-45b7-8169-740bb25f2e88";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"NIKBt6kw_uPhNI0qtR2DnRf7mSOgAQdx7Q94SKMjXbQ";}s:4:"name";s:10:"Plain text";s:6:"format";s:10:"plain_text";s:6:"weight";i:10;s:7:"filters";a:3:{s:18:"filter_html_escape";a:5:{s:2:"id";s:18:"filter_html_escape";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:-10;s:8:"settings";a:0:{}}s:10:"filter_url";a:5:{s:2:"id";s:10:"filter_url";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:0;s:8:"settings";a:1:{s:17:"filter_url_length";i:72;}}s:12:"filter_autop";a:5:{s:2:"id";s:12:"filter_autop";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:0;s:8:"settings";a:0:{}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'filter.format.restricted_html',
  'data' => 'a:9:{s:4:"uuid";s:36:"34829048-b87f-4c08-b0ec-55e407a01afe";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"oz6NyPDAB4HB6N9hgH2LwNVtCd-sXbMG1fbn5KsRIDI";}s:4:"name";s:15:"Restricted HTML";s:6:"format";s:15:"restricted_html";s:6:"weight";i:1;s:7:"filters";a:3:{s:11:"filter_html";a:5:{s:2:"id";s:11:"filter_html";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:-10;s:8:"settings";a:3:{s:12:"allowed_html";s:149:"<a href hreflang> <em> <strong> <cite> <blockquote cite> <code> <ul type> <ol start type> <li> <dl> <dt> <dd> <h2 id> <h3 id> <h4 id> <h5 id> <h6 id>";s:16:"filter_html_help";b:1;s:20:"filter_html_nofollow";b:0;}}s:12:"filter_autop";a:5:{s:2:"id";s:12:"filter_autop";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:0;s:8:"settings";a:0:{}}s:10:"filter_url";a:5:{s:2:"id";s:10:"filter_url";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:0;s:8:"settings";a:1:{s:17:"filter_url_length";i:72;}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'filter.settings',
  'data' => 'a:3:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"FiPjM3WdB__ruFA7B6TLwni_UcZbmek5G4b2dxQItxA";}s:15:"fallback_format";s:10:"plain_text";s:27:"always_show_fallback_choice";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'image.settings',
  'data' => 'a:4:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"k-yDFHbqNfpe-Srg4sdCSqaosCl2D8uwyEY5esF8gEw";}s:13:"preview_image";s:29:"core/modules/image/sample.png";s:26:"allow_insecure_derivatives";b:0;s:20:"suppress_itok_output";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'image.style.large',
  'data' => 'a:8:{s:4:"uuid";s:36:"9bb053fd-992a-4ca3-bcf9-14f86a40e8e4";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"J2n0RpFzS0-bgSyxjs6rSdgxB1rb-bTAgqywNx_964M";}s:4:"name";s:5:"large";s:5:"label";s:16:"Large (480×480)";s:7:"effects";a:1:{s:36:"ddd73aa7-4bd6-4c85-b600-bdf2b1628d1d";a:4:{s:4:"uuid";s:36:"ddd73aa7-4bd6-4c85-b600-bdf2b1628d1d";s:2:"id";s:11:"image_scale";s:6:"weight";i:0;s:4:"data";a:3:{s:5:"width";i:480;s:6:"height";i:480;s:7:"upscale";b:0;}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'image.style.medium',
  'data' => 'a:8:{s:4:"uuid";s:36:"987a55c1-a2c5-4173-831f-d4c324bd6dfb";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Y9NmnZHQq20ASSyTNA6JnwtWrJJiSajOehGDtmUFdM0";}s:4:"name";s:6:"medium";s:5:"label";s:17:"Medium (220×220)";s:7:"effects";a:1:{s:36:"bddf0d06-42f9-4c75-a700-a33cafa25ea0";a:4:{s:4:"uuid";s:36:"bddf0d06-42f9-4c75-a700-a33cafa25ea0";s:2:"id";s:11:"image_scale";s:6:"weight";i:0;s:4:"data";a:3:{s:5:"width";i:220;s:6:"height";i:220;s:7:"upscale";b:0;}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'image.style.thumbnail',
  'data' => 'a:8:{s:4:"uuid";s:36:"29aed8da-4271-4aa4-98b5-c82f09e8fea9";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"cCiWdBHgLwj5omG35lsKc4LkW4MBdmcctkVop4ol5x0";}s:4:"name";s:9:"thumbnail";s:5:"label";s:20:"Thumbnail (100×100)";s:7:"effects";a:1:{s:36:"1cfec298-8620-4749-b100-ccb6c4500779";a:4:{s:4:"uuid";s:36:"1cfec298-8620-4749-b100-ccb6c4500779";s:2:"id";s:11:"image_scale";s:6:"weight";i:0;s:4:"data";a:3:{s:5:"width";i:100;s:6:"height";i:100;s:7:"upscale";b:0;}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'image.style.wide',
  'data' => 'a:8:{s:4:"uuid";s:36:"83e90fb2-fa03-456d-8678-4c574f3d7d8c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"LswCVLg8z4Zk1u6pV1Dpj1qUj5YY2CQ7_ojx7bJQ8qk";}s:4:"name";s:4:"wide";s:5:"label";s:11:"Wide (1090)";s:7:"effects";a:1:{s:36:"09959c15-59ce-4f6d-90df-e2d7cf32bce5";a:4:{s:4:"uuid";s:36:"09959c15-59ce-4f6d-90df-e2d7cf32bce5";s:2:"id";s:11:"image_scale";s:6:"weight";i:1;s:4:"data";a:3:{s:5:"width";i:1090;s:6:"height";N;s:7:"upscale";b:0;}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'menu_ui.settings',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"SqMarzIjxC3F8dZo9FEOxfqDKD_sdW1tbcFTV1BA2zU";}s:24:"override_parent_selector";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'node.settings',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"W0cgFPhPJ3gAdqm06-az48BLf5MVcoZVS0HdByoofi0";}s:15:"use_admin_theme";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'node.type.article',
  'data' => 'a:13:{s:4:"uuid";s:36:"f2c03a43-67e9-494f-97b5-63b6375d27a5";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:7:"menu_ui";}}s:20:"third_party_settings";a:1:{s:7:"menu_ui";a:2:{s:15:"available_menus";a:1:{i:0;s:4:"main";}s:6:"parent";s:5:"main:";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"AeW1SEDgb1OTQACAWGhzvMknMYAJlcZu0jljfeU3oso";}s:4:"name";s:7:"Article";s:4:"type";s:7:"article";s:11:"description";s:89:"Use <em>articles</em> for time-sensitive content like news, press releases or blog posts.";s:4:"help";s:0:"";s:12:"new_revision";b:1;s:12:"preview_mode";i:1;s:17:"display_submitted";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'node.type.page',
  'data' => "a:13:{s:4:\"uuid\";s:36:\"b8eee83a-751f-44e1-b403-2198bb97ec25\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:7:\"menu_ui\";}}s:20:\"third_party_settings\";a:1:{s:7:\"menu_ui\";a:2:{s:15:\"available_menus\";a:1:{i:0;s:4:\"main\";}s:6:\"parent\";s:5:\"main:\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"KuyA4NHPXcmKAjRtwa0vQc2ZcyrUJy6IlS2TAyMNRbc\";}s:4:\"name\";s:10:\"Basic page\";s:4:\"type\";s:4:\"page\";s:11:\"description\";s:77:\"Use <em>basic pages</em> for your static content, such as an 'About us' page.\";s:4:\"help\";s:0:\"\";s:12:\"new_revision\";b:1;s:12:\"preview_mode\";i:1;s:17:\"display_submitted\";b:0;}",
))
->values(array(
  'collection' => '',
  'name' => 'olivero.settings',
  'data' => 'a:7:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Ylohp6sdrL1dU4v-KcXzXTP-U8BAMgh4NWJA9eGHtO4";}s:7:"favicon";a:1:{s:11:"use_default";b:1;}s:8:"features";a:4:{s:20:"comment_user_picture";b:1;s:25:"comment_user_verification";b:1;s:7:"favicon";b:1;s:17:"node_user_picture";b:0;}s:4:"logo";a:1:{s:11:"use_default";b:0;}s:20:"third_party_settings";a:1:{s:8:"shortcut";a:1:{s:11:"module_link";b:1;}}s:22:"mobile_menu_all_widths";i:0;s:22:"site_branding_bg_color";s:7:"default";}',
))
->values(array(
  'collection' => '',
  'name' => 'rabbit_hole.behavior_settings.default',
  'data' => 'a:13:{s:4:"uuid";s:36:"bf480a7d-f120-49bc-9ce2-8d3807fea0ec";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"hzh9CgsYCGxPEcbR3ieT1la6e43lMv-ivoN7oZJKkQQ";}s:2:"id";s:7:"default";s:14:"entity_type_id";N;s:9:"entity_id";N;s:6:"action";s:12:"display_page";s:14:"allow_override";i:1;s:8:"redirect";s:0:"";s:13:"redirect_code";i:0;s:24:"redirect_fallback_action";s:13:"access_denied";}',
))
->values(array(
  'collection' => '',
  'name' => 'rabbit_hole.behavior_settings.default_bundle',
  'data' => 'a:13:{s:4:"uuid";s:36:"ae7d012c-c572-4aad-b53b-fac4d7ef022e";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"qUkgsWZRCa_sLIn5JsMzB3xnx5ekIsVeGGZr7T0s9MY";}s:2:"id";s:14:"default_bundle";s:14:"entity_type_id";N;s:9:"entity_id";N;s:6:"action";s:12:"display_page";s:14:"allow_override";i:1;s:8:"redirect";s:0:"";s:13:"redirect_code";i:0;s:24:"redirect_fallback_action";s:13:"access_denied";}',
))
->values(array(
  'collection' => '',
  'name' => 'rabbit_hole.behavior_settings.node_type_article',
  'data' => 'a:12:{s:4:"uuid";s:36:"fa21bc8e-3113-4150-a5f7-3a6b665a3b6f";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:1:{i:0;s:17:"node.type.article";}}s:2:"id";s:17:"node_type_article";s:14:"entity_type_id";s:9:"node_type";s:9:"entity_id";s:7:"article";s:6:"action";s:13:"page_redirect";s:14:"allow_override";i:1;s:8:"redirect";s:9:"/articles";s:13:"redirect_code";i:301;s:24:"redirect_fallback_action";s:13:"access_denied";}',
))
->values(array(
  'collection' => '',
  'name' => 'rabbit_hole.behavior_settings.taxonomy_vocabulary_tags',
  'data' => 'a:12:{s:4:"uuid";s:36:"e72c30ab-9660-4f0e-8fc4-a7834a0dd04b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:1:{i:0;s:24:"taxonomy.vocabulary.tags";}}s:2:"id";s:24:"taxonomy_vocabulary_tags";s:14:"entity_type_id";s:19:"taxonomy_vocabulary";s:9:"entity_id";s:4:"tags";s:6:"action";s:20:"page_redirect_custom";s:14:"allow_override";i:1;s:8:"redirect";s:5:"/tags";s:13:"redirect_code";i:301;s:24:"redirect_fallback_action";s:13:"access_denied";}',
))
->values(array(
  'collection' => '',
  'name' => 'rabbit_hole.behavior_settings.user',
  'data' => 'a:12:{s:4:"uuid";s:36:"79eed3d9-4fdd-40b2-9b1d-e5440bd92433";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:2:"id";s:4:"user";s:14:"entity_type_id";s:4:"user";s:9:"entity_id";N;s:6:"action";s:14:"page_not_found";s:14:"allow_override";i:1;s:8:"redirect";s:0:"";s:13:"redirect_code";i:301;s:24:"redirect_fallback_action";s:13:"access_denied";}',
))
->values(array(
  'collection' => '',
  'name' => 'search.page.node_search',
  'data' => 'a:11:{s:4:"uuid";s:36:"58c9e4c2-eec7-4ee7-9986-738d9ed5c78c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"97tvtzGOa8_flb22CzSjgtm_YkiGMHvEBO-6q2K9V_U";}s:2:"id";s:11:"node_search";s:5:"label";s:7:"Content";s:4:"path";s:4:"node";s:6:"weight";i:-10;s:6:"plugin";s:11:"node_search";s:13:"configuration";a:1:{s:8:"rankings";a:0:{}}}',
))
->values(array(
  'collection' => '',
  'name' => 'search.page.user_search',
  'data' => 'a:11:{s:4:"uuid";s:36:"c37120e6-f9c1-41a1-8ffc-1d763107163c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"k3aUaZXGDuhkek2TZIee0PApOPTvYZLadziekdyHA5A";}s:2:"id";s:11:"user_search";s:5:"label";s:5:"Users";s:4:"path";s:4:"user";s:6:"weight";i:0;s:6:"plugin";s:11:"user_search";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'search.settings',
  'data' => 'a:5:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"hvVxL1G-ZCxaq32IZws0YsfuhvaDiQE_np-0g35KjUk";}s:12:"and_or_limit";i:7;s:12:"default_page";s:11:"node_search";s:5:"index";a:4:{s:10:"cron_limit";i:100;s:11:"overlap_cjk";b:1;s:17:"minimum_word_size";i:3;s:11:"tag_weights";a:12:{s:2:"h1";i:25;s:2:"h2";i:18;s:2:"h3";i:15;s:2:"h4";i:14;s:2:"h5";i:9;s:2:"h6";i:6;s:1:"u";i:3;s:1:"b";i:3;s:1:"i";i:3;s:6:"strong";i:3;s:2:"em";i:3;s:1:"a";i:10;}}s:7:"logging";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'shortcut.set.default',
  'data' => 'a:7:{s:4:"uuid";s:36:"1c370768-46b6-42cf-9b64-8ee8f643edc7";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"U5VlGjd_SfV0Qm_EfnaynOfc549cNscFAx48JfYoMRI";}s:2:"id";s:7:"default";s:5:"label";s:7:"Default";}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.comment_delete_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"5f656b10-b5fb-4298-b518-a32679087872";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:7:"comment";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"vpBH8OmL4sdesCdeZLsW8KOutB5gkbreWJbfjhfFKaQ";}s:2:"id";s:21:"comment_delete_action";s:5:"label";s:14:"Delete comment";s:4:"type";s:7:"comment";s:6:"plugin";s:28:"entity:delete_action:comment";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.comment_publish_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"6761de1f-3792-4aaa-8e91-4a4997bbdf88";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:7:"comment";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"C00dyL_W_5M0nFlgUB3lWUTUs96jn51Jw1MLHVEHZD0";}s:2:"id";s:22:"comment_publish_action";s:5:"label";s:15:"Publish comment";s:4:"type";s:7:"comment";s:6:"plugin";s:29:"entity:publish_action:comment";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.comment_save_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"df875fda-75ee-44f6-85f6-a67a1dca6fe1";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:7:"comment";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"lfyE_snmvfg_EQ3VDyhUtGAXgmqtEiqa46I3bTMg8DU";}s:2:"id";s:19:"comment_save_action";s:5:"label";s:12:"Save comment";s:4:"type";s:7:"comment";s:6:"plugin";s:26:"entity:save_action:comment";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.comment_unpublish_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"5db82785-8f19-422a-b63f-31fe1f0cec45";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:7:"comment";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"tWOIjSMobEWOFZddMkNqb9JySbOVwE1diC6NRqcfLTk";}s:2:"id";s:24:"comment_unpublish_action";s:5:"label";s:17:"Unpublish comment";s:4:"type";s:7:"comment";s:6:"plugin";s:31:"entity:unpublish_action:comment";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.node_delete_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"a4e858ff-a668-4282-8e77-98c262d56292";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"t43OqwzP3CTbcAagSsWKNy6KwMm_zShXo3c4-So6rQg";}s:2:"id";s:18:"node_delete_action";s:5:"label";s:14:"Delete content";s:4:"type";s:4:"node";s:6:"plugin";s:25:"entity:delete_action:node";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.node_make_sticky_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"409ce2ad-5e9b-4b95-b3d6-8477271e3c21";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"sOb26JSy3fGpWkvR0WYN6_hMqj_6d1rvbvrkzp1yya0";}s:2:"id";s:23:"node_make_sticky_action";s:5:"label";s:19:"Make content sticky";s:4:"type";s:4:"node";s:6:"plugin";s:23:"node_make_sticky_action";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.node_make_unsticky_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"26b08999-f474-47e0-8051-bce594577c5e";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"lDM9mvIGAu8Sw8rt-uCO4Sr7yX5VPrDPxYcawkbKd6k";}s:2:"id";s:25:"node_make_unsticky_action";s:5:"label";s:21:"Make content unsticky";s:4:"type";s:4:"node";s:6:"plugin";s:25:"node_make_unsticky_action";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.node_promote_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"302d5d05-7465-47e3-b15a-8c34cf9f6912";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"N0RDBTqiK4dKoN4p4oW2j0SGWycdHyALUe9M-Ofp89U";}s:2:"id";s:19:"node_promote_action";s:5:"label";s:29:"Promote content to front page";s:4:"type";s:4:"node";s:6:"plugin";s:19:"node_promote_action";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.node_publish_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"4daf6bec-d2dc-44bf-a2d3-2349f32f2a12";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"2B9uF8NL5gutNKSdPRAhhAsDWFZZG1PJOBmx0aBGd_0";}s:2:"id";s:19:"node_publish_action";s:5:"label";s:15:"Publish content";s:4:"type";s:4:"node";s:6:"plugin";s:26:"entity:publish_action:node";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.node_save_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"204a0f15-e96a-486f-96e6-444b0ca9fdc2";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"LhdsoZPL_pFas2fjaAWue4zvrQ_tEVofLYtcNec-JGM";}s:2:"id";s:16:"node_save_action";s:5:"label";s:12:"Save content";s:4:"type";s:4:"node";s:6:"plugin";s:23:"entity:save_action:node";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.node_unpromote_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"a1b4900f-6ea6-44c6-a820-46972c5a530d";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"JBptjnfuOMtsdKygklXxoOgeOCTMtQxlkymjnnj-cC0";}s:2:"id";s:21:"node_unpromote_action";s:5:"label";s:30:"Remove content from front page";s:4:"type";s:4:"node";s:6:"plugin";s:21:"node_unpromote_action";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.node_unpublish_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"82fddbbe-471a-479e-91b4-84a25e9bc0aa";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"C7X8h9FWlwkQ9y5mnU2JzgaZICAdc6HFbPVbhvjlAYE";}s:2:"id";s:21:"node_unpublish_action";s:5:"label";s:17:"Unpublish content";s:4:"type";s:4:"node";s:6:"plugin";s:28:"entity:unpublish_action:node";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.taxonomy_term_publish_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"c449d713-5b72-4d22-991d-69848db25bf5";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:8:"taxonomy";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"DoVt_VGgVLcDD4XmVbSFzr0K17SJy9imFiYusKkJBgY";}s:2:"id";s:28:"taxonomy_term_publish_action";s:5:"label";s:21:"Publish taxonomy term";s:4:"type";s:13:"taxonomy_term";s:6:"plugin";s:35:"entity:publish_action:taxonomy_term";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.taxonomy_term_unpublish_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"4de35454-ce45-4eaa-b979-bc7b46e84f4b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:8:"taxonomy";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"z2sNRM3ECa7FPCGnSNje_9SmZJQgwhD_6fG_L4Mr8zI";}s:2:"id";s:30:"taxonomy_term_unpublish_action";s:5:"label";s:23:"Unpublish taxonomy term";s:4:"type";s:13:"taxonomy_term";s:6:"plugin";s:37:"entity:unpublish_action:taxonomy_term";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.user_add_role_action.administrator',
  'data' => 'a:9:{s:4:"uuid";s:36:"8cec3297-a41f-43eb-bfc7-892900ed17ba";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:23:"user.role.administrator";}s:6:"module";a:1:{i:0;s:4:"user";}}s:2:"id";s:34:"user_add_role_action.administrator";s:5:"label";s:50:"Add the Administrator role to the selected user(s)";s:4:"type";s:4:"user";s:6:"plugin";s:20:"user_add_role_action";s:13:"configuration";a:1:{s:3:"rid";s:13:"administrator";}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.user_add_role_action.content_editor',
  'data' => 'a:9:{s:4:"uuid";s:36:"d6fb77a0-ccf6-4544-a641-293451d25a4b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:24:"user.role.content_editor";}s:6:"module";a:1:{i:0;s:4:"user";}}s:2:"id";s:35:"user_add_role_action.content_editor";s:5:"label";s:51:"Add the Content editor role to the selected user(s)";s:4:"type";s:4:"user";s:6:"plugin";s:20:"user_add_role_action";s:13:"configuration";a:1:{s:3:"rid";s:14:"content_editor";}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.user_block_user_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"28b16d16-efb1-4178-9c00-9a67b78fc013";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"DyypzTfThX10FFQw-399qPfEbLLyrhXgQrKPVsmAoJ4";}s:2:"id";s:22:"user_block_user_action";s:5:"label";s:26:"Block the selected user(s)";s:4:"type";s:4:"user";s:6:"plugin";s:22:"user_block_user_action";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.user_cancel_user_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"a485eae3-859c-4b73-8044-29ea53d94688";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"nvrL9bFilzBvm2bjO9rQnFDpBA7dBBUjShSSt6NS-DU";}s:2:"id";s:23:"user_cancel_user_action";s:5:"label";s:35:"Cancel the selected user account(s)";s:4:"type";s:4:"user";s:6:"plugin";s:23:"user_cancel_user_action";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.user_remove_role_action.administrator',
  'data' => 'a:9:{s:4:"uuid";s:36:"180a8529-8d78-44e4-a8ab-e5d3d1326611";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:23:"user.role.administrator";}s:6:"module";a:1:{i:0;s:4:"user";}}s:2:"id";s:37:"user_remove_role_action.administrator";s:5:"label";s:55:"Remove the Administrator role from the selected user(s)";s:4:"type";s:4:"user";s:6:"plugin";s:23:"user_remove_role_action";s:13:"configuration";a:1:{s:3:"rid";s:13:"administrator";}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.user_remove_role_action.content_editor',
  'data' => 'a:9:{s:4:"uuid";s:36:"b7e68852-84d3-4d45-80d7-d638ad2f3001";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:24:"user.role.content_editor";}s:6:"module";a:1:{i:0;s:4:"user";}}s:2:"id";s:38:"user_remove_role_action.content_editor";s:5:"label";s:56:"Remove the Content editor role from the selected user(s)";s:4:"type";s:4:"user";s:6:"plugin";s:23:"user_remove_role_action";s:13:"configuration";a:1:{s:3:"rid";s:14:"content_editor";}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.user_unblock_user_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"879c21c9-08f1-47c5-913f-b939ad49d2b1";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"SPsUXsR3Rc8d1y3gewzaAKWa1ncea_ywXX3f7LTn7k0";}s:2:"id";s:24:"user_unblock_user_action";s:5:"label";s:28:"Unblock the selected user(s)";s:4:"type";s:4:"user";s:6:"plugin";s:24:"user_unblock_user_action";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.advisories',
  'data' => 'a:3:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"x0FuQ_7Cg81mSDQwG028_Z0CjH3R9ib5IDlHeV2BbAo";}s:7:"enabled";b:1;s:14:"interval_hours";i:6;}',
))
->values(array(
  'collection' => '',
  'name' => 'system.cron',
  'data' => 'a:3:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"5Pw921y1EPfFN98wykliBBLArm51pC-SmrXeYCe7d0Y";}s:9:"threshold";a:2:{s:20:"requirements_warning";i:172800;s:18:"requirements_error";i:1209600;}s:7:"logging";i:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'system.date',
  'data' => 'a:4:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"t7clj3mzmOGrXX0HuCH5usf0vEqRtnMTBFVBIEmZ5pc";}s:9:"first_day";i:0;s:7:"country";a:1:{s:7:"default";s:0:"";}s:8:"timezone";a:2:{s:7:"default";s:3:"UTC";s:4:"user";a:3:{s:12:"configurable";b:1;s:7:"default";i:0;s:4:"warn";b:0;}}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.diff',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"1WanmaEhxW_vM8_5Ktsdntj8MaO9UBHXg0lN603PsWM";}s:7:"context";a:2:{s:13:"lines_leading";i:2;s:14:"lines_trailing";i:2;}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.file',
  'data' => 'a:4:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"mguGHCYb9Dw5EcpfjwoShGV1Vjkbz3QuPRCLfxiye-g";}s:22:"allow_insecure_uploads";b:0;s:14:"default_scheme";s:6:"public";s:21:"temporary_maximum_age";i:21600;}',
))
->values(array(
  'collection' => '',
  'name' => 'system.image',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"durWHaKeBaq4d9Wpi4RqwADj1OufDepcnJuhVLmKN24";}s:7:"toolkit";s:2:"gd";}',
))
->values(array(
  'collection' => '',
  'name' => 'system.image.gd',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"eNXaHfkJJUThHeF0nvkoXyPLRrKYGxgHRjORvT4F5rQ";}s:12:"jpeg_quality";i:75;}',
))
->values(array(
  'collection' => '',
  'name' => 'system.logging',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"u3-njszl92FaxjrCMiq0yDcjAfcdx72w1zT1O9dx6aA";}s:11:"error_level";s:4:"hide";}',
))
->values(array(
  'collection' => '',
  'name' => 'system.mail',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"rYgt7uhPafP2ngaN_ZUPFuyI4KdE0zU868zLNSlzKoE";}s:9:"interface";a:1:{s:7:"default";s:8:"php_mail";}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.maintenance',
  'data' => 'a:3:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"1SNdA25INsV5YjlgAJtfC-6AM8VcWe_00xneMLb2yFg";}s:8:"langcode";s:2:"en";s:7:"message";s:93:"@site is currently under maintenance. We should be back shortly. Thank you for your patience.";}',
))
->values(array(
  'collection' => '',
  'name' => 'system.menu.account',
  'data' => 'a:9:{s:4:"uuid";s:36:"32c478d3-6011-4c47-b28b-c9f5ac145eab";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"M_Bh81osDyUQ4wV0GgU_NdBNqkzM87sLxjaCdFj9mnw";}s:2:"id";s:7:"account";s:5:"label";s:17:"User account menu";s:11:"description";s:40:"Links related to the active user account";s:6:"locked";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'system.menu.admin',
  'data' => 'a:9:{s:4:"uuid";s:36:"eaa4d291-fb65-4128-84b0-40907672e5ed";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"sapEi2YDGoI9yQIT_WgIV2vUdQ6DScH0V3fAyTadAL0";}s:2:"id";s:5:"admin";s:5:"label";s:14:"Administration";s:11:"description";s:25:"Administrative task links";s:6:"locked";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'system.menu.footer',
  'data' => 'a:9:{s:4:"uuid";s:36:"96f8f789-3700-49b5-af38-4963dbab0e4e";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"7yrlW5z9zdg2eBucB2GPqXKSMQfH9lSRSO4DbWF7AFc";}s:2:"id";s:6:"footer";s:5:"label";s:6:"Footer";s:11:"description";s:22:"Site information links";s:6:"locked";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'system.menu.main',
  'data' => 'a:9:{s:4:"uuid";s:36:"9323e082-f9cf-45b6-aca9-172c0ee871bd";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Q2Ra3jfoIVk0f3SjxJX61byRQFVBAbpzYDQOiY-kno8";}s:2:"id";s:4:"main";s:5:"label";s:15:"Main navigation";s:11:"description";s:18:"Site section links";s:6:"locked";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'system.menu.tools',
  'data' => 'a:9:{s:4:"uuid";s:36:"e1cfe7a9-2e30-45cf-a2ab-07b152cdd3e7";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"BCM-vV1zzRaLHN18dqAR_CuGOj8AFJvTx7BKl_8Gcxc";}s:2:"id";s:5:"tools";s:5:"label";s:5:"Tools";s:11:"description";s:39:"User tool links, often added by modules";s:6:"locked";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'system.performance',
  'data' => 'a:6:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"b2cssrj-lOmATIbdehfCqfCFgVR0qCdxxWhwqa2KBVQ";}s:5:"cache";a:1:{s:4:"page";a:1:{s:7:"max_age";i:0;}}s:3:"css";a:2:{s:10:"preprocess";b:1;s:4:"gzip";b:1;}s:8:"fast_404";a:4:{s:7:"enabled";b:1;s:5:"paths";s:69:"/\.(?:txt|png|gif|jpe?g|css|js|ico|swf|flv|cgi|bat|pl|dll|exe|asp)$/i";s:13:"exclude_paths";s:27:"/\/(?:styles|imagecache)\//";s:4:"html";s:162:"<!DOCTYPE html><html><head><title>404 Not Found</title></head><body><h1>Not Found</h1><p>The requested URL "@path" was not found on this server.</p></body></html>";}s:2:"js";a:2:{s:10:"preprocess";b:1;s:4:"gzip";b:1;}s:20:"stale_file_threshold";i:2592000;}',
))
->values(array(
  'collection' => '',
  'name' => 'system.rss',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"MIpNzlG4gPunfS7vTCwUPum6QH3GUsEBMj-qS631Jw0";}s:5:"items";a:1:{s:9:"view_mode";s:3:"rss";}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.site',
  'data' => 'a:11:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"VDJxTZtQR21qB4lvOq8zszJZLvLKrSPQpdn2E3T71Ww";}s:8:"langcode";s:2:"en";s:4:"uuid";s:36:"c7a58122-ec76-4d96-979d-c7aeb49ec0ab";s:4:"name";s:18:"Drush Site-Install";s:4:"mail";s:17:"admin@example.com";s:6:"slogan";s:0:"";s:4:"page";a:3:{i:403;s:0:"";i:404;s:0:"";s:5:"front";s:5:"/node";}s:18:"admin_compact_mode";b:0;s:17:"weight_select_max";i:100;s:16:"default_langcode";s:2:"en";s:17:"mail_notification";s:0:"";}',
))
->values(array(
  'collection' => '',
  'name' => 'system.theme',
  'data' => 'a:3:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"eJ529VM1gSIA_vgTy2PdiDvJuG0xhSxfQjCyl5WKlv4";}s:5:"admin";s:5:"claro";s:7:"default";s:7:"olivero";}',
))
->values(array(
  'collection' => '',
  'name' => 'system.theme.global',
  'data' => 'a:4:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"9rAU4Pku7eMBQxauQqAgjzlcicFZ2As6zEa6zvTlCB8";}s:7:"favicon";a:4:{s:8:"mimetype";s:24:"image/vnd.microsoft.icon";s:4:"path";s:0:"";s:3:"url";s:0:"";s:11:"use_default";b:1;}s:8:"features";a:4:{s:20:"comment_user_picture";b:1;s:25:"comment_user_verification";b:1;s:7:"favicon";b:1;s:17:"node_user_picture";b:1;}s:4:"logo";a:3:{s:4:"path";s:0:"";s:3:"url";s:0:"";s:11:"use_default";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'taxonomy.settings',
  'data' => 'a:4:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"zKpaWT6cJc1tVQQaTqatGELaCqU_oyRym6zTl27Yias";}s:20:"maintain_index_table";b:1;s:17:"override_selector";b:0;s:20:"terms_per_page_admin";i:100;}',
))
->values(array(
  'collection' => '',
  'name' => 'taxonomy.vocabulary.tags',
  'data' => 'a:9:{s:4:"uuid";s:36:"7a3f07cc-15f1-465b-9849-e0c03bb59f78";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"yoNVreoTdTZTY7GuE8fI9Jmxqdz8vlo4ZJKixMNSosw";}s:4:"name";s:4:"Tags";s:3:"vid";s:4:"tags";s:11:"description";s:61:"Use tags to group articles on similar topics into categories.";s:6:"weight";i:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'text.settings',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Bkewb77RBOK3_aXMPsp8p87gbc03NvmC5gBLzPl7hVA";}s:22:"default_summary_length";i:600;}',
))
->values(array(
  'collection' => '',
  'name' => 'tour.tour.block-layout',
  'data' => 'a:10:{s:4:"uuid";s:36:"c6712d2f-69b8-4200-8401-059a7240a0b2";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:5:"block";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ructO0IOsghR3CIbNd-0QfLTDiUo8gIJ7mB_nxSil4o";}s:2:"id";s:12:"block-layout";s:5:"label";s:17:"Block Layout Page";s:6:"module";s:5:"block";s:6:"routes";a:1:{i:0;a:1:{s:10:"route_name";s:19:"block.admin_display";}}s:4:"tips";a:5:{s:12:"block-layout";a:5:{s:2:"id";s:12:"block-layout";s:6:"plugin";s:4:"text";s:5:"label";s:12:"Block Layout";s:6:"weight";i:1;s:4:"body";s:150:"Blocks are boxes of content rendered into an area, or region, of a web page that can be displayed in regions (such as footer or sidebar) on your page.";}s:11:"place-block";a:6:{s:2:"id";s:11:"place-block";s:6:"plugin";s:4:"text";s:5:"label";s:12:"Place Blocks";s:6:"weight";i:2;s:8:"selector";s:14:".button--small";s:4:"body";s:163:"Any custom or contributed block can be added to a particular region by clicking on a button Place block. A new block can also be created by clicking on Place Block";}s:12:"block-region";a:6:{s:2:"id";s:12:"block-region";s:6:"plugin";s:4:"text";s:5:"label";s:12:"Block Region";s:6:"weight";i:3;s:8:"selector";s:20:".block-region-select";s:4:"body";s:151:"Assign or change the region of a block by clicking here. A dropdown list with all the regions will appear. You can place one block in multiple regions.";}s:15:"configure-block";a:6:{s:2:"id";s:15:"configure-block";s:6:"plugin";s:4:"text";s:5:"label";s:15:"Configure Block";s:6:"weight";i:4;s:8:"selector";s:18:".dropbutton-widget";s:4:"body";s:173:"By Clicking on "Configure" you can go ahead and edit the contents of the block, deal with the visibility settings and even change the placement of where it is on your theme.";}s:20:"custom-block-library";a:5:{s:2:"id";s:20:"custom-block-library";s:6:"plugin";s:4:"text";s:5:"label";s:20:"Custom Block Library";s:6:"weight";i:5;s:4:"body";s:203:"The block management screen also has an another tab on the top which is used to add Custom blocks. The name of the tab is "Custom block library". This tab ultimately provides a link to add custom blocks.";}}}',
))
->values(array(
  'collection' => '',
  'name' => 'tour.tour.views-ui',
  'data' => "a:10:{s:4:\"uuid\";s:36:\"b1baec29-9b50-4f44-8cf5-d97c1f63f4b9\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:8:\"views_ui\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"XIYL1KF7ND2XQRa5AxvEcp8vgCN2kUGiuBNhCgxrPME\";}s:2:\"id\";s:8:\"views-ui\";s:5:\"label\";s:14:\"View edit page\";s:6:\"module\";s:8:\"views_ui\";s:6:\"routes\";a:2:{i:0;a:1:{s:10:\"route_name\";s:21:\"entity.view.edit_form\";}i:1;a:1:{s:10:\"route_name\";s:29:\"entity.view.edit_display_form\";}}s:4:\"tips\";a:10:{s:10:\"views-main\";a:5:{s:2:\"id\";s:10:\"views-main\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:20:\"Manage view settings\";s:6:\"weight\";i:1;s:4:\"body\";s:31:\"View or edit the configuration.\";}s:17:\"views-ui-displays\";a:6:{s:2:\"id\";s:17:\"views-ui-displays\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:21:\"Displays in this view\";s:6:\"weight\";i:2;s:8:\"selector\";s:18:\"#views-display-top\";s:4:\"body\";s:169:\"A display is a way of outputting the results, e.g., as a page or a block. A view can contain multiple displays, which are listed here. The active display is highlighted.\";}s:19:\"views-ui-view-admin\";a:7:{s:2:\"id\";s:19:\"views-ui-view-admin\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:19:\"View administration\";s:6:\"weight\";i:3;s:8:\"position\";s:5:\"right\";s:8:\"selector\";s:28:\"#views-display-extra-actions\";s:4:\"body\";s:140:\"Perform administrative tasks, including adding a description and creating a clone. Click the drop-down button to view the available options.\";}s:15:\"views-ui-format\";a:6:{s:2:\"id\";s:15:\"views-ui-format\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:13:\"Output format\";s:6:\"weight\";i:4;s:8:\"selector\";s:35:\".views-ui-display-tab-bucket.format\";s:4:\"body\";s:325:\"Choose how to output results. E.g., choose <em>Content</em> to output each item completely, using your configured display settings. Or choose <em>Fields</em>, which allows you to output only specific fields for each result. Additional formats can be added by installing modules to <em>extend</em> Drupal's base functionality.\";}s:15:\"views-ui-fields\";a:6:{s:2:\"id\";s:15:\"views-ui-fields\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:6:\"Fields\";s:6:\"weight\";i:5;s:8:\"selector\";s:34:\".views-ui-display-tab-bucket.field\";s:4:\"body\";s:89:\"If this view uses fields, they are listed here. You can click on a field to configure it.\";}s:15:\"views-ui-filter\";a:6:{s:2:\"id\";s:15:\"views-ui-filter\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:16:\"Filter your view\";s:6:\"weight\";i:6;s:8:\"selector\";s:35:\".views-ui-display-tab-bucket.filter\";s:4:\"body\";s:173:\"Add filters to limit the results in the output. E.g., to only show content that is <em>published</em>, you would add a filter for <em>Published</em> and select <em>Yes</em>.\";}s:26:\"views-ui-filter-operations\";a:6:{s:2:\"id\";s:26:\"views-ui-filter-operations\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:14:\"Filter actions\";s:6:\"weight\";i:7;s:8:\"selector\";s:54:\".views-ui-display-tab-bucket.filter .dropbutton-widget\";s:4:\"body\";s:33:\"Add, rearrange or remove filters.\";}s:14:\"views-ui-sorts\";a:6:{s:2:\"id\";s:14:\"views-ui-sorts\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:13:\"Sort Criteria\";s:6:\"weight\";i:8;s:8:\"selector\";s:33:\".views-ui-display-tab-bucket.sort\";s:4:\"body\";s:96:\"Control the order in which the results are output. Click on an active sort rule to configure it.\";}s:25:\"views-ui-sorts-operations\";a:6:{s:2:\"id\";s:25:\"views-ui-sorts-operations\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:12:\"Sort actions\";s:6:\"weight\";i:9;s:8:\"selector\";s:52:\".views-ui-display-tab-bucket.sort .dropbutton-widget\";s:4:\"body\";s:39:\"Add, rearrange or remove sorting rules.\";}s:16:\"views-ui-preview\";a:7:{s:2:\"id\";s:16:\"views-ui-preview\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:7:\"Preview\";s:6:\"weight\";i:10;s:8:\"position\";s:5:\"right\";s:8:\"selector\";s:15:\"#preview-submit\";s:4:\"body\";s:34:\"Show a preview of the view output.\";}}}",
))
->values(array(
  'collection' => '',
  'name' => 'update.settings',
  'data' => 'a:4:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"2QzULf0zovJQx3J06Y9rufzzfi-CY2CTTlEfJJh2Qyw";}s:5:"check";a:2:{s:19:"disabled_extensions";b:0;s:13:"interval_days";i:1;}s:5:"fetch";a:3:{s:3:"url";s:0:"";s:12:"max_attempts";i:2;s:7:"timeout";i:30;}s:12:"notification";a:2:{s:6:"emails";a:1:{i:0;s:17:"admin@example.com";}s:9:"threshold";s:3:"all";}}',
))
->values(array(
  'collection' => '',
  'name' => 'user.flood',
  'data' => 'a:6:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"UYfMzeP1S8jKm9PSvxf7nQNe8DsNS-3bc2WSNNXBQWs";}s:8:"uid_only";b:0;s:8:"ip_limit";i:50;s:9:"ip_window";i:3600;s:10:"user_limit";i:5;s:11:"user_window";i:21600;}',
))
->values(array(
  'collection' => '',
  'name' => 'user.mail',
  'data' => "a:11:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"6CZIzFifRq3qbdq3n3nDpEOO4hWIQtKOAQNPvGNGKeM\";}s:8:\"langcode\";s:2:\"en\";s:14:\"cancel_confirm\";a:2:{s:7:\"subject\";s:67:\"Account cancellation request for [user:display-name] at [site:name]\";s:4:\"body\";s:388:\"[user:display-name]\r\n\r\nA request to cancel your account has been made at [site:name].\r\n\r\nYou may now cancel your account on [site:url-brief] by clicking this link or copying and pasting it into your browser:\r\n\r\n[user:cancel-url]\r\n\r\nNOTE: The cancellation of your account is not reversible.\r\n\r\nThis link expires in one day and nothing will happen if it is not used.\r\n\r\n--  [site:name] team\";}s:14:\"password_reset\";a:2:{s:7:\"subject\";s:68:\"Replacement login information for [user:display-name] at [site:name]\";s:4:\"body\";s:417:\"[user:display-name],\r\n\r\nA request to reset the password for your account has been made at [site:name].\r\n\r\nYou may now log in by clicking this link or copying and pasting it into your browser:\r\n\r\n[user:one-time-login-url]\r\n\r\nThis link can only be used once to log in and will lead you to a page where you can set your password. It expires after one day and nothing will happen if it's not used.\r\n\r\n--  [site:name] team\";}s:22:\"register_admin_created\";a:2:{s:7:\"subject\";s:58:\"An administrator created an account for you at [site:name]\";s:4:\"body\";s:486:\"[user:display-name],\r\n\r\nA site administrator at [site:name] has created an account for you. You may now log in by clicking this link or copying and pasting it into your browser:\r\n\r\n[user:one-time-login-url]\r\n\r\nThis link can only be used once to log in and will lead you to a page where you can set your password.\r\n\r\nAfter setting your password, you will be able to log in at [site:login-url] in the future using:\r\n\r\nusername: [user:name]\r\npassword: Your password\r\n\r\n--  [site:name] team\";}s:29:\"register_no_approval_required\";a:2:{s:7:\"subject\";s:54:\"Account details for [user:display-name] at [site:name]\";s:4:\"body\";s:460:\"[user:display-name],\r\n\r\nThank you for registering at [site:name]. You may now log in by clicking this link or copying and pasting it into your browser:\r\n\r\n[user:one-time-login-url]\r\n\r\nThis link can only be used once to log in and will lead you to a page where you can set your password.\r\n\r\nAfter setting your password, you will be able to log in at [site:login-url] in the future using:\r\n\r\nusername: [user:name]\r\npassword: Your password\r\n\r\n--  [site:name] team\";}s:25:\"register_pending_approval\";a:2:{s:7:\"subject\";s:79:\"Account details for [user:display-name] at [site:name] (pending admin approval)\";s:4:\"body\";s:292:\"[user:display-name],\r\n\r\nThank you for registering at [site:name]. Your application for an account is currently pending approval. Once it has been approved, you will receive another email containing information about how to log in, set your password, and other details.\r\n\r\n--  [site:name] team\";}s:31:\"register_pending_approval_admin\";a:2:{s:7:\"subject\";s:79:\"Account details for [user:display-name] at [site:name] (pending admin approval)\";s:4:\"body\";s:66:\"[user:display-name] has applied for an account.\r\n\r\n[user:edit-url]\";}s:16:\"status_activated\";a:2:{s:7:\"subject\";s:65:\"Account details for [user:display-name] at [site:name] (approved)\";s:4:\"body\";s:477:\"[user:display-name],\r\n\r\nYour account at [site:name] has been activated.\r\n\r\nYou may now log in by clicking this link or copying and pasting it into your browser:\r\n\r\n[user:one-time-login-url]\r\n\r\nThis link can only be used once to log in and will lead you to a page where you can set your password.\r\n\r\nAfter setting your password, you will be able to log in at [site:login-url] in the future using:\r\n\r\nusername: [user:account-name]\r\npassword: Your password\r\n\r\n--  [site:name] team\";}s:14:\"status_blocked\";a:2:{s:7:\"subject\";s:64:\"Account details for [user:display-name] at [site:name] (blocked)\";s:4:\"body\";s:93:\"[user:display-name],\r\n\r\nYour account on [site:name] has been blocked.\r\n\r\n--  [site:name] team\";}s:15:\"status_canceled\";a:2:{s:7:\"subject\";s:65:\"Account details for [user:display-name] at [site:name] (canceled)\";s:4:\"body\";s:94:\"[user:display-name],\r\n\r\nYour account on [site:name] has been canceled.\r\n\r\n--  [site:name] team\";}}",
))
->values(array(
  'collection' => '',
  'name' => 'user.role.administrator',
  'data' => 'a:10:{s:4:"uuid";s:36:"91230e95-9e22-408b-8aad-f10efcaf81a5";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"OeKGIkmZA_c-t6QLH81WNQx8gDCc1MRmxaTuQgxBByU";}s:2:"id";s:13:"administrator";s:5:"label";s:13:"Administrator";s:6:"weight";i:3;s:8:"is_admin";b:1;s:11:"permissions";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'user.role.anonymous',
  'data' => 'a:10:{s:4:"uuid";s:36:"62ef622d-8099-4c0e-9332-4aa7bce947bd";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:29:"filter.format.restricted_html";}s:6:"module";a:5:{i:0;s:7:"comment";i:1;s:7:"contact";i:2;s:6:"filter";i:3;s:6:"search";i:4;s:6:"system";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"6WavjUYXIegP9AAg2zXGx54MWIVoomC3SZhNiqe-Dyk";}s:2:"id";s:9:"anonymous";s:5:"label";s:14:"Anonymous user";s:6:"weight";i:0;s:8:"is_admin";b:0;s:11:"permissions";a:5:{i:0;s:15:"access comments";i:1;s:14:"access content";i:2;s:29:"access site-wide contact form";i:3;s:14:"search content";i:4;s:31:"use text format restricted_html";}}',
))
->values(array(
  'collection' => '',
  'name' => 'user.role.authenticated',
  'data' => 'a:10:{s:4:"uuid";s:36:"69a5c5d9-5fad-4bf9-b424-5e572c8e7124";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:24:"filter.format.basic_html";}s:6:"module";a:6:{i:0;s:7:"comment";i:1;s:7:"contact";i:2;s:6:"filter";i:3;s:6:"search";i:4;s:8:"shortcut";i:5;s:6:"system";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"I44QAB4es39lNzMQWiJLq2dfjX7VRSOzT_5KzAcUq_M";}s:2:"id";s:13:"authenticated";s:5:"label";s:18:"Authenticated user";s:6:"weight";i:1;s:8:"is_admin";b:0;s:11:"permissions";a:8:{i:0;s:15:"access comments";i:1;s:14:"access content";i:2;s:16:"access shortcuts";i:3;s:29:"access site-wide contact form";i:4;s:13:"post comments";i:5;s:14:"search content";i:6;s:21:"skip comment approval";i:7;s:26:"use text format basic_html";}}',
))
->values(array(
  'collection' => '',
  'name' => 'user.role.content_editor',
  'data' => 'a:10:{s:4:"uuid";s:36:"97313136-8527-45df-b2b9-89f0a91fa696";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:3:{i:0;s:17:"node.type.article";i:1;s:14:"node.type.page";i:2;s:24:"taxonomy.vocabulary.tags";}s:6:"module";a:9:{i:0;s:7:"comment";i:1;s:10:"contextual";i:2;s:4:"file";i:3;s:4:"node";i:4;s:4:"path";i:5;s:6:"system";i:6;s:8:"taxonomy";i:7;s:7:"toolbar";i:8;s:4:"tour";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Wur9kcEOwY1Jal81NssKnz3RhVJxAvBwyWQBGcA_1Go";}s:2:"id";s:14:"content_editor";s:5:"label";s:14:"Content editor";s:6:"weight";i:2;s:8:"is_admin";b:0;s:11:"permissions";a:23:{i:0;s:27:"access administration pages";i:1;s:23:"access content overview";i:2;s:23:"access contextual links";i:3;s:21:"access files overview";i:4;s:14:"access toolbar";i:5;s:11:"access tour";i:6;s:22:"administer url aliases";i:7;s:22:"create article content";i:8;s:19:"create page content";i:9;s:20:"create terms in tags";i:10;s:18:"create url aliases";i:11;s:24:"delete article revisions";i:12;s:26:"delete own article content";i:13;s:23:"delete own page content";i:14;s:21:"delete page revisions";i:15;s:24:"edit own article content";i:16;s:17:"edit own comments";i:17;s:21:"edit own page content";i:18;s:18:"edit terms in tags";i:19;s:20:"revert all revisions";i:20;s:18:"view all revisions";i:21;s:28:"view own unpublished content";i:22;s:29:"view the administration theme";}}',
))
->values(array(
  'collection' => '',
  'name' => 'user.settings',
  'data' => 'a:9:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"-htDFWUv1S4OlJMzta2nhFl4QbhJvu0D9xsJ-clxo-M";}s:8:"langcode";s:2:"en";s:9:"anonymous";s:9:"Anonymous";s:11:"verify_mail";b:1;s:6:"notify";a:8:{s:14:"cancel_confirm";b:1;s:14:"password_reset";b:1;s:16:"status_activated";b:1;s:14:"status_blocked";b:0;s:15:"status_canceled";b:0;s:22:"register_admin_created";b:1;s:29:"register_no_approval_required";b:1;s:25:"register_pending_approval";b:1;}s:8:"register";s:23:"visitors_admin_approval";s:13:"cancel_method";s:17:"user_cancel_block";s:22:"password_reset_timeout";i:86400;s:17:"password_strength";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'views.settings',
  'data' => 'a:6:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"uZHsLrDp1ThO0RvupHKcPzLOyVvWexm58JTTHNDo7yc";}s:17:"display_extenders";a:0:{}s:10:"skip_cache";b:0;s:13:"sql_signature";b:0;s:2:"ui";a:3:{s:4:"show";a:7:{s:18:"additional_queries";b:0;s:15:"advanced_column";b:0;s:15:"default_display";b:0;s:22:"performance_statistics";b:0;s:19:"preview_information";b:1;s:9:"sql_query";a:2:{s:7:"enabled";b:0;s:5:"where";s:5:"above";}s:13:"display_embed";b:0;}s:19:"always_live_preview";b:1;s:24:"exposed_filter_any_label";s:7:"old_any";}s:22:"field_rewrite_elements";a:29:{s:3:"div";s:3:"DIV";s:4:"span";s:4:"SPAN";s:2:"h1";s:2:"H1";s:2:"h2";s:2:"H2";s:2:"h3";s:2:"H3";s:2:"h4";s:2:"H4";s:2:"h5";s:2:"H5";s:2:"h6";s:2:"H6";s:1:"p";s:1:"P";s:6:"header";s:6:"HEADER";s:6:"footer";s:6:"FOOTER";s:7:"article";s:7:"ARTICLE";s:7:"section";s:7:"SECTION";s:5:"aside";s:5:"ASIDE";s:7:"details";s:7:"DETAILS";s:10:"blockquote";s:10:"BLOCKQUOTE";s:6:"figure";s:6:"FIGURE";s:7:"address";s:7:"ADDRESS";s:4:"code";s:4:"CODE";s:3:"pre";s:3:"PRE";s:3:"var";s:3:"VAR";s:4:"samp";s:4:"SAMP";s:3:"kbd";s:3:"KBD";s:6:"strong";s:6:"STRONG";s:2:"em";s:2:"EM";s:3:"del";s:3:"DEL";s:3:"ins";s:3:"INS";s:1:"q";s:1:"Q";s:1:"s";s:1:"S";}}',
))
->values(array(
  'collection' => '',
  'name' => 'views.view.archive',
  'data' => 'a:13:{s:4:"uuid";s:36:"19e738c3-448d-4d69-b9d0-a284b56894eb";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:33:"core.entity_view_mode.node.teaser";}s:6:"module";a:2:{i:0;s:4:"node";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ko9GznzNBXHkuz09OCaBQ1YOSJYYjTY0TBpNV3WKnog";}s:2:"id";s:7:"archive";s:5:"label";s:7:"Archive";s:6:"module";s:4:"node";s:11:"description";s:22:"All content, by month.";s:3:"tag";s:7:"default";s:10:"base_table";s:15:"node_field_data";s:10:"base_field";s:3:"nid";s:7:"display";a:3:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:17:{s:5:"title";s:15:"Monthly archive";s:6:"fields";a:0:{}s:5:"pager";a:2:{s:4:"type";s:4:"mini";s:7:"options";a:6:{s:6:"offset";i:0;s:14:"items_per_page";i:10;s:11:"total_pages";i:0;s:2:"id";i:0;s:4:"tags";a:2:{s:4:"next";s:6:"››";s:8:"previous";s:6:"‹‹";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:5:"Apply";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:14:"access content";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"empty";a:0:{}s:5:"sorts";a:1:{s:7:"created";a:13:{s:2:"id";s:7:"created";s:5:"table";s:15:"node_field_data";s:5:"field";s:7:"created";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:7:"created";s:9:"plugin_id";s:4:"date";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:7:"created";}s:7:"exposed";b:0;s:11:"granularity";s:6:"second";}}s:9:"arguments";a:1:{s:18:"created_year_month";a:13:{s:2:"id";s:18:"created_year_month";s:5:"table";s:15:"node_field_data";s:5:"field";s:18:"created_year_month";s:11:"entity_type";s:4:"node";s:9:"plugin_id";s:15:"date_year_month";s:14:"default_action";s:7:"summary";s:9:"exception";a:1:{s:12:"title_enable";b:1;}s:12:"title_enable";b:1;s:5:"title";s:34:"{{ arguments.created_year_month }}";s:21:"default_argument_type";s:5:"fixed";s:15:"summary_options";a:2:{s:8:"override";b:1;s:14:"items_per_page";i:30;}s:7:"summary";a:2:{s:10:"sort_order";s:4:"desc";s:6:"format";s:15:"default_summary";}s:18:"specify_validation";b:1;}}s:7:"filters";a:2:{s:6:"status";a:9:{s:2:"id";s:6:"status";s:5:"table";s:15:"node_field_data";s:5:"field";s:6:"status";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:5:"value";s:1:"1";s:5:"group";i:0;s:6:"expose";a:3:{s:8:"operator";s:1:"0";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}}s:8:"langcode";a:16:{s:2:"id";s:8:"langcode";s:5:"table";s:15:"node_field_data";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:8:"langcode";s:9:"plugin_id";s:8:"language";s:8:"operator";s:2:"in";s:5:"value";a:1:{s:31:"***LANGUAGE_language_content***";s:31:"***LANGUAGE_language_content***";}s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:13:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:5:"style";a:2:{s:4:"type";s:7:"default";s:7:"options";a:4:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:11:"uses_fields";b:0;}}s:3:"row";a:2:{s:4:"type";s:11:"entity:node";s:7:"options";a:1:{s:9:"view_mode";s:6:"teaser";}}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:0:{}s:6:"header";a:0:{}s:6:"footer";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:28:"languages:language_interface";i:1;s:3:"url";i:2;s:14:"url.query_args";i:3;s:21:"user.node_grants:view";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:7:"block_1";a:6:{s:2:"id";s:7:"block_1";s:13:"display_title";s:5:"Block";s:14:"display_plugin";s:5:"block";s:8:"position";i:1;s:15:"display_options";a:4:{s:9:"arguments";a:1:{s:18:"created_year_month";a:13:{s:2:"id";s:18:"created_year_month";s:5:"table";s:15:"node_field_data";s:5:"field";s:18:"created_year_month";s:11:"entity_type";s:4:"node";s:9:"plugin_id";s:15:"date_year_month";s:14:"default_action";s:7:"summary";s:9:"exception";a:1:{s:12:"title_enable";b:1;}s:12:"title_enable";b:1;s:5:"title";s:34:"{{ arguments.created_year_month }}";s:21:"default_argument_type";s:5:"fixed";s:15:"summary_options";a:1:{s:14:"items_per_page";i:30;}s:7:"summary";a:1:{s:6:"format";s:15:"default_summary";}s:18:"specify_validation";b:1;}}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:0:{}}s:8:"defaults";a:1:{s:9:"arguments";b:0;}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:28:"languages:language_interface";i:1;s:3:"url";i:2;s:14:"url.query_args";i:3;s:21:"user.node_grants:view";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"page_1";a:6:{s:2:"id";s:6:"page_1";s:13:"display_title";s:4:"Page";s:14:"display_plugin";s:4:"page";s:8:"position";i:2;s:15:"display_options";a:3:{s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:0:{}}s:17:"display_extenders";a:0:{}s:4:"path";s:7:"archive";}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:28:"languages:language_interface";i:1;s:3:"url";i:2;s:14:"url.query_args";i:3;s:21:"user.node_grants:view";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'views.view.block_content',
  'data' => 'a:13:{s:4:"uuid";s:36:"a6ef2058-ad9b-49be-a320-42409905c55e";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:13:"block_content";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"jvd5Pu6jy-lra4oMr-mR7zuY6CVDv9CaNeoj0Y70gV4";}s:2:"id";s:13:"block_content";s:5:"label";s:20:"Custom block library";s:6:"module";s:5:"views";s:11:"description";s:30:"Find and manage custom blocks.";s:3:"tag";s:7:"default";s:10:"base_table";s:24:"block_content_field_data";s:10:"base_field";s:2:"id";s:7:"display";a:2:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:17:{s:5:"title";s:20:"Custom block library";s:6:"fields";a:4:{s:4:"info";a:37:{s:2:"id";s:4:"info";s:5:"table";s:24:"block_content_field_data";s:5:"field";s:4:"info";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";N;s:12:"entity_field";s:4:"info";s:9:"plugin_id";s:5:"field";s:5:"label";s:17:"Block description";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:6:"string";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:4:"type";a:37:{s:2:"id";s:4:"type";s:5:"table";s:24:"block_content_field_data";s:5:"field";s:4:"type";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:13:"block_content";s:12:"entity_field";s:4:"type";s:9:"plugin_id";s:5:"field";s:5:"label";s:10:"Block type";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:9:"target_id";s:4:"type";s:22:"entity_reference_label";s:8:"settings";a:1:{s:4:"link";b:0;}s:12:"group_column";s:9:"target_id";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:7:"changed";a:26:{s:2:"id";s:7:"changed";s:5:"table";s:24:"block_content_field_data";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:13:"block_content";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:5:"field";s:5:"label";s:7:"Updated";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:9:"timestamp";s:8:"settings";a:3:{s:11:"date_format";s:5:"short";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";}}s:10:"operations";a:24:{s:2:"id";s:10:"operations";s:5:"table";s:13:"block_content";s:5:"field";s:10:"operations";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:13:"block_content";s:9:"plugin_id";s:17:"entity_operations";s:5:"label";s:10:"Operations";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:11:"destination";b:1;}}s:5:"pager";a:2:{s:4:"type";s:4:"mini";s:7:"options";a:6:{s:6:"offset";i:0;s:14:"items_per_page";i:50;s:11:"total_pages";N;s:2:"id";i:0;s:4:"tags";a:2:{s:4:"next";s:8:"Next ›";s:8:"previous";s:12:"‹ Previous";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:5:"Apply";s:12:"reset_button";b:1;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:17:"administer blocks";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"empty";a:2:{s:16:"area_text_custom";a:10:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:11:"text_custom";s:5:"empty";b:1;s:7:"content";s:37:"There are no custom blocks available.";s:8:"tokenize";b:0;}s:27:"block_content_listing_empty";a:10:{s:2:"id";s:27:"block_content_listing_empty";s:5:"table";s:13:"block_content";s:5:"field";s:27:"block_content_listing_empty";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:13:"block_content";s:9:"plugin_id";s:27:"block_content_listing_empty";s:5:"label";s:0:"";s:5:"empty";b:1;}}s:5:"sorts";a:0:{}s:9:"arguments";a:0:{}s:7:"filters";a:3:{s:4:"info";a:16:{s:2:"id";s:4:"info";s:5:"table";s:24:"block_content_field_data";s:5:"field";s:4:"info";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:13:"block_content";s:12:"entity_field";s:4:"info";s:9:"plugin_id";s:6:"string";s:8:"operator";s:8:"contains";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:7:"info_op";s:5:"label";s:17:"Block description";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:7:"info_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:4:"info";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:4:"type";a:16:{s:2:"id";s:4:"type";s:5:"table";s:24:"block_content_field_data";s:5:"field";s:4:"type";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:13:"block_content";s:12:"entity_field";s:4:"type";s:9:"plugin_id";s:6:"bundle";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:7:"type_op";s:5:"label";s:10:"Block type";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:7:"type_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:4:"type";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:8:"reusable";a:16:{s:2:"id";s:8:"reusable";s:5:"table";s:24:"block_content_field_data";s:5:"field";s:8:"reusable";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:13:"block_content";s:12:"entity_field";s:8:"reusable";s:9:"plugin_id";s:7:"boolean";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:12:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:7:"columns";a:4:{s:4:"info";s:4:"info";s:4:"type";s:4:"type";s:7:"changed";s:7:"changed";s:10:"operations";s:10:"operations";}s:7:"default";s:7:"changed";s:4:"info";a:4:{s:4:"info";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:4:"type";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:7:"changed";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:10:"operations";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}}s:8:"override";b:1;s:6:"sticky";b:0;s:7:"summary";s:0:"";s:11:"empty_table";b:1;s:7:"caption";s:0:"";s:11:"description";s:0:"";}}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:0:{}s:6:"header";a:0:{}s:6:"footer";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"page_1";a:6:{s:2:"id";s:6:"page_1";s:13:"display_title";s:4:"Page";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:3:{s:17:"display_extenders";a:0:{}s:4:"path";s:35:"admin/structure/block/block-content";s:4:"menu";a:7:{s:4:"type";s:3:"tab";s:5:"title";s:20:"Custom block library";s:11:"description";s:0:"";s:6:"weight";i:0;s:9:"menu_name";s:5:"admin";s:6:"parent";s:19:"block.admin_display";s:7:"context";s:1:"0";}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'views.view.comment',
  'data' => 'a:13:{s:4:"uuid";s:36:"9e2d20b7-d5e7-4d44-9806-4ef509ffdb82";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:7:"comment";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"CgXkKY33fd-yaHz89du2hSw6MJOoIeNUJ-VHE5BiSdQ";}s:2:"id";s:7:"comment";s:5:"label";s:8:"Comments";s:6:"module";s:7:"comment";s:11:"description";s:25:"Find and manage comments.";s:3:"tag";s:7:"default";s:10:"base_table";s:18:"comment_field_data";s:10:"base_field";s:3:"cid";s:7:"display";a:3:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:26:{s:5:"title";s:8:"Comments";s:6:"fields";a:8:{s:17:"comment_bulk_form";a:26:{s:2:"id";s:17:"comment_bulk_form";s:5:"table";s:7:"comment";s:5:"field";s:17:"comment_bulk_form";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:9:"plugin_id";s:17:"comment_bulk_form";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:12:"action_title";s:6:"Action";s:15:"include_exclude";s:7:"include";s:16:"selected_actions";a:2:{i:0;s:21:"comment_delete_action";i:1;s:24:"comment_unpublish_action";}}s:7:"subject";a:37:{s:2:"id";s:7:"subject";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"subject";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"subject";s:9:"plugin_id";s:5:"field";s:5:"label";s:7:"Subject";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:17:"comment_permalink";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:3:"uid";a:37:{s:2:"id";s:3:"uid";s:5:"table";s:18:"comment_field_data";s:5:"field";s:3:"uid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:3:"uid";s:9:"plugin_id";s:5:"field";s:5:"label";s:0:"";s:7:"exclude";b:1;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:9:"target_id";s:4:"type";s:22:"entity_reference_label";s:8:"settings";a:1:{s:4:"link";b:1;}s:12:"group_column";s:9:"target_id";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:4:"name";a:37:{s:2:"id";s:4:"name";s:5:"table";s:18:"comment_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:5:"field";s:5:"label";s:6:"Author";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:9:"{{ uid }}";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:16:"comment_username";s:8:"settings";a:0:{}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:9:"entity_id";a:37:{s:2:"id";s:9:"entity_id";s:5:"table";s:18:"comment_field_data";s:5:"field";s:9:"entity_id";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:9:"entity_id";s:9:"plugin_id";s:16:"commented_entity";s:5:"label";s:9:"Posted in";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:9:"target_id";s:4:"type";s:22:"entity_reference_label";s:8:"settings";a:1:{s:4:"link";b:1;}s:12:"group_column";s:9:"target_id";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:7:"changed";a:37:{s:2:"id";s:7:"changed";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:5:"field";s:5:"label";s:7:"Updated";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:9:"timestamp";s:8:"settings";a:3:{s:11:"date_format";s:5:"short";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:10:"operations";a:24:{s:2:"id";s:10:"operations";s:5:"table";s:7:"comment";s:5:"field";s:10:"operations";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:9:"plugin_id";s:17:"entity_operations";s:5:"label";s:10:"Operations";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:11:"destination";b:1;}s:6:"name_1";a:37:{s:2:"id";s:6:"name_1";s:5:"table";s:16:"users_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:3:"uid";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:5:"field";s:5:"label";s:0:"";s:7:"exclude";b:1;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:9:"user_name";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}}s:5:"pager";a:2:{s:4:"type";s:4:"full";s:7:"options";a:7:{s:6:"offset";i:0;s:14:"items_per_page";i:50;s:11:"total_pages";N;s:2:"id";i:0;s:4:"tags";a:4:{s:4:"next";s:8:"next ›";s:8:"previous";s:12:"‹ previous";s:5:"first";s:8:"« first";s:4:"last";s:7:"last »";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}s:8:"quantity";i:9;}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:6:"Filter";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:19:"administer comments";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"empty";a:1:{s:16:"area_text_custom";a:10:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:11:"text_custom";s:5:"empty";b:1;s:7:"content";s:22:"No comments available.";s:8:"tokenize";b:0;}}s:5:"sorts";a:1:{s:7:"changed";a:13:{s:2:"id";s:7:"changed";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:4:"date";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:7:"changed";}s:7:"exposed";b:0;s:11:"granularity";s:6:"second";}}s:9:"arguments";a:0:{}s:7:"filters";a:4:{s:6:"status";a:16:{s:2:"id";s:6:"status";s:5:"table";s:18:"comment_field_data";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:7:"subject";a:16:{s:2:"id";s:7:"subject";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"subject";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"subject";s:9:"plugin_id";s:6:"string";s:8:"operator";s:8:"contains";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:10:"subject_op";s:5:"label";s:7:"Subject";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:10:"subject_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:7:"subject";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:7:"combine";a:15:{s:2:"id";s:7:"combine";s:5:"table";s:5:"views";s:5:"field";s:7:"combine";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:7:"combine";s:8:"operator";s:8:"contains";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:10:"combine_op";s:5:"label";s:11:"Author name";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:10:"combine_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:11:"author_name";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:6:"fields";a:2:{s:4:"name";s:4:"name";s:6:"name_1";s:6:"name_1";}}s:8:"langcode";a:16:{s:2:"id";s:8:"langcode";s:5:"table";s:18:"comment_field_data";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:8:"langcode";s:9:"plugin_id";s:8:"language";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:11:"langcode_op";s:5:"label";s:8:"Language";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:11:"langcode_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:8:"langcode";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:13:"filter_groups";a:2:{s:8:"operator";s:3:"AND";s:6:"groups";a:1:{i:1;s:3:"AND";}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:12:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:7:"columns";a:6:{s:17:"comment_bulk_form";s:17:"comment_bulk_form";s:7:"subject";s:7:"subject";s:3:"uid";s:3:"uid";s:9:"entity_id";s:9:"entity_id";s:7:"changed";s:7:"changed";s:10:"operations";s:10:"operations";}s:7:"default";s:7:"changed";s:4:"info";a:6:{s:17:"comment_bulk_form";a:4:{s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:7:"subject";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:3:"uid";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:9:"entity_id";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:7:"changed";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:10:"operations";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}}s:8:"override";b:1;s:6:"sticky";b:1;s:7:"summary";s:0:"";s:11:"empty_table";b:1;s:7:"caption";s:0:"";s:11:"description";s:0:"";}}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:1:{s:3:"uid";a:10:{s:2:"id";s:3:"uid";s:5:"table";s:18:"comment_field_data";s:5:"field";s:3:"uid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:6:"author";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:3:"uid";s:9:"plugin_id";s:8:"standard";s:8:"required";b:0;}}s:9:"css_class";s:0:"";s:8:"use_ajax";b:0;s:8:"group_by";b:0;s:16:"show_admin_links";b:1;s:8:"use_more";b:0;s:15:"use_more_always";b:1;s:13:"use_more_text";s:4:"more";s:6:"header";a:0:{}s:6:"footer";a:0:{}s:23:"hide_attachment_summary";b:0;s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:4:{s:7:"max-age";i:0;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}s:9:"cacheable";b:0;}}s:14:"page_published";a:6:{s:2:"id";s:14:"page_published";s:13:"display_title";s:18:"Published comments";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:6:{s:19:"display_description";s:30:"The approved comments listing.";s:15:"display_comment";s:0:"";s:13:"exposed_block";b:0;s:17:"display_extenders";a:0:{}s:4:"path";s:21:"admin/content/comment";s:4:"menu";a:7:{s:4:"type";s:3:"tab";s:5:"title";s:8:"Comments";s:11:"description";s:18:"Comments published";s:6:"weight";i:0;s:9:"menu_name";s:5:"admin";s:6:"parent";s:0:"";s:7:"context";s:1:"0";}}s:14:"cache_metadata";a:4:{s:7:"max-age";i:0;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}s:9:"cacheable";b:0;}}s:15:"page_unapproved";a:6:{s:2:"id";s:15:"page_unapproved";s:13:"display_title";s:19:"Unapproved comments";s:14:"display_plugin";s:4:"page";s:8:"position";i:2;s:15:"display_options";a:8:{s:6:"fields";a:8:{s:17:"comment_bulk_form";a:26:{s:2:"id";s:17:"comment_bulk_form";s:5:"table";s:7:"comment";s:5:"field";s:17:"comment_bulk_form";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:9:"plugin_id";s:17:"comment_bulk_form";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:12:"action_title";s:6:"Action";s:15:"include_exclude";s:7:"include";s:16:"selected_actions";a:2:{i:0;s:21:"comment_delete_action";i:1;s:22:"comment_publish_action";}}s:7:"subject";a:37:{s:2:"id";s:7:"subject";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"subject";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"subject";s:9:"plugin_id";s:5:"field";s:5:"label";s:7:"Subject";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:17:"comment_permalink";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:3:"uid";a:37:{s:2:"id";s:3:"uid";s:5:"table";s:18:"comment_field_data";s:5:"field";s:3:"uid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:3:"uid";s:9:"plugin_id";s:5:"field";s:5:"label";s:0:"";s:7:"exclude";b:1;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:9:"target_id";s:4:"type";s:22:"entity_reference_label";s:8:"settings";a:1:{s:4:"link";b:1;}s:12:"group_column";s:9:"target_id";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:4:"name";a:37:{s:2:"id";s:4:"name";s:5:"table";s:18:"comment_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:5:"field";s:5:"label";s:6:"Author";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:9:"{{ uid }}";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:16:"comment_username";s:8:"settings";a:0:{}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:9:"entity_id";a:37:{s:2:"id";s:9:"entity_id";s:5:"table";s:18:"comment_field_data";s:5:"field";s:9:"entity_id";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:9:"entity_id";s:9:"plugin_id";s:16:"commented_entity";s:5:"label";s:9:"Posted in";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:9:"target_id";s:4:"type";s:22:"entity_reference_label";s:8:"settings";a:1:{s:4:"link";b:1;}s:12:"group_column";s:9:"target_id";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:7:"changed";a:37:{s:2:"id";s:7:"changed";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:5:"field";s:5:"label";s:7:"Updated";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:9:"timestamp";s:8:"settings";a:3:{s:11:"date_format";s:5:"short";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:10:"operations";a:24:{s:2:"id";s:10:"operations";s:5:"table";s:7:"comment";s:5:"field";s:10:"operations";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:9:"plugin_id";s:17:"entity_operations";s:5:"label";s:10:"Operations";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:11:"destination";b:1;}s:6:"name_1";a:37:{s:2:"id";s:6:"name_1";s:5:"table";s:16:"users_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:3:"uid";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:5:"field";s:5:"label";s:0:"";s:7:"exclude";b:1;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:9:"user_name";s:8:"settings";a:1:{s:14:"link_to_entity";b:0;}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}}s:7:"filters";a:4:{s:6:"status";a:16:{s:2:"id";s:6:"status";s:5:"table";s:18:"comment_field_data";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:8:"operator";s:1:"=";s:5:"value";s:1:"0";s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:7:"subject";a:16:{s:2:"id";s:7:"subject";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"subject";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"subject";s:9:"plugin_id";s:6:"string";s:8:"operator";s:8:"contains";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:10:"subject_op";s:5:"label";s:7:"Subject";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:10:"subject_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:7:"subject";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:7:"combine";a:15:{s:2:"id";s:7:"combine";s:5:"table";s:5:"views";s:5:"field";s:7:"combine";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:7:"combine";s:8:"operator";s:8:"contains";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:10:"combine_op";s:5:"label";s:11:"Author Name";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:10:"combine_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:11:"author_name";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:6:"fields";a:2:{s:4:"name";s:4:"name";s:6:"name_1";s:6:"name_1";}}s:8:"langcode";a:16:{s:2:"id";s:8:"langcode";s:5:"table";s:18:"comment_field_data";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:8:"langcode";s:9:"plugin_id";s:8:"language";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:11:"langcode_op";s:5:"label";s:8:"Language";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:11:"langcode_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:8:"langcode";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:13:"filter_groups";a:2:{s:8:"operator";s:3:"AND";s:6:"groups";a:1:{i:1;s:3:"AND";}}s:8:"defaults";a:3:{s:6:"fields";b:0;s:7:"filters";b:0;s:13:"filter_groups";b:0;}s:19:"display_description";s:32:"The unapproved comments listing.";s:17:"display_extenders";a:0:{}s:4:"path";s:30:"admin/content/comment/approval";s:4:"menu";a:7:{s:4:"type";s:3:"tab";s:5:"title";s:19:"Unapproved comments";s:11:"description";s:19:"Comments unapproved";s:6:"weight";i:1;s:9:"menu_name";s:5:"admin";s:6:"parent";s:0:"";s:7:"context";s:1:"0";}}s:14:"cache_metadata";a:4:{s:7:"max-age";i:0;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}s:9:"cacheable";b:0;}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'views.view.comments_recent',
  'data' => 'a:13:{s:4:"uuid";s:36:"fde5a3d5-3205-4baf-a22b-38b8b2d1ff07";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:3:{i:0;s:7:"comment";i:1;s:4:"node";i:2;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"S_NN2ubd_NovTfgzbHVlZMmIJJQS-3h9h3inzbaFUMY";}s:2:"id";s:15:"comments_recent";s:5:"label";s:15:"Recent comments";s:6:"module";s:5:"views";s:11:"description";s:16:"Recent comments.";s:3:"tag";s:7:"default";s:10:"base_table";s:18:"comment_field_data";s:10:"base_field";s:3:"cid";s:7:"display";a:2:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:14:{s:5:"title";s:15:"Recent comments";s:6:"fields";a:2:{s:7:"subject";a:26:{s:2:"id";s:7:"subject";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"subject";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"subject";s:9:"plugin_id";s:5:"field";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:0;s:8:"ellipsis";b:0;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:6:"string";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}}s:7:"changed";a:26:{s:2:"id";s:7:"changed";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:5:"field";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:13:"timestamp_ago";s:8:"settings";a:3:{s:13:"future_format";s:15:"@interval hence";s:11:"past_format";s:13:"@interval ago";s:11:"granularity";i:2;}}}s:5:"pager";a:2:{s:4:"type";s:4:"some";s:7:"options";a:2:{s:6:"offset";i:0;s:14:"items_per_page";i:10;}}s:12:"exposed_form";a:1:{s:4:"type";s:5:"basic";}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:15:"access comments";}}s:5:"cache";a:1:{s:4:"type";s:3:"tag";}s:5:"empty";a:1:{s:16:"area_text_custom";a:11:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:11:"text_custom";s:5:"label";s:0:"";s:5:"empty";b:1;s:7:"content";s:22:"No comments available.";s:8:"tokenize";b:0;}}s:5:"sorts";a:2:{s:7:"created";a:12:{s:2:"id";s:7:"created";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"created";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"created";s:9:"plugin_id";s:4:"date";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:7:"created";}s:7:"exposed";b:0;}s:3:"cid";a:12:{s:2:"id";s:3:"cid";s:5:"table";s:18:"comment_field_data";s:5:"field";s:3:"cid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:3:"cid";s:9:"plugin_id";s:5:"field";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:3:"cid";}s:7:"exposed";b:0;}}s:7:"filters";a:2:{s:6:"status";a:9:{s:2:"id";s:6:"status";s:5:"table";s:18:"comment_field_data";s:5:"field";s:6:"status";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:5:"value";s:1:"1";s:5:"group";i:1;s:6:"expose";a:3:{s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}}s:11:"status_node";a:10:{s:2:"id";s:11:"status_node";s:5:"table";s:15:"node_field_data";s:5:"field";s:6:"status";s:12:"relationship";s:4:"node";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:5:"value";s:1:"1";s:5:"group";i:1;s:6:"expose";a:3:{s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}}}s:5:"style";a:2:{s:4:"type";s:9:"html_list";s:7:"options";a:6:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:4:"type";s:2:"ul";s:13:"wrapper_class";s:9:"item-list";s:5:"class";s:0:"";}}s:3:"row";a:2:{s:4:"type";s:6:"fields";s:7:"options";a:2:{s:22:"default_field_elements";b:1;s:10:"hide_empty";b:0;}}s:5:"query";a:1:{s:4:"type";s:11:"views_query";}s:13:"relationships";a:1:{s:4:"node";a:5:{s:2:"id";s:4:"node";s:5:"table";s:18:"comment_field_data";s:5:"field";s:4:"node";s:9:"plugin_id";s:8:"standard";s:8:"required";b:1;}}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:3:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:7:"block_1";a:6:{s:2:"id";s:7:"block_1";s:13:"display_title";s:5:"Block";s:14:"display_plugin";s:5:"block";s:8:"position";i:1;s:15:"display_options";a:4:{s:17:"display_extenders";a:0:{}s:17:"block_description";s:15:"Recent comments";s:14:"block_category";s:13:"Lists (Views)";s:5:"allow";a:1:{s:14:"items_per_page";b:1;}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:3:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'views.view.content',
  'data' => 'a:13:{s:4:"uuid";s:36:"854b9cc0-5812-4641-9264-2a5477b753e0";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:4:"node";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"vBKWYGGDoAX-tFd1JErB8tZLSxx3lJ0foouVsgpcbB4";}s:2:"id";s:7:"content";s:5:"label";s:7:"Content";s:6:"module";s:4:"node";s:11:"description";s:24:"Find and manage content.";s:3:"tag";s:7:"default";s:10:"base_table";s:15:"node_field_data";s:10:"base_field";s:3:"nid";s:7:"display";a:2:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:17:{s:5:"title";s:7:"Content";s:6:"fields";a:7:{s:14:"node_bulk_form";a:14:{s:2:"id";s:14:"node_bulk_form";s:5:"table";s:4:"node";s:5:"field";s:14:"node_bulk_form";s:11:"entity_type";s:4:"node";s:9:"plugin_id";s:14:"node_bulk_form";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:1:{s:10:"alter_text";b:0;}s:13:"element_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;}s:5:"title";a:17:{s:2:"id";s:5:"title";s:5:"table";s:15:"node_field_data";s:5:"field";s:5:"title";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:5:"title";s:9:"plugin_id";s:5:"field";s:5:"label";s:5:"Title";s:7:"exclude";b:0;s:5:"alter";a:1:{s:10:"alter_text";b:0;}s:13:"element_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:6:"string";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}}s:4:"type";a:37:{s:2:"id";s:4:"type";s:5:"table";s:15:"node_field_data";s:5:"field";s:4:"type";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:4:"type";s:9:"plugin_id";s:5:"field";s:5:"label";s:12:"Content type";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:9:"target_id";s:4:"type";s:22:"entity_reference_label";s:8:"settings";a:1:{s:4:"link";b:0;}s:12:"group_column";s:9:"target_id";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:4:"name";a:17:{s:2:"id";s:4:"name";s:5:"table";s:16:"users_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:3:"uid";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:5:"field";s:5:"label";s:6:"Author";s:7:"exclude";b:0;s:5:"alter";a:1:{s:10:"alter_text";b:0;}s:13:"element_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:9:"user_name";}s:6:"status";a:17:{s:2:"id";s:6:"status";s:5:"table";s:15:"node_field_data";s:5:"field";s:6:"status";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:5:"field";s:5:"label";s:6:"Status";s:7:"exclude";b:0;s:5:"alter";a:1:{s:10:"alter_text";b:0;}s:13:"element_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:7:"boolean";s:8:"settings";a:3:{s:6:"format";s:6:"custom";s:19:"format_custom_false";s:11:"Unpublished";s:18:"format_custom_true";s:9:"Published";}}s:7:"changed";a:17:{s:2:"id";s:7:"changed";s:5:"table";s:15:"node_field_data";s:5:"field";s:7:"changed";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:5:"field";s:5:"label";s:7:"Updated";s:7:"exclude";b:0;s:5:"alter";a:1:{s:10:"alter_text";b:0;}s:13:"element_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:9:"timestamp";s:8:"settings";a:3:{s:11:"date_format";s:5:"short";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";}}s:10:"operations";a:23:{s:2:"id";s:10:"operations";s:5:"table";s:4:"node";s:5:"field";s:10:"operations";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:17:"entity_operations";s:5:"label";s:10:"Operations";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:11:"destination";b:1;}}s:5:"pager";a:2:{s:4:"type";s:4:"full";s:7:"options";a:2:{s:14:"items_per_page";i:50;s:4:"tags";a:4:{s:4:"next";s:8:"Next ›";s:8:"previous";s:12:"‹ Previous";s:5:"first";s:8:"« First";s:4:"last";s:7:"Last »";}}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:6:"Filter";s:12:"reset_button";b:1;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:23:"access content overview";}}s:5:"cache";a:1:{s:4:"type";s:3:"tag";}s:5:"empty";a:1:{s:16:"area_text_custom";a:6:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:9:"plugin_id";s:11:"text_custom";s:5:"empty";b:1;s:7:"content";s:21:"No content available.";}}s:5:"sorts";a:0:{}s:9:"arguments";a:0:{}s:7:"filters";a:5:{s:5:"title";a:16:{s:2:"id";s:5:"title";s:5:"table";s:15:"node_field_data";s:5:"field";s:5:"title";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:5:"title";s:9:"plugin_id";s:6:"string";s:8:"operator";s:8:"contains";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:8:"title_op";s:5:"label";s:5:"Title";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:8:"title_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:5:"title";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:4:"type";a:16:{s:2:"id";s:4:"type";s:5:"table";s:15:"node_field_data";s:5:"field";s:4:"type";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:4:"type";s:9:"plugin_id";s:6:"bundle";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:7:"type_op";s:5:"label";s:12:"Content type";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:7:"type_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:4:"type";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:6:"status";a:16:{s:2:"id";s:6:"status";s:5:"table";s:15:"node_field_data";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:6:"Status";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:9:"status_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:6:"status";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:1;s:10:"group_info";a:10:{s:5:"label";s:16:"Published status";s:11:"description";s:0:"";s:10:"identifier";s:6:"status";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:2:{i:1;a:3:{s:5:"title";s:9:"Published";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";}i:2;a:3:{s:5:"title";s:11:"Unpublished";s:8:"operator";s:1:"=";s:5:"value";s:1:"0";}}}}s:8:"langcode";a:16:{s:2:"id";s:8:"langcode";s:5:"table";s:15:"node_field_data";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:8:"langcode";s:9:"plugin_id";s:8:"language";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:11:"langcode_op";s:5:"label";s:8:"Language";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:11:"langcode_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:8:"langcode";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:12:"status_extra";a:9:{s:2:"id";s:12:"status_extra";s:5:"table";s:15:"node_field_data";s:5:"field";s:12:"status_extra";s:11:"entity_type";s:4:"node";s:9:"plugin_id";s:11:"node_status";s:8:"operator";s:1:"=";s:5:"value";b:0;s:5:"group";i:1;s:6:"expose";a:2:{s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}}}s:13:"filter_groups";a:2:{s:8:"operator";s:3:"AND";s:6:"groups";a:1:{i:1;s:3:"AND";}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:12:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:7:"columns";a:10:{s:14:"node_bulk_form";s:14:"node_bulk_form";s:5:"title";s:5:"title";s:4:"type";s:4:"type";s:4:"name";s:4:"name";s:6:"status";s:6:"status";s:7:"changed";s:7:"changed";s:9:"edit_node";s:9:"edit_node";s:11:"delete_node";s:11:"delete_node";s:10:"dropbutton";s:10:"dropbutton";s:9:"timestamp";s:5:"title";}s:7:"default";s:7:"changed";s:4:"info";a:10:{s:14:"node_bulk_form";a:4:{s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:5:"title";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:4:"type";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:4:"name";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:6:"status";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:7:"changed";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:9:"edit_node";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:11:"delete_node";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:10:"dropbutton";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:9:"timestamp";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}}s:8:"override";b:1;s:6:"sticky";b:1;s:7:"summary";s:0:"";s:11:"empty_table";b:1;s:7:"caption";s:0:"";s:11:"description";s:0:"";}}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:5:"query";a:1:{s:4:"type";s:11:"views_query";}s:13:"relationships";a:1:{s:3:"uid";a:6:{s:2:"id";s:3:"uid";s:5:"table";s:15:"node_field_data";s:5:"field";s:3:"uid";s:11:"admin_label";s:6:"author";s:9:"plugin_id";s:8:"standard";s:8:"required";b:1;}}s:16:"show_admin_links";b:0;s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:0;s:8:"contexts";a:7:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:4:"user";i:5;s:21:"user.node_grants:view";i:6;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"page_1";a:6:{s:2:"id";s:6:"page_1";s:13:"display_title";s:4:"Page";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:4:{s:17:"display_extenders";a:0:{}s:4:"path";s:18:"admin/content/node";s:4:"menu";a:6:{s:4:"type";s:11:"default tab";s:5:"title";s:7:"Content";s:11:"description";s:0:"";s:6:"weight";i:-10;s:9:"menu_name";s:5:"admin";s:7:"context";s:0:"";}s:11:"tab_options";a:5:{s:4:"type";s:6:"normal";s:5:"title";s:7:"Content";s:11:"description";s:23:"Find and manage content";s:6:"weight";i:-10;s:9:"menu_name";s:5:"admin";}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:0;s:8:"contexts";a:7:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:4:"user";i:5;s:21:"user.node_grants:view";i:6;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'views.view.content_recent',
  'data' => 'a:13:{s:4:"uuid";s:36:"967b6c2c-aaab-4f4e-ae95-7888fcf58266";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:4:"node";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"YqZN5rc7XDQcFcInc8wkzuaHJmC5YvirhTmDcrarT6M";}s:2:"id";s:14:"content_recent";s:5:"label";s:14:"Recent content";s:6:"module";s:4:"node";s:11:"description";s:15:"Recent content.";s:3:"tag";s:7:"default";s:10:"base_table";s:15:"node_field_data";s:10:"base_field";s:3:"nid";s:7:"display";a:2:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:22:{s:5:"title";s:14:"Recent content";s:6:"fields";a:2:{s:5:"title";a:26:{s:2:"id";s:5:"title";s:5:"table";s:15:"node_field_data";s:5:"field";s:5:"title";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:5:"title";s:9:"plugin_id";s:5:"field";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:8:{s:10:"alter_text";b:0;s:9:"make_link";b:0;s:8:"absolute";b:0;s:13:"word_boundary";b:0;s:8:"ellipsis";b:0;s:10:"strip_tags";b:0;s:4:"trim";b:0;s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:6:"string";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}}s:7:"changed";a:37:{s:2:"id";s:7:"changed";s:5:"table";s:15:"node_field_data";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:5:"field";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:13:"timestamp_ago";s:8:"settings";a:0:{}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}}s:5:"pager";a:2:{s:4:"type";s:4:"some";s:7:"options";a:2:{s:6:"offset";i:0;s:14:"items_per_page";i:10;}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:5:"Apply";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:14:"access content";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"empty";a:1:{s:16:"area_text_custom";a:10:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:11:"text_custom";s:5:"empty";b:1;s:7:"content";s:21:"No content available.";s:8:"tokenize";b:0;}}s:5:"sorts";a:1:{s:7:"changed";a:13:{s:2:"id";s:7:"changed";s:5:"table";s:15:"node_field_data";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:4:"date";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:7:"changed";}s:7:"exposed";b:0;s:11:"granularity";s:6:"second";}}s:9:"arguments";a:0:{}s:7:"filters";a:2:{s:12:"status_extra";a:15:{s:2:"id";s:12:"status_extra";s:5:"table";s:15:"node_field_data";s:5:"field";s:12:"status_extra";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:9:"plugin_id";s:11:"node_status";s:8:"operator";s:1:"=";s:5:"value";b:0;s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:8:"langcode";a:16:{s:2:"id";s:8:"langcode";s:5:"table";s:15:"node_field_data";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:8:"langcode";s:9:"plugin_id";s:8:"language";s:8:"operator";s:2:"in";s:5:"value";a:1:{s:31:"***LANGUAGE_language_content***";s:31:"***LANGUAGE_language_content***";}s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:13:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:5:"style";a:2:{s:4:"type";s:9:"html_list";s:7:"options";a:6:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:4:"type";s:2:"ul";s:13:"wrapper_class";s:9:"item-list";s:5:"class";s:0:"";}}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:1:{s:3:"uid";a:10:{s:2:"id";s:3:"uid";s:5:"table";s:15:"node_field_data";s:5:"field";s:3:"uid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:6:"author";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:3:"uid";s:9:"plugin_id";s:8:"standard";s:8:"required";b:1;}}s:8:"use_more";b:0;s:15:"use_more_always";b:0;s:13:"use_more_text";s:4:"More";s:12:"link_display";s:1:"0";s:8:"link_url";s:0:"";s:6:"header";a:0:{}s:6:"footer";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:4:"user";i:3;s:21:"user.node_grants:view";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:7:"block_1";a:6:{s:2:"id";s:7:"block_1";s:13:"display_title";s:5:"Block";s:14:"display_plugin";s:5:"block";s:8:"position";i:1;s:15:"display_options";a:1:{s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:4:"user";i:3;s:21:"user.node_grants:view";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'views.view.files',
  'data' => 'a:13:{s:4:"uuid";s:36:"4f8d7912-8acb-4ef7-9c76-ff228942601e";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:4:"file";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"DaGeEDJMcbbQtgV96AuPeZ-0irMc_Oa6Zzh2U3Kmul8";}s:2:"id";s:5:"files";s:5:"label";s:5:"Files";s:6:"module";s:4:"file";s:11:"description";s:22:"Find and manage files.";s:3:"tag";s:7:"default";s:10:"base_table";s:12:"file_managed";s:10:"base_field";s:3:"fid";s:7:"display";a:3:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:19:{s:5:"title";s:5:"Files";s:6:"fields";a:8:{s:3:"fid";a:24:{s:2:"id";s:3:"fid";s:5:"table";s:12:"file_managed";s:5:"field";s:3:"fid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:3:"fid";s:9:"plugin_id";s:5:"field";s:5:"label";s:3:"Fid";s:7:"exclude";b:1;s:5:"alter";a:8:{s:10:"alter_text";b:0;s:9:"make_link";b:0;s:8:"absolute";b:0;s:13:"word_boundary";b:0;s:8:"ellipsis";b:0;s:10:"strip_tags";b:0;s:4:"trim";b:0;s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;}s:8:"filename";a:36:{s:2:"id";s:8:"filename";s:5:"table";s:12:"file_managed";s:5:"field";s:8:"filename";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:8:"filename";s:9:"plugin_id";s:5:"field";s:5:"label";s:4:"Name";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:0;s:8:"ellipsis";b:0;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:9:"file_link";s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:8:"filemime";a:25:{s:2:"id";s:8:"filemime";s:5:"table";s:12:"file_managed";s:5:"field";s:8:"filemime";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:8:"filemime";s:9:"plugin_id";s:5:"field";s:5:"label";s:9:"MIME type";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:13:"file_filemime";}s:8:"filesize";a:25:{s:2:"id";s:8:"filesize";s:5:"table";s:12:"file_managed";s:5:"field";s:8:"filesize";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:8:"filesize";s:9:"plugin_id";s:5:"field";s:5:"label";s:4:"Size";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:9:"file_size";}s:6:"status";a:26:{s:2:"id";s:6:"status";s:5:"table";s:12:"file_managed";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:5:"field";s:5:"label";s:6:"Status";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:7:"boolean";s:8:"settings";a:3:{s:6:"format";s:6:"custom";s:19:"format_custom_false";s:9:"Temporary";s:18:"format_custom_true";s:9:"Permanent";}}s:7:"created";a:26:{s:2:"id";s:7:"created";s:5:"table";s:12:"file_managed";s:5:"field";s:7:"created";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:7:"created";s:9:"plugin_id";s:5:"field";s:5:"label";s:11:"Upload date";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:9:"timestamp";s:8:"settings";a:3:{s:11:"date_format";s:6:"medium";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";}}s:7:"changed";a:26:{s:2:"id";s:7:"changed";s:5:"table";s:12:"file_managed";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:5:"field";s:5:"label";s:12:"Changed date";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:9:"timestamp";s:8:"settings";a:3:{s:11:"date_format";s:6:"medium";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";}}s:5:"count";a:30:{s:2:"id";s:5:"count";s:5:"table";s:10:"file_usage";s:5:"field";s:5:"count";s:12:"relationship";s:3:"fid";s:10:"group_type";s:3:"sum";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:7:"numeric";s:5:"label";s:7:"Used in";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:1;s:4:"path";s:35:"admin/content/files/usage/{{ fid }}";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:13:"set_precision";b:0;s:9:"precision";i:0;s:7:"decimal";s:1:".";s:9:"separator";s:1:",";s:13:"format_plural";b:1;s:20:"format_plural_string";s:21:"1 place@count places";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:5:"pager";a:2:{s:4:"type";s:4:"mini";s:7:"options";a:6:{s:6:"offset";i:0;s:14:"items_per_page";i:50;s:11:"total_pages";i:0;s:2:"id";i:0;s:4:"tags";a:2:{s:4:"next";s:8:"Next ›";s:8:"previous";s:12:"‹ Previous";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:6:"Filter";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:21:"access files overview";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"empty";a:1:{s:16:"area_text_custom";a:6:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:9:"plugin_id";s:11:"text_custom";s:5:"empty";b:1;s:7:"content";s:19:"No files available.";}}s:5:"sorts";a:0:{}s:9:"arguments";a:0:{}s:7:"filters";a:3:{s:8:"filename";a:16:{s:2:"id";s:8:"filename";s:5:"table";s:12:"file_managed";s:5:"field";s:8:"filename";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:8:"filename";s:9:"plugin_id";s:6:"string";s:8:"operator";s:4:"word";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:11:"filemime_op";s:5:"label";s:8:"Filename";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:11:"filename_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:8:"filename";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:8:"filemime";a:16:{s:2:"id";s:8:"filemime";s:5:"table";s:12:"file_managed";s:5:"field";s:8:"filemime";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:8:"filemime";s:9:"plugin_id";s:6:"string";s:8:"operator";s:4:"word";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:11:"filemime_op";s:5:"label";s:9:"MIME type";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:11:"filemime_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:8:"filemime";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:6:"status";a:16:{s:2:"id";s:6:"status";s:5:"table";s:12:"file_managed";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:11:"file_status";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:9:"status_op";s:5:"label";s:6:"Status";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:9:"status_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:6:"status";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:12:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:7:"columns";a:8:{s:3:"fid";s:3:"fid";s:8:"filename";s:8:"filename";s:8:"filemime";s:8:"filemime";s:8:"filesize";s:8:"filesize";s:6:"status";s:6:"status";s:7:"created";s:7:"created";s:7:"changed";s:7:"changed";s:5:"count";s:5:"count";}s:7:"default";s:7:"changed";s:4:"info";a:8:{s:3:"fid";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:8:"filename";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:8:"filemime";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:15:"priority-medium";}s:8:"filesize";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:6:"status";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:7:"created";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:7:"changed";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:5:"count";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:15:"priority-medium";}}s:8:"override";b:1;s:6:"sticky";b:0;s:7:"summary";s:0:"";s:11:"empty_table";b:1;s:7:"caption";s:0:"";s:11:"description";s:0:"";}}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:1:{s:3:"fid";a:7:{s:2:"id";s:3:"fid";s:5:"table";s:12:"file_managed";s:5:"field";s:3:"fid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:10:"File usage";s:8:"required";b:1;}}s:8:"group_by";b:1;s:16:"show_admin_links";b:1;s:6:"header";a:0:{}s:6:"footer";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"page_1";a:6:{s:2:"id";s:6:"page_1";s:13:"display_title";s:14:"Files overview";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:6:{s:8:"defaults";a:2:{s:5:"pager";b:1;s:13:"relationships";b:0;}s:13:"relationships";a:1:{s:3:"fid";a:7:{s:2:"id";s:3:"fid";s:5:"table";s:12:"file_managed";s:5:"field";s:3:"fid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:10:"File usage";s:8:"required";b:0;}}s:19:"display_description";s:0:"";s:17:"display_extenders";a:0:{}s:4:"path";s:19:"admin/content/files";s:4:"menu";a:6:{s:4:"type";s:3:"tab";s:5:"title";s:5:"Files";s:11:"description";s:0:"";s:6:"weight";i:0;s:9:"menu_name";s:5:"admin";s:7:"context";s:0:"";}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"page_2";a:6:{s:2:"id";s:6:"page_2";s:13:"display_title";s:10:"File usage";s:14:"display_plugin";s:4:"page";s:8:"position";i:2;s:15:"display_options";a:15:{s:5:"title";s:10:"File usage";s:6:"fields";a:4:{s:12:"entity_label";a:23:{s:2:"id";s:12:"entity_label";s:5:"table";s:10:"file_usage";s:5:"field";s:12:"entity_label";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:12:"entity_label";s:5:"label";s:6:"Entity";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:14:"link_to_entity";b:1;}s:4:"type";a:22:{s:2:"id";s:4:"type";s:5:"table";s:10:"file_usage";s:5:"field";s:4:"type";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:8:"standard";s:5:"label";s:11:"Entity type";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;}s:6:"module";a:22:{s:2:"id";s:6:"module";s:5:"table";s:10:"file_usage";s:5:"field";s:6:"module";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:8:"standard";s:5:"label";s:18:"Registering module";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;}s:5:"count";a:30:{s:2:"id";s:5:"count";s:5:"table";s:10:"file_usage";s:5:"field";s:5:"count";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:7:"numeric";s:5:"label";s:9:"Use count";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:13:"set_precision";b:0;s:9:"precision";i:0;s:7:"decimal";s:1:".";s:9:"separator";s:1:",";s:13:"format_plural";b:0;s:20:"format_plural_string";s:8:"1@count";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:5:"pager";a:2:{s:4:"type";s:4:"mini";s:7:"options";a:6:{s:6:"offset";i:0;s:14:"items_per_page";i:10;s:11:"total_pages";i:0;s:2:"id";i:0;s:4:"tags";a:2:{s:4:"next";s:8:"Next ›";s:8:"previous";s:12:"‹ Previous";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}}}s:5:"empty";a:0:{}s:9:"arguments";a:1:{s:3:"fid";a:23:{s:2:"id";s:3:"fid";s:5:"table";s:12:"file_managed";s:5:"field";s:3:"fid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:3:"fid";s:9:"plugin_id";s:8:"file_fid";s:14:"default_action";s:9:"not found";s:9:"exception";a:3:{s:5:"value";s:3:"all";s:12:"title_enable";b:0;s:5:"title";s:3:"All";}s:12:"title_enable";b:1;s:5:"title";s:46:"File usage information for {{ arguments.fid }}";s:21:"default_argument_type";s:5:"fixed";s:24:"default_argument_options";a:1:{s:8:"argument";s:0:"";}s:25:"default_argument_skip_url";b:0;s:15:"summary_options";a:4:{s:9:"base_path";s:0:"";s:5:"count";b:1;s:8:"override";b:0;s:14:"items_per_page";i:25;}s:7:"summary";a:3:{s:10:"sort_order";s:3:"asc";s:17:"number_of_records";i:0;s:6:"format";s:15:"default_summary";}s:18:"specify_validation";b:0;s:8:"validate";a:2:{s:4:"type";s:4:"none";s:4:"fail";s:9:"not found";}s:16:"validate_options";a:0:{}s:12:"break_phrase";b:0;s:3:"not";b:0;}}s:7:"filters";a:0:{}s:13:"filter_groups";a:2:{s:8:"operator";s:3:"AND";s:6:"groups";a:0:{}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:12:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:7:"columns";a:4:{s:12:"entity_label";s:12:"entity_label";s:4:"type";s:4:"type";s:6:"module";s:6:"module";s:5:"count";s:5:"count";}s:7:"default";s:12:"entity_label";s:4:"info";a:4:{s:12:"entity_label";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:4:"type";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:15:"priority-medium";}s:6:"module";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:5:"count";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}}s:8:"override";b:1;s:6:"sticky";b:0;s:7:"summary";s:0:"";s:11:"empty_table";b:1;s:7:"caption";s:0:"";s:11:"description";s:0:"";}}s:3:"row";a:2:{s:4:"type";s:6:"fields";s:7:"options";a:0:{}}s:8:"defaults";a:11:{s:5:"empty";b:0;s:5:"title";b:0;s:5:"pager";b:0;s:8:"group_by";b:0;s:5:"style";b:0;s:3:"row";b:0;s:13:"relationships";b:0;s:6:"fields";b:0;s:9:"arguments";b:0;s:7:"filters";b:0;s:13:"filter_groups";b:0;}s:13:"relationships";a:1:{s:3:"fid";a:7:{s:2:"id";s:3:"fid";s:5:"table";s:12:"file_managed";s:5:"field";s:3:"fid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:10:"File usage";s:8:"required";b:1;}}s:8:"group_by";b:0;s:19:"display_description";s:0:"";s:17:"display_extenders";a:0:{}s:4:"path";s:27:"admin/content/files/usage/%";}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:4:{i:0;s:28:"languages:language_interface";i:1;s:3:"url";i:2;s:14:"url.query_args";i:3;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'views.view.frontpage',
  'data' => 'a:13:{s:4:"uuid";s:36:"639eb23e-4b75-4bec-9e05-aef9eb033c81";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:30:"core.entity_view_mode.node.rss";i:1;s:33:"core.entity_view_mode.node.teaser";}s:6:"module";a:2:{i:0;s:4:"node";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"6eeliKIydPjqyv5V__QqTfahvJMWkHjOVUUuUIdB1ik";}s:2:"id";s:9:"frontpage";s:5:"label";s:9:"Frontpage";s:6:"module";s:4:"node";s:11:"description";s:39:"All content promoted to the front page.";s:3:"tag";s:7:"default";s:10:"base_table";s:15:"node_field_data";s:10:"base_field";s:3:"nid";s:7:"display";a:3:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:17:{s:5:"title";s:0:"";s:6:"fields";a:0:{}s:5:"pager";a:2:{s:4:"type";s:4:"full";s:7:"options";a:7:{s:6:"offset";i:0;s:14:"items_per_page";i:10;s:11:"total_pages";i:0;s:2:"id";i:0;s:4:"tags";a:4:{s:4:"next";s:8:"Next ›";s:8:"previous";s:12:"‹ Previous";s:5:"first";s:8:"« First";s:4:"last";s:7:"Last »";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}s:8:"quantity";i:9;}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:5:"Apply";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:14:"access content";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"empty";a:3:{s:16:"area_text_custom";a:11:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:11:"text_custom";s:5:"label";s:0:"";s:5:"empty";b:1;s:7:"content";s:181:"No front page content has been created yet.<br/>Follow the <a target="_blank" href="https://www.drupal.org/docs/user_guide/en/index.html">User Guide</a> to start building your site.";s:8:"tokenize";b:0;}s:18:"node_listing_empty";a:10:{s:2:"id";s:18:"node_listing_empty";s:5:"table";s:4:"node";s:5:"field";s:18:"node_listing_empty";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:9:"plugin_id";s:18:"node_listing_empty";s:5:"label";s:0:"";s:5:"empty";b:1;}s:5:"title";a:10:{s:2:"id";s:5:"title";s:5:"table";s:5:"views";s:5:"field";s:5:"title";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:5:"title";s:5:"label";s:0:"";s:5:"empty";b:1;s:5:"title";s:8:"Welcome!";}}s:5:"sorts";a:2:{s:6:"sticky";a:12:{s:2:"id";s:6:"sticky";s:5:"table";s:15:"node_field_data";s:5:"field";s:6:"sticky";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:6:"sticky";s:9:"plugin_id";s:7:"boolean";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:6:"sticky";}s:7:"exposed";b:0;}s:7:"created";a:13:{s:2:"id";s:7:"created";s:5:"table";s:15:"node_field_data";s:5:"field";s:7:"created";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:7:"created";s:9:"plugin_id";s:4:"date";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:7:"created";}s:7:"exposed";b:0;s:11:"granularity";s:6:"second";}}s:9:"arguments";a:0:{}s:7:"filters";a:3:{s:7:"promote";a:16:{s:2:"id";s:7:"promote";s:5:"table";s:15:"node_field_data";s:5:"field";s:7:"promote";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:7:"promote";s:9:"plugin_id";s:7:"boolean";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:6:"status";a:9:{s:2:"id";s:6:"status";s:5:"table";s:15:"node_field_data";s:5:"field";s:6:"status";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:5:"value";s:1:"1";s:5:"group";i:1;s:6:"expose";a:3:{s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}}s:8:"langcode";a:16:{s:2:"id";s:8:"langcode";s:5:"table";s:15:"node_field_data";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:8:"langcode";s:9:"plugin_id";s:8:"language";s:8:"operator";s:2:"in";s:5:"value";a:1:{s:31:"***LANGUAGE_language_content***";s:31:"***LANGUAGE_language_content***";}s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:13:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:5:"style";a:2:{s:4:"type";s:7:"default";s:7:"options";a:4:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:11:"uses_fields";b:0;}}s:3:"row";a:2:{s:4:"type";s:11:"entity:node";s:7:"options";a:1:{s:9:"view_mode";s:6:"teaser";}}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:0:{}s:6:"header";a:0:{}s:6:"footer";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:4:{i:0;s:28:"languages:language_interface";i:1;s:14:"url.query_args";i:2;s:21:"user.node_grants:view";i:3;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"feed_1";a:6:{s:2:"id";s:6:"feed_1";s:13:"display_title";s:4:"Feed";s:14:"display_plugin";s:4:"feed";s:8:"position";i:2;s:15:"display_options";a:7:{s:5:"pager";a:2:{s:4:"type";s:4:"some";s:7:"options";a:2:{s:6:"offset";i:0;s:14:"items_per_page";i:10;}}s:5:"style";a:2:{s:4:"type";s:3:"rss";s:7:"options";a:3:{s:8:"grouping";a:0:{}s:11:"uses_fields";b:0;s:11:"description";s:0:"";}}s:3:"row";a:2:{s:4:"type";s:8:"node_rss";s:7:"options";a:2:{s:12:"relationship";s:4:"none";s:9:"view_mode";s:3:"rss";}}s:17:"display_extenders";a:0:{}s:4:"path";s:7:"rss.xml";s:14:"sitename_title";b:1;s:8:"displays";a:2:{s:6:"page_1";s:6:"page_1";s:7:"default";s:0:"";}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:3:{i:0;s:28:"languages:language_interface";i:1;s:21:"user.node_grants:view";i:2;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"page_1";a:6:{s:2:"id";s:6:"page_1";s:13:"display_title";s:4:"Page";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:2:{s:17:"display_extenders";a:0:{}s:4:"path";s:4:"node";}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:4:{i:0;s:28:"languages:language_interface";i:1;s:14:"url.query_args";i:2;s:21:"user.node_grants:view";i:3;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'views.view.glossary',
  'data' => 'a:13:{s:4:"uuid";s:36:"8a79aa2c-15b9-4124-9735-542afd321165";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:16:"system.menu.main";}s:6:"module";a:2:{i:0;s:4:"node";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"sz_FoMz5aClG4jFy4UDlkenXQtgTUXohEDjWVBuHaro";}s:2:"id";s:8:"glossary";s:5:"label";s:8:"Glossary";s:6:"module";s:4:"node";s:11:"description";s:23:"All content, by letter.";s:3:"tag";s:7:"default";s:10:"base_table";s:15:"node_field_data";s:10:"base_field";s:3:"nid";s:7:"display";a:3:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:17:{s:6:"fields";a:3:{s:5:"title";a:24:{s:2:"id";s:5:"title";s:5:"table";s:15:"node_field_data";s:5:"field";s:5:"title";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:5:"title";s:9:"plugin_id";s:5:"field";s:5:"label";s:5:"Title";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;}s:4:"name";a:25:{s:2:"id";s:4:"name";s:5:"table";s:16:"users_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:3:"uid";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:5:"field";s:5:"label";s:6:"Author";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:9:"user_name";}s:7:"changed";a:26:{s:2:"id";s:7:"changed";s:5:"table";s:15:"node_field_data";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:5:"field";s:5:"label";s:11:"Last update";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:9:"timestamp";s:8:"settings";a:3:{s:11:"date_format";s:4:"long";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";}}}s:5:"pager";a:2:{s:4:"type";s:4:"mini";s:7:"options";a:6:{s:6:"offset";i:0;s:14:"items_per_page";i:36;s:11:"total_pages";i:0;s:2:"id";i:0;s:4:"tags";a:2:{s:4:"next";s:6:"››";s:8:"previous";s:6:"‹‹";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:5:"Apply";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:14:"access content";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"empty";a:0:{}s:5:"sorts";a:0:{}s:9:"arguments";a:1:{s:5:"title";a:27:{s:2:"id";s:5:"title";s:5:"table";s:15:"node_field_data";s:5:"field";s:5:"title";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:5:"title";s:9:"plugin_id";s:6:"string";s:14:"default_action";s:7:"default";s:9:"exception";a:1:{s:12:"title_enable";b:1;}s:12:"title_enable";b:0;s:5:"title";s:0:"";s:21:"default_argument_type";s:5:"fixed";s:24:"default_argument_options";a:1:{s:8:"argument";s:1:"a";}s:25:"default_argument_skip_url";b:0;s:15:"summary_options";a:0:{}s:7:"summary";a:1:{s:6:"format";s:15:"default_summary";}s:18:"specify_validation";b:1;s:8:"validate";a:2:{s:4:"type";s:4:"none";s:4:"fail";s:9:"not found";}s:16:"validate_options";a:0:{}s:8:"glossary";b:1;s:5:"limit";i:1;s:4:"case";s:5:"upper";s:9:"path_case";s:5:"lower";s:14:"transform_dash";b:0;s:12:"break_phrase";b:0;}}s:7:"filters";a:2:{s:6:"status";a:9:{s:2:"id";s:6:"status";s:5:"table";s:15:"node_field_data";s:5:"field";s:6:"status";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:5:"value";s:1:"1";s:5:"group";i:1;s:6:"expose";a:3:{s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}}s:8:"langcode";a:16:{s:2:"id";s:8:"langcode";s:5:"table";s:15:"node_field_data";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:8:"langcode";s:9:"plugin_id";s:8:"language";s:8:"operator";s:2:"in";s:5:"value";a:1:{s:31:"***LANGUAGE_language_content***";s:31:"***LANGUAGE_language_content***";}s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:13:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:12:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:11:"uses_fields";b:0;s:7:"columns";a:3:{s:5:"title";s:5:"title";s:4:"name";s:4:"name";s:7:"changed";s:7:"changed";}s:7:"default";s:5:"title";s:4:"info";a:3:{s:5:"title";a:2:{s:8:"sortable";b:1;s:9:"separator";s:0:"";}s:4:"name";a:2:{s:8:"sortable";b:1;s:9:"separator";s:0:"";}s:7:"changed";a:2:{s:8:"sortable";b:1;s:9:"separator";s:0:"";}}s:8:"override";b:1;s:6:"sticky";b:0;s:7:"summary";s:0:"";s:5:"order";s:3:"asc";s:11:"empty_table";b:0;}}s:3:"row";a:2:{s:4:"type";s:6:"fields";s:7:"options";a:4:{s:22:"default_field_elements";b:1;s:6:"inline";a:0:{}s:9:"separator";s:0:"";s:10:"hide_empty";b:0;}}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:1:{s:3:"uid";a:8:{s:2:"id";s:3:"uid";s:5:"table";s:15:"node_field_data";s:5:"field";s:3:"uid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:6:"author";s:9:"plugin_id";s:8:"standard";s:8:"required";b:0;}}s:8:"use_ajax";b:1;s:6:"header";a:0:{}s:6:"footer";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:6:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:21:"user.node_grants:view";i:5;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:12:"attachment_1";a:6:{s:2:"id";s:12:"attachment_1";s:13:"display_title";s:10:"Attachment";s:14:"display_plugin";s:10:"attachment";s:8:"position";i:2;s:15:"display_options";a:7:{s:5:"pager";a:2:{s:4:"type";s:4:"none";s:7:"options";a:2:{s:6:"offset";i:0;s:14:"items_per_page";i:0;}}s:9:"arguments";a:1:{s:5:"title";a:27:{s:2:"id";s:5:"title";s:5:"table";s:15:"node_field_data";s:5:"field";s:5:"title";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:5:"title";s:9:"plugin_id";s:6:"string";s:14:"default_action";s:7:"summary";s:9:"exception";a:1:{s:12:"title_enable";b:1;}s:12:"title_enable";b:0;s:5:"title";s:0:"";s:21:"default_argument_type";s:5:"fixed";s:24:"default_argument_options";a:1:{s:8:"argument";s:1:"a";}s:25:"default_argument_skip_url";b:0;s:15:"summary_options";a:3:{s:14:"items_per_page";i:25;s:6:"inline";b:1;s:9:"separator";s:3:" | ";}s:7:"summary";a:1:{s:6:"format";s:19:"unformatted_summary";}s:18:"specify_validation";b:1;s:8:"validate";a:2:{s:4:"type";s:4:"none";s:4:"fail";s:9:"not found";}s:16:"validate_options";a:0:{}s:8:"glossary";b:1;s:5:"limit";i:1;s:4:"case";s:5:"upper";s:9:"path_case";s:5:"lower";s:14:"transform_dash";b:0;s:12:"break_phrase";b:0;}}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:0:{}}s:8:"defaults";a:1:{s:9:"arguments";b:0;}s:17:"display_extenders";a:0:{}s:8:"displays";a:2:{s:7:"default";s:7:"default";s:6:"page_1";s:6:"page_1";}s:17:"inherit_arguments";b:0;}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:6:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:21:"user.node_grants:view";i:5;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"page_1";a:6:{s:2:"id";s:6:"page_1";s:13:"display_title";s:4:"Page";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:4:{s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:0:{}}s:17:"display_extenders";a:0:{}s:4:"path";s:8:"glossary";s:4:"menu";a:5:{s:4:"type";s:6:"normal";s:5:"title";s:8:"Glossary";s:6:"weight";i:0;s:9:"menu_name";s:4:"main";s:6:"parent";s:0:"";}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:6:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:21:"user.node_grants:view";i:5;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'views.view.taxonomy_term',
  'data' => 'a:13:{s:4:"uuid";s:36:"fa1285d7-e7c3-40be-a421-05f2bf849419";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:33:"core.entity_view_mode.node.teaser";}s:6:"module";a:3:{i:0;s:4:"node";i:1;s:8:"taxonomy";i:2;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"YKgw0f77GEmCu6_6Om9Mbig0mON9JdfVuMxTtd0WQaI";}s:2:"id";s:13:"taxonomy_term";s:5:"label";s:13:"Taxonomy term";s:6:"module";s:8:"taxonomy";s:11:"description";s:45:"Content belonging to a certain taxonomy term.";s:3:"tag";s:7:"default";s:10:"base_table";s:15:"node_field_data";s:10:"base_field";s:3:"nid";s:7:"display";a:3:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:18:{s:6:"fields";a:0:{}s:5:"pager";a:2:{s:4:"type";s:4:"mini";s:7:"options";a:6:{s:6:"offset";i:0;s:14:"items_per_page";i:10;s:11:"total_pages";i:0;s:2:"id";i:0;s:4:"tags";a:2:{s:4:"next";s:6:"››";s:8:"previous";s:6:"‹‹";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:5:"Apply";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:14:"access content";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"empty";a:0:{}s:5:"sorts";a:2:{s:6:"sticky";a:10:{s:2:"id";s:6:"sticky";s:5:"table";s:14:"taxonomy_index";s:5:"field";s:6:"sticky";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:8:"standard";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:6:"sticky";}s:7:"exposed";b:0;}s:7:"created";a:11:{s:2:"id";s:7:"created";s:5:"table";s:14:"taxonomy_index";s:5:"field";s:7:"created";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:4:"date";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:7:"created";}s:7:"exposed";b:0;s:11:"granularity";s:6:"second";}}s:9:"arguments";a:1:{s:3:"tid";a:23:{s:2:"id";s:3:"tid";s:5:"table";s:14:"taxonomy_index";s:5:"field";s:3:"tid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:18:"taxonomy_index_tid";s:14:"default_action";s:9:"not found";s:9:"exception";a:3:{s:5:"value";s:0:"";s:12:"title_enable";b:0;s:5:"title";s:3:"All";}s:12:"title_enable";b:1;s:5:"title";s:19:"{{ arguments.tid }}";s:21:"default_argument_type";s:5:"fixed";s:24:"default_argument_options";a:1:{s:8:"argument";s:0:"";}s:25:"default_argument_skip_url";b:0;s:15:"summary_options";a:4:{s:9:"base_path";s:0:"";s:5:"count";b:1;s:8:"override";b:0;s:14:"items_per_page";i:25;}s:7:"summary";a:3:{s:10:"sort_order";s:3:"asc";s:17:"number_of_records";i:0;s:6:"format";s:15:"default_summary";}s:18:"specify_validation";b:1;s:8:"validate";a:2:{s:4:"type";s:20:"entity:taxonomy_term";s:4:"fail";s:9:"not found";}s:16:"validate_options";a:4:{s:7:"bundles";a:0:{}s:6:"access";b:1;s:9:"operation";s:4:"view";s:8:"multiple";i:0;}s:12:"break_phrase";b:0;s:9:"add_table";b:0;s:13:"require_value";b:0;s:17:"reduce_duplicates";b:0;}}s:7:"filters";a:2:{s:8:"langcode";a:16:{s:2:"id";s:8:"langcode";s:5:"table";s:15:"node_field_data";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:8:"langcode";s:9:"plugin_id";s:8:"language";s:8:"operator";s:2:"in";s:5:"value";a:1:{s:31:"***LANGUAGE_language_content***";s:31:"***LANGUAGE_language_content***";}s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:13:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:6:"status";a:14:{s:2:"id";s:6:"status";s:5:"table";s:14:"taxonomy_index";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:7:"boolean";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:5:"style";a:2:{s:4:"type";s:7:"default";s:7:"options";a:4:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:11:"uses_fields";b:0;}}s:3:"row";a:2:{s:4:"type";s:11:"entity:node";s:7:"options";a:1:{s:9:"view_mode";s:6:"teaser";}}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:0:{}s:12:"link_display";s:6:"page_1";s:8:"link_url";s:0:"";s:6:"header";a:1:{s:20:"entity_taxonomy_term";a:12:{s:2:"id";s:20:"entity_taxonomy_term";s:5:"table";s:5:"views";s:5:"field";s:20:"entity_taxonomy_term";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:6:"entity";s:5:"empty";b:1;s:6:"target";s:23:"{{ raw_arguments.tid }}";s:9:"view_mode";s:4:"full";s:8:"tokenize";b:1;s:13:"bypass_access";b:0;}}s:6:"footer";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:28:"languages:language_interface";i:1;s:3:"url";i:2;s:14:"url.query_args";i:3;s:21:"user.node_grants:view";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"feed_1";a:6:{s:2:"id";s:6:"feed_1";s:13:"display_title";s:4:"Feed";s:14:"display_plugin";s:4:"feed";s:8:"position";i:2;s:15:"display_options";a:7:{s:5:"pager";a:2:{s:4:"type";s:4:"some";s:7:"options";a:2:{s:6:"offset";i:0;s:14:"items_per_page";i:10;}}s:5:"style";a:2:{s:4:"type";s:3:"rss";s:7:"options";a:3:{s:8:"grouping";a:0:{}s:11:"uses_fields";b:0;s:11:"description";s:0:"";}}s:3:"row";a:2:{s:4:"type";s:8:"node_rss";s:7:"options";a:2:{s:12:"relationship";s:4:"none";s:9:"view_mode";s:7:"default";}}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:0:{}}s:17:"display_extenders";a:0:{}s:4:"path";s:20:"taxonomy/term/%/feed";s:8:"displays";a:2:{s:6:"page_1";s:6:"page_1";s:7:"default";s:1:"0";}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:4:{i:0;s:28:"languages:language_interface";i:1;s:3:"url";i:2;s:21:"user.node_grants:view";i:3;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"page_1";a:6:{s:2:"id";s:6:"page_1";s:13:"display_title";s:4:"Page";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:3:{s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:0:{}}s:17:"display_extenders";a:0:{}s:4:"path";s:15:"taxonomy/term/%";}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:28:"languages:language_interface";i:1;s:3:"url";i:2;s:14:"url.query_args";i:3;s:21:"user.node_grants:view";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'views.view.user_admin_people',
  'data' => 'a:13:{s:4:"uuid";s:36:"10ec64fe-cf91-4c4a-941b-2ba3e21c3338";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"njaZigMvB4ap21Fg_tQcJhWgYJCGNi49Z5rRL_N6RI0";}s:2:"id";s:17:"user_admin_people";s:5:"label";s:6:"People";s:6:"module";s:4:"user";s:11:"description";s:50:"Find and manage people interacting with your site.";s:3:"tag";s:7:"default";s:10:"base_table";s:16:"users_field_data";s:10:"base_field";s:3:"uid";s:7:"display";a:2:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:25:{s:5:"title";s:6:"People";s:6:"fields";a:8:{s:14:"user_bulk_form";a:23:{s:2:"id";s:14:"user_bulk_form";s:5:"table";s:5:"users";s:5:"field";s:14:"user_bulk_form";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:9:"plugin_id";s:14:"user_bulk_form";s:5:"label";s:11:"Bulk update";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;}s:4:"name";a:25:{s:2:"id";s:4:"name";s:5:"table";s:16:"users_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:5:"field";s:5:"label";s:8:"Username";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:9:"user_name";}s:6:"status";a:26:{s:2:"id";s:6:"status";s:5:"table";s:16:"users_field_data";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:5:"field";s:5:"label";s:6:"Status";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:7:"boolean";s:8:"settings";a:3:{s:6:"format";s:6:"custom";s:19:"format_custom_false";s:7:"Blocked";s:18:"format_custom_true";s:6:"Active";}}s:15:"roles_target_id";a:24:{s:2:"id";s:15:"roles_target_id";s:5:"table";s:11:"user__roles";s:5:"field";s:15:"roles_target_id";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:10:"user_roles";s:5:"label";s:5:"Roles";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:2:"ul";s:9:"separator";s:2:", ";}s:7:"created";a:26:{s:2:"id";s:7:"created";s:5:"table";s:16:"users_field_data";s:5:"field";s:7:"created";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:7:"created";s:9:"plugin_id";s:5:"field";s:5:"label";s:10:"Member for";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:13:"timestamp_ago";s:8:"settings";a:3:{s:13:"future_format";s:9:"@interval";s:11:"past_format";s:9:"@interval";s:11:"granularity";i:2;}}s:6:"access";a:26:{s:2:"id";s:6:"access";s:5:"table";s:16:"users_field_data";s:5:"field";s:6:"access";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:6:"access";s:9:"plugin_id";s:5:"field";s:5:"label";s:11:"Last access";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:13:"timestamp_ago";s:8:"settings";a:3:{s:13:"future_format";s:15:"@interval hence";s:11:"past_format";s:13:"@interval ago";s:11:"granularity";i:2;}}s:10:"operations";a:24:{s:2:"id";s:10:"operations";s:5:"table";s:5:"users";s:5:"field";s:10:"operations";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:9:"plugin_id";s:17:"entity_operations";s:5:"label";s:10:"Operations";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:11:"destination";b:1;}s:4:"mail";a:37:{s:2:"id";s:4:"mail";s:5:"table";s:16:"users_field_data";s:5:"field";s:4:"mail";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:4:"mail";s:9:"plugin_id";s:5:"field";s:5:"label";s:0:"";s:7:"exclude";b:1;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:12:"basic_string";s:8:"settings";a:0:{}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}}s:5:"pager";a:2:{s:4:"type";s:4:"full";s:7:"options";a:7:{s:6:"offset";i:0;s:14:"items_per_page";i:50;s:11:"total_pages";i:0;s:2:"id";i:0;s:4:"tags";a:4:{s:4:"next";s:8:"Next ›";s:8:"previous";s:12:"‹ Previous";s:5:"first";s:8:"« First";s:4:"last";s:7:"Last »";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}s:8:"quantity";i:9;}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:6:"Filter";s:12:"reset_button";b:1;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:16:"administer users";}}s:5:"cache";a:1:{s:4:"type";s:3:"tag";}s:5:"empty";a:1:{s:16:"area_text_custom";a:10:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:11:"text_custom";s:5:"empty";b:1;s:7:"content";s:20:"No people available.";s:8:"tokenize";b:0;}}s:5:"sorts";a:1:{s:7:"created";a:13:{s:2:"id";s:7:"created";s:5:"table";s:16:"users_field_data";s:5:"field";s:7:"created";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:7:"created";s:9:"plugin_id";s:4:"date";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:7:"created";}s:7:"exposed";b:0;s:11:"granularity";s:6:"second";}}s:7:"filters";a:6:{s:7:"combine";a:15:{s:2:"id";s:7:"combine";s:5:"table";s:5:"views";s:5:"field";s:7:"combine";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:7:"combine";s:8:"operator";s:8:"contains";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:10:"combine_op";s:5:"label";s:22:"Name or email contains";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:10:"combine_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:4:"user";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:6:"fields";a:2:{s:4:"name";s:4:"name";s:4:"mail";s:4:"mail";}}s:6:"status";a:16:{s:2:"id";s:6:"status";s:5:"table";s:16:"users_field_data";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:9:"status_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:6:"status";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}}s:10:"is_grouped";b:1;s:10:"group_info";a:10:{s:5:"label";s:6:"Status";s:11:"description";s:0:"";s:10:"identifier";s:6:"status";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:2:{i:1;a:3:{s:5:"title";s:6:"Active";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";}i:2;a:3:{s:5:"title";s:7:"Blocked";s:8:"operator";s:1:"=";s:5:"value";s:1:"0";}}}}s:15:"roles_target_id";a:15:{s:2:"id";s:15:"roles_target_id";s:5:"table";s:11:"user__roles";s:5:"field";s:15:"roles_target_id";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:10:"user_roles";s:8:"operator";s:2:"or";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:18:"roles_target_id_op";s:5:"label";s:4:"Role";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:18:"roles_target_id_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:4:"role";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:17:"reduce_duplicates";b:0;}s:10:"permission";a:15:{s:2:"id";s:10:"permission";s:5:"table";s:11:"user__roles";s:5:"field";s:10:"permission";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:16:"user_permissions";s:8:"operator";s:2:"or";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:13:"permission_op";s:5:"label";s:10:"Permission";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:13:"permission_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:10:"permission";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:17:"reduce_duplicates";b:0;}s:16:"default_langcode";a:16:{s:2:"id";s:16:"default_langcode";s:5:"table";s:16:"users_field_data";s:5:"field";s:16:"default_langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:16:"default_langcode";s:9:"plugin_id";s:7:"boolean";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:7:"uid_raw";a:15:{s:2:"id";s:7:"uid_raw";s:5:"table";s:16:"users_field_data";s:5:"field";s:7:"uid_raw";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:9:"plugin_id";s:7:"numeric";s:8:"operator";s:2:"!=";s:5:"value";a:3:{s:3:"min";s:0:"";s:3:"max";s:0:"";s:5:"value";s:1:"0";}s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:1:"0";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:13:"filter_groups";a:2:{s:8:"operator";s:3:"AND";s:6:"groups";a:1:{i:1;s:3:"AND";}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:10:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:7:"columns";a:8:{s:14:"user_bulk_form";s:14:"user_bulk_form";s:4:"name";s:4:"name";s:6:"status";s:6:"status";s:3:"rid";s:3:"rid";s:7:"created";s:7:"created";s:6:"access";s:6:"access";s:9:"edit_node";s:9:"edit_node";s:10:"dropbutton";s:10:"dropbutton";}s:7:"default";s:7:"created";s:4:"info";a:8:{s:14:"user_bulk_form";a:4:{s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:4:"name";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:6:"status";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:3:"rid";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:7:"created";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:6:"access";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:9:"edit_node";a:4:{s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:10:"dropbutton";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}}s:8:"override";b:1;s:6:"sticky";b:0;s:7:"summary";s:0:"";s:11:"empty_table";b:1;}}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:9:"css_class";s:0:"";s:8:"use_ajax";b:0;s:8:"group_by";b:0;s:16:"show_admin_links";b:1;s:8:"use_more";b:0;s:15:"use_more_always";b:0;s:13:"use_more_text";s:4:"more";s:12:"link_display";s:6:"page_1";s:8:"link_url";s:0:"";s:15:"display_comment";s:0:"";s:23:"hide_attachment_summary";b:0;s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:0;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"page_1";a:6:{s:2:"id";s:6:"page_1";s:13:"display_title";s:4:"Page";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:6:{s:8:"defaults";a:1:{s:16:"show_admin_links";b:0;}s:16:"show_admin_links";b:0;s:17:"display_extenders";a:0:{}s:4:"path";s:17:"admin/people/list";s:4:"menu";a:6:{s:4:"type";s:11:"default tab";s:5:"title";s:4:"List";s:11:"description";s:50:"Find and manage people interacting with your site.";s:6:"weight";i:-10;s:9:"menu_name";s:5:"admin";s:7:"context";s:0:"";}s:11:"tab_options";a:5:{s:4:"type";s:6:"normal";s:5:"title";s:6:"People";s:11:"description";s:45:"Manage user accounts, roles, and permissions.";s:6:"weight";i:0;s:9:"menu_name";s:5:"admin";}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:0;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'views.view.who_s_new',
  'data' => "a:13:{s:4:\"uuid\";s:36:\"3626aaf5-6c82-4e1b-8f19-752e2cdac89f\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"zji0_13MyVGK7Bn1lUMDeZyyOIZedWvqpYUeM_SioPI\";}s:2:\"id\";s:9:\"who_s_new\";s:5:\"label\";s:9:\"Who's new\";s:6:\"module\";s:4:\"user\";s:11:\"description\";s:53:\"Shows a list of the newest user accounts on the site.\";s:3:\"tag\";s:7:\"default\";s:10:\"base_table\";s:16:\"users_field_data\";s:10:\"base_field\";s:3:\"uid\";s:7:\"display\";a:2:{s:7:\"default\";a:6:{s:2:\"id\";s:7:\"default\";s:13:\"display_title\";s:7:\"Default\";s:14:\"display_plugin\";s:7:\"default\";s:8:\"position\";i:0;s:15:\"display_options\";a:17:{s:5:\"title\";s:9:\"Who's new\";s:6:\"fields\";a:1:{s:4:\"name\";a:25:{s:2:\"id\";s:4:\"name\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:4:\"name\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:4:\"name\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:8:{s:10:\"alter_text\";b:0;s:9:\"make_link\";b:0;s:8:\"absolute\";b:0;s:13:\"word_boundary\";b:0;s:8:\"ellipsis\";b:0;s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"type\";s:9:\"user_name\";}}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"some\";s:7:\"options\";a:2:{s:6:\"offset\";i:0;s:14:\"items_per_page\";i:5;}}s:12:\"exposed_form\";a:2:{s:4:\"type\";s:5:\"basic\";s:7:\"options\";a:7:{s:13:\"submit_button\";s:5:\"Apply\";s:12:\"reset_button\";b:0;s:18:\"reset_button_label\";s:5:\"Reset\";s:19:\"exposed_sorts_label\";s:7:\"Sort by\";s:17:\"expose_sort_order\";b:1;s:14:\"sort_asc_label\";s:3:\"Asc\";s:15:\"sort_desc_label\";s:4:\"Desc\";}}s:6:\"access\";a:2:{s:4:\"type\";s:4:\"perm\";s:7:\"options\";a:1:{s:4:\"perm\";s:14:\"access content\";}}s:5:\"cache\";a:2:{s:4:\"type\";s:3:\"tag\";s:7:\"options\";a:0:{}}s:5:\"empty\";a:0:{}s:5:\"sorts\";a:1:{s:7:\"created\";a:13:{s:2:\"id\";s:7:\"created\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:7:\"created\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:7:\"created\";s:9:\"plugin_id\";s:4:\"date\";s:5:\"order\";s:4:\"DESC\";s:6:\"expose\";a:2:{s:5:\"label\";s:0:\"\";s:16:\"field_identifier\";s:7:\"created\";}s:7:\"exposed\";b:0;s:11:\"granularity\";s:6:\"second\";}}s:9:\"arguments\";a:0:{}s:7:\"filters\";a:2:{s:6:\"status\";a:9:{s:2:\"id\";s:6:\"status\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:6:\"status\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:6:\"status\";s:9:\"plugin_id\";s:7:\"boolean\";s:5:\"value\";s:1:\"1\";s:5:\"group\";i:1;s:6:\"expose\";a:3:{s:8:\"operator\";s:1:\"0\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}}}s:6:\"access\";a:16:{s:2:\"id\";s:6:\"access\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:6:\"access\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:6:\"access\";s:9:\"plugin_id\";s:4:\"date\";s:8:\"operator\";s:1:\">\";s:5:\"value\";a:4:{s:3:\"min\";s:0:\"\";s:3:\"max\";s:0:\"\";s:5:\"value\";s:10:\"1970-01-01\";s:4:\"type\";s:4:\"date\";}s:5:\"group\";i:1;s:7:\"exposed\";b:0;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:1:\"0\";s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:0:\"\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:0:\"\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:1:{s:13:\"authenticated\";s:13:\"authenticated\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}}s:5:\"style\";a:1:{s:4:\"type\";s:9:\"html_list\";}s:3:\"row\";a:1:{s:4:\"type\";s:6:\"fields\";}s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:5:{s:13:\"query_comment\";s:0:\"\";s:19:\"disable_sql_rewrite\";b:0;s:8:\"distinct\";b:0;s:7:\"replica\";b:0;s:10:\"query_tags\";a:0:{}}}s:13:\"relationships\";a:0:{}s:6:\"header\";a:0:{}s:6:\"footer\";a:0:{}s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:3:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}s:7:\"block_1\";a:6:{s:2:\"id\";s:7:\"block_1\";s:13:\"display_title\";s:9:\"Who's new\";s:14:\"display_plugin\";s:5:\"block\";s:8:\"position\";i:1;s:15:\"display_options\";a:4:{s:19:\"display_description\";s:19:\"A list of new users\";s:17:\"display_extenders\";a:0:{}s:17:\"block_description\";s:9:\"Who's new\";s:14:\"block_category\";s:4:\"User\";}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:3:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}}}",
))
->values(array(
  'collection' => '',
  'name' => 'views.view.who_s_online',
  'data' => "a:13:{s:4:\"uuid\";s:36:\"be956f46-fbc7-42d5-9482-711b3ab643c2\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"suDsVMgawXoQt4rfmdfpr05EVX3z3KyfDDTYgeSM898\";}s:2:\"id\";s:12:\"who_s_online\";s:5:\"label\";s:18:\"Who's online block\";s:6:\"module\";s:4:\"user\";s:11:\"description\";s:93:\"Shows the user names of the most recently active users, and the total number of active users.\";s:3:\"tag\";s:7:\"default\";s:10:\"base_table\";s:16:\"users_field_data\";s:10:\"base_field\";s:3:\"uid\";s:7:\"display\";a:2:{s:7:\"default\";a:6:{s:2:\"id\";s:7:\"default\";s:13:\"display_title\";s:7:\"Default\";s:14:\"display_plugin\";s:7:\"default\";s:8:\"position\";i:0;s:15:\"display_options\";a:17:{s:5:\"title\";s:12:\"Who's online\";s:6:\"fields\";a:1:{s:4:\"name\";a:25:{s:2:\"id\";s:4:\"name\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:4:\"name\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:4:\"name\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:8:{s:10:\"alter_text\";b:0;s:9:\"make_link\";b:0;s:8:\"absolute\";b:0;s:13:\"word_boundary\";b:0;s:8:\"ellipsis\";b:0;s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"type\";s:9:\"user_name\";}}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"some\";s:7:\"options\";a:2:{s:6:\"offset\";i:0;s:14:\"items_per_page\";i:10;}}s:12:\"exposed_form\";a:2:{s:4:\"type\";s:5:\"basic\";s:7:\"options\";a:7:{s:13:\"submit_button\";s:5:\"Apply\";s:12:\"reset_button\";b:0;s:18:\"reset_button_label\";s:5:\"Reset\";s:19:\"exposed_sorts_label\";s:7:\"Sort by\";s:17:\"expose_sort_order\";b:1;s:14:\"sort_asc_label\";s:3:\"Asc\";s:15:\"sort_desc_label\";s:4:\"Desc\";}}s:6:\"access\";a:2:{s:4:\"type\";s:4:\"perm\";s:7:\"options\";a:1:{s:4:\"perm\";s:20:\"access user profiles\";}}s:5:\"cache\";a:2:{s:4:\"type\";s:3:\"tag\";s:7:\"options\";a:0:{}}s:5:\"empty\";a:1:{s:16:\"area_text_custom\";a:10:{s:2:\"id\";s:16:\"area_text_custom\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:16:\"area_text_custom\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:11:\"text_custom\";s:5:\"empty\";b:1;s:7:\"content\";s:35:\"There are currently 0 users online.\";s:8:\"tokenize\";b:0;}}s:5:\"sorts\";a:1:{s:6:\"access\";a:13:{s:2:\"id\";s:6:\"access\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:6:\"access\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:6:\"access\";s:9:\"plugin_id\";s:4:\"date\";s:5:\"order\";s:4:\"DESC\";s:6:\"expose\";a:2:{s:5:\"label\";s:0:\"\";s:16:\"field_identifier\";s:6:\"access\";}s:7:\"exposed\";b:0;s:11:\"granularity\";s:6:\"second\";}}s:9:\"arguments\";a:0:{}s:7:\"filters\";a:2:{s:6:\"status\";a:9:{s:2:\"id\";s:6:\"status\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:6:\"status\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:6:\"status\";s:9:\"plugin_id\";s:7:\"boolean\";s:5:\"value\";s:1:\"1\";s:5:\"group\";i:1;s:6:\"expose\";a:3:{s:8:\"operator\";s:1:\"0\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}}}s:6:\"access\";a:16:{s:2:\"id\";s:6:\"access\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:6:\"access\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:6:\"access\";s:9:\"plugin_id\";s:4:\"date\";s:8:\"operator\";s:2:\">=\";s:5:\"value\";a:4:{s:3:\"min\";s:0:\"\";s:3:\"max\";s:0:\"\";s:5:\"value\";s:11:\"-15 minutes\";s:4:\"type\";s:6:\"offset\";}s:5:\"group\";i:1;s:7:\"exposed\";b:0;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:9:\"access_op\";s:5:\"label\";s:11:\"Last access\";s:11:\"description\";s:77:\"A user is considered online for this long after they have last viewed a page.\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:9:\"access_op\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:6:\"access\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}}s:5:\"style\";a:2:{s:4:\"type\";s:9:\"html_list\";s:7:\"options\";a:6:{s:8:\"grouping\";a:0:{}s:9:\"row_class\";s:0:\"\";s:17:\"default_row_class\";b:1;s:4:\"type\";s:2:\"ul\";s:13:\"wrapper_class\";s:9:\"item-list\";s:5:\"class\";s:0:\"\";}}s:3:\"row\";a:1:{s:4:\"type\";s:6:\"fields\";}s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:5:{s:13:\"query_comment\";s:0:\"\";s:19:\"disable_sql_rewrite\";b:0;s:8:\"distinct\";b:0;s:7:\"replica\";b:0;s:10:\"query_tags\";a:0:{}}}s:13:\"relationships\";a:0:{}s:6:\"header\";a:1:{s:6:\"result\";a:9:{s:2:\"id\";s:6:\"result\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:6:\"result\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:6:\"result\";s:5:\"empty\";b:0;s:7:\"content\";s:40:\"There are currently @total users online.\";}}s:6:\"footer\";a:0:{}s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:3:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}s:18:\"who_s_online_block\";a:6:{s:2:\"id\";s:18:\"who_s_online_block\";s:13:\"display_title\";s:12:\"Who's online\";s:14:\"display_plugin\";s:5:\"block\";s:8:\"position\";i:1;s:15:\"display_options\";a:3:{s:19:\"display_description\";s:45:\"A list of users that are currently logged in.\";s:17:\"display_extenders\";a:0:{}s:17:\"block_description\";s:12:\"Who's online\";}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:3:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}}}",
))
->execute();
$connection->schema()->createTable('config_import', array(
  'fields' => array(
    'collection' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'name' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
  ),
  'primary key' => array(
    'collection',
    'name',
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->insert('config_import')
->fields(array(
  'collection',
  'name',
  'data',
))
->values(array(
  'collection' => '',
  'name' => 'automated_cron.settings',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"fUksROt4FfkAU9BV4hV2XvhTBSS2nTNrZS4U7S-tKrs";}s:8:"interval";i:10800;}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.claro_breadcrumbs',
  'data' => 'a:13:{s:4:"uuid";s:36:"f7df1911-ad5b-4cb3-8153-59321df33c3e";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:5:"claro";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"NjcxOBrPOiK5-38t56DwFBDVY4yer7YSlbRWXFuHe7A";}s:2:"id";s:17:"claro_breadcrumbs";s:5:"theme";s:5:"claro";s:6:"region";s:10:"breadcrumb";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:23:"system_breadcrumb_block";s:8:"settings";a:4:{s:2:"id";s:23:"system_breadcrumb_block";s:5:"label";s:11:"Breadcrumbs";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.claro_content',
  'data' => 'a:13:{s:4:"uuid";s:36:"f2ffe7dc-4030-4952-980a-11f199e6b8b7";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:5:"claro";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"a0Yyx1GeyKarZ4T_yXQBR_ZFKnXiFLtxAb6gWLd8nr0";}s:2:"id";s:13:"claro_content";s:5:"theme";s:5:"claro";s:6:"region";s:7:"content";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:17:"system_main_block";s:8:"settings";a:4:{s:2:"id";s:17:"system_main_block";s:5:"label";s:17:"Main page content";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.claro_help',
  'data' => 'a:13:{s:4:"uuid";s:36:"cf8942d4-054b-4fcd-9182-39a5cc30128f";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:4:"help";}s:5:"theme";a:1:{i:0;s:5:"claro";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"jccFSSVqV0WCDb6NtML1VWAWTtDbZ-zn5YgTRMgMrIM";}s:2:"id";s:10:"claro_help";s:5:"theme";s:5:"claro";s:6:"region";s:4:"help";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:10:"help_block";s:8:"settings";a:4:{s:2:"id";s:10:"help_block";s:5:"label";s:4:"Help";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"help";}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.claro_local_actions',
  'data' => 'a:13:{s:4:"uuid";s:36:"459da073-0b49-4889-b68e-65e6c6d21aa8";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:5:"claro";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"CdXfDmRgAvms7EQovxxWPdYi0GitxeRbVtScYK16ZH0";}s:2:"id";s:19:"claro_local_actions";s:5:"theme";s:5:"claro";s:6:"region";s:7:"content";s:6:"weight";i:-10;s:8:"provider";N;s:6:"plugin";s:19:"local_actions_block";s:8:"settings";a:4:{s:2:"id";s:19:"local_actions_block";s:5:"label";s:21:"Primary admin actions";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"core";}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.claro_messages',
  'data' => 'a:13:{s:4:"uuid";s:36:"8662e482-f3f3-4eb8-b414-35ec43424eaf";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:5:"claro";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"-Ac3ISpIT0PQ-whzD7_dw0SdKi6dAbRFNWdSjOiVDqg";}s:2:"id";s:14:"claro_messages";s:5:"theme";s:5:"claro";s:6:"region";s:11:"highlighted";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:21:"system_messages_block";s:8:"settings";a:4:{s:2:"id";s:21:"system_messages_block";s:5:"label";s:15:"Status messages";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.claro_page_title',
  'data' => 'a:13:{s:4:"uuid";s:36:"d9a84d3b-290b-4cc6-842b-598d359a5606";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:5:"claro";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"fNwDdW063tk_ktzSWzZVeQS9wzvLooVO280BQ9WrsIs";}s:2:"id";s:16:"claro_page_title";s:5:"theme";s:5:"claro";s:6:"region";s:6:"header";s:6:"weight";i:-30;s:8:"provider";N;s:6:"plugin";s:16:"page_title_block";s:8:"settings";a:4:{s:2:"id";s:16:"page_title_block";s:5:"label";s:10:"Page title";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"core";}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.claro_primary_local_tasks',
  'data' => 'a:13:{s:4:"uuid";s:36:"c47e7602-16ce-4e01-b63c-c758f7f1f86c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:5:"claro";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ACjBZI5shAMiiUpsz-inLYVXDqNNXRnSzAWV3kV_8Hw";}s:2:"id";s:25:"claro_primary_local_tasks";s:5:"theme";s:5:"claro";s:6:"region";s:6:"header";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:17:"local_tasks_block";s:8:"settings";a:6:{s:2:"id";s:17:"local_tasks_block";s:5:"label";s:12:"Primary tabs";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"core";s:7:"primary";b:1;s:9:"secondary";b:0;}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.claro_secondary_local_tasks',
  'data' => 'a:13:{s:4:"uuid";s:36:"2e1bcbf0-8814-48e4-bbcf-0240ed25b562";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:5:"claro";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"2L0geP-ixCbCkEpW6BVF6H7vDUZN4ea07_Y9CociQm4";}s:2:"id";s:27:"claro_secondary_local_tasks";s:5:"theme";s:5:"claro";s:6:"region";s:11:"pre_content";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:17:"local_tasks_block";s:8:"settings";a:6:{s:2:"id";s:17:"local_tasks_block";s:5:"label";s:14:"Secondary tabs";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"core";s:7:"primary";b:0;s:9:"secondary";b:1;}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.olivero_account_menu',
  'data' => 'a:13:{s:4:"uuid";s:36:"4fbdbb90-d3f0-4816-8a3b-88de512cd8f8";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:3:{s:6:"config";a:1:{i:0;s:19:"system.menu.account";}s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"gmxYWWHmgbe0Pnv8y48ZLSLH5mEHejOjAP6RLxUfdzU";}s:2:"id";s:20:"olivero_account_menu";s:5:"theme";s:7:"olivero";s:6:"region";s:14:"secondary_menu";s:6:"weight";i:-4;s:8:"provider";N;s:6:"plugin";s:25:"system_menu_block:account";s:8:"settings";a:7:{s:2:"id";s:25:"system_menu_block:account";s:5:"label";s:17:"User account menu";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";s:5:"level";i:1;s:5:"depth";i:1;s:16:"expand_all_items";b:0;}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.olivero_breadcrumbs',
  'data' => 'a:13:{s:4:"uuid";s:36:"e5e26cf3-f53e-4872-9680-96de34915223";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"VhBzWb7lMRtIOg9G7VSw_0uopi-7zXeHq4vXqqV1HFE";}s:2:"id";s:19:"olivero_breadcrumbs";s:5:"theme";s:7:"olivero";s:6:"region";s:10:"breadcrumb";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:23:"system_breadcrumb_block";s:8:"settings";a:4:{s:2:"id";s:23:"system_breadcrumb_block";s:5:"label";s:11:"Breadcrumbs";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.olivero_content',
  'data' => 'a:13:{s:4:"uuid";s:36:"ef5f9f63-2e20-446c-a8b7-d8375dade67b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"erQSEZF2XUjNmgTl0uNRBzmg18ZGXwUcw2FhApoeuHk";}s:2:"id";s:15:"olivero_content";s:5:"theme";s:7:"olivero";s:6:"region";s:7:"content";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:17:"system_main_block";s:8:"settings";a:4:{s:2:"id";s:17:"system_main_block";s:5:"label";s:17:"Main page content";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.olivero_help',
  'data' => 'a:13:{s:4:"uuid";s:36:"c1dde7d9-e643-4c46-91ce-b8084172fe2a";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:4:"help";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"VfPFqqxfkomud5CO8DUijw85QIl9GIxh_nIxLOYESxg";}s:2:"id";s:12:"olivero_help";s:5:"theme";s:7:"olivero";s:6:"region";s:13:"content_above";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:10:"help_block";s:8:"settings";a:4:{s:2:"id";s:10:"help_block";s:5:"label";s:4:"Help";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"help";}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.olivero_main_menu',
  'data' => 'a:13:{s:4:"uuid";s:36:"aa232095-6eeb-43c2-a0d9-53fcad8111b3";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:3:{s:6:"config";a:1:{i:0;s:16:"system.menu.main";}s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"KWAiziL39uEzmOJEql_wbUP2RtqGceL3WM2CfxhMelE";}s:2:"id";s:17:"olivero_main_menu";s:5:"theme";s:7:"olivero";s:6:"region";s:12:"primary_menu";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:22:"system_menu_block:main";s:8:"settings";a:7:{s:2:"id";s:22:"system_menu_block:main";s:5:"label";s:15:"Main navigation";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";s:5:"level";i:1;s:5:"depth";i:2;s:16:"expand_all_items";b:1;}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.olivero_messages',
  'data' => 'a:13:{s:4:"uuid";s:36:"0442b9ac-98e8-4171-97c3-c123f193dfcd";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"BZ5tpW7H8X4PVGRm3MImTIHd2tN0eF7zOtp4SpRYUA0";}s:2:"id";s:16:"olivero_messages";s:5:"theme";s:7:"olivero";s:6:"region";s:11:"highlighted";s:6:"weight";i:-5;s:8:"provider";N;s:6:"plugin";s:21:"system_messages_block";s:8:"settings";a:4:{s:2:"id";s:21:"system_messages_block";s:5:"label";s:15:"Status messages";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.olivero_page_title',
  'data' => 'a:13:{s:4:"uuid";s:36:"65675939-734e-4b74-b21d-54f954204978";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"6aOgWsNTXjqrDm98TXSAjP6qd2nCijD1xw45MrnbK-Y";}s:2:"id";s:18:"olivero_page_title";s:5:"theme";s:7:"olivero";s:6:"region";s:13:"content_above";s:6:"weight";i:-5;s:8:"provider";N;s:6:"plugin";s:16:"page_title_block";s:8:"settings";a:4:{s:2:"id";s:16:"page_title_block";s:5:"label";s:10:"Page title";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"core";}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.olivero_powered',
  'data' => 'a:13:{s:4:"uuid";s:36:"59e9b4eb-a103-4b80-bb14-c2265781acef";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"eYL19CLDyinGTWYQfBD1DswWzglEotE_kHnHx3AxTXM";}s:2:"id";s:15:"olivero_powered";s:5:"theme";s:7:"olivero";s:6:"region";s:13:"footer_bottom";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:23:"system_powered_by_block";s:8:"settings";a:4:{s:2:"id";s:23:"system_powered_by_block";s:5:"label";s:17:"Powered by Drupal";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.olivero_primary_admin_actions',
  'data' => 'a:13:{s:4:"uuid";s:36:"ef91aa88-b6dd-45c1-bd82-26873c2cc4ca";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Q9_2whdOj1YIomfvsIfopROW4FT_X5pY0DjdOiOaQ5U";}s:2:"id";s:29:"olivero_primary_admin_actions";s:5:"theme";s:7:"olivero";s:6:"region";s:11:"highlighted";s:6:"weight";i:-5;s:8:"provider";N;s:6:"plugin";s:19:"local_actions_block";s:8:"settings";a:4:{s:2:"id";s:19:"local_actions_block";s:5:"label";s:21:"Primary admin actions";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"core";}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.olivero_primary_local_tasks',
  'data' => 'a:13:{s:4:"uuid";s:36:"e6de916d-3c06-47bc-b12d-ff646ff9bd44";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"nGE3EoPQQaQCuqTUtZgw0-KIzmrqdKDzdNQf2JyPUt4";}s:2:"id";s:27:"olivero_primary_local_tasks";s:5:"theme";s:7:"olivero";s:6:"region";s:11:"highlighted";s:6:"weight";i:-4;s:8:"provider";N;s:6:"plugin";s:17:"local_tasks_block";s:8:"settings";a:6:{s:2:"id";s:17:"local_tasks_block";s:5:"label";s:12:"Primary tabs";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"core";s:7:"primary";b:1;s:9:"secondary";b:0;}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.olivero_search_form_narrow',
  'data' => 'a:13:{s:4:"uuid";s:36:"946411ff-8719-4097-b45b-ad6f3e1ef3c4";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"search";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"yEBET0cqDbk8dkWzaJw-8CKft0961VBflsISoSR6Lj8";}s:2:"id";s:26:"olivero_search_form_narrow";s:5:"theme";s:7:"olivero";s:6:"region";s:12:"primary_menu";s:6:"weight";i:-4;s:8:"provider";N;s:6:"plugin";s:17:"search_form_block";s:8:"settings";a:5:{s:2:"id";s:17:"search_form_block";s:5:"label";s:20:"Search form (narrow)";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"search";s:7:"page_id";s:0:"";}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.olivero_search_form_wide',
  'data' => 'a:13:{s:4:"uuid";s:36:"23cb830b-910c-42ef-ada8-7989bf95cbbb";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"search";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"imMyHD6LYci0gtXq56qr9ZKGHzbEG9uFydrN5EhKtSU";}s:2:"id";s:24:"olivero_search_form_wide";s:5:"theme";s:7:"olivero";s:6:"region";s:14:"secondary_menu";s:6:"weight";i:-5;s:8:"provider";N;s:6:"plugin";s:17:"search_form_block";s:8:"settings";a:5:{s:2:"id";s:17:"search_form_block";s:5:"label";s:18:"Search form (wide)";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"search";s:7:"page_id";s:0:"";}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.olivero_secondary_local_tasks',
  'data' => 'a:13:{s:4:"uuid";s:36:"aede71f4-8663-4ae2-8eb9-e87548031e97";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ydSxdq7R66I8UMC460rOzlfzvlUL4VRbdwc6z9DWaUI";}s:2:"id";s:29:"olivero_secondary_local_tasks";s:5:"theme";s:7:"olivero";s:6:"region";s:11:"highlighted";s:6:"weight";i:-2;s:8:"provider";N;s:6:"plugin";s:17:"local_tasks_block";s:8:"settings";a:6:{s:2:"id";s:17:"local_tasks_block";s:5:"label";s:14:"Secondary tabs";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"core";s:7:"primary";b:0;s:9:"secondary";b:1;}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.olivero_site_branding',
  'data' => 'a:13:{s:4:"uuid";s:36:"52366cc5-86b4-4cd1-a3ff-f395d76faece";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"n_nlgjggHVfQt2H__zvLOKB2YtjPDbQ5tHijF9LE1aM";}s:2:"id";s:21:"olivero_site_branding";s:5:"theme";s:7:"olivero";s:6:"region";s:6:"header";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:21:"system_branding_block";s:8:"settings";a:7:{s:2:"id";s:21:"system_branding_block";s:5:"label";s:13:"Site branding";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";s:13:"use_site_logo";b:1;s:13:"use_site_name";b:1;s:15:"use_site_slogan";b:0;}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.olivero_syndicate',
  'data' => 'a:13:{s:4:"uuid";s:36:"1f2e6bce-f5f5-4215-b257-4ef0bc5bb580";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:4:"node";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"0gq3VPg-_UM69FCCWurLFIrrnIjC2HLKhwo9iQNtcUo";}s:2:"id";s:17:"olivero_syndicate";s:5:"theme";s:7:"olivero";s:6:"region";s:6:"social";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:20:"node_syndicate_block";s:8:"settings";a:5:{s:2:"id";s:20:"node_syndicate_block";s:5:"label";s:8:"RSS feed";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"node";s:11:"block_count";i:10;}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block_content.type.basic',
  'data' => 'a:9:{s:4:"uuid";s:36:"4881ab95-c558-467e-804a-2979c2fd93d4";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"zglzjmYxi0G0ag9MZ02y0LSJOdpWRwJxyP_OvFojFyo";}s:2:"id";s:5:"basic";s:5:"label";s:11:"Basic block";s:8:"revision";i:0;s:11:"description";s:42:"A basic block contains a title and a body.";}',
))
->values(array(
  'collection' => '',
  'name' => 'claro.settings',
  'data' => 'a:1:{s:20:"third_party_settings";a:1:{s:8:"shortcut";a:1:{s:11:"module_link";b:1;}}}',
))
->values(array(
  'collection' => '',
  'name' => 'comment.settings',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"YNUW2Ij5uE7a4oaXp3i_2lvaFdYM1zNKPPfnEjB0jEc";}s:16:"log_ip_addresses";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'comment.type.comment',
  'data' => 'a:9:{s:4:"uuid";s:36:"63ce59b3-6c19-4247-a9b5-237ccf113e5a";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"bqZsN31T2n0UjcbyCpOPi9D2iO0sAOHR7FnEs9qMvaA";}s:2:"id";s:7:"comment";s:5:"label";s:16:"Default comments";s:21:"target_entity_type_id";s:4:"node";s:11:"description";s:28:"Allows commenting on content";}',
))
->values(array(
  'collection' => '',
  'name' => 'contact.form.feedback',
  'data' => 'a:12:{s:4:"uuid";s:36:"d78951fc-6ea8-4dc7-a4bb-34b0407ebb52";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"vymHlgJy26BuI5GGj9-IXjwR3dRC5C0tij4BpWJnoqw";}s:2:"id";s:8:"feedback";s:5:"label";s:16:"Website feedback";s:10:"recipients";a:1:{i:0;s:17:"admin@example.com";}s:5:"reply";s:0:"";s:6:"weight";i:0;s:7:"message";s:27:"Your message has been sent.";s:8:"redirect";s:0:"";}',
))
->values(array(
  'collection' => '',
  'name' => 'contact.form.personal',
  'data' => 'a:12:{s:4:"uuid";s:36:"cb2134ab-de78-46fb-857b-7f10480bf6ca";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"jonvgt3CkUM2eMLTFwWfHileWWDC4YtXCuIlCahTk_I";}s:2:"id";s:8:"personal";s:5:"label";s:21:"Personal contact form";s:10:"recipients";a:0:{}s:5:"reply";s:0:"";s:6:"weight";i:0;s:7:"message";s:27:"Your message has been sent.";s:8:"redirect";s:0:"";}',
))
->values(array(
  'collection' => '',
  'name' => 'contact.settings',
  'data' => 'a:4:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"U69DBeuvXuNVOC15rVNaBjDPK2fWFbo9v4takdYSSO8";}s:12:"default_form";s:8:"feedback";s:5:"flood";a:2:{s:5:"limit";i:5;s:8:"interval";i:3600;}s:20:"user_default_enabled";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.base_field_override.node.page.promote',
  'data' => 'a:17:{s:4:"uuid";s:36:"a81001fa-33aa-4d00-b7ea-dbabbec715d1";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:1:{i:0;s:14:"node.type.page";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"fPUEnm4T5zfZRr3ttDUqq7yCDd2uW3clWD-pvos4tlQ";}s:2:"id";s:17:"node.page.promote";s:10:"field_name";s:7:"promote";s:11:"entity_type";s:4:"node";s:6:"bundle";s:4:"page";s:5:"label";s:22:"Promoted to front page";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:0;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";i:0;}}s:22:"default_value_callback";s:0:"";s:8:"settings";a:2:{s:8:"on_label";s:2:"On";s:9:"off_label";s:3:"Off";}s:10:"field_type";s:7:"boolean";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.date_format.fallback',
  'data' => 'a:9:{s:4:"uuid";s:36:"fc55a34d-977a-4c5e-9dab-c53f0ec8b807";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"7klS5IWXrwzVaPpYZFAs6wcx8U2FF1X73OfrtTsvuvE";}s:2:"id";s:8:"fallback";s:5:"label";s:20:"Fallback date format";s:6:"locked";b:1;s:7:"pattern";s:14:"D, m/d/Y - H:i";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.date_format.html_date',
  'data' => 'a:9:{s:4:"uuid";s:36:"a250c99c-7172-4b50-b307-511c40463c4d";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"EOQltUQPmgc6UQ2rcJ4Xi_leCEJj5ui0TR-12duS-Tk";}s:2:"id";s:9:"html_date";s:5:"label";s:9:"HTML Date";s:6:"locked";b:1;s:7:"pattern";s:5:"Y-m-d";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.date_format.html_datetime',
  'data' => 'a:9:{s:4:"uuid";s:36:"bf6c9d38-c690-404a-8d73-c8f0aad5470f";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"jxfClwZIRXIdcvMrE--WkcZxDGUVoOIE3Sm2NRZlFuE";}s:2:"id";s:13:"html_datetime";s:5:"label";s:13:"HTML Datetime";s:6:"locked";b:1;s:7:"pattern";s:13:"Y-m-d\TH:i:sO";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.date_format.html_month',
  'data' => 'a:9:{s:4:"uuid";s:36:"ea70c2ac-98e7-4c4a-a56a-ec5bf6ce3e53";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Z7KuCUwM_WdTNvLcoltuX3_8d-s-8FZkTN6KgNwF0eM";}s:2:"id";s:10:"html_month";s:5:"label";s:10:"HTML Month";s:6:"locked";b:1;s:7:"pattern";s:3:"Y-m";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.date_format.html_time',
  'data' => 'a:9:{s:4:"uuid";s:36:"5568ba70-4dae-4e97-8b83-2cb119bc6be2";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"M7yqicYkU36hRy5p9drAaGBBihhUD1OyujFrAaQ93ZE";}s:2:"id";s:9:"html_time";s:5:"label";s:9:"HTML Time";s:6:"locked";b:1;s:7:"pattern";s:5:"H:i:s";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.date_format.html_week',
  'data' => 'a:9:{s:4:"uuid";s:36:"a2e91c79-4092-4c47-94bb-b84041f2b3dc";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"wKD4WsoV_wFgv2vgI4mcAAFSIzrye17ykzdwrnApkfY";}s:2:"id";s:9:"html_week";s:5:"label";s:9:"HTML Week";s:6:"locked";b:1;s:7:"pattern";s:5:"Y-\WW";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.date_format.html_year',
  'data' => 'a:9:{s:4:"uuid";s:36:"0e95ba11-2ad1-4afe-8e2a-05b49c6ee6b9";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"OjekiQuX9RbVQ2_8jOHBL94RgYLePqX7wpfNGgcQzrk";}s:2:"id";s:9:"html_year";s:5:"label";s:9:"HTML Year";s:6:"locked";b:1;s:7:"pattern";s:1:"Y";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.date_format.html_yearless_date',
  'data' => 'a:9:{s:4:"uuid";s:36:"f1c6c204-fc6f-47ab-a5ec-73f2033bdeaf";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"5VpawMrKPEPCkoO4YpPa0TDFO2dgiIHfTziJtwlmUxc";}s:2:"id";s:18:"html_yearless_date";s:5:"label";s:18:"HTML Yearless date";s:6:"locked";b:1;s:7:"pattern";s:3:"m-d";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.date_format.long',
  'data' => 'a:9:{s:4:"uuid";s:36:"1d0b2c03-3a8a-43d2-96d7-85796d902a39";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"og8sWXhBuHbLMw3CoiBEZjgqSyhFBFmcbUW_wLcfNbo";}s:2:"id";s:4:"long";s:5:"label";s:17:"Default long date";s:6:"locked";b:0;s:7:"pattern";s:15:"l, F j, Y - H:i";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.date_format.medium',
  'data' => 'a:9:{s:4:"uuid";s:36:"5b386ae4-5082-4cde-9ec6-6a0a9c1fb723";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"nzL5d024NjXIX_8TlT6uFAu973lmfkmHklJC-2i9rAE";}s:2:"id";s:6:"medium";s:5:"label";s:19:"Default medium date";s:6:"locked";b:0;s:7:"pattern";s:14:"D, m/d/Y - H:i";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.date_format.olivero_medium',
  'data' => 'a:9:{s:4:"uuid";s:36:"2ffba333-ed3b-4e2e-81e7-66b3364aa6bb";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:8:"enforced";a:1:{s:5:"theme";a:1:{i:0;s:7:"olivero";}}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Mt6cmxUbDZ9XxD6p25WQ8tj3_JcX8ylfcddwZc8gcAE";}s:2:"id";s:14:"olivero_medium";s:5:"label";s:14:"Olivero Medium";s:6:"locked";b:0;s:7:"pattern";s:8:"j  F,  Y";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.date_format.short',
  'data' => 'a:9:{s:4:"uuid";s:36:"ee4078e7-1a7f-4492-a2be-63a96add03b9";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"AlzeyytA8InBgxIG9H2UDJYs3CG98Zj6yRsDKmlbZwA";}s:2:"id";s:5:"short";s:5:"label";s:18:"Default short date";s:6:"locked";b:0;s:7:"pattern";s:11:"m/d/Y - H:i";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_form_display.block_content.basic.default',
  'data' => 'a:11:{s:4:"uuid";s:36:"8d2b1728-4a57-4aa8-8653-8d5e9e9fac2d";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:24:"block_content.type.basic";i:1;s:36:"field.field.block_content.basic.body";}s:6:"module";a:1:{i:0;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"jAps3FCxvKecABS_tgExbhCZrBLQB3bNPWw18WjE3ss";}s:2:"id";s:27:"block_content.basic.default";s:16:"targetEntityType";s:13:"block_content";s:6:"bundle";s:5:"basic";s:4:"mode";s:7:"default";s:7:"content";a:2:{s:4:"body";a:5:{s:4:"type";s:26:"text_textarea_with_summary";s:6:"weight";i:-4;s:6:"region";s:7:"content";s:8:"settings";a:4:{s:4:"rows";i:9;s:12:"summary_rows";i:3;s:11:"placeholder";s:0:"";s:12:"show_summary";b:0;}s:20:"third_party_settings";a:0:{}}s:4:"info";a:5:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:-5;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}}s:6:"hidden";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_form_display.comment.comment.default',
  'data' => 'a:11:{s:4:"uuid";s:36:"158b3f10-2979-46bf-83e2-a687c389253c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:20:"comment.type.comment";i:1;s:40:"field.field.comment.comment.comment_body";}s:6:"module";a:1:{i:0;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"I0Pa0aQvT_jawlPo9oz4FE3h_ickc55dYKTPl6gILes";}s:2:"id";s:23:"comment.comment.default";s:16:"targetEntityType";s:7:"comment";s:6:"bundle";s:7:"comment";s:4:"mode";s:7:"default";s:7:"content";a:3:{s:6:"author";a:2:{s:6:"weight";i:-2;s:6:"region";s:7:"content";}s:12:"comment_body";a:5:{s:4:"type";s:13:"text_textarea";s:6:"weight";i:11;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"rows";i:5;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:7:"subject";a:5:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:10;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}}s:6:"hidden";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_form_display.node.article.default',
  'data' => 'a:11:{s:4:"uuid";s:36:"26f84e3c-dce5-445f-bc14-e13f3f3077e0";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:6:{i:0;s:29:"field.field.node.article.body";i:1;s:32:"field.field.node.article.comment";i:2;s:36:"field.field.node.article.field_image";i:3;s:35:"field.field.node.article.field_tags";i:4;s:21:"image.style.thumbnail";i:5;s:17:"node.type.article";}s:6:"module";a:4:{i:0;s:7:"comment";i:1;s:5:"image";i:2;s:4:"path";i:3;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ewbd6G2uX456-bgwseM2Q-KQG3RkASoyHmTh-XR3oLU";}s:2:"id";s:20:"node.article.default";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:7:"article";s:4:"mode";s:7:"default";s:7:"content";a:11:{s:4:"body";a:5:{s:4:"type";s:26:"text_textarea_with_summary";s:6:"weight";i:2;s:6:"region";s:7:"content";s:8:"settings";a:4:{s:4:"rows";i:9;s:12:"summary_rows";i:3;s:11:"placeholder";s:0:"";s:12:"show_summary";b:0;}s:20:"third_party_settings";a:0:{}}s:7:"comment";a:5:{s:4:"type";s:15:"comment_default";s:6:"weight";i:20;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:7:"created";a:5:{s:4:"type";s:18:"datetime_timestamp";s:6:"weight";i:10;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:11:"field_image";a:5:{s:4:"type";s:11:"image_image";s:6:"weight";i:1;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:18:"progress_indicator";s:8:"throbber";s:19:"preview_image_style";s:9:"thumbnail";}s:20:"third_party_settings";a:0:{}}s:10:"field_tags";a:5:{s:4:"type";s:34:"entity_reference_autocomplete_tags";s:6:"weight";i:3;s:6:"region";s:7:"content";s:8:"settings";a:4:{s:14:"match_operator";s:8:"CONTAINS";s:11:"match_limit";i:10;s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:4:"path";a:5:{s:4:"type";s:4:"path";s:6:"weight";i:30;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:7:"promote";a:5:{s:4:"type";s:16:"boolean_checkbox";s:6:"weight";i:15;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:20:"third_party_settings";a:0:{}}s:6:"status";a:5:{s:4:"type";s:16:"boolean_checkbox";s:6:"weight";i:120;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:20:"third_party_settings";a:0:{}}s:6:"sticky";a:5:{s:4:"type";s:16:"boolean_checkbox";s:6:"weight";i:16;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:20:"third_party_settings";a:0:{}}s:5:"title";a:5:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:0;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:3:"uid";a:5:{s:4:"type";s:29:"entity_reference_autocomplete";s:6:"weight";i:5;s:6:"region";s:7:"content";s:8:"settings";a:4:{s:14:"match_operator";s:8:"CONTAINS";s:11:"match_limit";i:10;s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}}s:6:"hidden";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_form_display.node.page.default',
  'data' => 'a:11:{s:4:"uuid";s:36:"5201f1f5-40b8-4a21-bdd8-a74ab02089bc";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:26:"field.field.node.page.body";i:1;s:14:"node.type.page";}s:6:"module";a:2:{i:0;s:4:"path";i:1;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"SfpLhPExzvR0MgFp0Wp7CrmgEnhcqQ-fXIWFhbf4ue0";}s:2:"id";s:17:"node.page.default";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:4:"page";s:4:"mode";s:7:"default";s:7:"content";a:8:{s:4:"body";a:5:{s:4:"type";s:26:"text_textarea_with_summary";s:6:"weight";i:31;s:6:"region";s:7:"content";s:8:"settings";a:4:{s:4:"rows";i:9;s:12:"summary_rows";i:3;s:11:"placeholder";s:0:"";s:12:"show_summary";b:0;}s:20:"third_party_settings";a:0:{}}s:7:"created";a:5:{s:4:"type";s:18:"datetime_timestamp";s:6:"weight";i:10;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:4:"path";a:5:{s:4:"type";s:4:"path";s:6:"weight";i:30;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:7:"promote";a:5:{s:4:"type";s:16:"boolean_checkbox";s:6:"weight";i:15;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:20:"third_party_settings";a:0:{}}s:6:"status";a:5:{s:4:"type";s:16:"boolean_checkbox";s:6:"weight";i:120;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:20:"third_party_settings";a:0:{}}s:6:"sticky";a:5:{s:4:"type";s:16:"boolean_checkbox";s:6:"weight";i:16;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:20:"third_party_settings";a:0:{}}s:5:"title";a:5:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:-5;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:3:"uid";a:5:{s:4:"type";s:29:"entity_reference_autocomplete";s:6:"weight";i:5;s:6:"region";s:7:"content";s:8:"settings";a:4:{s:14:"match_operator";s:8:"CONTAINS";s:11:"match_limit";i:10;s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}}s:6:"hidden";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_form_display.user.user.default',
  'data' => 'a:11:{s:4:"uuid";s:36:"496aaf84-ad4d-4013-9c17-a9cda437272b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:34:"field.field.user.user.user_picture";i:1;s:21:"image.style.thumbnail";}s:6:"module";a:2:{i:0;s:5:"image";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"FaQ9Ptcpxpg30AtiqRDtl_8zbJArHP1LPfug_s59TOA";}s:2:"id";s:17:"user.user.default";s:16:"targetEntityType";s:4:"user";s:6:"bundle";s:4:"user";s:4:"mode";s:7:"default";s:7:"content";a:5:{s:7:"account";a:2:{s:6:"weight";i:-10;s:6:"region";s:7:"content";}s:7:"contact";a:2:{s:6:"weight";i:5;s:6:"region";s:7:"content";}s:8:"language";a:2:{s:6:"weight";i:0;s:6:"region";s:7:"content";}s:8:"timezone";a:2:{s:6:"weight";i:6;s:6:"region";s:7:"content";}s:12:"user_picture";a:5:{s:4:"type";s:11:"image_image";s:6:"weight";i:-1;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:18:"progress_indicator";s:8:"throbber";s:19:"preview_image_style";s:9:"thumbnail";}s:20:"third_party_settings";a:0:{}}}s:6:"hidden";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_form_mode.user.register',
  'data' => 'a:9:{s:4:"uuid";s:36:"dc755c05-6c79-41b9-a243-27bad6080f38";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"flXhTcp55yLcyy7ZLOhPGKGZobZQJdkAFVWV3LseiuI";}s:2:"id";s:13:"user.register";s:5:"label";s:8:"Register";s:16:"targetEntityType";s:4:"user";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.block_content.basic.default',
  'data' => 'a:11:{s:4:"uuid";s:36:"32412924-bff8-41a6-bf40-dab1e7e643e3";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:24:"block_content.type.basic";i:1;s:36:"field.field.block_content.basic.body";}s:6:"module";a:1:{i:0;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"hBNNDTFwakREOTa6GGMqN899Iyrii0hInwSJtQ7Kj30";}s:2:"id";s:27:"block_content.basic.default";s:16:"targetEntityType";s:13:"block_content";s:6:"bundle";s:5:"basic";s:4:"mode";s:7:"default";s:7:"content";a:1:{s:4:"body";a:6:{s:4:"type";s:12:"text_default";s:5:"label";s:6:"hidden";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}}s:6:"hidden";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.comment.comment.default',
  'data' => 'a:11:{s:4:"uuid";s:36:"294f8feb-b408-4d00-995c-e1d58f72e00b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:20:"comment.type.comment";i:1;s:40:"field.field.comment.comment.comment_body";}s:6:"module";a:1:{i:0;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"aBQUGsQ46M4048fIlFuTXwl2zV0j2cJX89CTUobh9hA";}s:2:"id";s:23:"comment.comment.default";s:16:"targetEntityType";s:7:"comment";s:6:"bundle";s:7:"comment";s:4:"mode";s:7:"default";s:7:"content";a:2:{s:12:"comment_body";a:6:{s:4:"type";s:12:"text_default";s:5:"label";s:6:"hidden";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}s:5:"links";a:2:{s:6:"weight";i:100;s:6:"region";s:7:"content";}}s:6:"hidden";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.node.article.default',
  'data' => 'a:11:{s:4:"uuid";s:36:"69b0f199-ad2a-49cd-9dd7-89dd23c5b66c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:7:{i:0;s:48:"core.entity_view_display.comment.comment.default";i:1;s:29:"field.field.node.article.body";i:2;s:32:"field.field.node.article.comment";i:3;s:36:"field.field.node.article.field_image";i:4;s:35:"field.field.node.article.field_tags";i:5;s:16:"image.style.wide";i:6;s:17:"node.type.article";}s:6:"module";a:4:{i:0;s:7:"comment";i:1;s:5:"image";i:2;s:4:"text";i:3;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"7fb0j9HnIXfP9ndewzgPPzzeX_SV532wuYpkscrCMCk";}s:2:"id";s:20:"node.article.default";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:7:"article";s:4:"mode";s:7:"default";s:7:"content";a:5:{s:4:"body";a:6:{s:4:"type";s:12:"text_default";s:5:"label";s:6:"hidden";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}s:7:"comment";a:6:{s:4:"type";s:15:"comment_default";s:5:"label";s:5:"above";s:8:"settings";a:2:{s:9:"view_mode";s:7:"default";s:8:"pager_id";i:0;}s:20:"third_party_settings";a:0:{}s:6:"weight";i:110;s:6:"region";s:7:"content";}s:11:"field_image";a:6:{s:4:"type";s:5:"image";s:5:"label";s:6:"hidden";s:8:"settings";a:3:{s:11:"image_style";s:4:"wide";s:10:"image_link";s:0:"";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:-1;s:6:"region";s:7:"content";}s:10:"field_tags";a:6:{s:4:"type";s:22:"entity_reference_label";s:5:"label";s:5:"above";s:8:"settings";a:1:{s:4:"link";b:1;}s:20:"third_party_settings";a:0:{}s:6:"weight";i:10;s:6:"region";s:7:"content";}s:5:"links";a:4:{s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:6:"weight";i:100;s:6:"region";s:7:"content";}}s:6:"hidden";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.node.article.rss',
  'data' => 'a:11:{s:4:"uuid";s:36:"90156650-0cc9-4125-97fe-0479950a9551";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:6:{i:0;s:30:"core.entity_view_mode.node.rss";i:1;s:29:"field.field.node.article.body";i:2;s:32:"field.field.node.article.comment";i:3;s:36:"field.field.node.article.field_image";i:4;s:35:"field.field.node.article.field_tags";i:5;s:17:"node.type.article";}s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"2rIr6K5Q0UQ9khg0zE_CK-PtJH76UL-BDDZcZnZzwCc";}s:2:"id";s:16:"node.article.rss";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:7:"article";s:4:"mode";s:3:"rss";s:7:"content";a:1:{s:5:"links";a:2:{s:6:"weight";i:100;s:6:"region";s:7:"content";}}s:6:"hidden";a:4:{s:4:"body";b:1;s:7:"comment";b:1;s:11:"field_image";b:1;s:10:"field_tags";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.node.article.teaser',
  'data' => 'a:11:{s:4:"uuid";s:36:"afa608b4-006c-42dd-9afa-43f3c16ef7cd";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:7:{i:0;s:33:"core.entity_view_mode.node.teaser";i:1;s:29:"field.field.node.article.body";i:2;s:32:"field.field.node.article.comment";i:3;s:36:"field.field.node.article.field_image";i:4;s:35:"field.field.node.article.field_tags";i:5;s:18:"image.style.medium";i:6;s:17:"node.type.article";}s:6:"module";a:3:{i:0;s:5:"image";i:1;s:4:"text";i:2;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"83jX5ChAGdMzOxiDA_B1NjgebVMuD8lNVDgClg_QVP8";}s:2:"id";s:19:"node.article.teaser";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:7:"article";s:4:"mode";s:6:"teaser";s:7:"content";a:4:{s:4:"body";a:6:{s:4:"type";s:23:"text_summary_or_trimmed";s:5:"label";s:6:"hidden";s:8:"settings";a:1:{s:11:"trim_length";i:600;}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}s:11:"field_image";a:6:{s:4:"type";s:5:"image";s:5:"label";s:6:"hidden";s:8:"settings";a:3:{s:11:"image_style";s:6:"medium";s:10:"image_link";s:7:"content";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:-1;s:6:"region";s:7:"content";}s:10:"field_tags";a:6:{s:4:"type";s:22:"entity_reference_label";s:5:"label";s:5:"above";s:8:"settings";a:1:{s:4:"link";b:1;}s:20:"third_party_settings";a:0:{}s:6:"weight";i:10;s:6:"region";s:7:"content";}s:5:"links";a:2:{s:6:"weight";i:100;s:6:"region";s:7:"content";}}s:6:"hidden";a:3:{s:7:"comment";b:1;s:11:"field_image";b:1;s:10:"field_tags";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.node.page.default',
  'data' => 'a:11:{s:4:"uuid";s:36:"3df1c635-9a37-4ebd-b6ac-d6c576bf5c93";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:26:"field.field.node.page.body";i:1;s:14:"node.type.page";}s:6:"module";a:2:{i:0;s:4:"text";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"M_Y8L5tfmhx7DR143E05YyZSpvgil6VFvqcfBWykalg";}s:2:"id";s:17:"node.page.default";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:4:"page";s:4:"mode";s:7:"default";s:7:"content";a:2:{s:4:"body";a:6:{s:4:"type";s:12:"text_default";s:5:"label";s:6:"hidden";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:6:"weight";i:100;s:6:"region";s:7:"content";}s:5:"links";a:2:{s:6:"weight";i:101;s:6:"region";s:7:"content";}}s:6:"hidden";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.node.page.teaser',
  'data' => 'a:11:{s:4:"uuid";s:36:"7b67ecbf-72bd-4e61-b6a8-9f382e2c171c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:3:{i:0;s:33:"core.entity_view_mode.node.teaser";i:1;s:26:"field.field.node.page.body";i:2;s:14:"node.type.page";}s:6:"module";a:2:{i:0;s:4:"text";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"8BgdRtLbtQ0F__o0FHSH0Mx5fvXOra9tfT1GmNKbRYw";}s:2:"id";s:16:"node.page.teaser";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:4:"page";s:4:"mode";s:6:"teaser";s:7:"content";a:2:{s:4:"body";a:6:{s:4:"type";s:23:"text_summary_or_trimmed";s:5:"label";s:6:"hidden";s:8:"settings";a:1:{s:11:"trim_length";i:600;}s:20:"third_party_settings";a:0:{}s:6:"weight";i:100;s:6:"region";s:7:"content";}s:5:"links";a:2:{s:6:"weight";i:101;s:6:"region";s:7:"content";}}s:6:"hidden";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.user.user.compact',
  'data' => 'a:11:{s:4:"uuid";s:36:"7d171050-f25c-46c6-bebb-7677d4567e18";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:3:{i:0;s:34:"core.entity_view_mode.user.compact";i:1;s:34:"field.field.user.user.user_picture";i:2;s:21:"image.style.thumbnail";}s:6:"module";a:2:{i:0;s:5:"image";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"00zr_RBdTjPjBGITD3h4c1ESQZimjdVCcHGt1trLqIY";}s:2:"id";s:17:"user.user.compact";s:16:"targetEntityType";s:4:"user";s:6:"bundle";s:4:"user";s:4:"mode";s:7:"compact";s:7:"content";a:1:{s:12:"user_picture";a:6:{s:4:"type";s:5:"image";s:5:"label";s:6:"hidden";s:8:"settings";a:3:{s:11:"image_style";s:9:"thumbnail";s:10:"image_link";s:7:"content";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}}s:6:"hidden";a:1:{s:10:"member_for";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.user.user.default',
  'data' => 'a:11:{s:4:"uuid";s:36:"7ca019af-f9a1-42bb-9a97-2b075fd770ea";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:34:"field.field.user.user.user_picture";i:1;s:21:"image.style.thumbnail";}s:6:"module";a:2:{i:0;s:5:"image";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"mZLyuWM9CQx2ZJVqFGSbzgFnHzudVbHBYmdU256A5Wk";}s:2:"id";s:17:"user.user.default";s:16:"targetEntityType";s:4:"user";s:6:"bundle";s:4:"user";s:4:"mode";s:7:"default";s:7:"content";a:2:{s:10:"member_for";a:2:{s:6:"weight";i:5;s:6:"region";s:7:"content";}s:12:"user_picture";a:6:{s:4:"type";s:5:"image";s:5:"label";s:6:"hidden";s:8:"settings";a:3:{s:11:"image_style";s:9:"thumbnail";s:10:"image_link";s:7:"content";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}}s:6:"hidden";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.block_content.full',
  'data' => 'a:9:{s:4:"uuid";s:36:"5c5c9306-d386-4ecc-ae0d-629535b0c29f";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:13:"block_content";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"4tedlMuvQjDOdvHdw86_e-2Rt78aR7TGFMfOK8Ejppg";}s:2:"id";s:18:"block_content.full";s:5:"label";s:4:"Full";s:16:"targetEntityType";s:13:"block_content";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.comment.full',
  'data' => 'a:9:{s:4:"uuid";s:36:"388d609f-5453-4e15-b2f5-83a72ae546d7";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:7:"comment";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"K7eNlfU7NEUajz01wItywZklr2oaPgL6s1_97fmDXLA";}s:2:"id";s:12:"comment.full";s:5:"label";s:12:"Full comment";s:16:"targetEntityType";s:7:"comment";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.node.full',
  'data' => 'a:9:{s:4:"uuid";s:36:"249d4400-885a-4003-be6e-9353dd5fc4c7";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ElrtInxGjZd7GaapJ5O9n-ugi2hG2IxFivtgn0tHOsk";}s:2:"id";s:9:"node.full";s:5:"label";s:12:"Full content";s:16:"targetEntityType";s:4:"node";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.node.rss',
  'data' => 'a:9:{s:4:"uuid";s:36:"86d20921-4629-4162-b3a5-419cfb9af234";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"vlYzr-rp2f9NMp-Qlr4sFjlqRq-90mco5-afLNGwCrU";}s:2:"id";s:8:"node.rss";s:5:"label";s:3:"RSS";s:16:"targetEntityType";s:4:"node";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.node.search_index',
  'data' => 'a:9:{s:4:"uuid";s:36:"4a18b620-3934-406b-b0a3-b181e5e7671a";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"fVFfJv_GzBRE-wpRHbfD5a3VjnhbEOXG6lvRd3uaccY";}s:2:"id";s:17:"node.search_index";s:5:"label";s:12:"Search index";s:16:"targetEntityType";s:4:"node";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.node.search_result',
  'data' => 'a:9:{s:4:"uuid";s:36:"1b99a673-7dd1-4f63-bac1-c08068a1dcea";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"6GCOQ-jP2RbdbHA5YWQ6bT8CfGbqrBYKOSC_XY4E3ZM";}s:2:"id";s:18:"node.search_result";s:5:"label";s:32:"Search result highlighting input";s:16:"targetEntityType";s:4:"node";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.node.teaser',
  'data' => 'a:9:{s:4:"uuid";s:36:"c641d165-0cb4-467c-8aa6-54ac4ffe62d7";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Mz9qWr1kUYK0mjRAGDsr5XS6PvtZ24en_7ndt-pyWe4";}s:2:"id";s:11:"node.teaser";s:5:"label";s:6:"Teaser";s:16:"targetEntityType";s:4:"node";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.taxonomy_term.full',
  'data' => 'a:9:{s:4:"uuid";s:36:"f35baadd-bd61-488f-9032-b91176c3235e";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:8:"taxonomy";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"-PPKjsNQPvoIDjOuUAvlLocYD976MNjb9Zpgyz5_BWE";}s:2:"id";s:18:"taxonomy_term.full";s:5:"label";s:18:"Taxonomy term page";s:16:"targetEntityType";s:13:"taxonomy_term";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.user.compact',
  'data' => 'a:9:{s:4:"uuid";s:36:"463b7949-5ecc-4fb2-b674-45dee5f906fb";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"71CSAr_LNPcgu6D6jI4INl1KATkahmeyUFBETAWya8g";}s:2:"id";s:12:"user.compact";s:5:"label";s:7:"Compact";s:16:"targetEntityType";s:4:"user";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.user.full',
  'data' => 'a:9:{s:4:"uuid";s:36:"089bb350-b28f-4432-a8e7-c057202d6250";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"mQIF_foYjmnVSr9MpcD4CTaJE_FpO1AyDd_DskztGhM";}s:2:"id";s:9:"user.full";s:5:"label";s:12:"User account";s:16:"targetEntityType";s:4:"user";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.extension',
  'data' => 'a:4:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"R4IF-ClDHXxblLcG0L7MgsLvfBIMAvi_skumNFQwkDc";}s:6:"module";a:45:{s:14:"automated_cron";i:0;s:8:"big_pipe";i:0;s:5:"block";i:0;s:13:"block_content";i:0;s:10:"breakpoint";i:0;s:9:"ckeditor5";i:0;s:7:"comment";i:0;s:6:"config";i:0;s:7:"contact";i:0;s:10:"contextual";i:0;s:8:"datetime";i:0;s:18:"dynamic_page_cache";i:0;s:6:"editor";i:0;s:5:"field";i:0;s:8:"field_ui";i:0;s:4:"file";i:0;s:6:"filter";i:0;s:4:"help";i:0;s:7:"history";i:0;s:5:"image";i:0;s:4:"link";i:0;s:17:"menu_link_content";i:0;s:7:"menu_ui";i:0;s:5:"mysql";i:0;s:4:"node";i:0;s:7:"options";i:0;s:10:"page_cache";i:0;s:4:"path";i:0;s:10:"path_alias";i:0;s:11:"rabbit_hole";i:0;s:7:"rh_node";i:0;s:11:"rh_taxonomy";i:0;s:7:"rh_user";i:0;s:6:"search";i:0;s:8:"shortcut";i:0;s:6:"system";i:0;s:8:"taxonomy";i:0;s:4:"text";i:0;s:7:"toolbar";i:0;s:4:"tour";i:0;s:6:"update";i:0;s:4:"user";i:0;s:8:"views_ui";i:0;s:5:"views";i:10;s:8:"standard";i:1000;}s:5:"theme";a:2:{s:7:"olivero";i:0;s:5:"claro";i:0;}s:7:"profile";s:8:"standard";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.menu.static_menu_link_overrides',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"CXhei_vpaZk-3f_Mj2cH0YmpK-ZpKHoSzVA3yZrDq0g";}s:11:"definitions";a:1:{s:18:"contact__site_page";a:5:{s:9:"menu_name";s:6:"footer";s:6:"parent";s:0:"";s:6:"weight";i:0;s:8:"expanded";b:0;s:7:"enabled";b:1;}}}',
))
->values(array(
  'collection' => '',
  'name' => 'editor.editor.basic_html',
  'data' => 'a:9:{s:4:"uuid";s:36:"33fdf202-e530-4ad5-b69d-f1637f4f601b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:24:"filter.format.basic_html";}s:6:"module";a:1:{i:0;s:9:"ckeditor5";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"uXAqOeMiQVnzE5yk7-v1DsBagmkCI2h_q5WAf0bir-o";}s:6:"format";s:10:"basic_html";s:6:"editor";s:9:"ckeditor5";s:8:"settings";a:2:{s:7:"toolbar";a:1:{s:5:"items";a:15:{i:0;s:4:"bold";i:1;s:6:"italic";i:2;s:1:"|";i:3;s:4:"link";i:4;s:1:"|";i:5;s:12:"bulletedList";i:6;s:12:"numberedList";i:7;s:1:"|";i:8;s:10:"blockQuote";i:9;s:17:"drupalInsertImage";i:10;s:1:"|";i:11;s:7:"heading";i:12;s:4:"code";i:13;s:1:"|";i:14;s:13:"sourceEditing";}}s:7:"plugins";a:4:{s:17:"ckeditor5_heading";a:1:{s:16:"enabled_headings";a:5:{i:0;s:8:"heading2";i:1;s:8:"heading3";i:2;s:8:"heading4";i:3;s:8:"heading5";i:4;s:8:"heading6";}}s:23:"ckeditor5_sourceEditing";a:1:{s:12:"allowed_tags";a:13:{i:0;s:6:"<cite>";i:1;s:4:"<dl>";i:2;s:4:"<dt>";i:3;s:4:"<dd>";i:4;s:12:"<a hreflang>";i:5;s:17:"<blockquote cite>";i:6;s:9:"<ul type>";i:7;s:15:"<ol start type>";i:8;s:7:"<h2 id>";i:9;s:7:"<h3 id>";i:10;s:7:"<h4 id>";i:11;s:7:"<h5 id>";i:12;s:7:"<h6 id>";}}s:14:"ckeditor5_list";a:2:{s:8:"reversed";b:0;s:10:"startIndex";b:1;}s:21:"ckeditor5_imageResize";a:1:{s:12:"allow_resize";b:1;}}}s:12:"image_upload";a:5:{s:6:"status";b:1;s:6:"scheme";s:6:"public";s:9:"directory";s:13:"inline-images";s:8:"max_size";s:0:"";s:14:"max_dimensions";a:2:{s:5:"width";i:0;s:6:"height";i:0;}}}',
))
->values(array(
  'collection' => '',
  'name' => 'editor.editor.full_html',
  'data' => 'a:9:{s:4:"uuid";s:36:"9fcb2e7a-0370-490c-a98b-4c44279d3f17";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:23:"filter.format.full_html";}s:6:"module";a:1:{i:0;s:9:"ckeditor5";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"a0UeuvbLLshU7EeXK0lLcsZYdDuR4ByvaYRhrX_84mo";}s:6:"format";s:9:"full_html";s:6:"editor";s:9:"ckeditor5";s:8:"settings";a:2:{s:7:"toolbar";a:1:{s:5:"items";a:21:{i:0;s:4:"bold";i:1;s:6:"italic";i:2;s:13:"strikethrough";i:3;s:11:"superscript";i:4;s:9:"subscript";i:5;s:12:"removeFormat";i:6;s:1:"|";i:7;s:4:"link";i:8;s:1:"|";i:9;s:12:"bulletedList";i:10;s:12:"numberedList";i:11;s:1:"|";i:12;s:10:"blockQuote";i:13;s:17:"drupalInsertImage";i:14;s:11:"insertTable";i:15;s:14:"horizontalLine";i:16;s:1:"|";i:17;s:7:"heading";i:18;s:9:"codeBlock";i:19;s:1:"|";i:20;s:13:"sourceEditing";}}s:7:"plugins";a:4:{s:17:"ckeditor5_heading";a:1:{s:16:"enabled_headings";a:5:{i:0;s:8:"heading2";i:1;s:8:"heading3";i:2;s:8:"heading4";i:3;s:8:"heading5";i:4;s:8:"heading6";}}s:23:"ckeditor5_sourceEditing";a:1:{s:12:"allowed_tags";a:0:{}}s:14:"ckeditor5_list";a:2:{s:8:"reversed";b:1;s:10:"startIndex";b:1;}s:21:"ckeditor5_imageResize";a:1:{s:12:"allow_resize";b:1;}}}s:12:"image_upload";a:5:{s:6:"status";b:1;s:6:"scheme";s:6:"public";s:9:"directory";s:13:"inline-images";s:8:"max_size";s:0:"";s:14:"max_dimensions";a:2:{s:5:"width";i:0;s:6:"height";i:0;}}}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.block_content.basic.body',
  'data' => 'a:17:{s:4:"uuid";s:36:"74c9a038-e5bd-4c2f-bca4-bad616e68cc4";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:24:"block_content.type.basic";i:1;s:32:"field.storage.block_content.body";}s:6:"module";a:1:{i:0;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"foetbaMhlB6uLc2bn-PESvaPkbuDWj0MEjpQVwQiP-o";}s:2:"id";s:24:"block_content.basic.body";s:10:"field_name";s:4:"body";s:11:"entity_type";s:13:"block_content";s:6:"bundle";s:5:"basic";s:5:"label";s:4:"Body";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:2:{s:15:"display_summary";b:0;s:16:"required_summary";b:0;}s:10:"field_type";s:17:"text_with_summary";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.comment.comment.comment_body',
  'data' => 'a:17:{s:4:"uuid";s:36:"31a4fe58-da46-43bf-9a6e-5da5c546443b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:20:"comment.type.comment";i:1;s:34:"field.storage.comment.comment_body";}s:6:"module";a:1:{i:0;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"TmAKjNrJ7RR60YpqvJq_QqEewYe_S8Kd23n8VRCqiWs";}s:2:"id";s:28:"comment.comment.comment_body";s:10:"field_name";s:12:"comment_body";s:11:"entity_type";s:7:"comment";s:6:"bundle";s:7:"comment";s:5:"label";s:7:"Comment";s:11:"description";s:0:"";s:8:"required";b:1;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:0:{}s:10:"field_type";s:9:"text_long";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.node.article.body',
  'data' => 'a:17:{s:4:"uuid";s:36:"21a0f353-84ac-403b-9f0b-6348ce0bbfd9";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:23:"field.storage.node.body";i:1;s:17:"node.type.article";}s:6:"module";a:1:{i:0;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"IjZnOLWk1Pjq3WRg2pLSA1ERh7Po7izCq_p6UztZr2c";}s:2:"id";s:17:"node.article.body";s:10:"field_name";s:4:"body";s:11:"entity_type";s:4:"node";s:6:"bundle";s:7:"article";s:5:"label";s:4:"Body";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:2:{s:15:"display_summary";b:1;s:16:"required_summary";b:0;}s:10:"field_type";s:17:"text_with_summary";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.node.article.comment',
  'data' => 'a:17:{s:4:"uuid";s:36:"d590a738-36b2-4e12-a222-2b905172c780";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:26:"field.storage.node.comment";i:1;s:17:"node.type.article";}s:6:"module";a:1:{i:0;s:7:"comment";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"UqXlkKC4v2-bDfWx4zcXQrD5YIi3d5byENEmWv-G_Uc";}s:2:"id";s:20:"node.article.comment";s:10:"field_name";s:7:"comment";s:11:"entity_type";s:4:"node";s:6:"bundle";s:7:"article";s:5:"label";s:8:"Comments";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:1;s:13:"default_value";a:1:{i:0;a:6:{s:6:"status";i:2;s:3:"cid";i:0;s:22:"last_comment_timestamp";i:0;s:17:"last_comment_name";N;s:16:"last_comment_uid";i:0;s:13:"comment_count";i:0;}}s:22:"default_value_callback";s:0:"";s:8:"settings";a:5:{s:12:"default_mode";i:1;s:8:"per_page";i:50;s:9:"anonymous";i:0;s:13:"form_location";b:1;s:7:"preview";i:1;}s:10:"field_type";s:7:"comment";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.node.article.field_image',
  'data' => 'a:17:{s:4:"uuid";s:36:"c55d79f2-3363-4976-ad22-e6cf221920d7";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:30:"field.storage.node.field_image";i:1;s:17:"node.type.article";}s:6:"module";a:1:{i:0;s:5:"image";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"PmVL51L3A9QGbPLoeLHw5epAPszeZRasCeC3imeeDRQ";}s:2:"id";s:24:"node.article.field_image";s:10:"field_name";s:11:"field_image";s:11:"entity_type";s:4:"node";s:6:"bundle";s:7:"article";s:5:"label";s:5:"Image";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:12:{s:7:"handler";s:12:"default:file";s:16:"handler_settings";a:0:{}s:14:"file_directory";s:31:"[date:custom:Y]-[date:custom:m]";s:15:"file_extensions";s:16:"png gif jpg jpeg";s:12:"max_filesize";s:0:"";s:14:"max_resolution";s:0:"";s:14:"min_resolution";s:0:"";s:9:"alt_field";b:1;s:18:"alt_field_required";b:1;s:11:"title_field";b:0;s:20:"title_field_required";b:0;s:13:"default_image";a:5:{s:4:"uuid";N;s:3:"alt";s:0:"";s:5:"title";s:0:"";s:5:"width";N;s:6:"height";N;}}s:10:"field_type";s:5:"image";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.node.article.field_tags',
  'data' => 'a:17:{s:4:"uuid";s:36:"9bd4733c-d1c9-4fee-9639-cc1cdb8fdcb5";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:3:{i:0;s:29:"field.storage.node.field_tags";i:1;s:17:"node.type.article";i:2;s:24:"taxonomy.vocabulary.tags";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"QdUgf_beeoaPiyKorFv0q1fcJpWH_uZTqe_xoVJacrw";}s:2:"id";s:23:"node.article.field_tags";s:10:"field_name";s:10:"field_tags";s:11:"entity_type";s:4:"node";s:6:"bundle";s:7:"article";s:5:"label";s:4:"Tags";s:11:"description";s:84:"Enter a comma-separated list. For example: Amsterdam, Mexico City, "Cleveland, Ohio"";s:8:"required";b:0;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:2:{s:7:"handler";s:21:"default:taxonomy_term";s:16:"handler_settings";a:3:{s:14:"target_bundles";a:1:{s:4:"tags";s:4:"tags";}s:4:"sort";a:1:{s:5:"field";s:5:"_none";}s:11:"auto_create";b:1;}}s:10:"field_type";s:16:"entity_reference";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.node.page.body',
  'data' => 'a:17:{s:4:"uuid";s:36:"804a65de-765e-44f6-acf7-20a8d53490ea";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:23:"field.storage.node.body";i:1;s:14:"node.type.page";}s:6:"module";a:1:{i:0;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"KgVkxLl_K3E3lvN6CEoWQIDT0V8J4Mv-fVYrAIc7-FE";}s:2:"id";s:14:"node.page.body";s:10:"field_name";s:4:"body";s:11:"entity_type";s:4:"node";s:6:"bundle";s:4:"page";s:5:"label";s:4:"Body";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:2:{s:15:"display_summary";b:1;s:16:"required_summary";b:0;}s:10:"field_type";s:17:"text_with_summary";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.user.user.user_picture',
  'data' => 'a:17:{s:4:"uuid";s:36:"797c8e1a-df33-4a40-b28b-5b924085355e";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:31:"field.storage.user.user_picture";}s:6:"module";a:2:{i:0;s:5:"image";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"twhm-ZOwSVkUjuLI_pQsaPo_pVLcqFfDmY-ojfqw0yk";}s:2:"id";s:22:"user.user.user_picture";s:10:"field_name";s:12:"user_picture";s:11:"entity_type";s:4:"user";s:6:"bundle";s:4:"user";s:5:"label";s:7:"Picture";s:11:"description";s:29:"Your virtual face or picture.";s:8:"required";b:0;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:12:{s:7:"handler";s:12:"default:file";s:16:"handler_settings";a:0:{}s:14:"file_directory";s:40:"pictures/[date:custom:Y]-[date:custom:m]";s:15:"file_extensions";s:16:"png gif jpg jpeg";s:12:"max_filesize";s:0:"";s:14:"max_resolution";s:0:"";s:14:"min_resolution";s:0:"";s:9:"alt_field";b:0;s:18:"alt_field_required";b:0;s:11:"title_field";b:0;s:20:"title_field_required";b:0;s:13:"default_image";a:5:{s:4:"uuid";N;s:3:"alt";s:0:"";s:5:"title";s:0:"";s:5:"width";N;s:6:"height";N;}}s:10:"field_type";s:5:"image";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.settings',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"nJk0TAQBzlNo52ehiHI7bIEPLGi0BYqZvPdEn7Chfu0";}s:16:"purge_batch_size";i:50;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.block_content.body',
  'data' => 'a:17:{s:4:"uuid";s:36:"06af7efe-abc6-42ea-969f-6cfc97601d94";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:13:"block_content";i:1;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"eS0snV_L3dx9shtWRTzm5eblwOJ7qKWC9IE-4GMTDFc";}s:2:"id";s:18:"block_content.body";s:10:"field_name";s:4:"body";s:11:"entity_type";s:13:"block_content";s:4:"type";s:17:"text_with_summary";s:8:"settings";a:0:{}s:6:"module";s:4:"text";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:1;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.comment.comment_body',
  'data' => 'a:17:{s:4:"uuid";s:36:"c566e36b-0afb-40b2-9595-e249ba88a889";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:7:"comment";i:1;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"swYoCch_hY8QO5uwr4FURplfnUCUlpPB4idF8WGVCpw";}s:2:"id";s:20:"comment.comment_body";s:10:"field_name";s:12:"comment_body";s:11:"entity_type";s:7:"comment";s:4:"type";s:9:"text_long";s:8:"settings";a:0:{}s:6:"module";s:4:"text";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:1;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.node.body',
  'data' => 'a:17:{s:4:"uuid";s:36:"1eeb692d-16be-477f-8383-3f6355004254";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:4:"node";i:1;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"EBUo7qOWqaiZaQ_RC9sLY5IoDKphS34v77VIHSACmVY";}s:2:"id";s:9:"node.body";s:10:"field_name";s:4:"body";s:11:"entity_type";s:4:"node";s:4:"type";s:17:"text_with_summary";s:8:"settings";a:0:{}s:6:"module";s:4:"text";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:1;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.node.comment',
  'data' => 'a:17:{s:4:"uuid";s:36:"dbdd39c4-d17a-4c5f-be9e-9db9a64027de";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:7:"comment";i:1;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ktCna9xmWvYZIUfOCUyDQvedn5RtnS4CRmEIwNmvYjc";}s:2:"id";s:12:"node.comment";s:10:"field_name";s:7:"comment";s:11:"entity_type";s:4:"node";s:4:"type";s:7:"comment";s:8:"settings";a:1:{s:12:"comment_type";s:7:"comment";}s:6:"module";s:7:"comment";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.node.field_image',
  'data' => 'a:17:{s:4:"uuid";s:36:"3f70cbf2-e4e2-4352-ae29-e8696da9eeb2";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:3:{i:0;s:4:"file";i:1;s:5:"image";i:2;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"EymokncRIZ7SgQT2IdOQhQJicX4nNc0K89ik-LxmOHE";}s:2:"id";s:16:"node.field_image";s:10:"field_name";s:11:"field_image";s:11:"entity_type";s:4:"node";s:4:"type";s:5:"image";s:8:"settings";a:5:{s:11:"target_type";s:4:"file";s:13:"display_field";b:0;s:15:"display_default";b:0;s:10:"uri_scheme";s:6:"public";s:13:"default_image";a:5:{s:4:"uuid";N;s:3:"alt";s:0:"";s:5:"title";s:0:"";s:5:"width";N;s:6:"height";N;}}s:6:"module";s:5:"image";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.node.field_tags',
  'data' => 'a:17:{s:4:"uuid";s:36:"5ed462ff-240c-4675-aa57-4bb7dc3d064e";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:4:"node";i:1;s:8:"taxonomy";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"WpOE_bs8Bs_HY2ns7n2r__de-xno0-Bxkqep5-MsHAs";}s:2:"id";s:15:"node.field_tags";s:10:"field_name";s:10:"field_tags";s:11:"entity_type";s:4:"node";s:4:"type";s:16:"entity_reference";s:8:"settings";a:1:{s:11:"target_type";s:13:"taxonomy_term";}s:6:"module";s:4:"core";s:6:"locked";b:0;s:11:"cardinality";i:-1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.user.user_picture',
  'data' => 'a:17:{s:4:"uuid";s:36:"b3e256f3-94df-4903-8aa5-5a0cb456ed71";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:3:{i:0;s:4:"file";i:1;s:5:"image";i:2;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"0q8-mw8y-Ls5I578sIPQFLp4ljpH7WvVYpzY-I9O-8E";}s:2:"id";s:17:"user.user_picture";s:10:"field_name";s:12:"user_picture";s:11:"entity_type";s:4:"user";s:4:"type";s:5:"image";s:8:"settings";a:5:{s:11:"target_type";s:4:"file";s:13:"display_field";b:0;s:15:"display_default";b:0;s:10:"uri_scheme";s:6:"public";s:13:"default_image";a:5:{s:4:"uuid";N;s:3:"alt";s:0:"";s:5:"title";s:0:"";s:5:"width";N;s:6:"height";N;}}s:6:"module";s:5:"image";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field_ui.settings',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Q1nMi90W6YQxKzZAgJQw7Ag9U4JrsEUwkomF0lhvbIM";}s:12:"field_prefix";s:6:"field_";}',
))
->values(array(
  'collection' => '',
  'name' => 'file.settings',
  'data' => 'a:4:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"0aMkoXYnax5_tHI9C9zHs-K48KJ6K75PHtD9x-0nbgM";}s:11:"description";a:2:{s:4:"type";s:9:"textfield";s:6:"length";i:128;}s:4:"icon";a:1:{s:9:"directory";s:23:"core/modules/file/icons";}s:35:"make_unused_managed_files_temporary";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'filter.format.basic_html',
  'data' => 'a:9:{s:4:"uuid";s:36:"fff73a0c-209f-4629-85ea-a4a703c8df26";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:6:"editor";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"RjoJPQLCAE8u1Ys_yCKubpkYlRz_Oy12a5qCVeNIHJ8";}s:4:"name";s:10:"Basic HTML";s:6:"format";s:10:"basic_html";s:6:"weight";i:0;s:7:"filters";a:5:{s:11:"filter_html";a:5:{s:2:"id";s:11:"filter_html";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:-10;s:8:"settings";a:3:{s:12:"allowed_html";s:243:"<br> <p> <h2 id> <h3 id> <h4 id> <h5 id> <h6 id> <cite> <dl> <dt> <dd> <a hreflang href> <blockquote cite> <ul type> <ol start type> <strong> <em> <code> <li> <img src alt data-entity-uuid data-entity-type height width data-caption data-align>";s:16:"filter_html_help";b:0;s:20:"filter_html_nofollow";b:0;}}s:12:"filter_align";a:5:{s:2:"id";s:12:"filter_align";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:7;s:8:"settings";a:0:{}}s:14:"filter_caption";a:5:{s:2:"id";s:14:"filter_caption";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:8;s:8:"settings";a:0:{}}s:24:"filter_html_image_secure";a:5:{s:2:"id";s:24:"filter_html_image_secure";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:9;s:8:"settings";a:0:{}}s:21:"editor_file_reference";a:5:{s:2:"id";s:21:"editor_file_reference";s:8:"provider";s:6:"editor";s:6:"status";b:1;s:6:"weight";i:11;s:8:"settings";a:0:{}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'filter.format.full_html',
  'data' => 'a:9:{s:4:"uuid";s:36:"63b3a490-4b0b-420d-9fc5-c204a9553b34";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:6:"editor";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"WNeK5FbcY8pXgEpbD_KgRzlF1-5PL3BJXwqaBctPTqw";}s:4:"name";s:9:"Full HTML";s:6:"format";s:9:"full_html";s:6:"weight";i:2;s:7:"filters";a:4:{s:12:"filter_align";a:5:{s:2:"id";s:12:"filter_align";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:8;s:8:"settings";a:0:{}}s:14:"filter_caption";a:5:{s:2:"id";s:14:"filter_caption";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:9;s:8:"settings";a:0:{}}s:20:"filter_htmlcorrector";a:5:{s:2:"id";s:20:"filter_htmlcorrector";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:10;s:8:"settings";a:0:{}}s:21:"editor_file_reference";a:5:{s:2:"id";s:21:"editor_file_reference";s:8:"provider";s:6:"editor";s:6:"status";b:1;s:6:"weight";i:11;s:8:"settings";a:0:{}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'filter.format.plain_text',
  'data' => 'a:9:{s:4:"uuid";s:36:"5c2357c3-3152-45b7-8169-740bb25f2e88";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"NIKBt6kw_uPhNI0qtR2DnRf7mSOgAQdx7Q94SKMjXbQ";}s:4:"name";s:10:"Plain text";s:6:"format";s:10:"plain_text";s:6:"weight";i:10;s:7:"filters";a:3:{s:18:"filter_html_escape";a:5:{s:2:"id";s:18:"filter_html_escape";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:-10;s:8:"settings";a:0:{}}s:10:"filter_url";a:5:{s:2:"id";s:10:"filter_url";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:0;s:8:"settings";a:1:{s:17:"filter_url_length";i:72;}}s:12:"filter_autop";a:5:{s:2:"id";s:12:"filter_autop";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:0;s:8:"settings";a:0:{}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'filter.format.restricted_html',
  'data' => 'a:9:{s:4:"uuid";s:36:"34829048-b87f-4c08-b0ec-55e407a01afe";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"oz6NyPDAB4HB6N9hgH2LwNVtCd-sXbMG1fbn5KsRIDI";}s:4:"name";s:15:"Restricted HTML";s:6:"format";s:15:"restricted_html";s:6:"weight";i:1;s:7:"filters";a:3:{s:11:"filter_html";a:5:{s:2:"id";s:11:"filter_html";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:-10;s:8:"settings";a:3:{s:12:"allowed_html";s:149:"<a href hreflang> <em> <strong> <cite> <blockquote cite> <code> <ul type> <ol start type> <li> <dl> <dt> <dd> <h2 id> <h3 id> <h4 id> <h5 id> <h6 id>";s:16:"filter_html_help";b:1;s:20:"filter_html_nofollow";b:0;}}s:12:"filter_autop";a:5:{s:2:"id";s:12:"filter_autop";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:0;s:8:"settings";a:0:{}}s:10:"filter_url";a:5:{s:2:"id";s:10:"filter_url";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:0;s:8:"settings";a:1:{s:17:"filter_url_length";i:72;}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'filter.settings',
  'data' => 'a:3:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"FiPjM3WdB__ruFA7B6TLwni_UcZbmek5G4b2dxQItxA";}s:15:"fallback_format";s:10:"plain_text";s:27:"always_show_fallback_choice";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'image.settings',
  'data' => 'a:4:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"k-yDFHbqNfpe-Srg4sdCSqaosCl2D8uwyEY5esF8gEw";}s:13:"preview_image";s:29:"core/modules/image/sample.png";s:26:"allow_insecure_derivatives";b:0;s:20:"suppress_itok_output";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'image.style.large',
  'data' => 'a:8:{s:4:"uuid";s:36:"9bb053fd-992a-4ca3-bcf9-14f86a40e8e4";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"J2n0RpFzS0-bgSyxjs6rSdgxB1rb-bTAgqywNx_964M";}s:4:"name";s:5:"large";s:5:"label";s:16:"Large (480×480)";s:7:"effects";a:1:{s:36:"ddd73aa7-4bd6-4c85-b600-bdf2b1628d1d";a:4:{s:4:"uuid";s:36:"ddd73aa7-4bd6-4c85-b600-bdf2b1628d1d";s:2:"id";s:11:"image_scale";s:6:"weight";i:0;s:4:"data";a:3:{s:5:"width";i:480;s:6:"height";i:480;s:7:"upscale";b:0;}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'image.style.medium',
  'data' => 'a:8:{s:4:"uuid";s:36:"987a55c1-a2c5-4173-831f-d4c324bd6dfb";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Y9NmnZHQq20ASSyTNA6JnwtWrJJiSajOehGDtmUFdM0";}s:4:"name";s:6:"medium";s:5:"label";s:17:"Medium (220×220)";s:7:"effects";a:1:{s:36:"bddf0d06-42f9-4c75-a700-a33cafa25ea0";a:4:{s:4:"uuid";s:36:"bddf0d06-42f9-4c75-a700-a33cafa25ea0";s:2:"id";s:11:"image_scale";s:6:"weight";i:0;s:4:"data";a:3:{s:5:"width";i:220;s:6:"height";i:220;s:7:"upscale";b:0;}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'image.style.thumbnail',
  'data' => 'a:8:{s:4:"uuid";s:36:"29aed8da-4271-4aa4-98b5-c82f09e8fea9";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"cCiWdBHgLwj5omG35lsKc4LkW4MBdmcctkVop4ol5x0";}s:4:"name";s:9:"thumbnail";s:5:"label";s:20:"Thumbnail (100×100)";s:7:"effects";a:1:{s:36:"1cfec298-8620-4749-b100-ccb6c4500779";a:4:{s:4:"uuid";s:36:"1cfec298-8620-4749-b100-ccb6c4500779";s:2:"id";s:11:"image_scale";s:6:"weight";i:0;s:4:"data";a:3:{s:5:"width";i:100;s:6:"height";i:100;s:7:"upscale";b:0;}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'image.style.wide',
  'data' => 'a:8:{s:4:"uuid";s:36:"83e90fb2-fa03-456d-8678-4c574f3d7d8c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"LswCVLg8z4Zk1u6pV1Dpj1qUj5YY2CQ7_ojx7bJQ8qk";}s:4:"name";s:4:"wide";s:5:"label";s:11:"Wide (1090)";s:7:"effects";a:1:{s:36:"09959c15-59ce-4f6d-90df-e2d7cf32bce5";a:4:{s:4:"uuid";s:36:"09959c15-59ce-4f6d-90df-e2d7cf32bce5";s:2:"id";s:11:"image_scale";s:6:"weight";i:1;s:4:"data";a:3:{s:5:"width";i:1090;s:6:"height";N;s:7:"upscale";b:0;}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'menu_ui.settings',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"SqMarzIjxC3F8dZo9FEOxfqDKD_sdW1tbcFTV1BA2zU";}s:24:"override_parent_selector";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'node.settings',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"W0cgFPhPJ3gAdqm06-az48BLf5MVcoZVS0HdByoofi0";}s:15:"use_admin_theme";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'node.type.article',
  'data' => 'a:13:{s:4:"uuid";s:36:"f2c03a43-67e9-494f-97b5-63b6375d27a5";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:7:"menu_ui";}}s:20:"third_party_settings";a:1:{s:7:"menu_ui";a:2:{s:15:"available_menus";a:1:{i:0;s:4:"main";}s:6:"parent";s:5:"main:";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"AeW1SEDgb1OTQACAWGhzvMknMYAJlcZu0jljfeU3oso";}s:4:"name";s:7:"Article";s:4:"type";s:7:"article";s:11:"description";s:89:"Use <em>articles</em> for time-sensitive content like news, press releases or blog posts.";s:4:"help";s:0:"";s:12:"new_revision";b:1;s:12:"preview_mode";i:1;s:17:"display_submitted";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'node.type.page',
  'data' => "a:13:{s:4:\"uuid\";s:36:\"b8eee83a-751f-44e1-b403-2198bb97ec25\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:7:\"menu_ui\";}}s:20:\"third_party_settings\";a:1:{s:7:\"menu_ui\";a:2:{s:15:\"available_menus\";a:1:{i:0;s:4:\"main\";}s:6:\"parent\";s:5:\"main:\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"KuyA4NHPXcmKAjRtwa0vQc2ZcyrUJy6IlS2TAyMNRbc\";}s:4:\"name\";s:10:\"Basic page\";s:4:\"type\";s:4:\"page\";s:11:\"description\";s:77:\"Use <em>basic pages</em> for your static content, such as an 'About us' page.\";s:4:\"help\";s:0:\"\";s:12:\"new_revision\";b:1;s:12:\"preview_mode\";i:1;s:17:\"display_submitted\";b:0;}",
))
->values(array(
  'collection' => '',
  'name' => 'olivero.settings',
  'data' => 'a:7:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Ylohp6sdrL1dU4v-KcXzXTP-U8BAMgh4NWJA9eGHtO4";}s:7:"favicon";a:1:{s:11:"use_default";b:1;}s:8:"features";a:4:{s:20:"comment_user_picture";b:1;s:25:"comment_user_verification";b:1;s:7:"favicon";b:1;s:17:"node_user_picture";b:0;}s:4:"logo";a:1:{s:11:"use_default";b:0;}s:20:"third_party_settings";a:1:{s:8:"shortcut";a:1:{s:11:"module_link";b:1;}}s:22:"mobile_menu_all_widths";i:0;s:22:"site_branding_bg_color";s:7:"default";}',
))
->values(array(
  'collection' => '',
  'name' => 'rabbit_hole.behavior_settings.default',
  'data' => 'a:13:{s:4:"uuid";s:36:"bf480a7d-f120-49bc-9ce2-8d3807fea0ec";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"hzh9CgsYCGxPEcbR3ieT1la6e43lMv-ivoN7oZJKkQQ";}s:2:"id";s:7:"default";s:14:"entity_type_id";N;s:9:"entity_id";N;s:6:"action";s:12:"display_page";s:14:"allow_override";i:1;s:8:"redirect";s:0:"";s:13:"redirect_code";i:0;s:24:"redirect_fallback_action";s:13:"access_denied";}',
))
->values(array(
  'collection' => '',
  'name' => 'rabbit_hole.behavior_settings.default_bundle',
  'data' => 'a:13:{s:4:"uuid";s:36:"ae7d012c-c572-4aad-b53b-fac4d7ef022e";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"qUkgsWZRCa_sLIn5JsMzB3xnx5ekIsVeGGZr7T0s9MY";}s:2:"id";s:14:"default_bundle";s:14:"entity_type_id";N;s:9:"entity_id";N;s:6:"action";s:12:"display_page";s:14:"allow_override";i:1;s:8:"redirect";s:0:"";s:13:"redirect_code";i:0;s:24:"redirect_fallback_action";s:13:"access_denied";}',
))
->values(array(
  'collection' => '',
  'name' => 'rabbit_hole.behavior_settings.node_type_article',
  'data' => 'a:12:{s:4:"uuid";s:36:"fa21bc8e-3113-4150-a5f7-3a6b665a3b6f";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:1:{i:0;s:17:"node.type.article";}}s:2:"id";s:17:"node_type_article";s:14:"entity_type_id";s:9:"node_type";s:9:"entity_id";s:7:"article";s:6:"action";s:13:"page_redirect";s:14:"allow_override";i:1;s:8:"redirect";s:9:"/articles";s:13:"redirect_code";i:301;s:24:"redirect_fallback_action";s:13:"access_denied";}',
))
->values(array(
  'collection' => '',
  'name' => 'rabbit_hole.behavior_settings.taxonomy_vocabulary_tags',
  'data' => 'a:12:{s:4:"uuid";s:36:"e72c30ab-9660-4f0e-8fc4-a7834a0dd04b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:1:{i:0;s:24:"taxonomy.vocabulary.tags";}}s:2:"id";s:24:"taxonomy_vocabulary_tags";s:14:"entity_type_id";s:19:"taxonomy_vocabulary";s:9:"entity_id";s:4:"tags";s:6:"action";s:20:"page_redirect_custom";s:14:"allow_override";i:1;s:8:"redirect";s:5:"/tags";s:13:"redirect_code";i:301;s:24:"redirect_fallback_action";s:13:"access_denied";}',
))
->values(array(
  'collection' => '',
  'name' => 'rabbit_hole.behavior_settings.user',
  'data' => 'a:12:{s:4:"uuid";s:36:"79eed3d9-4fdd-40b2-9b1d-e5440bd92433";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:2:"id";s:4:"user";s:14:"entity_type_id";s:4:"user";s:9:"entity_id";N;s:6:"action";s:14:"page_not_found";s:14:"allow_override";i:1;s:8:"redirect";s:0:"";s:13:"redirect_code";i:301;s:24:"redirect_fallback_action";s:13:"access_denied";}',
))
->values(array(
  'collection' => '',
  'name' => 'search.page.node_search',
  'data' => 'a:11:{s:4:"uuid";s:36:"58c9e4c2-eec7-4ee7-9986-738d9ed5c78c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"97tvtzGOa8_flb22CzSjgtm_YkiGMHvEBO-6q2K9V_U";}s:2:"id";s:11:"node_search";s:5:"label";s:7:"Content";s:4:"path";s:4:"node";s:6:"weight";i:-10;s:6:"plugin";s:11:"node_search";s:13:"configuration";a:1:{s:8:"rankings";a:0:{}}}',
))
->values(array(
  'collection' => '',
  'name' => 'search.page.user_search',
  'data' => 'a:11:{s:4:"uuid";s:36:"c37120e6-f9c1-41a1-8ffc-1d763107163c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"k3aUaZXGDuhkek2TZIee0PApOPTvYZLadziekdyHA5A";}s:2:"id";s:11:"user_search";s:5:"label";s:5:"Users";s:4:"path";s:4:"user";s:6:"weight";i:0;s:6:"plugin";s:11:"user_search";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'search.settings',
  'data' => 'a:5:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"hvVxL1G-ZCxaq32IZws0YsfuhvaDiQE_np-0g35KjUk";}s:12:"and_or_limit";i:7;s:12:"default_page";s:11:"node_search";s:5:"index";a:4:{s:10:"cron_limit";i:100;s:11:"overlap_cjk";b:1;s:17:"minimum_word_size";i:3;s:11:"tag_weights";a:12:{s:2:"h1";i:25;s:2:"h2";i:18;s:2:"h3";i:15;s:2:"h4";i:14;s:2:"h5";i:9;s:2:"h6";i:6;s:1:"u";i:3;s:1:"b";i:3;s:1:"i";i:3;s:6:"strong";i:3;s:2:"em";i:3;s:1:"a";i:10;}}s:7:"logging";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'shortcut.set.default',
  'data' => 'a:7:{s:4:"uuid";s:36:"1c370768-46b6-42cf-9b64-8ee8f643edc7";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"U5VlGjd_SfV0Qm_EfnaynOfc549cNscFAx48JfYoMRI";}s:2:"id";s:7:"default";s:5:"label";s:7:"Default";}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.comment_delete_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"5f656b10-b5fb-4298-b518-a32679087872";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:7:"comment";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"vpBH8OmL4sdesCdeZLsW8KOutB5gkbreWJbfjhfFKaQ";}s:2:"id";s:21:"comment_delete_action";s:5:"label";s:14:"Delete comment";s:4:"type";s:7:"comment";s:6:"plugin";s:28:"entity:delete_action:comment";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.comment_publish_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"6761de1f-3792-4aaa-8e91-4a4997bbdf88";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:7:"comment";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"C00dyL_W_5M0nFlgUB3lWUTUs96jn51Jw1MLHVEHZD0";}s:2:"id";s:22:"comment_publish_action";s:5:"label";s:15:"Publish comment";s:4:"type";s:7:"comment";s:6:"plugin";s:29:"entity:publish_action:comment";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.comment_save_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"df875fda-75ee-44f6-85f6-a67a1dca6fe1";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:7:"comment";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"lfyE_snmvfg_EQ3VDyhUtGAXgmqtEiqa46I3bTMg8DU";}s:2:"id";s:19:"comment_save_action";s:5:"label";s:12:"Save comment";s:4:"type";s:7:"comment";s:6:"plugin";s:26:"entity:save_action:comment";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.comment_unpublish_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"5db82785-8f19-422a-b63f-31fe1f0cec45";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:7:"comment";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"tWOIjSMobEWOFZddMkNqb9JySbOVwE1diC6NRqcfLTk";}s:2:"id";s:24:"comment_unpublish_action";s:5:"label";s:17:"Unpublish comment";s:4:"type";s:7:"comment";s:6:"plugin";s:31:"entity:unpublish_action:comment";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.node_delete_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"a4e858ff-a668-4282-8e77-98c262d56292";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"t43OqwzP3CTbcAagSsWKNy6KwMm_zShXo3c4-So6rQg";}s:2:"id";s:18:"node_delete_action";s:5:"label";s:14:"Delete content";s:4:"type";s:4:"node";s:6:"plugin";s:25:"entity:delete_action:node";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.node_make_sticky_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"409ce2ad-5e9b-4b95-b3d6-8477271e3c21";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"sOb26JSy3fGpWkvR0WYN6_hMqj_6d1rvbvrkzp1yya0";}s:2:"id";s:23:"node_make_sticky_action";s:5:"label";s:19:"Make content sticky";s:4:"type";s:4:"node";s:6:"plugin";s:23:"node_make_sticky_action";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.node_make_unsticky_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"26b08999-f474-47e0-8051-bce594577c5e";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"lDM9mvIGAu8Sw8rt-uCO4Sr7yX5VPrDPxYcawkbKd6k";}s:2:"id";s:25:"node_make_unsticky_action";s:5:"label";s:21:"Make content unsticky";s:4:"type";s:4:"node";s:6:"plugin";s:25:"node_make_unsticky_action";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.node_promote_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"302d5d05-7465-47e3-b15a-8c34cf9f6912";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"N0RDBTqiK4dKoN4p4oW2j0SGWycdHyALUe9M-Ofp89U";}s:2:"id";s:19:"node_promote_action";s:5:"label";s:29:"Promote content to front page";s:4:"type";s:4:"node";s:6:"plugin";s:19:"node_promote_action";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.node_publish_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"4daf6bec-d2dc-44bf-a2d3-2349f32f2a12";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"2B9uF8NL5gutNKSdPRAhhAsDWFZZG1PJOBmx0aBGd_0";}s:2:"id";s:19:"node_publish_action";s:5:"label";s:15:"Publish content";s:4:"type";s:4:"node";s:6:"plugin";s:26:"entity:publish_action:node";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.node_save_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"204a0f15-e96a-486f-96e6-444b0ca9fdc2";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"LhdsoZPL_pFas2fjaAWue4zvrQ_tEVofLYtcNec-JGM";}s:2:"id";s:16:"node_save_action";s:5:"label";s:12:"Save content";s:4:"type";s:4:"node";s:6:"plugin";s:23:"entity:save_action:node";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.node_unpromote_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"a1b4900f-6ea6-44c6-a820-46972c5a530d";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"JBptjnfuOMtsdKygklXxoOgeOCTMtQxlkymjnnj-cC0";}s:2:"id";s:21:"node_unpromote_action";s:5:"label";s:30:"Remove content from front page";s:4:"type";s:4:"node";s:6:"plugin";s:21:"node_unpromote_action";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.node_unpublish_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"82fddbbe-471a-479e-91b4-84a25e9bc0aa";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"C7X8h9FWlwkQ9y5mnU2JzgaZICAdc6HFbPVbhvjlAYE";}s:2:"id";s:21:"node_unpublish_action";s:5:"label";s:17:"Unpublish content";s:4:"type";s:4:"node";s:6:"plugin";s:28:"entity:unpublish_action:node";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.taxonomy_term_publish_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"c449d713-5b72-4d22-991d-69848db25bf5";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:8:"taxonomy";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"DoVt_VGgVLcDD4XmVbSFzr0K17SJy9imFiYusKkJBgY";}s:2:"id";s:28:"taxonomy_term_publish_action";s:5:"label";s:21:"Publish taxonomy term";s:4:"type";s:13:"taxonomy_term";s:6:"plugin";s:35:"entity:publish_action:taxonomy_term";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.taxonomy_term_unpublish_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"4de35454-ce45-4eaa-b979-bc7b46e84f4b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:8:"taxonomy";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"z2sNRM3ECa7FPCGnSNje_9SmZJQgwhD_6fG_L4Mr8zI";}s:2:"id";s:30:"taxonomy_term_unpublish_action";s:5:"label";s:23:"Unpublish taxonomy term";s:4:"type";s:13:"taxonomy_term";s:6:"plugin";s:37:"entity:unpublish_action:taxonomy_term";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.user_add_role_action.administrator',
  'data' => 'a:9:{s:4:"uuid";s:36:"8cec3297-a41f-43eb-bfc7-892900ed17ba";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:23:"user.role.administrator";}s:6:"module";a:1:{i:0;s:4:"user";}}s:2:"id";s:34:"user_add_role_action.administrator";s:5:"label";s:50:"Add the Administrator role to the selected user(s)";s:4:"type";s:4:"user";s:6:"plugin";s:20:"user_add_role_action";s:13:"configuration";a:1:{s:3:"rid";s:13:"administrator";}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.user_add_role_action.content_editor',
  'data' => 'a:9:{s:4:"uuid";s:36:"d6fb77a0-ccf6-4544-a641-293451d25a4b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:24:"user.role.content_editor";}s:6:"module";a:1:{i:0;s:4:"user";}}s:2:"id";s:35:"user_add_role_action.content_editor";s:5:"label";s:51:"Add the Content editor role to the selected user(s)";s:4:"type";s:4:"user";s:6:"plugin";s:20:"user_add_role_action";s:13:"configuration";a:1:{s:3:"rid";s:14:"content_editor";}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.user_block_user_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"28b16d16-efb1-4178-9c00-9a67b78fc013";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"DyypzTfThX10FFQw-399qPfEbLLyrhXgQrKPVsmAoJ4";}s:2:"id";s:22:"user_block_user_action";s:5:"label";s:26:"Block the selected user(s)";s:4:"type";s:4:"user";s:6:"plugin";s:22:"user_block_user_action";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.user_cancel_user_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"a485eae3-859c-4b73-8044-29ea53d94688";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"nvrL9bFilzBvm2bjO9rQnFDpBA7dBBUjShSSt6NS-DU";}s:2:"id";s:23:"user_cancel_user_action";s:5:"label";s:35:"Cancel the selected user account(s)";s:4:"type";s:4:"user";s:6:"plugin";s:23:"user_cancel_user_action";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.user_remove_role_action.administrator',
  'data' => 'a:9:{s:4:"uuid";s:36:"180a8529-8d78-44e4-a8ab-e5d3d1326611";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:23:"user.role.administrator";}s:6:"module";a:1:{i:0;s:4:"user";}}s:2:"id";s:37:"user_remove_role_action.administrator";s:5:"label";s:55:"Remove the Administrator role from the selected user(s)";s:4:"type";s:4:"user";s:6:"plugin";s:23:"user_remove_role_action";s:13:"configuration";a:1:{s:3:"rid";s:13:"administrator";}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.user_remove_role_action.content_editor',
  'data' => 'a:9:{s:4:"uuid";s:36:"b7e68852-84d3-4d45-80d7-d638ad2f3001";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:24:"user.role.content_editor";}s:6:"module";a:1:{i:0;s:4:"user";}}s:2:"id";s:38:"user_remove_role_action.content_editor";s:5:"label";s:56:"Remove the Content editor role from the selected user(s)";s:4:"type";s:4:"user";s:6:"plugin";s:23:"user_remove_role_action";s:13:"configuration";a:1:{s:3:"rid";s:14:"content_editor";}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.user_unblock_user_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"879c21c9-08f1-47c5-913f-b939ad49d2b1";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"SPsUXsR3Rc8d1y3gewzaAKWa1ncea_ywXX3f7LTn7k0";}s:2:"id";s:24:"user_unblock_user_action";s:5:"label";s:28:"Unblock the selected user(s)";s:4:"type";s:4:"user";s:6:"plugin";s:24:"user_unblock_user_action";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.advisories',
  'data' => 'a:3:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"x0FuQ_7Cg81mSDQwG028_Z0CjH3R9ib5IDlHeV2BbAo";}s:7:"enabled";b:1;s:14:"interval_hours";i:6;}',
))
->values(array(
  'collection' => '',
  'name' => 'system.cron',
  'data' => 'a:3:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"5Pw921y1EPfFN98wykliBBLArm51pC-SmrXeYCe7d0Y";}s:9:"threshold";a:2:{s:20:"requirements_warning";i:172800;s:18:"requirements_error";i:1209600;}s:7:"logging";i:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'system.date',
  'data' => 'a:4:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"t7clj3mzmOGrXX0HuCH5usf0vEqRtnMTBFVBIEmZ5pc";}s:9:"first_day";i:0;s:7:"country";a:1:{s:7:"default";s:0:"";}s:8:"timezone";a:2:{s:7:"default";s:3:"UTC";s:4:"user";a:3:{s:12:"configurable";b:1;s:7:"default";i:0;s:4:"warn";b:0;}}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.diff',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"1WanmaEhxW_vM8_5Ktsdntj8MaO9UBHXg0lN603PsWM";}s:7:"context";a:2:{s:13:"lines_leading";i:2;s:14:"lines_trailing";i:2;}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.file',
  'data' => 'a:4:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"mguGHCYb9Dw5EcpfjwoShGV1Vjkbz3QuPRCLfxiye-g";}s:22:"allow_insecure_uploads";b:0;s:14:"default_scheme";s:6:"public";s:21:"temporary_maximum_age";i:21600;}',
))
->values(array(
  'collection' => '',
  'name' => 'system.image',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"durWHaKeBaq4d9Wpi4RqwADj1OufDepcnJuhVLmKN24";}s:7:"toolkit";s:2:"gd";}',
))
->values(array(
  'collection' => '',
  'name' => 'system.image.gd',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"eNXaHfkJJUThHeF0nvkoXyPLRrKYGxgHRjORvT4F5rQ";}s:12:"jpeg_quality";i:75;}',
))
->values(array(
  'collection' => '',
  'name' => 'system.logging',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"u3-njszl92FaxjrCMiq0yDcjAfcdx72w1zT1O9dx6aA";}s:11:"error_level";s:4:"hide";}',
))
->values(array(
  'collection' => '',
  'name' => 'system.mail',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"rYgt7uhPafP2ngaN_ZUPFuyI4KdE0zU868zLNSlzKoE";}s:9:"interface";a:1:{s:7:"default";s:8:"php_mail";}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.maintenance',
  'data' => 'a:3:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"1SNdA25INsV5YjlgAJtfC-6AM8VcWe_00xneMLb2yFg";}s:8:"langcode";s:2:"en";s:7:"message";s:93:"@site is currently under maintenance. We should be back shortly. Thank you for your patience.";}',
))
->values(array(
  'collection' => '',
  'name' => 'system.menu.account',
  'data' => 'a:9:{s:4:"uuid";s:36:"32c478d3-6011-4c47-b28b-c9f5ac145eab";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"M_Bh81osDyUQ4wV0GgU_NdBNqkzM87sLxjaCdFj9mnw";}s:2:"id";s:7:"account";s:5:"label";s:17:"User account menu";s:11:"description";s:40:"Links related to the active user account";s:6:"locked";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'system.menu.admin',
  'data' => 'a:9:{s:4:"uuid";s:36:"eaa4d291-fb65-4128-84b0-40907672e5ed";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"sapEi2YDGoI9yQIT_WgIV2vUdQ6DScH0V3fAyTadAL0";}s:2:"id";s:5:"admin";s:5:"label";s:14:"Administration";s:11:"description";s:25:"Administrative task links";s:6:"locked";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'system.menu.footer',
  'data' => 'a:9:{s:4:"uuid";s:36:"96f8f789-3700-49b5-af38-4963dbab0e4e";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"7yrlW5z9zdg2eBucB2GPqXKSMQfH9lSRSO4DbWF7AFc";}s:2:"id";s:6:"footer";s:5:"label";s:6:"Footer";s:11:"description";s:22:"Site information links";s:6:"locked";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'system.menu.main',
  'data' => 'a:9:{s:4:"uuid";s:36:"9323e082-f9cf-45b6-aca9-172c0ee871bd";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Q2Ra3jfoIVk0f3SjxJX61byRQFVBAbpzYDQOiY-kno8";}s:2:"id";s:4:"main";s:5:"label";s:15:"Main navigation";s:11:"description";s:18:"Site section links";s:6:"locked";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'system.menu.tools',
  'data' => 'a:9:{s:4:"uuid";s:36:"e1cfe7a9-2e30-45cf-a2ab-07b152cdd3e7";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"BCM-vV1zzRaLHN18dqAR_CuGOj8AFJvTx7BKl_8Gcxc";}s:2:"id";s:5:"tools";s:5:"label";s:5:"Tools";s:11:"description";s:39:"User tool links, often added by modules";s:6:"locked";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'system.performance',
  'data' => 'a:6:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"b2cssrj-lOmATIbdehfCqfCFgVR0qCdxxWhwqa2KBVQ";}s:5:"cache";a:1:{s:4:"page";a:1:{s:7:"max_age";i:0;}}s:3:"css";a:2:{s:10:"preprocess";b:1;s:4:"gzip";b:1;}s:8:"fast_404";a:4:{s:7:"enabled";b:1;s:5:"paths";s:69:"/\.(?:txt|png|gif|jpe?g|css|js|ico|swf|flv|cgi|bat|pl|dll|exe|asp)$/i";s:13:"exclude_paths";s:27:"/\/(?:styles|imagecache)\//";s:4:"html";s:162:"<!DOCTYPE html><html><head><title>404 Not Found</title></head><body><h1>Not Found</h1><p>The requested URL "@path" was not found on this server.</p></body></html>";}s:2:"js";a:2:{s:10:"preprocess";b:1;s:4:"gzip";b:1;}s:20:"stale_file_threshold";i:2592000;}',
))
->values(array(
  'collection' => '',
  'name' => 'system.rss',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"MIpNzlG4gPunfS7vTCwUPum6QH3GUsEBMj-qS631Jw0";}s:5:"items";a:1:{s:9:"view_mode";s:3:"rss";}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.site',
  'data' => 'a:11:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"VDJxTZtQR21qB4lvOq8zszJZLvLKrSPQpdn2E3T71Ww";}s:8:"langcode";s:2:"en";s:4:"uuid";s:36:"c7a58122-ec76-4d96-979d-c7aeb49ec0ab";s:4:"name";s:18:"Drush Site-Install";s:4:"mail";s:17:"admin@example.com";s:6:"slogan";s:0:"";s:4:"page";a:3:{i:403;s:0:"";i:404;s:0:"";s:5:"front";s:5:"/node";}s:18:"admin_compact_mode";b:0;s:17:"weight_select_max";i:100;s:16:"default_langcode";s:2:"en";s:17:"mail_notification";s:0:"";}',
))
->values(array(
  'collection' => '',
  'name' => 'system.theme',
  'data' => 'a:3:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"eJ529VM1gSIA_vgTy2PdiDvJuG0xhSxfQjCyl5WKlv4";}s:5:"admin";s:5:"claro";s:7:"default";s:7:"olivero";}',
))
->values(array(
  'collection' => '',
  'name' => 'system.theme.global',
  'data' => 'a:4:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"9rAU4Pku7eMBQxauQqAgjzlcicFZ2As6zEa6zvTlCB8";}s:7:"favicon";a:4:{s:8:"mimetype";s:24:"image/vnd.microsoft.icon";s:4:"path";s:0:"";s:3:"url";s:0:"";s:11:"use_default";b:1;}s:8:"features";a:4:{s:20:"comment_user_picture";b:1;s:25:"comment_user_verification";b:1;s:7:"favicon";b:1;s:17:"node_user_picture";b:1;}s:4:"logo";a:3:{s:4:"path";s:0:"";s:3:"url";s:0:"";s:11:"use_default";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'taxonomy.settings',
  'data' => 'a:4:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"zKpaWT6cJc1tVQQaTqatGELaCqU_oyRym6zTl27Yias";}s:20:"maintain_index_table";b:1;s:17:"override_selector";b:0;s:20:"terms_per_page_admin";i:100;}',
))
->values(array(
  'collection' => '',
  'name' => 'taxonomy.vocabulary.tags',
  'data' => 'a:9:{s:4:"uuid";s:36:"7a3f07cc-15f1-465b-9849-e0c03bb59f78";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"yoNVreoTdTZTY7GuE8fI9Jmxqdz8vlo4ZJKixMNSosw";}s:4:"name";s:4:"Tags";s:3:"vid";s:4:"tags";s:11:"description";s:61:"Use tags to group articles on similar topics into categories.";s:6:"weight";i:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'text.settings',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Bkewb77RBOK3_aXMPsp8p87gbc03NvmC5gBLzPl7hVA";}s:22:"default_summary_length";i:600;}',
))
->values(array(
  'collection' => '',
  'name' => 'tour.tour.block-layout',
  'data' => 'a:10:{s:4:"uuid";s:36:"c6712d2f-69b8-4200-8401-059a7240a0b2";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:5:"block";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ructO0IOsghR3CIbNd-0QfLTDiUo8gIJ7mB_nxSil4o";}s:2:"id";s:12:"block-layout";s:5:"label";s:17:"Block Layout Page";s:6:"module";s:5:"block";s:6:"routes";a:1:{i:0;a:1:{s:10:"route_name";s:19:"block.admin_display";}}s:4:"tips";a:5:{s:12:"block-layout";a:5:{s:2:"id";s:12:"block-layout";s:6:"plugin";s:4:"text";s:5:"label";s:12:"Block Layout";s:6:"weight";i:1;s:4:"body";s:150:"Blocks are boxes of content rendered into an area, or region, of a web page that can be displayed in regions (such as footer or sidebar) on your page.";}s:11:"place-block";a:6:{s:2:"id";s:11:"place-block";s:6:"plugin";s:4:"text";s:5:"label";s:12:"Place Blocks";s:6:"weight";i:2;s:8:"selector";s:14:".button--small";s:4:"body";s:163:"Any custom or contributed block can be added to a particular region by clicking on a button Place block. A new block can also be created by clicking on Place Block";}s:12:"block-region";a:6:{s:2:"id";s:12:"block-region";s:6:"plugin";s:4:"text";s:5:"label";s:12:"Block Region";s:6:"weight";i:3;s:8:"selector";s:20:".block-region-select";s:4:"body";s:151:"Assign or change the region of a block by clicking here. A dropdown list with all the regions will appear. You can place one block in multiple regions.";}s:15:"configure-block";a:6:{s:2:"id";s:15:"configure-block";s:6:"plugin";s:4:"text";s:5:"label";s:15:"Configure Block";s:6:"weight";i:4;s:8:"selector";s:18:".dropbutton-widget";s:4:"body";s:173:"By Clicking on "Configure" you can go ahead and edit the contents of the block, deal with the visibility settings and even change the placement of where it is on your theme.";}s:20:"custom-block-library";a:5:{s:2:"id";s:20:"custom-block-library";s:6:"plugin";s:4:"text";s:5:"label";s:20:"Custom Block Library";s:6:"weight";i:5;s:4:"body";s:203:"The block management screen also has an another tab on the top which is used to add Custom blocks. The name of the tab is "Custom block library". This tab ultimately provides a link to add custom blocks.";}}}',
))
->values(array(
  'collection' => '',
  'name' => 'tour.tour.views-ui',
  'data' => "a:10:{s:4:\"uuid\";s:36:\"b1baec29-9b50-4f44-8cf5-d97c1f63f4b9\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:8:\"views_ui\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"XIYL1KF7ND2XQRa5AxvEcp8vgCN2kUGiuBNhCgxrPME\";}s:2:\"id\";s:8:\"views-ui\";s:5:\"label\";s:14:\"View edit page\";s:6:\"module\";s:8:\"views_ui\";s:6:\"routes\";a:2:{i:0;a:1:{s:10:\"route_name\";s:21:\"entity.view.edit_form\";}i:1;a:1:{s:10:\"route_name\";s:29:\"entity.view.edit_display_form\";}}s:4:\"tips\";a:10:{s:10:\"views-main\";a:5:{s:2:\"id\";s:10:\"views-main\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:20:\"Manage view settings\";s:6:\"weight\";i:1;s:4:\"body\";s:31:\"View or edit the configuration.\";}s:17:\"views-ui-displays\";a:6:{s:2:\"id\";s:17:\"views-ui-displays\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:21:\"Displays in this view\";s:6:\"weight\";i:2;s:8:\"selector\";s:18:\"#views-display-top\";s:4:\"body\";s:169:\"A display is a way of outputting the results, e.g., as a page or a block. A view can contain multiple displays, which are listed here. The active display is highlighted.\";}s:19:\"views-ui-view-admin\";a:7:{s:2:\"id\";s:19:\"views-ui-view-admin\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:19:\"View administration\";s:6:\"weight\";i:3;s:8:\"position\";s:5:\"right\";s:8:\"selector\";s:28:\"#views-display-extra-actions\";s:4:\"body\";s:140:\"Perform administrative tasks, including adding a description and creating a clone. Click the drop-down button to view the available options.\";}s:15:\"views-ui-format\";a:6:{s:2:\"id\";s:15:\"views-ui-format\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:13:\"Output format\";s:6:\"weight\";i:4;s:8:\"selector\";s:35:\".views-ui-display-tab-bucket.format\";s:4:\"body\";s:325:\"Choose how to output results. E.g., choose <em>Content</em> to output each item completely, using your configured display settings. Or choose <em>Fields</em>, which allows you to output only specific fields for each result. Additional formats can be added by installing modules to <em>extend</em> Drupal's base functionality.\";}s:15:\"views-ui-fields\";a:6:{s:2:\"id\";s:15:\"views-ui-fields\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:6:\"Fields\";s:6:\"weight\";i:5;s:8:\"selector\";s:34:\".views-ui-display-tab-bucket.field\";s:4:\"body\";s:89:\"If this view uses fields, they are listed here. You can click on a field to configure it.\";}s:15:\"views-ui-filter\";a:6:{s:2:\"id\";s:15:\"views-ui-filter\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:16:\"Filter your view\";s:6:\"weight\";i:6;s:8:\"selector\";s:35:\".views-ui-display-tab-bucket.filter\";s:4:\"body\";s:173:\"Add filters to limit the results in the output. E.g., to only show content that is <em>published</em>, you would add a filter for <em>Published</em> and select <em>Yes</em>.\";}s:26:\"views-ui-filter-operations\";a:6:{s:2:\"id\";s:26:\"views-ui-filter-operations\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:14:\"Filter actions\";s:6:\"weight\";i:7;s:8:\"selector\";s:54:\".views-ui-display-tab-bucket.filter .dropbutton-widget\";s:4:\"body\";s:33:\"Add, rearrange or remove filters.\";}s:14:\"views-ui-sorts\";a:6:{s:2:\"id\";s:14:\"views-ui-sorts\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:13:\"Sort Criteria\";s:6:\"weight\";i:8;s:8:\"selector\";s:33:\".views-ui-display-tab-bucket.sort\";s:4:\"body\";s:96:\"Control the order in which the results are output. Click on an active sort rule to configure it.\";}s:25:\"views-ui-sorts-operations\";a:6:{s:2:\"id\";s:25:\"views-ui-sorts-operations\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:12:\"Sort actions\";s:6:\"weight\";i:9;s:8:\"selector\";s:52:\".views-ui-display-tab-bucket.sort .dropbutton-widget\";s:4:\"body\";s:39:\"Add, rearrange or remove sorting rules.\";}s:16:\"views-ui-preview\";a:7:{s:2:\"id\";s:16:\"views-ui-preview\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:7:\"Preview\";s:6:\"weight\";i:10;s:8:\"position\";s:5:\"right\";s:8:\"selector\";s:15:\"#preview-submit\";s:4:\"body\";s:34:\"Show a preview of the view output.\";}}}",
))
->values(array(
  'collection' => '',
  'name' => 'update.settings',
  'data' => 'a:4:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"2QzULf0zovJQx3J06Y9rufzzfi-CY2CTTlEfJJh2Qyw";}s:5:"check";a:2:{s:19:"disabled_extensions";b:0;s:13:"interval_days";i:1;}s:5:"fetch";a:3:{s:3:"url";s:0:"";s:12:"max_attempts";i:2;s:7:"timeout";i:30;}s:12:"notification";a:2:{s:6:"emails";a:1:{i:0;s:17:"admin@example.com";}s:9:"threshold";s:3:"all";}}',
))
->values(array(
  'collection' => '',
  'name' => 'user.flood',
  'data' => 'a:6:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"UYfMzeP1S8jKm9PSvxf7nQNe8DsNS-3bc2WSNNXBQWs";}s:8:"uid_only";b:0;s:8:"ip_limit";i:50;s:9:"ip_window";i:3600;s:10:"user_limit";i:5;s:11:"user_window";i:21600;}',
))
->values(array(
  'collection' => '',
  'name' => 'user.mail',
  'data' => "a:11:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"6CZIzFifRq3qbdq3n3nDpEOO4hWIQtKOAQNPvGNGKeM\";}s:8:\"langcode\";s:2:\"en\";s:14:\"cancel_confirm\";a:2:{s:7:\"subject\";s:67:\"Account cancellation request for [user:display-name] at [site:name]\";s:4:\"body\";s:388:\"[user:display-name]\r\n\r\nA request to cancel your account has been made at [site:name].\r\n\r\nYou may now cancel your account on [site:url-brief] by clicking this link or copying and pasting it into your browser:\r\n\r\n[user:cancel-url]\r\n\r\nNOTE: The cancellation of your account is not reversible.\r\n\r\nThis link expires in one day and nothing will happen if it is not used.\r\n\r\n--  [site:name] team\";}s:14:\"password_reset\";a:2:{s:7:\"subject\";s:68:\"Replacement login information for [user:display-name] at [site:name]\";s:4:\"body\";s:417:\"[user:display-name],\r\n\r\nA request to reset the password for your account has been made at [site:name].\r\n\r\nYou may now log in by clicking this link or copying and pasting it into your browser:\r\n\r\n[user:one-time-login-url]\r\n\r\nThis link can only be used once to log in and will lead you to a page where you can set your password. It expires after one day and nothing will happen if it's not used.\r\n\r\n--  [site:name] team\";}s:22:\"register_admin_created\";a:2:{s:7:\"subject\";s:58:\"An administrator created an account for you at [site:name]\";s:4:\"body\";s:486:\"[user:display-name],\r\n\r\nA site administrator at [site:name] has created an account for you. You may now log in by clicking this link or copying and pasting it into your browser:\r\n\r\n[user:one-time-login-url]\r\n\r\nThis link can only be used once to log in and will lead you to a page where you can set your password.\r\n\r\nAfter setting your password, you will be able to log in at [site:login-url] in the future using:\r\n\r\nusername: [user:name]\r\npassword: Your password\r\n\r\n--  [site:name] team\";}s:29:\"register_no_approval_required\";a:2:{s:7:\"subject\";s:54:\"Account details for [user:display-name] at [site:name]\";s:4:\"body\";s:460:\"[user:display-name],\r\n\r\nThank you for registering at [site:name]. You may now log in by clicking this link or copying and pasting it into your browser:\r\n\r\n[user:one-time-login-url]\r\n\r\nThis link can only be used once to log in and will lead you to a page where you can set your password.\r\n\r\nAfter setting your password, you will be able to log in at [site:login-url] in the future using:\r\n\r\nusername: [user:name]\r\npassword: Your password\r\n\r\n--  [site:name] team\";}s:25:\"register_pending_approval\";a:2:{s:7:\"subject\";s:79:\"Account details for [user:display-name] at [site:name] (pending admin approval)\";s:4:\"body\";s:292:\"[user:display-name],\r\n\r\nThank you for registering at [site:name]. Your application for an account is currently pending approval. Once it has been approved, you will receive another email containing information about how to log in, set your password, and other details.\r\n\r\n--  [site:name] team\";}s:31:\"register_pending_approval_admin\";a:2:{s:7:\"subject\";s:79:\"Account details for [user:display-name] at [site:name] (pending admin approval)\";s:4:\"body\";s:66:\"[user:display-name] has applied for an account.\r\n\r\n[user:edit-url]\";}s:16:\"status_activated\";a:2:{s:7:\"subject\";s:65:\"Account details for [user:display-name] at [site:name] (approved)\";s:4:\"body\";s:477:\"[user:display-name],\r\n\r\nYour account at [site:name] has been activated.\r\n\r\nYou may now log in by clicking this link or copying and pasting it into your browser:\r\n\r\n[user:one-time-login-url]\r\n\r\nThis link can only be used once to log in and will lead you to a page where you can set your password.\r\n\r\nAfter setting your password, you will be able to log in at [site:login-url] in the future using:\r\n\r\nusername: [user:account-name]\r\npassword: Your password\r\n\r\n--  [site:name] team\";}s:14:\"status_blocked\";a:2:{s:7:\"subject\";s:64:\"Account details for [user:display-name] at [site:name] (blocked)\";s:4:\"body\";s:93:\"[user:display-name],\r\n\r\nYour account on [site:name] has been blocked.\r\n\r\n--  [site:name] team\";}s:15:\"status_canceled\";a:2:{s:7:\"subject\";s:65:\"Account details for [user:display-name] at [site:name] (canceled)\";s:4:\"body\";s:94:\"[user:display-name],\r\n\r\nYour account on [site:name] has been canceled.\r\n\r\n--  [site:name] team\";}}",
))
->values(array(
  'collection' => '',
  'name' => 'user.role.administrator',
  'data' => 'a:10:{s:4:"uuid";s:36:"91230e95-9e22-408b-8aad-f10efcaf81a5";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"OeKGIkmZA_c-t6QLH81WNQx8gDCc1MRmxaTuQgxBByU";}s:2:"id";s:13:"administrator";s:5:"label";s:13:"Administrator";s:6:"weight";i:3;s:8:"is_admin";b:1;s:11:"permissions";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'user.role.anonymous',
  'data' => 'a:10:{s:4:"uuid";s:36:"62ef622d-8099-4c0e-9332-4aa7bce947bd";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:29:"filter.format.restricted_html";}s:6:"module";a:5:{i:0;s:7:"comment";i:1;s:7:"contact";i:2;s:6:"filter";i:3;s:6:"search";i:4;s:6:"system";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"6WavjUYXIegP9AAg2zXGx54MWIVoomC3SZhNiqe-Dyk";}s:2:"id";s:9:"anonymous";s:5:"label";s:14:"Anonymous user";s:6:"weight";i:0;s:8:"is_admin";b:0;s:11:"permissions";a:5:{i:0;s:15:"access comments";i:1;s:14:"access content";i:2;s:29:"access site-wide contact form";i:3;s:14:"search content";i:4;s:31:"use text format restricted_html";}}',
))
->values(array(
  'collection' => '',
  'name' => 'user.role.authenticated',
  'data' => 'a:10:{s:4:"uuid";s:36:"69a5c5d9-5fad-4bf9-b424-5e572c8e7124";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:24:"filter.format.basic_html";}s:6:"module";a:6:{i:0;s:7:"comment";i:1;s:7:"contact";i:2;s:6:"filter";i:3;s:6:"search";i:4;s:8:"shortcut";i:5;s:6:"system";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"I44QAB4es39lNzMQWiJLq2dfjX7VRSOzT_5KzAcUq_M";}s:2:"id";s:13:"authenticated";s:5:"label";s:18:"Authenticated user";s:6:"weight";i:1;s:8:"is_admin";b:0;s:11:"permissions";a:8:{i:0;s:15:"access comments";i:1;s:14:"access content";i:2;s:16:"access shortcuts";i:3;s:29:"access site-wide contact form";i:4;s:13:"post comments";i:5;s:14:"search content";i:6;s:21:"skip comment approval";i:7;s:26:"use text format basic_html";}}',
))
->values(array(
  'collection' => '',
  'name' => 'user.role.content_editor',
  'data' => 'a:10:{s:4:"uuid";s:36:"97313136-8527-45df-b2b9-89f0a91fa696";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:3:{i:0;s:17:"node.type.article";i:1;s:14:"node.type.page";i:2;s:24:"taxonomy.vocabulary.tags";}s:6:"module";a:9:{i:0;s:7:"comment";i:1;s:10:"contextual";i:2;s:4:"file";i:3;s:4:"node";i:4;s:4:"path";i:5;s:6:"system";i:6;s:8:"taxonomy";i:7;s:7:"toolbar";i:8;s:4:"tour";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Wur9kcEOwY1Jal81NssKnz3RhVJxAvBwyWQBGcA_1Go";}s:2:"id";s:14:"content_editor";s:5:"label";s:14:"Content editor";s:6:"weight";i:2;s:8:"is_admin";b:0;s:11:"permissions";a:23:{i:0;s:27:"access administration pages";i:1;s:23:"access content overview";i:2;s:23:"access contextual links";i:3;s:21:"access files overview";i:4;s:14:"access toolbar";i:5;s:11:"access tour";i:6;s:22:"administer url aliases";i:7;s:22:"create article content";i:8;s:19:"create page content";i:9;s:20:"create terms in tags";i:10;s:18:"create url aliases";i:11;s:24:"delete article revisions";i:12;s:26:"delete own article content";i:13;s:23:"delete own page content";i:14;s:21:"delete page revisions";i:15;s:24:"edit own article content";i:16;s:17:"edit own comments";i:17;s:21:"edit own page content";i:18;s:18:"edit terms in tags";i:19;s:20:"revert all revisions";i:20;s:18:"view all revisions";i:21;s:28:"view own unpublished content";i:22;s:29:"view the administration theme";}}',
))
->values(array(
  'collection' => '',
  'name' => 'user.settings',
  'data' => 'a:9:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"-htDFWUv1S4OlJMzta2nhFl4QbhJvu0D9xsJ-clxo-M";}s:8:"langcode";s:2:"en";s:9:"anonymous";s:9:"Anonymous";s:11:"verify_mail";b:1;s:6:"notify";a:8:{s:14:"cancel_confirm";b:1;s:14:"password_reset";b:1;s:16:"status_activated";b:1;s:14:"status_blocked";b:0;s:15:"status_canceled";b:0;s:22:"register_admin_created";b:1;s:29:"register_no_approval_required";b:1;s:25:"register_pending_approval";b:1;}s:8:"register";s:23:"visitors_admin_approval";s:13:"cancel_method";s:17:"user_cancel_block";s:22:"password_reset_timeout";i:86400;s:17:"password_strength";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'views.settings',
  'data' => 'a:6:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"uZHsLrDp1ThO0RvupHKcPzLOyVvWexm58JTTHNDo7yc";}s:17:"display_extenders";a:0:{}s:10:"skip_cache";b:0;s:13:"sql_signature";b:0;s:2:"ui";a:3:{s:4:"show";a:7:{s:18:"additional_queries";b:0;s:15:"advanced_column";b:0;s:15:"default_display";b:0;s:22:"performance_statistics";b:0;s:19:"preview_information";b:1;s:9:"sql_query";a:2:{s:7:"enabled";b:0;s:5:"where";s:5:"above";}s:13:"display_embed";b:0;}s:19:"always_live_preview";b:1;s:24:"exposed_filter_any_label";s:7:"old_any";}s:22:"field_rewrite_elements";a:29:{s:3:"div";s:3:"DIV";s:4:"span";s:4:"SPAN";s:2:"h1";s:2:"H1";s:2:"h2";s:2:"H2";s:2:"h3";s:2:"H3";s:2:"h4";s:2:"H4";s:2:"h5";s:2:"H5";s:2:"h6";s:2:"H6";s:1:"p";s:1:"P";s:6:"header";s:6:"HEADER";s:6:"footer";s:6:"FOOTER";s:7:"article";s:7:"ARTICLE";s:7:"section";s:7:"SECTION";s:5:"aside";s:5:"ASIDE";s:7:"details";s:7:"DETAILS";s:10:"blockquote";s:10:"BLOCKQUOTE";s:6:"figure";s:6:"FIGURE";s:7:"address";s:7:"ADDRESS";s:4:"code";s:4:"CODE";s:3:"pre";s:3:"PRE";s:3:"var";s:3:"VAR";s:4:"samp";s:4:"SAMP";s:3:"kbd";s:3:"KBD";s:6:"strong";s:6:"STRONG";s:2:"em";s:2:"EM";s:3:"del";s:3:"DEL";s:3:"ins";s:3:"INS";s:1:"q";s:1:"Q";s:1:"s";s:1:"S";}}',
))
->values(array(
  'collection' => '',
  'name' => 'views.view.archive',
  'data' => 'a:13:{s:4:"uuid";s:36:"19e738c3-448d-4d69-b9d0-a284b56894eb";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:33:"core.entity_view_mode.node.teaser";}s:6:"module";a:2:{i:0;s:4:"node";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ko9GznzNBXHkuz09OCaBQ1YOSJYYjTY0TBpNV3WKnog";}s:2:"id";s:7:"archive";s:5:"label";s:7:"Archive";s:6:"module";s:4:"node";s:11:"description";s:22:"All content, by month.";s:3:"tag";s:7:"default";s:10:"base_table";s:15:"node_field_data";s:10:"base_field";s:3:"nid";s:7:"display";a:3:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:17:{s:5:"title";s:15:"Monthly archive";s:6:"fields";a:0:{}s:5:"pager";a:2:{s:4:"type";s:4:"mini";s:7:"options";a:6:{s:6:"offset";i:0;s:14:"items_per_page";i:10;s:11:"total_pages";i:0;s:2:"id";i:0;s:4:"tags";a:2:{s:4:"next";s:6:"››";s:8:"previous";s:6:"‹‹";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:5:"Apply";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:14:"access content";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"empty";a:0:{}s:5:"sorts";a:1:{s:7:"created";a:13:{s:2:"id";s:7:"created";s:5:"table";s:15:"node_field_data";s:5:"field";s:7:"created";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:7:"created";s:9:"plugin_id";s:4:"date";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:7:"created";}s:7:"exposed";b:0;s:11:"granularity";s:6:"second";}}s:9:"arguments";a:1:{s:18:"created_year_month";a:13:{s:2:"id";s:18:"created_year_month";s:5:"table";s:15:"node_field_data";s:5:"field";s:18:"created_year_month";s:11:"entity_type";s:4:"node";s:9:"plugin_id";s:15:"date_year_month";s:14:"default_action";s:7:"summary";s:9:"exception";a:1:{s:12:"title_enable";b:1;}s:12:"title_enable";b:1;s:5:"title";s:34:"{{ arguments.created_year_month }}";s:21:"default_argument_type";s:5:"fixed";s:15:"summary_options";a:2:{s:8:"override";b:1;s:14:"items_per_page";i:30;}s:7:"summary";a:2:{s:10:"sort_order";s:4:"desc";s:6:"format";s:15:"default_summary";}s:18:"specify_validation";b:1;}}s:7:"filters";a:2:{s:6:"status";a:9:{s:2:"id";s:6:"status";s:5:"table";s:15:"node_field_data";s:5:"field";s:6:"status";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:5:"value";s:1:"1";s:5:"group";i:0;s:6:"expose";a:3:{s:8:"operator";s:1:"0";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}}s:8:"langcode";a:16:{s:2:"id";s:8:"langcode";s:5:"table";s:15:"node_field_data";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:8:"langcode";s:9:"plugin_id";s:8:"language";s:8:"operator";s:2:"in";s:5:"value";a:1:{s:31:"***LANGUAGE_language_content***";s:31:"***LANGUAGE_language_content***";}s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:13:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:5:"style";a:2:{s:4:"type";s:7:"default";s:7:"options";a:4:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:11:"uses_fields";b:0;}}s:3:"row";a:2:{s:4:"type";s:11:"entity:node";s:7:"options";a:1:{s:9:"view_mode";s:6:"teaser";}}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:0:{}s:6:"header";a:0:{}s:6:"footer";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:28:"languages:language_interface";i:1;s:3:"url";i:2;s:14:"url.query_args";i:3;s:21:"user.node_grants:view";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:7:"block_1";a:6:{s:2:"id";s:7:"block_1";s:13:"display_title";s:5:"Block";s:14:"display_plugin";s:5:"block";s:8:"position";i:1;s:15:"display_options";a:4:{s:9:"arguments";a:1:{s:18:"created_year_month";a:13:{s:2:"id";s:18:"created_year_month";s:5:"table";s:15:"node_field_data";s:5:"field";s:18:"created_year_month";s:11:"entity_type";s:4:"node";s:9:"plugin_id";s:15:"date_year_month";s:14:"default_action";s:7:"summary";s:9:"exception";a:1:{s:12:"title_enable";b:1;}s:12:"title_enable";b:1;s:5:"title";s:34:"{{ arguments.created_year_month }}";s:21:"default_argument_type";s:5:"fixed";s:15:"summary_options";a:1:{s:14:"items_per_page";i:30;}s:7:"summary";a:1:{s:6:"format";s:15:"default_summary";}s:18:"specify_validation";b:1;}}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:0:{}}s:8:"defaults";a:1:{s:9:"arguments";b:0;}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:28:"languages:language_interface";i:1;s:3:"url";i:2;s:14:"url.query_args";i:3;s:21:"user.node_grants:view";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"page_1";a:6:{s:2:"id";s:6:"page_1";s:13:"display_title";s:4:"Page";s:14:"display_plugin";s:4:"page";s:8:"position";i:2;s:15:"display_options";a:3:{s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:0:{}}s:17:"display_extenders";a:0:{}s:4:"path";s:7:"archive";}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:28:"languages:language_interface";i:1;s:3:"url";i:2;s:14:"url.query_args";i:3;s:21:"user.node_grants:view";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'views.view.block_content',
  'data' => 'a:13:{s:4:"uuid";s:36:"a6ef2058-ad9b-49be-a320-42409905c55e";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:13:"block_content";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"jvd5Pu6jy-lra4oMr-mR7zuY6CVDv9CaNeoj0Y70gV4";}s:2:"id";s:13:"block_content";s:5:"label";s:20:"Custom block library";s:6:"module";s:5:"views";s:11:"description";s:30:"Find and manage custom blocks.";s:3:"tag";s:7:"default";s:10:"base_table";s:24:"block_content_field_data";s:10:"base_field";s:2:"id";s:7:"display";a:2:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:17:{s:5:"title";s:20:"Custom block library";s:6:"fields";a:4:{s:4:"info";a:37:{s:2:"id";s:4:"info";s:5:"table";s:24:"block_content_field_data";s:5:"field";s:4:"info";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";N;s:12:"entity_field";s:4:"info";s:9:"plugin_id";s:5:"field";s:5:"label";s:17:"Block description";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:6:"string";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:4:"type";a:37:{s:2:"id";s:4:"type";s:5:"table";s:24:"block_content_field_data";s:5:"field";s:4:"type";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:13:"block_content";s:12:"entity_field";s:4:"type";s:9:"plugin_id";s:5:"field";s:5:"label";s:10:"Block type";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:9:"target_id";s:4:"type";s:22:"entity_reference_label";s:8:"settings";a:1:{s:4:"link";b:0;}s:12:"group_column";s:9:"target_id";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:7:"changed";a:26:{s:2:"id";s:7:"changed";s:5:"table";s:24:"block_content_field_data";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:13:"block_content";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:5:"field";s:5:"label";s:7:"Updated";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:9:"timestamp";s:8:"settings";a:3:{s:11:"date_format";s:5:"short";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";}}s:10:"operations";a:24:{s:2:"id";s:10:"operations";s:5:"table";s:13:"block_content";s:5:"field";s:10:"operations";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:13:"block_content";s:9:"plugin_id";s:17:"entity_operations";s:5:"label";s:10:"Operations";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:11:"destination";b:1;}}s:5:"pager";a:2:{s:4:"type";s:4:"mini";s:7:"options";a:6:{s:6:"offset";i:0;s:14:"items_per_page";i:50;s:11:"total_pages";N;s:2:"id";i:0;s:4:"tags";a:2:{s:4:"next";s:8:"Next ›";s:8:"previous";s:12:"‹ Previous";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:5:"Apply";s:12:"reset_button";b:1;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:17:"administer blocks";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"empty";a:2:{s:16:"area_text_custom";a:10:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:11:"text_custom";s:5:"empty";b:1;s:7:"content";s:37:"There are no custom blocks available.";s:8:"tokenize";b:0;}s:27:"block_content_listing_empty";a:10:{s:2:"id";s:27:"block_content_listing_empty";s:5:"table";s:13:"block_content";s:5:"field";s:27:"block_content_listing_empty";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:13:"block_content";s:9:"plugin_id";s:27:"block_content_listing_empty";s:5:"label";s:0:"";s:5:"empty";b:1;}}s:5:"sorts";a:0:{}s:9:"arguments";a:0:{}s:7:"filters";a:3:{s:4:"info";a:16:{s:2:"id";s:4:"info";s:5:"table";s:24:"block_content_field_data";s:5:"field";s:4:"info";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:13:"block_content";s:12:"entity_field";s:4:"info";s:9:"plugin_id";s:6:"string";s:8:"operator";s:8:"contains";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:7:"info_op";s:5:"label";s:17:"Block description";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:7:"info_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:4:"info";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:4:"type";a:16:{s:2:"id";s:4:"type";s:5:"table";s:24:"block_content_field_data";s:5:"field";s:4:"type";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:13:"block_content";s:12:"entity_field";s:4:"type";s:9:"plugin_id";s:6:"bundle";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:7:"type_op";s:5:"label";s:10:"Block type";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:7:"type_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:4:"type";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:8:"reusable";a:16:{s:2:"id";s:8:"reusable";s:5:"table";s:24:"block_content_field_data";s:5:"field";s:8:"reusable";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:13:"block_content";s:12:"entity_field";s:8:"reusable";s:9:"plugin_id";s:7:"boolean";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:12:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:7:"columns";a:4:{s:4:"info";s:4:"info";s:4:"type";s:4:"type";s:7:"changed";s:7:"changed";s:10:"operations";s:10:"operations";}s:7:"default";s:7:"changed";s:4:"info";a:4:{s:4:"info";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:4:"type";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:7:"changed";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:10:"operations";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}}s:8:"override";b:1;s:6:"sticky";b:0;s:7:"summary";s:0:"";s:11:"empty_table";b:1;s:7:"caption";s:0:"";s:11:"description";s:0:"";}}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:0:{}s:6:"header";a:0:{}s:6:"footer";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"page_1";a:6:{s:2:"id";s:6:"page_1";s:13:"display_title";s:4:"Page";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:3:{s:17:"display_extenders";a:0:{}s:4:"path";s:35:"admin/structure/block/block-content";s:4:"menu";a:7:{s:4:"type";s:3:"tab";s:5:"title";s:20:"Custom block library";s:11:"description";s:0:"";s:6:"weight";i:0;s:9:"menu_name";s:5:"admin";s:6:"parent";s:19:"block.admin_display";s:7:"context";s:1:"0";}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'views.view.comment',
  'data' => 'a:13:{s:4:"uuid";s:36:"9e2d20b7-d5e7-4d44-9806-4ef509ffdb82";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:7:"comment";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"CgXkKY33fd-yaHz89du2hSw6MJOoIeNUJ-VHE5BiSdQ";}s:2:"id";s:7:"comment";s:5:"label";s:8:"Comments";s:6:"module";s:7:"comment";s:11:"description";s:25:"Find and manage comments.";s:3:"tag";s:7:"default";s:10:"base_table";s:18:"comment_field_data";s:10:"base_field";s:3:"cid";s:7:"display";a:3:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:26:{s:5:"title";s:8:"Comments";s:6:"fields";a:8:{s:17:"comment_bulk_form";a:26:{s:2:"id";s:17:"comment_bulk_form";s:5:"table";s:7:"comment";s:5:"field";s:17:"comment_bulk_form";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:9:"plugin_id";s:17:"comment_bulk_form";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:12:"action_title";s:6:"Action";s:15:"include_exclude";s:7:"include";s:16:"selected_actions";a:2:{i:0;s:21:"comment_delete_action";i:1;s:24:"comment_unpublish_action";}}s:7:"subject";a:37:{s:2:"id";s:7:"subject";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"subject";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"subject";s:9:"plugin_id";s:5:"field";s:5:"label";s:7:"Subject";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:17:"comment_permalink";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:3:"uid";a:37:{s:2:"id";s:3:"uid";s:5:"table";s:18:"comment_field_data";s:5:"field";s:3:"uid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:3:"uid";s:9:"plugin_id";s:5:"field";s:5:"label";s:0:"";s:7:"exclude";b:1;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:9:"target_id";s:4:"type";s:22:"entity_reference_label";s:8:"settings";a:1:{s:4:"link";b:1;}s:12:"group_column";s:9:"target_id";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:4:"name";a:37:{s:2:"id";s:4:"name";s:5:"table";s:18:"comment_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:5:"field";s:5:"label";s:6:"Author";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:9:"{{ uid }}";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:16:"comment_username";s:8:"settings";a:0:{}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:9:"entity_id";a:37:{s:2:"id";s:9:"entity_id";s:5:"table";s:18:"comment_field_data";s:5:"field";s:9:"entity_id";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:9:"entity_id";s:9:"plugin_id";s:16:"commented_entity";s:5:"label";s:9:"Posted in";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:9:"target_id";s:4:"type";s:22:"entity_reference_label";s:8:"settings";a:1:{s:4:"link";b:1;}s:12:"group_column";s:9:"target_id";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:7:"changed";a:37:{s:2:"id";s:7:"changed";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:5:"field";s:5:"label";s:7:"Updated";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:9:"timestamp";s:8:"settings";a:3:{s:11:"date_format";s:5:"short";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:10:"operations";a:24:{s:2:"id";s:10:"operations";s:5:"table";s:7:"comment";s:5:"field";s:10:"operations";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:9:"plugin_id";s:17:"entity_operations";s:5:"label";s:10:"Operations";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:11:"destination";b:1;}s:6:"name_1";a:37:{s:2:"id";s:6:"name_1";s:5:"table";s:16:"users_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:3:"uid";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:5:"field";s:5:"label";s:0:"";s:7:"exclude";b:1;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:9:"user_name";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}}s:5:"pager";a:2:{s:4:"type";s:4:"full";s:7:"options";a:7:{s:6:"offset";i:0;s:14:"items_per_page";i:50;s:11:"total_pages";N;s:2:"id";i:0;s:4:"tags";a:4:{s:4:"next";s:8:"next ›";s:8:"previous";s:12:"‹ previous";s:5:"first";s:8:"« first";s:4:"last";s:7:"last »";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}s:8:"quantity";i:9;}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:6:"Filter";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:19:"administer comments";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"empty";a:1:{s:16:"area_text_custom";a:10:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:11:"text_custom";s:5:"empty";b:1;s:7:"content";s:22:"No comments available.";s:8:"tokenize";b:0;}}s:5:"sorts";a:1:{s:7:"changed";a:13:{s:2:"id";s:7:"changed";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:4:"date";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:7:"changed";}s:7:"exposed";b:0;s:11:"granularity";s:6:"second";}}s:9:"arguments";a:0:{}s:7:"filters";a:4:{s:6:"status";a:16:{s:2:"id";s:6:"status";s:5:"table";s:18:"comment_field_data";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:7:"subject";a:16:{s:2:"id";s:7:"subject";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"subject";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"subject";s:9:"plugin_id";s:6:"string";s:8:"operator";s:8:"contains";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:10:"subject_op";s:5:"label";s:7:"Subject";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:10:"subject_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:7:"subject";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:7:"combine";a:15:{s:2:"id";s:7:"combine";s:5:"table";s:5:"views";s:5:"field";s:7:"combine";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:7:"combine";s:8:"operator";s:8:"contains";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:10:"combine_op";s:5:"label";s:11:"Author name";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:10:"combine_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:11:"author_name";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:6:"fields";a:2:{s:4:"name";s:4:"name";s:6:"name_1";s:6:"name_1";}}s:8:"langcode";a:16:{s:2:"id";s:8:"langcode";s:5:"table";s:18:"comment_field_data";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:8:"langcode";s:9:"plugin_id";s:8:"language";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:11:"langcode_op";s:5:"label";s:8:"Language";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:11:"langcode_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:8:"langcode";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:13:"filter_groups";a:2:{s:8:"operator";s:3:"AND";s:6:"groups";a:1:{i:1;s:3:"AND";}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:12:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:7:"columns";a:6:{s:17:"comment_bulk_form";s:17:"comment_bulk_form";s:7:"subject";s:7:"subject";s:3:"uid";s:3:"uid";s:9:"entity_id";s:9:"entity_id";s:7:"changed";s:7:"changed";s:10:"operations";s:10:"operations";}s:7:"default";s:7:"changed";s:4:"info";a:6:{s:17:"comment_bulk_form";a:4:{s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:7:"subject";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:3:"uid";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:9:"entity_id";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:7:"changed";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:10:"operations";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}}s:8:"override";b:1;s:6:"sticky";b:1;s:7:"summary";s:0:"";s:11:"empty_table";b:1;s:7:"caption";s:0:"";s:11:"description";s:0:"";}}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:1:{s:3:"uid";a:10:{s:2:"id";s:3:"uid";s:5:"table";s:18:"comment_field_data";s:5:"field";s:3:"uid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:6:"author";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:3:"uid";s:9:"plugin_id";s:8:"standard";s:8:"required";b:0;}}s:9:"css_class";s:0:"";s:8:"use_ajax";b:0;s:8:"group_by";b:0;s:16:"show_admin_links";b:1;s:8:"use_more";b:0;s:15:"use_more_always";b:1;s:13:"use_more_text";s:4:"more";s:6:"header";a:0:{}s:6:"footer";a:0:{}s:23:"hide_attachment_summary";b:0;s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:4:{s:7:"max-age";i:0;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}s:9:"cacheable";b:0;}}s:14:"page_published";a:6:{s:2:"id";s:14:"page_published";s:13:"display_title";s:18:"Published comments";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:6:{s:19:"display_description";s:30:"The approved comments listing.";s:15:"display_comment";s:0:"";s:13:"exposed_block";b:0;s:17:"display_extenders";a:0:{}s:4:"path";s:21:"admin/content/comment";s:4:"menu";a:7:{s:4:"type";s:3:"tab";s:5:"title";s:8:"Comments";s:11:"description";s:18:"Comments published";s:6:"weight";i:0;s:9:"menu_name";s:5:"admin";s:6:"parent";s:0:"";s:7:"context";s:1:"0";}}s:14:"cache_metadata";a:4:{s:7:"max-age";i:0;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}s:9:"cacheable";b:0;}}s:15:"page_unapproved";a:6:{s:2:"id";s:15:"page_unapproved";s:13:"display_title";s:19:"Unapproved comments";s:14:"display_plugin";s:4:"page";s:8:"position";i:2;s:15:"display_options";a:8:{s:6:"fields";a:8:{s:17:"comment_bulk_form";a:26:{s:2:"id";s:17:"comment_bulk_form";s:5:"table";s:7:"comment";s:5:"field";s:17:"comment_bulk_form";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:9:"plugin_id";s:17:"comment_bulk_form";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:12:"action_title";s:6:"Action";s:15:"include_exclude";s:7:"include";s:16:"selected_actions";a:2:{i:0;s:21:"comment_delete_action";i:1;s:22:"comment_publish_action";}}s:7:"subject";a:37:{s:2:"id";s:7:"subject";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"subject";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"subject";s:9:"plugin_id";s:5:"field";s:5:"label";s:7:"Subject";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:17:"comment_permalink";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:3:"uid";a:37:{s:2:"id";s:3:"uid";s:5:"table";s:18:"comment_field_data";s:5:"field";s:3:"uid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:3:"uid";s:9:"plugin_id";s:5:"field";s:5:"label";s:0:"";s:7:"exclude";b:1;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:9:"target_id";s:4:"type";s:22:"entity_reference_label";s:8:"settings";a:1:{s:4:"link";b:1;}s:12:"group_column";s:9:"target_id";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:4:"name";a:37:{s:2:"id";s:4:"name";s:5:"table";s:18:"comment_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:5:"field";s:5:"label";s:6:"Author";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:9:"{{ uid }}";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:16:"comment_username";s:8:"settings";a:0:{}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:9:"entity_id";a:37:{s:2:"id";s:9:"entity_id";s:5:"table";s:18:"comment_field_data";s:5:"field";s:9:"entity_id";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:9:"entity_id";s:9:"plugin_id";s:16:"commented_entity";s:5:"label";s:9:"Posted in";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:9:"target_id";s:4:"type";s:22:"entity_reference_label";s:8:"settings";a:1:{s:4:"link";b:1;}s:12:"group_column";s:9:"target_id";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:7:"changed";a:37:{s:2:"id";s:7:"changed";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:5:"field";s:5:"label";s:7:"Updated";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:9:"timestamp";s:8:"settings";a:3:{s:11:"date_format";s:5:"short";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:10:"operations";a:24:{s:2:"id";s:10:"operations";s:5:"table";s:7:"comment";s:5:"field";s:10:"operations";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:9:"plugin_id";s:17:"entity_operations";s:5:"label";s:10:"Operations";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:11:"destination";b:1;}s:6:"name_1";a:37:{s:2:"id";s:6:"name_1";s:5:"table";s:16:"users_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:3:"uid";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:5:"field";s:5:"label";s:0:"";s:7:"exclude";b:1;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:9:"user_name";s:8:"settings";a:1:{s:14:"link_to_entity";b:0;}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}}s:7:"filters";a:4:{s:6:"status";a:16:{s:2:"id";s:6:"status";s:5:"table";s:18:"comment_field_data";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:8:"operator";s:1:"=";s:5:"value";s:1:"0";s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:7:"subject";a:16:{s:2:"id";s:7:"subject";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"subject";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"subject";s:9:"plugin_id";s:6:"string";s:8:"operator";s:8:"contains";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:10:"subject_op";s:5:"label";s:7:"Subject";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:10:"subject_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:7:"subject";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:7:"combine";a:15:{s:2:"id";s:7:"combine";s:5:"table";s:5:"views";s:5:"field";s:7:"combine";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:7:"combine";s:8:"operator";s:8:"contains";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:10:"combine_op";s:5:"label";s:11:"Author Name";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:10:"combine_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:11:"author_name";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:6:"fields";a:2:{s:4:"name";s:4:"name";s:6:"name_1";s:6:"name_1";}}s:8:"langcode";a:16:{s:2:"id";s:8:"langcode";s:5:"table";s:18:"comment_field_data";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:8:"langcode";s:9:"plugin_id";s:8:"language";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:11:"langcode_op";s:5:"label";s:8:"Language";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:11:"langcode_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:8:"langcode";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:13:"filter_groups";a:2:{s:8:"operator";s:3:"AND";s:6:"groups";a:1:{i:1;s:3:"AND";}}s:8:"defaults";a:3:{s:6:"fields";b:0;s:7:"filters";b:0;s:13:"filter_groups";b:0;}s:19:"display_description";s:32:"The unapproved comments listing.";s:17:"display_extenders";a:0:{}s:4:"path";s:30:"admin/content/comment/approval";s:4:"menu";a:7:{s:4:"type";s:3:"tab";s:5:"title";s:19:"Unapproved comments";s:11:"description";s:19:"Comments unapproved";s:6:"weight";i:1;s:9:"menu_name";s:5:"admin";s:6:"parent";s:0:"";s:7:"context";s:1:"0";}}s:14:"cache_metadata";a:4:{s:7:"max-age";i:0;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}s:9:"cacheable";b:0;}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'views.view.comments_recent',
  'data' => 'a:13:{s:4:"uuid";s:36:"fde5a3d5-3205-4baf-a22b-38b8b2d1ff07";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:3:{i:0;s:7:"comment";i:1;s:4:"node";i:2;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"S_NN2ubd_NovTfgzbHVlZMmIJJQS-3h9h3inzbaFUMY";}s:2:"id";s:15:"comments_recent";s:5:"label";s:15:"Recent comments";s:6:"module";s:5:"views";s:11:"description";s:16:"Recent comments.";s:3:"tag";s:7:"default";s:10:"base_table";s:18:"comment_field_data";s:10:"base_field";s:3:"cid";s:7:"display";a:2:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:14:{s:5:"title";s:15:"Recent comments";s:6:"fields";a:2:{s:7:"subject";a:26:{s:2:"id";s:7:"subject";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"subject";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"subject";s:9:"plugin_id";s:5:"field";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:0;s:8:"ellipsis";b:0;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:6:"string";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}}s:7:"changed";a:26:{s:2:"id";s:7:"changed";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:5:"field";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:13:"timestamp_ago";s:8:"settings";a:3:{s:13:"future_format";s:15:"@interval hence";s:11:"past_format";s:13:"@interval ago";s:11:"granularity";i:2;}}}s:5:"pager";a:2:{s:4:"type";s:4:"some";s:7:"options";a:2:{s:6:"offset";i:0;s:14:"items_per_page";i:10;}}s:12:"exposed_form";a:1:{s:4:"type";s:5:"basic";}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:15:"access comments";}}s:5:"cache";a:1:{s:4:"type";s:3:"tag";}s:5:"empty";a:1:{s:16:"area_text_custom";a:11:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:11:"text_custom";s:5:"label";s:0:"";s:5:"empty";b:1;s:7:"content";s:22:"No comments available.";s:8:"tokenize";b:0;}}s:5:"sorts";a:2:{s:7:"created";a:12:{s:2:"id";s:7:"created";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"created";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"created";s:9:"plugin_id";s:4:"date";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:7:"created";}s:7:"exposed";b:0;}s:3:"cid";a:12:{s:2:"id";s:3:"cid";s:5:"table";s:18:"comment_field_data";s:5:"field";s:3:"cid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:3:"cid";s:9:"plugin_id";s:5:"field";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:3:"cid";}s:7:"exposed";b:0;}}s:7:"filters";a:2:{s:6:"status";a:9:{s:2:"id";s:6:"status";s:5:"table";s:18:"comment_field_data";s:5:"field";s:6:"status";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:5:"value";s:1:"1";s:5:"group";i:1;s:6:"expose";a:3:{s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}}s:11:"status_node";a:10:{s:2:"id";s:11:"status_node";s:5:"table";s:15:"node_field_data";s:5:"field";s:6:"status";s:12:"relationship";s:4:"node";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:5:"value";s:1:"1";s:5:"group";i:1;s:6:"expose";a:3:{s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}}}s:5:"style";a:2:{s:4:"type";s:9:"html_list";s:7:"options";a:6:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:4:"type";s:2:"ul";s:13:"wrapper_class";s:9:"item-list";s:5:"class";s:0:"";}}s:3:"row";a:2:{s:4:"type";s:6:"fields";s:7:"options";a:2:{s:22:"default_field_elements";b:1;s:10:"hide_empty";b:0;}}s:5:"query";a:1:{s:4:"type";s:11:"views_query";}s:13:"relationships";a:1:{s:4:"node";a:5:{s:2:"id";s:4:"node";s:5:"table";s:18:"comment_field_data";s:5:"field";s:4:"node";s:9:"plugin_id";s:8:"standard";s:8:"required";b:1;}}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:3:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:7:"block_1";a:6:{s:2:"id";s:7:"block_1";s:13:"display_title";s:5:"Block";s:14:"display_plugin";s:5:"block";s:8:"position";i:1;s:15:"display_options";a:4:{s:17:"display_extenders";a:0:{}s:17:"block_description";s:15:"Recent comments";s:14:"block_category";s:13:"Lists (Views)";s:5:"allow";a:1:{s:14:"items_per_page";b:1;}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:3:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'views.view.content',
  'data' => 'a:13:{s:4:"uuid";s:36:"854b9cc0-5812-4641-9264-2a5477b753e0";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:4:"node";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"vBKWYGGDoAX-tFd1JErB8tZLSxx3lJ0foouVsgpcbB4";}s:2:"id";s:7:"content";s:5:"label";s:7:"Content";s:6:"module";s:4:"node";s:11:"description";s:24:"Find and manage content.";s:3:"tag";s:7:"default";s:10:"base_table";s:15:"node_field_data";s:10:"base_field";s:3:"nid";s:7:"display";a:2:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:17:{s:5:"title";s:7:"Content";s:6:"fields";a:7:{s:14:"node_bulk_form";a:14:{s:2:"id";s:14:"node_bulk_form";s:5:"table";s:4:"node";s:5:"field";s:14:"node_bulk_form";s:11:"entity_type";s:4:"node";s:9:"plugin_id";s:14:"node_bulk_form";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:1:{s:10:"alter_text";b:0;}s:13:"element_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;}s:5:"title";a:17:{s:2:"id";s:5:"title";s:5:"table";s:15:"node_field_data";s:5:"field";s:5:"title";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:5:"title";s:9:"plugin_id";s:5:"field";s:5:"label";s:5:"Title";s:7:"exclude";b:0;s:5:"alter";a:1:{s:10:"alter_text";b:0;}s:13:"element_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:6:"string";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}}s:4:"type";a:37:{s:2:"id";s:4:"type";s:5:"table";s:15:"node_field_data";s:5:"field";s:4:"type";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:4:"type";s:9:"plugin_id";s:5:"field";s:5:"label";s:12:"Content type";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:9:"target_id";s:4:"type";s:22:"entity_reference_label";s:8:"settings";a:1:{s:4:"link";b:0;}s:12:"group_column";s:9:"target_id";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:4:"name";a:17:{s:2:"id";s:4:"name";s:5:"table";s:16:"users_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:3:"uid";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:5:"field";s:5:"label";s:6:"Author";s:7:"exclude";b:0;s:5:"alter";a:1:{s:10:"alter_text";b:0;}s:13:"element_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:9:"user_name";}s:6:"status";a:17:{s:2:"id";s:6:"status";s:5:"table";s:15:"node_field_data";s:5:"field";s:6:"status";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:5:"field";s:5:"label";s:6:"Status";s:7:"exclude";b:0;s:5:"alter";a:1:{s:10:"alter_text";b:0;}s:13:"element_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:7:"boolean";s:8:"settings";a:3:{s:6:"format";s:6:"custom";s:19:"format_custom_false";s:11:"Unpublished";s:18:"format_custom_true";s:9:"Published";}}s:7:"changed";a:17:{s:2:"id";s:7:"changed";s:5:"table";s:15:"node_field_data";s:5:"field";s:7:"changed";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:5:"field";s:5:"label";s:7:"Updated";s:7:"exclude";b:0;s:5:"alter";a:1:{s:10:"alter_text";b:0;}s:13:"element_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:9:"timestamp";s:8:"settings";a:3:{s:11:"date_format";s:5:"short";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";}}s:10:"operations";a:23:{s:2:"id";s:10:"operations";s:5:"table";s:4:"node";s:5:"field";s:10:"operations";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:17:"entity_operations";s:5:"label";s:10:"Operations";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:11:"destination";b:1;}}s:5:"pager";a:2:{s:4:"type";s:4:"full";s:7:"options";a:2:{s:14:"items_per_page";i:50;s:4:"tags";a:4:{s:4:"next";s:8:"Next ›";s:8:"previous";s:12:"‹ Previous";s:5:"first";s:8:"« First";s:4:"last";s:7:"Last »";}}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:6:"Filter";s:12:"reset_button";b:1;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:23:"access content overview";}}s:5:"cache";a:1:{s:4:"type";s:3:"tag";}s:5:"empty";a:1:{s:16:"area_text_custom";a:6:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:9:"plugin_id";s:11:"text_custom";s:5:"empty";b:1;s:7:"content";s:21:"No content available.";}}s:5:"sorts";a:0:{}s:9:"arguments";a:0:{}s:7:"filters";a:5:{s:5:"title";a:16:{s:2:"id";s:5:"title";s:5:"table";s:15:"node_field_data";s:5:"field";s:5:"title";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:5:"title";s:9:"plugin_id";s:6:"string";s:8:"operator";s:8:"contains";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:8:"title_op";s:5:"label";s:5:"Title";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:8:"title_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:5:"title";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:4:"type";a:16:{s:2:"id";s:4:"type";s:5:"table";s:15:"node_field_data";s:5:"field";s:4:"type";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:4:"type";s:9:"plugin_id";s:6:"bundle";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:7:"type_op";s:5:"label";s:12:"Content type";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:7:"type_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:4:"type";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:6:"status";a:16:{s:2:"id";s:6:"status";s:5:"table";s:15:"node_field_data";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:6:"Status";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:9:"status_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:6:"status";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:1;s:10:"group_info";a:10:{s:5:"label";s:16:"Published status";s:11:"description";s:0:"";s:10:"identifier";s:6:"status";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:2:{i:1;a:3:{s:5:"title";s:9:"Published";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";}i:2;a:3:{s:5:"title";s:11:"Unpublished";s:8:"operator";s:1:"=";s:5:"value";s:1:"0";}}}}s:8:"langcode";a:16:{s:2:"id";s:8:"langcode";s:5:"table";s:15:"node_field_data";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:8:"langcode";s:9:"plugin_id";s:8:"language";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:11:"langcode_op";s:5:"label";s:8:"Language";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:11:"langcode_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:8:"langcode";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:12:"status_extra";a:9:{s:2:"id";s:12:"status_extra";s:5:"table";s:15:"node_field_data";s:5:"field";s:12:"status_extra";s:11:"entity_type";s:4:"node";s:9:"plugin_id";s:11:"node_status";s:8:"operator";s:1:"=";s:5:"value";b:0;s:5:"group";i:1;s:6:"expose";a:2:{s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}}}s:13:"filter_groups";a:2:{s:8:"operator";s:3:"AND";s:6:"groups";a:1:{i:1;s:3:"AND";}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:12:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:7:"columns";a:10:{s:14:"node_bulk_form";s:14:"node_bulk_form";s:5:"title";s:5:"title";s:4:"type";s:4:"type";s:4:"name";s:4:"name";s:6:"status";s:6:"status";s:7:"changed";s:7:"changed";s:9:"edit_node";s:9:"edit_node";s:11:"delete_node";s:11:"delete_node";s:10:"dropbutton";s:10:"dropbutton";s:9:"timestamp";s:5:"title";}s:7:"default";s:7:"changed";s:4:"info";a:10:{s:14:"node_bulk_form";a:4:{s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:5:"title";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:4:"type";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:4:"name";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:6:"status";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:7:"changed";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:9:"edit_node";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:11:"delete_node";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:10:"dropbutton";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:9:"timestamp";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}}s:8:"override";b:1;s:6:"sticky";b:1;s:7:"summary";s:0:"";s:11:"empty_table";b:1;s:7:"caption";s:0:"";s:11:"description";s:0:"";}}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:5:"query";a:1:{s:4:"type";s:11:"views_query";}s:13:"relationships";a:1:{s:3:"uid";a:6:{s:2:"id";s:3:"uid";s:5:"table";s:15:"node_field_data";s:5:"field";s:3:"uid";s:11:"admin_label";s:6:"author";s:9:"plugin_id";s:8:"standard";s:8:"required";b:1;}}s:16:"show_admin_links";b:0;s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:0;s:8:"contexts";a:7:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:4:"user";i:5;s:21:"user.node_grants:view";i:6;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"page_1";a:6:{s:2:"id";s:6:"page_1";s:13:"display_title";s:4:"Page";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:4:{s:17:"display_extenders";a:0:{}s:4:"path";s:18:"admin/content/node";s:4:"menu";a:6:{s:4:"type";s:11:"default tab";s:5:"title";s:7:"Content";s:11:"description";s:0:"";s:6:"weight";i:-10;s:9:"menu_name";s:5:"admin";s:7:"context";s:0:"";}s:11:"tab_options";a:5:{s:4:"type";s:6:"normal";s:5:"title";s:7:"Content";s:11:"description";s:23:"Find and manage content";s:6:"weight";i:-10;s:9:"menu_name";s:5:"admin";}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:0;s:8:"contexts";a:7:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:4:"user";i:5;s:21:"user.node_grants:view";i:6;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'views.view.content_recent',
  'data' => 'a:13:{s:4:"uuid";s:36:"967b6c2c-aaab-4f4e-ae95-7888fcf58266";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:4:"node";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"YqZN5rc7XDQcFcInc8wkzuaHJmC5YvirhTmDcrarT6M";}s:2:"id";s:14:"content_recent";s:5:"label";s:14:"Recent content";s:6:"module";s:4:"node";s:11:"description";s:15:"Recent content.";s:3:"tag";s:7:"default";s:10:"base_table";s:15:"node_field_data";s:10:"base_field";s:3:"nid";s:7:"display";a:2:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:22:{s:5:"title";s:14:"Recent content";s:6:"fields";a:2:{s:5:"title";a:26:{s:2:"id";s:5:"title";s:5:"table";s:15:"node_field_data";s:5:"field";s:5:"title";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:5:"title";s:9:"plugin_id";s:5:"field";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:8:{s:10:"alter_text";b:0;s:9:"make_link";b:0;s:8:"absolute";b:0;s:13:"word_boundary";b:0;s:8:"ellipsis";b:0;s:10:"strip_tags";b:0;s:4:"trim";b:0;s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:6:"string";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}}s:7:"changed";a:37:{s:2:"id";s:7:"changed";s:5:"table";s:15:"node_field_data";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:5:"field";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:13:"timestamp_ago";s:8:"settings";a:0:{}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}}s:5:"pager";a:2:{s:4:"type";s:4:"some";s:7:"options";a:2:{s:6:"offset";i:0;s:14:"items_per_page";i:10;}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:5:"Apply";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:14:"access content";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"empty";a:1:{s:16:"area_text_custom";a:10:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:11:"text_custom";s:5:"empty";b:1;s:7:"content";s:21:"No content available.";s:8:"tokenize";b:0;}}s:5:"sorts";a:1:{s:7:"changed";a:13:{s:2:"id";s:7:"changed";s:5:"table";s:15:"node_field_data";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:4:"date";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:7:"changed";}s:7:"exposed";b:0;s:11:"granularity";s:6:"second";}}s:9:"arguments";a:0:{}s:7:"filters";a:2:{s:12:"status_extra";a:15:{s:2:"id";s:12:"status_extra";s:5:"table";s:15:"node_field_data";s:5:"field";s:12:"status_extra";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:9:"plugin_id";s:11:"node_status";s:8:"operator";s:1:"=";s:5:"value";b:0;s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:8:"langcode";a:16:{s:2:"id";s:8:"langcode";s:5:"table";s:15:"node_field_data";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:8:"langcode";s:9:"plugin_id";s:8:"language";s:8:"operator";s:2:"in";s:5:"value";a:1:{s:31:"***LANGUAGE_language_content***";s:31:"***LANGUAGE_language_content***";}s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:13:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:5:"style";a:2:{s:4:"type";s:9:"html_list";s:7:"options";a:6:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:4:"type";s:2:"ul";s:13:"wrapper_class";s:9:"item-list";s:5:"class";s:0:"";}}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:1:{s:3:"uid";a:10:{s:2:"id";s:3:"uid";s:5:"table";s:15:"node_field_data";s:5:"field";s:3:"uid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:6:"author";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:3:"uid";s:9:"plugin_id";s:8:"standard";s:8:"required";b:1;}}s:8:"use_more";b:0;s:15:"use_more_always";b:0;s:13:"use_more_text";s:4:"More";s:12:"link_display";s:1:"0";s:8:"link_url";s:0:"";s:6:"header";a:0:{}s:6:"footer";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:4:"user";i:3;s:21:"user.node_grants:view";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:7:"block_1";a:6:{s:2:"id";s:7:"block_1";s:13:"display_title";s:5:"Block";s:14:"display_plugin";s:5:"block";s:8:"position";i:1;s:15:"display_options";a:1:{s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:4:"user";i:3;s:21:"user.node_grants:view";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'views.view.files',
  'data' => 'a:13:{s:4:"uuid";s:36:"4f8d7912-8acb-4ef7-9c76-ff228942601e";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:4:"file";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"DaGeEDJMcbbQtgV96AuPeZ-0irMc_Oa6Zzh2U3Kmul8";}s:2:"id";s:5:"files";s:5:"label";s:5:"Files";s:6:"module";s:4:"file";s:11:"description";s:22:"Find and manage files.";s:3:"tag";s:7:"default";s:10:"base_table";s:12:"file_managed";s:10:"base_field";s:3:"fid";s:7:"display";a:3:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:19:{s:5:"title";s:5:"Files";s:6:"fields";a:8:{s:3:"fid";a:24:{s:2:"id";s:3:"fid";s:5:"table";s:12:"file_managed";s:5:"field";s:3:"fid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:3:"fid";s:9:"plugin_id";s:5:"field";s:5:"label";s:3:"Fid";s:7:"exclude";b:1;s:5:"alter";a:8:{s:10:"alter_text";b:0;s:9:"make_link";b:0;s:8:"absolute";b:0;s:13:"word_boundary";b:0;s:8:"ellipsis";b:0;s:10:"strip_tags";b:0;s:4:"trim";b:0;s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;}s:8:"filename";a:36:{s:2:"id";s:8:"filename";s:5:"table";s:12:"file_managed";s:5:"field";s:8:"filename";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:8:"filename";s:9:"plugin_id";s:5:"field";s:5:"label";s:4:"Name";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:0;s:8:"ellipsis";b:0;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:9:"file_link";s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:8:"filemime";a:25:{s:2:"id";s:8:"filemime";s:5:"table";s:12:"file_managed";s:5:"field";s:8:"filemime";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:8:"filemime";s:9:"plugin_id";s:5:"field";s:5:"label";s:9:"MIME type";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:13:"file_filemime";}s:8:"filesize";a:25:{s:2:"id";s:8:"filesize";s:5:"table";s:12:"file_managed";s:5:"field";s:8:"filesize";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:8:"filesize";s:9:"plugin_id";s:5:"field";s:5:"label";s:4:"Size";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:9:"file_size";}s:6:"status";a:26:{s:2:"id";s:6:"status";s:5:"table";s:12:"file_managed";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:5:"field";s:5:"label";s:6:"Status";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:7:"boolean";s:8:"settings";a:3:{s:6:"format";s:6:"custom";s:19:"format_custom_false";s:9:"Temporary";s:18:"format_custom_true";s:9:"Permanent";}}s:7:"created";a:26:{s:2:"id";s:7:"created";s:5:"table";s:12:"file_managed";s:5:"field";s:7:"created";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:7:"created";s:9:"plugin_id";s:5:"field";s:5:"label";s:11:"Upload date";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:9:"timestamp";s:8:"settings";a:3:{s:11:"date_format";s:6:"medium";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";}}s:7:"changed";a:26:{s:2:"id";s:7:"changed";s:5:"table";s:12:"file_managed";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:5:"field";s:5:"label";s:12:"Changed date";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:9:"timestamp";s:8:"settings";a:3:{s:11:"date_format";s:6:"medium";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";}}s:5:"count";a:30:{s:2:"id";s:5:"count";s:5:"table";s:10:"file_usage";s:5:"field";s:5:"count";s:12:"relationship";s:3:"fid";s:10:"group_type";s:3:"sum";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:7:"numeric";s:5:"label";s:7:"Used in";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:1;s:4:"path";s:35:"admin/content/files/usage/{{ fid }}";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:13:"set_precision";b:0;s:9:"precision";i:0;s:7:"decimal";s:1:".";s:9:"separator";s:1:",";s:13:"format_plural";b:1;s:20:"format_plural_string";s:21:"1 place@count places";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:5:"pager";a:2:{s:4:"type";s:4:"mini";s:7:"options";a:6:{s:6:"offset";i:0;s:14:"items_per_page";i:50;s:11:"total_pages";i:0;s:2:"id";i:0;s:4:"tags";a:2:{s:4:"next";s:8:"Next ›";s:8:"previous";s:12:"‹ Previous";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:6:"Filter";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:21:"access files overview";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"empty";a:1:{s:16:"area_text_custom";a:6:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:9:"plugin_id";s:11:"text_custom";s:5:"empty";b:1;s:7:"content";s:19:"No files available.";}}s:5:"sorts";a:0:{}s:9:"arguments";a:0:{}s:7:"filters";a:3:{s:8:"filename";a:16:{s:2:"id";s:8:"filename";s:5:"table";s:12:"file_managed";s:5:"field";s:8:"filename";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:8:"filename";s:9:"plugin_id";s:6:"string";s:8:"operator";s:4:"word";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:11:"filemime_op";s:5:"label";s:8:"Filename";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:11:"filename_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:8:"filename";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:8:"filemime";a:16:{s:2:"id";s:8:"filemime";s:5:"table";s:12:"file_managed";s:5:"field";s:8:"filemime";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:8:"filemime";s:9:"plugin_id";s:6:"string";s:8:"operator";s:4:"word";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:11:"filemime_op";s:5:"label";s:9:"MIME type";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:11:"filemime_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:8:"filemime";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:6:"status";a:16:{s:2:"id";s:6:"status";s:5:"table";s:12:"file_managed";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:11:"file_status";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:9:"status_op";s:5:"label";s:6:"Status";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:9:"status_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:6:"status";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:12:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:7:"columns";a:8:{s:3:"fid";s:3:"fid";s:8:"filename";s:8:"filename";s:8:"filemime";s:8:"filemime";s:8:"filesize";s:8:"filesize";s:6:"status";s:6:"status";s:7:"created";s:7:"created";s:7:"changed";s:7:"changed";s:5:"count";s:5:"count";}s:7:"default";s:7:"changed";s:4:"info";a:8:{s:3:"fid";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:8:"filename";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:8:"filemime";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:15:"priority-medium";}s:8:"filesize";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:6:"status";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:7:"created";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:7:"changed";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:5:"count";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:15:"priority-medium";}}s:8:"override";b:1;s:6:"sticky";b:0;s:7:"summary";s:0:"";s:11:"empty_table";b:1;s:7:"caption";s:0:"";s:11:"description";s:0:"";}}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:1:{s:3:"fid";a:7:{s:2:"id";s:3:"fid";s:5:"table";s:12:"file_managed";s:5:"field";s:3:"fid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:10:"File usage";s:8:"required";b:1;}}s:8:"group_by";b:1;s:16:"show_admin_links";b:1;s:6:"header";a:0:{}s:6:"footer";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"page_1";a:6:{s:2:"id";s:6:"page_1";s:13:"display_title";s:14:"Files overview";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:6:{s:8:"defaults";a:2:{s:5:"pager";b:1;s:13:"relationships";b:0;}s:13:"relationships";a:1:{s:3:"fid";a:7:{s:2:"id";s:3:"fid";s:5:"table";s:12:"file_managed";s:5:"field";s:3:"fid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:10:"File usage";s:8:"required";b:0;}}s:19:"display_description";s:0:"";s:17:"display_extenders";a:0:{}s:4:"path";s:19:"admin/content/files";s:4:"menu";a:6:{s:4:"type";s:3:"tab";s:5:"title";s:5:"Files";s:11:"description";s:0:"";s:6:"weight";i:0;s:9:"menu_name";s:5:"admin";s:7:"context";s:0:"";}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"page_2";a:6:{s:2:"id";s:6:"page_2";s:13:"display_title";s:10:"File usage";s:14:"display_plugin";s:4:"page";s:8:"position";i:2;s:15:"display_options";a:15:{s:5:"title";s:10:"File usage";s:6:"fields";a:4:{s:12:"entity_label";a:23:{s:2:"id";s:12:"entity_label";s:5:"table";s:10:"file_usage";s:5:"field";s:12:"entity_label";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:12:"entity_label";s:5:"label";s:6:"Entity";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:14:"link_to_entity";b:1;}s:4:"type";a:22:{s:2:"id";s:4:"type";s:5:"table";s:10:"file_usage";s:5:"field";s:4:"type";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:8:"standard";s:5:"label";s:11:"Entity type";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;}s:6:"module";a:22:{s:2:"id";s:6:"module";s:5:"table";s:10:"file_usage";s:5:"field";s:6:"module";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:8:"standard";s:5:"label";s:18:"Registering module";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;}s:5:"count";a:30:{s:2:"id";s:5:"count";s:5:"table";s:10:"file_usage";s:5:"field";s:5:"count";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:7:"numeric";s:5:"label";s:9:"Use count";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:13:"set_precision";b:0;s:9:"precision";i:0;s:7:"decimal";s:1:".";s:9:"separator";s:1:",";s:13:"format_plural";b:0;s:20:"format_plural_string";s:8:"1@count";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:5:"pager";a:2:{s:4:"type";s:4:"mini";s:7:"options";a:6:{s:6:"offset";i:0;s:14:"items_per_page";i:10;s:11:"total_pages";i:0;s:2:"id";i:0;s:4:"tags";a:2:{s:4:"next";s:8:"Next ›";s:8:"previous";s:12:"‹ Previous";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}}}s:5:"empty";a:0:{}s:9:"arguments";a:1:{s:3:"fid";a:23:{s:2:"id";s:3:"fid";s:5:"table";s:12:"file_managed";s:5:"field";s:3:"fid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:3:"fid";s:9:"plugin_id";s:8:"file_fid";s:14:"default_action";s:9:"not found";s:9:"exception";a:3:{s:5:"value";s:3:"all";s:12:"title_enable";b:0;s:5:"title";s:3:"All";}s:12:"title_enable";b:1;s:5:"title";s:46:"File usage information for {{ arguments.fid }}";s:21:"default_argument_type";s:5:"fixed";s:24:"default_argument_options";a:1:{s:8:"argument";s:0:"";}s:25:"default_argument_skip_url";b:0;s:15:"summary_options";a:4:{s:9:"base_path";s:0:"";s:5:"count";b:1;s:8:"override";b:0;s:14:"items_per_page";i:25;}s:7:"summary";a:3:{s:10:"sort_order";s:3:"asc";s:17:"number_of_records";i:0;s:6:"format";s:15:"default_summary";}s:18:"specify_validation";b:0;s:8:"validate";a:2:{s:4:"type";s:4:"none";s:4:"fail";s:9:"not found";}s:16:"validate_options";a:0:{}s:12:"break_phrase";b:0;s:3:"not";b:0;}}s:7:"filters";a:0:{}s:13:"filter_groups";a:2:{s:8:"operator";s:3:"AND";s:6:"groups";a:0:{}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:12:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:7:"columns";a:4:{s:12:"entity_label";s:12:"entity_label";s:4:"type";s:4:"type";s:6:"module";s:6:"module";s:5:"count";s:5:"count";}s:7:"default";s:12:"entity_label";s:4:"info";a:4:{s:12:"entity_label";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:4:"type";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:15:"priority-medium";}s:6:"module";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:5:"count";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}}s:8:"override";b:1;s:6:"sticky";b:0;s:7:"summary";s:0:"";s:11:"empty_table";b:1;s:7:"caption";s:0:"";s:11:"description";s:0:"";}}s:3:"row";a:2:{s:4:"type";s:6:"fields";s:7:"options";a:0:{}}s:8:"defaults";a:11:{s:5:"empty";b:0;s:5:"title";b:0;s:5:"pager";b:0;s:8:"group_by";b:0;s:5:"style";b:0;s:3:"row";b:0;s:13:"relationships";b:0;s:6:"fields";b:0;s:9:"arguments";b:0;s:7:"filters";b:0;s:13:"filter_groups";b:0;}s:13:"relationships";a:1:{s:3:"fid";a:7:{s:2:"id";s:3:"fid";s:5:"table";s:12:"file_managed";s:5:"field";s:3:"fid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:10:"File usage";s:8:"required";b:1;}}s:8:"group_by";b:0;s:19:"display_description";s:0:"";s:17:"display_extenders";a:0:{}s:4:"path";s:27:"admin/content/files/usage/%";}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:4:{i:0;s:28:"languages:language_interface";i:1;s:3:"url";i:2;s:14:"url.query_args";i:3;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'views.view.frontpage',
  'data' => 'a:13:{s:4:"uuid";s:36:"639eb23e-4b75-4bec-9e05-aef9eb033c81";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:30:"core.entity_view_mode.node.rss";i:1;s:33:"core.entity_view_mode.node.teaser";}s:6:"module";a:2:{i:0;s:4:"node";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"6eeliKIydPjqyv5V__QqTfahvJMWkHjOVUUuUIdB1ik";}s:2:"id";s:9:"frontpage";s:5:"label";s:9:"Frontpage";s:6:"module";s:4:"node";s:11:"description";s:39:"All content promoted to the front page.";s:3:"tag";s:7:"default";s:10:"base_table";s:15:"node_field_data";s:10:"base_field";s:3:"nid";s:7:"display";a:3:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:17:{s:5:"title";s:0:"";s:6:"fields";a:0:{}s:5:"pager";a:2:{s:4:"type";s:4:"full";s:7:"options";a:7:{s:6:"offset";i:0;s:14:"items_per_page";i:10;s:11:"total_pages";i:0;s:2:"id";i:0;s:4:"tags";a:4:{s:4:"next";s:8:"Next ›";s:8:"previous";s:12:"‹ Previous";s:5:"first";s:8:"« First";s:4:"last";s:7:"Last »";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}s:8:"quantity";i:9;}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:5:"Apply";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:14:"access content";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"empty";a:3:{s:16:"area_text_custom";a:11:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:11:"text_custom";s:5:"label";s:0:"";s:5:"empty";b:1;s:7:"content";s:181:"No front page content has been created yet.<br/>Follow the <a target="_blank" href="https://www.drupal.org/docs/user_guide/en/index.html">User Guide</a> to start building your site.";s:8:"tokenize";b:0;}s:18:"node_listing_empty";a:10:{s:2:"id";s:18:"node_listing_empty";s:5:"table";s:4:"node";s:5:"field";s:18:"node_listing_empty";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:9:"plugin_id";s:18:"node_listing_empty";s:5:"label";s:0:"";s:5:"empty";b:1;}s:5:"title";a:10:{s:2:"id";s:5:"title";s:5:"table";s:5:"views";s:5:"field";s:5:"title";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:5:"title";s:5:"label";s:0:"";s:5:"empty";b:1;s:5:"title";s:8:"Welcome!";}}s:5:"sorts";a:2:{s:6:"sticky";a:12:{s:2:"id";s:6:"sticky";s:5:"table";s:15:"node_field_data";s:5:"field";s:6:"sticky";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:6:"sticky";s:9:"plugin_id";s:7:"boolean";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:6:"sticky";}s:7:"exposed";b:0;}s:7:"created";a:13:{s:2:"id";s:7:"created";s:5:"table";s:15:"node_field_data";s:5:"field";s:7:"created";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:7:"created";s:9:"plugin_id";s:4:"date";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:7:"created";}s:7:"exposed";b:0;s:11:"granularity";s:6:"second";}}s:9:"arguments";a:0:{}s:7:"filters";a:3:{s:7:"promote";a:16:{s:2:"id";s:7:"promote";s:5:"table";s:15:"node_field_data";s:5:"field";s:7:"promote";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:7:"promote";s:9:"plugin_id";s:7:"boolean";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:6:"status";a:9:{s:2:"id";s:6:"status";s:5:"table";s:15:"node_field_data";s:5:"field";s:6:"status";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:5:"value";s:1:"1";s:5:"group";i:1;s:6:"expose";a:3:{s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}}s:8:"langcode";a:16:{s:2:"id";s:8:"langcode";s:5:"table";s:15:"node_field_data";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:8:"langcode";s:9:"plugin_id";s:8:"language";s:8:"operator";s:2:"in";s:5:"value";a:1:{s:31:"***LANGUAGE_language_content***";s:31:"***LANGUAGE_language_content***";}s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:13:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:5:"style";a:2:{s:4:"type";s:7:"default";s:7:"options";a:4:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:11:"uses_fields";b:0;}}s:3:"row";a:2:{s:4:"type";s:11:"entity:node";s:7:"options";a:1:{s:9:"view_mode";s:6:"teaser";}}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:0:{}s:6:"header";a:0:{}s:6:"footer";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:4:{i:0;s:28:"languages:language_interface";i:1;s:14:"url.query_args";i:2;s:21:"user.node_grants:view";i:3;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"feed_1";a:6:{s:2:"id";s:6:"feed_1";s:13:"display_title";s:4:"Feed";s:14:"display_plugin";s:4:"feed";s:8:"position";i:2;s:15:"display_options";a:7:{s:5:"pager";a:2:{s:4:"type";s:4:"some";s:7:"options";a:2:{s:6:"offset";i:0;s:14:"items_per_page";i:10;}}s:5:"style";a:2:{s:4:"type";s:3:"rss";s:7:"options";a:3:{s:8:"grouping";a:0:{}s:11:"uses_fields";b:0;s:11:"description";s:0:"";}}s:3:"row";a:2:{s:4:"type";s:8:"node_rss";s:7:"options";a:2:{s:12:"relationship";s:4:"none";s:9:"view_mode";s:3:"rss";}}s:17:"display_extenders";a:0:{}s:4:"path";s:7:"rss.xml";s:14:"sitename_title";b:1;s:8:"displays";a:2:{s:6:"page_1";s:6:"page_1";s:7:"default";s:0:"";}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:3:{i:0;s:28:"languages:language_interface";i:1;s:21:"user.node_grants:view";i:2;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"page_1";a:6:{s:2:"id";s:6:"page_1";s:13:"display_title";s:4:"Page";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:2:{s:17:"display_extenders";a:0:{}s:4:"path";s:4:"node";}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:4:{i:0;s:28:"languages:language_interface";i:1;s:14:"url.query_args";i:2;s:21:"user.node_grants:view";i:3;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'views.view.glossary',
  'data' => 'a:13:{s:4:"uuid";s:36:"8a79aa2c-15b9-4124-9735-542afd321165";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:16:"system.menu.main";}s:6:"module";a:2:{i:0;s:4:"node";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"sz_FoMz5aClG4jFy4UDlkenXQtgTUXohEDjWVBuHaro";}s:2:"id";s:8:"glossary";s:5:"label";s:8:"Glossary";s:6:"module";s:4:"node";s:11:"description";s:23:"All content, by letter.";s:3:"tag";s:7:"default";s:10:"base_table";s:15:"node_field_data";s:10:"base_field";s:3:"nid";s:7:"display";a:3:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:17:{s:6:"fields";a:3:{s:5:"title";a:24:{s:2:"id";s:5:"title";s:5:"table";s:15:"node_field_data";s:5:"field";s:5:"title";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:5:"title";s:9:"plugin_id";s:5:"field";s:5:"label";s:5:"Title";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;}s:4:"name";a:25:{s:2:"id";s:4:"name";s:5:"table";s:16:"users_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:3:"uid";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:5:"field";s:5:"label";s:6:"Author";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:9:"user_name";}s:7:"changed";a:26:{s:2:"id";s:7:"changed";s:5:"table";s:15:"node_field_data";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:5:"field";s:5:"label";s:11:"Last update";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:9:"timestamp";s:8:"settings";a:3:{s:11:"date_format";s:4:"long";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";}}}s:5:"pager";a:2:{s:4:"type";s:4:"mini";s:7:"options";a:6:{s:6:"offset";i:0;s:14:"items_per_page";i:36;s:11:"total_pages";i:0;s:2:"id";i:0;s:4:"tags";a:2:{s:4:"next";s:6:"››";s:8:"previous";s:6:"‹‹";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:5:"Apply";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:14:"access content";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"empty";a:0:{}s:5:"sorts";a:0:{}s:9:"arguments";a:1:{s:5:"title";a:27:{s:2:"id";s:5:"title";s:5:"table";s:15:"node_field_data";s:5:"field";s:5:"title";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:5:"title";s:9:"plugin_id";s:6:"string";s:14:"default_action";s:7:"default";s:9:"exception";a:1:{s:12:"title_enable";b:1;}s:12:"title_enable";b:0;s:5:"title";s:0:"";s:21:"default_argument_type";s:5:"fixed";s:24:"default_argument_options";a:1:{s:8:"argument";s:1:"a";}s:25:"default_argument_skip_url";b:0;s:15:"summary_options";a:0:{}s:7:"summary";a:1:{s:6:"format";s:15:"default_summary";}s:18:"specify_validation";b:1;s:8:"validate";a:2:{s:4:"type";s:4:"none";s:4:"fail";s:9:"not found";}s:16:"validate_options";a:0:{}s:8:"glossary";b:1;s:5:"limit";i:1;s:4:"case";s:5:"upper";s:9:"path_case";s:5:"lower";s:14:"transform_dash";b:0;s:12:"break_phrase";b:0;}}s:7:"filters";a:2:{s:6:"status";a:9:{s:2:"id";s:6:"status";s:5:"table";s:15:"node_field_data";s:5:"field";s:6:"status";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:5:"value";s:1:"1";s:5:"group";i:1;s:6:"expose";a:3:{s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}}s:8:"langcode";a:16:{s:2:"id";s:8:"langcode";s:5:"table";s:15:"node_field_data";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:8:"langcode";s:9:"plugin_id";s:8:"language";s:8:"operator";s:2:"in";s:5:"value";a:1:{s:31:"***LANGUAGE_language_content***";s:31:"***LANGUAGE_language_content***";}s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:13:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:12:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:11:"uses_fields";b:0;s:7:"columns";a:3:{s:5:"title";s:5:"title";s:4:"name";s:4:"name";s:7:"changed";s:7:"changed";}s:7:"default";s:5:"title";s:4:"info";a:3:{s:5:"title";a:2:{s:8:"sortable";b:1;s:9:"separator";s:0:"";}s:4:"name";a:2:{s:8:"sortable";b:1;s:9:"separator";s:0:"";}s:7:"changed";a:2:{s:8:"sortable";b:1;s:9:"separator";s:0:"";}}s:8:"override";b:1;s:6:"sticky";b:0;s:7:"summary";s:0:"";s:5:"order";s:3:"asc";s:11:"empty_table";b:0;}}s:3:"row";a:2:{s:4:"type";s:6:"fields";s:7:"options";a:4:{s:22:"default_field_elements";b:1;s:6:"inline";a:0:{}s:9:"separator";s:0:"";s:10:"hide_empty";b:0;}}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:1:{s:3:"uid";a:8:{s:2:"id";s:3:"uid";s:5:"table";s:15:"node_field_data";s:5:"field";s:3:"uid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:6:"author";s:9:"plugin_id";s:8:"standard";s:8:"required";b:0;}}s:8:"use_ajax";b:1;s:6:"header";a:0:{}s:6:"footer";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:6:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:21:"user.node_grants:view";i:5;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:12:"attachment_1";a:6:{s:2:"id";s:12:"attachment_1";s:13:"display_title";s:10:"Attachment";s:14:"display_plugin";s:10:"attachment";s:8:"position";i:2;s:15:"display_options";a:7:{s:5:"pager";a:2:{s:4:"type";s:4:"none";s:7:"options";a:2:{s:6:"offset";i:0;s:14:"items_per_page";i:0;}}s:9:"arguments";a:1:{s:5:"title";a:27:{s:2:"id";s:5:"title";s:5:"table";s:15:"node_field_data";s:5:"field";s:5:"title";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:5:"title";s:9:"plugin_id";s:6:"string";s:14:"default_action";s:7:"summary";s:9:"exception";a:1:{s:12:"title_enable";b:1;}s:12:"title_enable";b:0;s:5:"title";s:0:"";s:21:"default_argument_type";s:5:"fixed";s:24:"default_argument_options";a:1:{s:8:"argument";s:1:"a";}s:25:"default_argument_skip_url";b:0;s:15:"summary_options";a:3:{s:14:"items_per_page";i:25;s:6:"inline";b:1;s:9:"separator";s:3:" | ";}s:7:"summary";a:1:{s:6:"format";s:19:"unformatted_summary";}s:18:"specify_validation";b:1;s:8:"validate";a:2:{s:4:"type";s:4:"none";s:4:"fail";s:9:"not found";}s:16:"validate_options";a:0:{}s:8:"glossary";b:1;s:5:"limit";i:1;s:4:"case";s:5:"upper";s:9:"path_case";s:5:"lower";s:14:"transform_dash";b:0;s:12:"break_phrase";b:0;}}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:0:{}}s:8:"defaults";a:1:{s:9:"arguments";b:0;}s:17:"display_extenders";a:0:{}s:8:"displays";a:2:{s:7:"default";s:7:"default";s:6:"page_1";s:6:"page_1";}s:17:"inherit_arguments";b:0;}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:6:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:21:"user.node_grants:view";i:5;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"page_1";a:6:{s:2:"id";s:6:"page_1";s:13:"display_title";s:4:"Page";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:4:{s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:0:{}}s:17:"display_extenders";a:0:{}s:4:"path";s:8:"glossary";s:4:"menu";a:5:{s:4:"type";s:6:"normal";s:5:"title";s:8:"Glossary";s:6:"weight";i:0;s:9:"menu_name";s:4:"main";s:6:"parent";s:0:"";}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:6:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:21:"user.node_grants:view";i:5;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'views.view.taxonomy_term',
  'data' => 'a:13:{s:4:"uuid";s:36:"fa1285d7-e7c3-40be-a421-05f2bf849419";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:33:"core.entity_view_mode.node.teaser";}s:6:"module";a:3:{i:0;s:4:"node";i:1;s:8:"taxonomy";i:2;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"YKgw0f77GEmCu6_6Om9Mbig0mON9JdfVuMxTtd0WQaI";}s:2:"id";s:13:"taxonomy_term";s:5:"label";s:13:"Taxonomy term";s:6:"module";s:8:"taxonomy";s:11:"description";s:45:"Content belonging to a certain taxonomy term.";s:3:"tag";s:7:"default";s:10:"base_table";s:15:"node_field_data";s:10:"base_field";s:3:"nid";s:7:"display";a:3:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:18:{s:6:"fields";a:0:{}s:5:"pager";a:2:{s:4:"type";s:4:"mini";s:7:"options";a:6:{s:6:"offset";i:0;s:14:"items_per_page";i:10;s:11:"total_pages";i:0;s:2:"id";i:0;s:4:"tags";a:2:{s:4:"next";s:6:"››";s:8:"previous";s:6:"‹‹";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:5:"Apply";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:14:"access content";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"empty";a:0:{}s:5:"sorts";a:2:{s:6:"sticky";a:10:{s:2:"id";s:6:"sticky";s:5:"table";s:14:"taxonomy_index";s:5:"field";s:6:"sticky";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:8:"standard";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:6:"sticky";}s:7:"exposed";b:0;}s:7:"created";a:11:{s:2:"id";s:7:"created";s:5:"table";s:14:"taxonomy_index";s:5:"field";s:7:"created";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:4:"date";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:7:"created";}s:7:"exposed";b:0;s:11:"granularity";s:6:"second";}}s:9:"arguments";a:1:{s:3:"tid";a:23:{s:2:"id";s:3:"tid";s:5:"table";s:14:"taxonomy_index";s:5:"field";s:3:"tid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:18:"taxonomy_index_tid";s:14:"default_action";s:9:"not found";s:9:"exception";a:3:{s:5:"value";s:0:"";s:12:"title_enable";b:0;s:5:"title";s:3:"All";}s:12:"title_enable";b:1;s:5:"title";s:19:"{{ arguments.tid }}";s:21:"default_argument_type";s:5:"fixed";s:24:"default_argument_options";a:1:{s:8:"argument";s:0:"";}s:25:"default_argument_skip_url";b:0;s:15:"summary_options";a:4:{s:9:"base_path";s:0:"";s:5:"count";b:1;s:8:"override";b:0;s:14:"items_per_page";i:25;}s:7:"summary";a:3:{s:10:"sort_order";s:3:"asc";s:17:"number_of_records";i:0;s:6:"format";s:15:"default_summary";}s:18:"specify_validation";b:1;s:8:"validate";a:2:{s:4:"type";s:20:"entity:taxonomy_term";s:4:"fail";s:9:"not found";}s:16:"validate_options";a:4:{s:7:"bundles";a:0:{}s:6:"access";b:1;s:9:"operation";s:4:"view";s:8:"multiple";i:0;}s:12:"break_phrase";b:0;s:9:"add_table";b:0;s:13:"require_value";b:0;s:17:"reduce_duplicates";b:0;}}s:7:"filters";a:2:{s:8:"langcode";a:16:{s:2:"id";s:8:"langcode";s:5:"table";s:15:"node_field_data";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:8:"langcode";s:9:"plugin_id";s:8:"language";s:8:"operator";s:2:"in";s:5:"value";a:1:{s:31:"***LANGUAGE_language_content***";s:31:"***LANGUAGE_language_content***";}s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:13:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:6:"status";a:14:{s:2:"id";s:6:"status";s:5:"table";s:14:"taxonomy_index";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:7:"boolean";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:5:"style";a:2:{s:4:"type";s:7:"default";s:7:"options";a:4:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:11:"uses_fields";b:0;}}s:3:"row";a:2:{s:4:"type";s:11:"entity:node";s:7:"options";a:1:{s:9:"view_mode";s:6:"teaser";}}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:0:{}s:12:"link_display";s:6:"page_1";s:8:"link_url";s:0:"";s:6:"header";a:1:{s:20:"entity_taxonomy_term";a:12:{s:2:"id";s:20:"entity_taxonomy_term";s:5:"table";s:5:"views";s:5:"field";s:20:"entity_taxonomy_term";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:6:"entity";s:5:"empty";b:1;s:6:"target";s:23:"{{ raw_arguments.tid }}";s:9:"view_mode";s:4:"full";s:8:"tokenize";b:1;s:13:"bypass_access";b:0;}}s:6:"footer";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:28:"languages:language_interface";i:1;s:3:"url";i:2;s:14:"url.query_args";i:3;s:21:"user.node_grants:view";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"feed_1";a:6:{s:2:"id";s:6:"feed_1";s:13:"display_title";s:4:"Feed";s:14:"display_plugin";s:4:"feed";s:8:"position";i:2;s:15:"display_options";a:7:{s:5:"pager";a:2:{s:4:"type";s:4:"some";s:7:"options";a:2:{s:6:"offset";i:0;s:14:"items_per_page";i:10;}}s:5:"style";a:2:{s:4:"type";s:3:"rss";s:7:"options";a:3:{s:8:"grouping";a:0:{}s:11:"uses_fields";b:0;s:11:"description";s:0:"";}}s:3:"row";a:2:{s:4:"type";s:8:"node_rss";s:7:"options";a:2:{s:12:"relationship";s:4:"none";s:9:"view_mode";s:7:"default";}}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:0:{}}s:17:"display_extenders";a:0:{}s:4:"path";s:20:"taxonomy/term/%/feed";s:8:"displays";a:2:{s:6:"page_1";s:6:"page_1";s:7:"default";s:1:"0";}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:4:{i:0;s:28:"languages:language_interface";i:1;s:3:"url";i:2;s:21:"user.node_grants:view";i:3;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"page_1";a:6:{s:2:"id";s:6:"page_1";s:13:"display_title";s:4:"Page";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:3:{s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:0:{}}s:17:"display_extenders";a:0:{}s:4:"path";s:15:"taxonomy/term/%";}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:28:"languages:language_interface";i:1;s:3:"url";i:2;s:14:"url.query_args";i:3;s:21:"user.node_grants:view";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'views.view.user_admin_people',
  'data' => 'a:13:{s:4:"uuid";s:36:"10ec64fe-cf91-4c4a-941b-2ba3e21c3338";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"njaZigMvB4ap21Fg_tQcJhWgYJCGNi49Z5rRL_N6RI0";}s:2:"id";s:17:"user_admin_people";s:5:"label";s:6:"People";s:6:"module";s:4:"user";s:11:"description";s:50:"Find and manage people interacting with your site.";s:3:"tag";s:7:"default";s:10:"base_table";s:16:"users_field_data";s:10:"base_field";s:3:"uid";s:7:"display";a:2:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:25:{s:5:"title";s:6:"People";s:6:"fields";a:8:{s:14:"user_bulk_form";a:23:{s:2:"id";s:14:"user_bulk_form";s:5:"table";s:5:"users";s:5:"field";s:14:"user_bulk_form";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:9:"plugin_id";s:14:"user_bulk_form";s:5:"label";s:11:"Bulk update";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;}s:4:"name";a:25:{s:2:"id";s:4:"name";s:5:"table";s:16:"users_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:5:"field";s:5:"label";s:8:"Username";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:9:"user_name";}s:6:"status";a:26:{s:2:"id";s:6:"status";s:5:"table";s:16:"users_field_data";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:5:"field";s:5:"label";s:6:"Status";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:7:"boolean";s:8:"settings";a:3:{s:6:"format";s:6:"custom";s:19:"format_custom_false";s:7:"Blocked";s:18:"format_custom_true";s:6:"Active";}}s:15:"roles_target_id";a:24:{s:2:"id";s:15:"roles_target_id";s:5:"table";s:11:"user__roles";s:5:"field";s:15:"roles_target_id";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:10:"user_roles";s:5:"label";s:5:"Roles";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:2:"ul";s:9:"separator";s:2:", ";}s:7:"created";a:26:{s:2:"id";s:7:"created";s:5:"table";s:16:"users_field_data";s:5:"field";s:7:"created";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:7:"created";s:9:"plugin_id";s:5:"field";s:5:"label";s:10:"Member for";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:13:"timestamp_ago";s:8:"settings";a:3:{s:13:"future_format";s:9:"@interval";s:11:"past_format";s:9:"@interval";s:11:"granularity";i:2;}}s:6:"access";a:26:{s:2:"id";s:6:"access";s:5:"table";s:16:"users_field_data";s:5:"field";s:6:"access";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:6:"access";s:9:"plugin_id";s:5:"field";s:5:"label";s:11:"Last access";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:13:"timestamp_ago";s:8:"settings";a:3:{s:13:"future_format";s:15:"@interval hence";s:11:"past_format";s:13:"@interval ago";s:11:"granularity";i:2;}}s:10:"operations";a:24:{s:2:"id";s:10:"operations";s:5:"table";s:5:"users";s:5:"field";s:10:"operations";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:9:"plugin_id";s:17:"entity_operations";s:5:"label";s:10:"Operations";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:11:"destination";b:1;}s:4:"mail";a:37:{s:2:"id";s:4:"mail";s:5:"table";s:16:"users_field_data";s:5:"field";s:4:"mail";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:4:"mail";s:9:"plugin_id";s:5:"field";s:5:"label";s:0:"";s:7:"exclude";b:1;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:12:"basic_string";s:8:"settings";a:0:{}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}}s:5:"pager";a:2:{s:4:"type";s:4:"full";s:7:"options";a:7:{s:6:"offset";i:0;s:14:"items_per_page";i:50;s:11:"total_pages";i:0;s:2:"id";i:0;s:4:"tags";a:4:{s:4:"next";s:8:"Next ›";s:8:"previous";s:12:"‹ Previous";s:5:"first";s:8:"« First";s:4:"last";s:7:"Last »";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}s:8:"quantity";i:9;}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:6:"Filter";s:12:"reset_button";b:1;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:16:"administer users";}}s:5:"cache";a:1:{s:4:"type";s:3:"tag";}s:5:"empty";a:1:{s:16:"area_text_custom";a:10:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:11:"text_custom";s:5:"empty";b:1;s:7:"content";s:20:"No people available.";s:8:"tokenize";b:0;}}s:5:"sorts";a:1:{s:7:"created";a:13:{s:2:"id";s:7:"created";s:5:"table";s:16:"users_field_data";s:5:"field";s:7:"created";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:7:"created";s:9:"plugin_id";s:4:"date";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:7:"created";}s:7:"exposed";b:0;s:11:"granularity";s:6:"second";}}s:7:"filters";a:6:{s:7:"combine";a:15:{s:2:"id";s:7:"combine";s:5:"table";s:5:"views";s:5:"field";s:7:"combine";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:7:"combine";s:8:"operator";s:8:"contains";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:10:"combine_op";s:5:"label";s:22:"Name or email contains";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:10:"combine_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:4:"user";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:6:"fields";a:2:{s:4:"name";s:4:"name";s:4:"mail";s:4:"mail";}}s:6:"status";a:16:{s:2:"id";s:6:"status";s:5:"table";s:16:"users_field_data";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:9:"status_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:6:"status";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}}s:10:"is_grouped";b:1;s:10:"group_info";a:10:{s:5:"label";s:6:"Status";s:11:"description";s:0:"";s:10:"identifier";s:6:"status";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:2:{i:1;a:3:{s:5:"title";s:6:"Active";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";}i:2;a:3:{s:5:"title";s:7:"Blocked";s:8:"operator";s:1:"=";s:5:"value";s:1:"0";}}}}s:15:"roles_target_id";a:15:{s:2:"id";s:15:"roles_target_id";s:5:"table";s:11:"user__roles";s:5:"field";s:15:"roles_target_id";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:10:"user_roles";s:8:"operator";s:2:"or";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:18:"roles_target_id_op";s:5:"label";s:4:"Role";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:18:"roles_target_id_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:4:"role";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:17:"reduce_duplicates";b:0;}s:10:"permission";a:15:{s:2:"id";s:10:"permission";s:5:"table";s:11:"user__roles";s:5:"field";s:10:"permission";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:16:"user_permissions";s:8:"operator";s:2:"or";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:13:"permission_op";s:5:"label";s:10:"Permission";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:13:"permission_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:10:"permission";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:17:"reduce_duplicates";b:0;}s:16:"default_langcode";a:16:{s:2:"id";s:16:"default_langcode";s:5:"table";s:16:"users_field_data";s:5:"field";s:16:"default_langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:16:"default_langcode";s:9:"plugin_id";s:7:"boolean";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:7:"uid_raw";a:15:{s:2:"id";s:7:"uid_raw";s:5:"table";s:16:"users_field_data";s:5:"field";s:7:"uid_raw";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:9:"plugin_id";s:7:"numeric";s:8:"operator";s:2:"!=";s:5:"value";a:3:{s:3:"min";s:0:"";s:3:"max";s:0:"";s:5:"value";s:1:"0";}s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:1:"0";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:13:"filter_groups";a:2:{s:8:"operator";s:3:"AND";s:6:"groups";a:1:{i:1;s:3:"AND";}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:10:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:7:"columns";a:8:{s:14:"user_bulk_form";s:14:"user_bulk_form";s:4:"name";s:4:"name";s:6:"status";s:6:"status";s:3:"rid";s:3:"rid";s:7:"created";s:7:"created";s:6:"access";s:6:"access";s:9:"edit_node";s:9:"edit_node";s:10:"dropbutton";s:10:"dropbutton";}s:7:"default";s:7:"created";s:4:"info";a:8:{s:14:"user_bulk_form";a:4:{s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:4:"name";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:6:"status";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:3:"rid";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:7:"created";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:6:"access";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:9:"edit_node";a:4:{s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:10:"dropbutton";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}}s:8:"override";b:1;s:6:"sticky";b:0;s:7:"summary";s:0:"";s:11:"empty_table";b:1;}}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:9:"css_class";s:0:"";s:8:"use_ajax";b:0;s:8:"group_by";b:0;s:16:"show_admin_links";b:1;s:8:"use_more";b:0;s:15:"use_more_always";b:0;s:13:"use_more_text";s:4:"more";s:12:"link_display";s:6:"page_1";s:8:"link_url";s:0:"";s:15:"display_comment";s:0:"";s:23:"hide_attachment_summary";b:0;s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:0;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"page_1";a:6:{s:2:"id";s:6:"page_1";s:13:"display_title";s:4:"Page";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:6:{s:8:"defaults";a:1:{s:16:"show_admin_links";b:0;}s:16:"show_admin_links";b:0;s:17:"display_extenders";a:0:{}s:4:"path";s:17:"admin/people/list";s:4:"menu";a:6:{s:4:"type";s:11:"default tab";s:5:"title";s:4:"List";s:11:"description";s:50:"Find and manage people interacting with your site.";s:6:"weight";i:-10;s:9:"menu_name";s:5:"admin";s:7:"context";s:0:"";}s:11:"tab_options";a:5:{s:4:"type";s:6:"normal";s:5:"title";s:6:"People";s:11:"description";s:45:"Manage user accounts, roles, and permissions.";s:6:"weight";i:0;s:9:"menu_name";s:5:"admin";}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:0;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'views.view.who_s_new',
  'data' => "a:13:{s:4:\"uuid\";s:36:\"3626aaf5-6c82-4e1b-8f19-752e2cdac89f\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"zji0_13MyVGK7Bn1lUMDeZyyOIZedWvqpYUeM_SioPI\";}s:2:\"id\";s:9:\"who_s_new\";s:5:\"label\";s:9:\"Who's new\";s:6:\"module\";s:4:\"user\";s:11:\"description\";s:53:\"Shows a list of the newest user accounts on the site.\";s:3:\"tag\";s:7:\"default\";s:10:\"base_table\";s:16:\"users_field_data\";s:10:\"base_field\";s:3:\"uid\";s:7:\"display\";a:2:{s:7:\"default\";a:6:{s:2:\"id\";s:7:\"default\";s:13:\"display_title\";s:7:\"Default\";s:14:\"display_plugin\";s:7:\"default\";s:8:\"position\";i:0;s:15:\"display_options\";a:17:{s:5:\"title\";s:9:\"Who's new\";s:6:\"fields\";a:1:{s:4:\"name\";a:25:{s:2:\"id\";s:4:\"name\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:4:\"name\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:4:\"name\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:8:{s:10:\"alter_text\";b:0;s:9:\"make_link\";b:0;s:8:\"absolute\";b:0;s:13:\"word_boundary\";b:0;s:8:\"ellipsis\";b:0;s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"type\";s:9:\"user_name\";}}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"some\";s:7:\"options\";a:2:{s:6:\"offset\";i:0;s:14:\"items_per_page\";i:5;}}s:12:\"exposed_form\";a:2:{s:4:\"type\";s:5:\"basic\";s:7:\"options\";a:7:{s:13:\"submit_button\";s:5:\"Apply\";s:12:\"reset_button\";b:0;s:18:\"reset_button_label\";s:5:\"Reset\";s:19:\"exposed_sorts_label\";s:7:\"Sort by\";s:17:\"expose_sort_order\";b:1;s:14:\"sort_asc_label\";s:3:\"Asc\";s:15:\"sort_desc_label\";s:4:\"Desc\";}}s:6:\"access\";a:2:{s:4:\"type\";s:4:\"perm\";s:7:\"options\";a:1:{s:4:\"perm\";s:14:\"access content\";}}s:5:\"cache\";a:2:{s:4:\"type\";s:3:\"tag\";s:7:\"options\";a:0:{}}s:5:\"empty\";a:0:{}s:5:\"sorts\";a:1:{s:7:\"created\";a:13:{s:2:\"id\";s:7:\"created\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:7:\"created\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:7:\"created\";s:9:\"plugin_id\";s:4:\"date\";s:5:\"order\";s:4:\"DESC\";s:6:\"expose\";a:2:{s:5:\"label\";s:0:\"\";s:16:\"field_identifier\";s:7:\"created\";}s:7:\"exposed\";b:0;s:11:\"granularity\";s:6:\"second\";}}s:9:\"arguments\";a:0:{}s:7:\"filters\";a:2:{s:6:\"status\";a:9:{s:2:\"id\";s:6:\"status\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:6:\"status\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:6:\"status\";s:9:\"plugin_id\";s:7:\"boolean\";s:5:\"value\";s:1:\"1\";s:5:\"group\";i:1;s:6:\"expose\";a:3:{s:8:\"operator\";s:1:\"0\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}}}s:6:\"access\";a:16:{s:2:\"id\";s:6:\"access\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:6:\"access\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:6:\"access\";s:9:\"plugin_id\";s:4:\"date\";s:8:\"operator\";s:1:\">\";s:5:\"value\";a:4:{s:3:\"min\";s:0:\"\";s:3:\"max\";s:0:\"\";s:5:\"value\";s:10:\"1970-01-01\";s:4:\"type\";s:4:\"date\";}s:5:\"group\";i:1;s:7:\"exposed\";b:0;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:1:\"0\";s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:0:\"\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:0:\"\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:1:{s:13:\"authenticated\";s:13:\"authenticated\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}}s:5:\"style\";a:1:{s:4:\"type\";s:9:\"html_list\";}s:3:\"row\";a:1:{s:4:\"type\";s:6:\"fields\";}s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:5:{s:13:\"query_comment\";s:0:\"\";s:19:\"disable_sql_rewrite\";b:0;s:8:\"distinct\";b:0;s:7:\"replica\";b:0;s:10:\"query_tags\";a:0:{}}}s:13:\"relationships\";a:0:{}s:6:\"header\";a:0:{}s:6:\"footer\";a:0:{}s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:3:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}s:7:\"block_1\";a:6:{s:2:\"id\";s:7:\"block_1\";s:13:\"display_title\";s:9:\"Who's new\";s:14:\"display_plugin\";s:5:\"block\";s:8:\"position\";i:1;s:15:\"display_options\";a:4:{s:19:\"display_description\";s:19:\"A list of new users\";s:17:\"display_extenders\";a:0:{}s:17:\"block_description\";s:9:\"Who's new\";s:14:\"block_category\";s:4:\"User\";}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:3:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}}}",
))
->values(array(
  'collection' => '',
  'name' => 'views.view.who_s_online',
  'data' => "a:13:{s:4:\"uuid\";s:36:\"be956f46-fbc7-42d5-9482-711b3ab643c2\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"suDsVMgawXoQt4rfmdfpr05EVX3z3KyfDDTYgeSM898\";}s:2:\"id\";s:12:\"who_s_online\";s:5:\"label\";s:18:\"Who's online block\";s:6:\"module\";s:4:\"user\";s:11:\"description\";s:93:\"Shows the user names of the most recently active users, and the total number of active users.\";s:3:\"tag\";s:7:\"default\";s:10:\"base_table\";s:16:\"users_field_data\";s:10:\"base_field\";s:3:\"uid\";s:7:\"display\";a:2:{s:7:\"default\";a:6:{s:2:\"id\";s:7:\"default\";s:13:\"display_title\";s:7:\"Default\";s:14:\"display_plugin\";s:7:\"default\";s:8:\"position\";i:0;s:15:\"display_options\";a:17:{s:5:\"title\";s:12:\"Who's online\";s:6:\"fields\";a:1:{s:4:\"name\";a:25:{s:2:\"id\";s:4:\"name\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:4:\"name\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:4:\"name\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:8:{s:10:\"alter_text\";b:0;s:9:\"make_link\";b:0;s:8:\"absolute\";b:0;s:13:\"word_boundary\";b:0;s:8:\"ellipsis\";b:0;s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"type\";s:9:\"user_name\";}}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"some\";s:7:\"options\";a:2:{s:6:\"offset\";i:0;s:14:\"items_per_page\";i:10;}}s:12:\"exposed_form\";a:2:{s:4:\"type\";s:5:\"basic\";s:7:\"options\";a:7:{s:13:\"submit_button\";s:5:\"Apply\";s:12:\"reset_button\";b:0;s:18:\"reset_button_label\";s:5:\"Reset\";s:19:\"exposed_sorts_label\";s:7:\"Sort by\";s:17:\"expose_sort_order\";b:1;s:14:\"sort_asc_label\";s:3:\"Asc\";s:15:\"sort_desc_label\";s:4:\"Desc\";}}s:6:\"access\";a:2:{s:4:\"type\";s:4:\"perm\";s:7:\"options\";a:1:{s:4:\"perm\";s:20:\"access user profiles\";}}s:5:\"cache\";a:2:{s:4:\"type\";s:3:\"tag\";s:7:\"options\";a:0:{}}s:5:\"empty\";a:1:{s:16:\"area_text_custom\";a:10:{s:2:\"id\";s:16:\"area_text_custom\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:16:\"area_text_custom\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:11:\"text_custom\";s:5:\"empty\";b:1;s:7:\"content\";s:35:\"There are currently 0 users online.\";s:8:\"tokenize\";b:0;}}s:5:\"sorts\";a:1:{s:6:\"access\";a:13:{s:2:\"id\";s:6:\"access\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:6:\"access\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:6:\"access\";s:9:\"plugin_id\";s:4:\"date\";s:5:\"order\";s:4:\"DESC\";s:6:\"expose\";a:2:{s:5:\"label\";s:0:\"\";s:16:\"field_identifier\";s:6:\"access\";}s:7:\"exposed\";b:0;s:11:\"granularity\";s:6:\"second\";}}s:9:\"arguments\";a:0:{}s:7:\"filters\";a:2:{s:6:\"status\";a:9:{s:2:\"id\";s:6:\"status\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:6:\"status\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:6:\"status\";s:9:\"plugin_id\";s:7:\"boolean\";s:5:\"value\";s:1:\"1\";s:5:\"group\";i:1;s:6:\"expose\";a:3:{s:8:\"operator\";s:1:\"0\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}}}s:6:\"access\";a:16:{s:2:\"id\";s:6:\"access\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:6:\"access\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:6:\"access\";s:9:\"plugin_id\";s:4:\"date\";s:8:\"operator\";s:2:\">=\";s:5:\"value\";a:4:{s:3:\"min\";s:0:\"\";s:3:\"max\";s:0:\"\";s:5:\"value\";s:11:\"-15 minutes\";s:4:\"type\";s:6:\"offset\";}s:5:\"group\";i:1;s:7:\"exposed\";b:0;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:9:\"access_op\";s:5:\"label\";s:11:\"Last access\";s:11:\"description\";s:77:\"A user is considered online for this long after they have last viewed a page.\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:9:\"access_op\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:6:\"access\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}}s:5:\"style\";a:2:{s:4:\"type\";s:9:\"html_list\";s:7:\"options\";a:6:{s:8:\"grouping\";a:0:{}s:9:\"row_class\";s:0:\"\";s:17:\"default_row_class\";b:1;s:4:\"type\";s:2:\"ul\";s:13:\"wrapper_class\";s:9:\"item-list\";s:5:\"class\";s:0:\"\";}}s:3:\"row\";a:1:{s:4:\"type\";s:6:\"fields\";}s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:5:{s:13:\"query_comment\";s:0:\"\";s:19:\"disable_sql_rewrite\";b:0;s:8:\"distinct\";b:0;s:7:\"replica\";b:0;s:10:\"query_tags\";a:0:{}}}s:13:\"relationships\";a:0:{}s:6:\"header\";a:1:{s:6:\"result\";a:9:{s:2:\"id\";s:6:\"result\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:6:\"result\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:6:\"result\";s:5:\"empty\";b:0;s:7:\"content\";s:40:\"There are currently @total users online.\";}}s:6:\"footer\";a:0:{}s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:3:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}s:18:\"who_s_online_block\";a:6:{s:2:\"id\";s:18:\"who_s_online_block\";s:13:\"display_title\";s:12:\"Who's online\";s:14:\"display_plugin\";s:5:\"block\";s:8:\"position\";i:1;s:15:\"display_options\";a:3:{s:19:\"display_description\";s:45:\"A list of users that are currently logged in.\";s:17:\"display_extenders\";a:0:{}s:17:\"block_description\";s:12:\"Who's online\";}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:3:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}}}",
))
->execute();
$connection->schema()->createTable('config_snapshot', array(
  'fields' => array(
    'collection' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'le